// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/dialogflow/cx/v3/agent.proto

package cxpb

import (
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	structpb "google.golang.org/protobuf/types/known/structpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Data format of the exported agent.
type ExportAgentRequest_DataFormat int32

const (
	// Unspecified format.
	ExportAgentRequest_DATA_FORMAT_UNSPECIFIED ExportAgentRequest_DataFormat = 0
	// Agent content will be exported as raw bytes.
	ExportAgentRequest_BLOB ExportAgentRequest_DataFormat = 1
	// Agent content will be exported in JSON Package format.
	ExportAgentRequest_JSON_PACKAGE ExportAgentRequest_DataFormat = 4
)

// Enum value maps for ExportAgentRequest_DataFormat.
var (
	ExportAgentRequest_DataFormat_name = map[int32]string{
		0: "DATA_FORMAT_UNSPECIFIED",
		1: "BLOB",
		4: "JSON_PACKAGE",
	}
	ExportAgentRequest_DataFormat_value = map[string]int32{
		"DATA_FORMAT_UNSPECIFIED": 0,
		"BLOB":                    1,
		"JSON_PACKAGE":            4,
	}
)

func (x ExportAgentRequest_DataFormat) Enum() *ExportAgentRequest_DataFormat {
	p := new(ExportAgentRequest_DataFormat)
	*p = x
	return p
}

func (x ExportAgentRequest_DataFormat) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExportAgentRequest_DataFormat) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3_agent_proto_enumTypes[0].Descriptor()
}

func (ExportAgentRequest_DataFormat) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3_agent_proto_enumTypes[0]
}

func (x ExportAgentRequest_DataFormat) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExportAgentRequest_DataFormat.Descriptor instead.
func (ExportAgentRequest_DataFormat) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_agent_proto_rawDescGZIP(), []int{8, 0}
}

// Restore option.
type RestoreAgentRequest_RestoreOption int32

const (
	// Unspecified. Treated as KEEP.
	RestoreAgentRequest_RESTORE_OPTION_UNSPECIFIED RestoreAgentRequest_RestoreOption = 0
	// Always respect the settings from the exported agent file. It may cause
	// a restoration failure if some settings (e.g. model type) are not
	// supported in the target agent.
	RestoreAgentRequest_KEEP RestoreAgentRequest_RestoreOption = 1
	// Fallback to default settings if some settings are not supported in the
	// target agent.
	RestoreAgentRequest_FALLBACK RestoreAgentRequest_RestoreOption = 2
)

// Enum value maps for RestoreAgentRequest_RestoreOption.
var (
	RestoreAgentRequest_RestoreOption_name = map[int32]string{
		0: "RESTORE_OPTION_UNSPECIFIED",
		1: "KEEP",
		2: "FALLBACK",
	}
	RestoreAgentRequest_RestoreOption_value = map[string]int32{
		"RESTORE_OPTION_UNSPECIFIED": 0,
		"KEEP":                       1,
		"FALLBACK":                   2,
	}
)

func (x RestoreAgentRequest_RestoreOption) Enum() *RestoreAgentRequest_RestoreOption {
	p := new(RestoreAgentRequest_RestoreOption)
	*p = x
	return p
}

func (x RestoreAgentRequest_RestoreOption) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RestoreAgentRequest_RestoreOption) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3_agent_proto_enumTypes[1].Descriptor()
}

func (RestoreAgentRequest_RestoreOption) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3_agent_proto_enumTypes[1]
}

func (x RestoreAgentRequest_RestoreOption) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RestoreAgentRequest_RestoreOption.Descriptor instead.
func (RestoreAgentRequest_RestoreOption) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_agent_proto_rawDescGZIP(), []int{10, 0}
}

// Settings related to speech recognition.
type SpeechToTextSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether to use speech adaptation for speech recognition.
	EnableSpeechAdaptation bool `protobuf:"varint,1,opt,name=enable_speech_adaptation,json=enableSpeechAdaptation,proto3" json:"enable_speech_adaptation,omitempty"`
}

func (x *SpeechToTextSettings) Reset() {
	*x = SpeechToTextSettings{}
	mi := &file_google_cloud_dialogflow_cx_v3_agent_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SpeechToTextSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpeechToTextSettings) ProtoMessage() {}

func (x *SpeechToTextSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_agent_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpeechToTextSettings.ProtoReflect.Descriptor instead.
func (*SpeechToTextSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_agent_proto_rawDescGZIP(), []int{0}
}

func (x *SpeechToTextSettings) GetEnableSpeechAdaptation() bool {
	if x != nil {
		return x.EnableSpeechAdaptation
	}
	return false
}

// Agents are best described as Natural Language Understanding (NLU) modules
// that transform user requests into actionable data. You can include agents
// in your app, product, or service to determine user intent and respond to the
// user in a natural way.
//
// After you create an agent, you can add
// [Intents][google.cloud.dialogflow.cx.v3.Intent], [Entity
// Types][google.cloud.dialogflow.cx.v3.EntityType],
// [Flows][google.cloud.dialogflow.cx.v3.Flow],
// [Fulfillments][google.cloud.dialogflow.cx.v3.Fulfillment],
// [Webhooks][google.cloud.dialogflow.cx.v3.Webhook],
// [TransitionRouteGroups][google.cloud.dialogflow.cx.v3.TransitionRouteGroup]
// and so on to manage the conversation flows.
type Agent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique identifier of the agent.
	// Required for the
	// [Agents.UpdateAgent][google.cloud.dialogflow.cx.v3.Agents.UpdateAgent]
	// method.
	// [Agents.CreateAgent][google.cloud.dialogflow.cx.v3.Agents.CreateAgent]
	// populates the name automatically.
	// Format: `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The human-readable name of the agent, unique within the location.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. Immutable. The default language of the agent as a language tag.
	// See [Language
	// Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
	// for a list of the currently supported language codes.
	// This field cannot be set by the
	// [Agents.UpdateAgent][google.cloud.dialogflow.cx.v3.Agents.UpdateAgent]
	// method.
	DefaultLanguageCode string `protobuf:"bytes,3,opt,name=default_language_code,json=defaultLanguageCode,proto3" json:"default_language_code,omitempty"`
	// The list of all languages supported by the agent (except for the
	// `default_language_code`).
	SupportedLanguageCodes []string `protobuf:"bytes,4,rep,name=supported_language_codes,json=supportedLanguageCodes,proto3" json:"supported_language_codes,omitempty"`
	// Required. The time zone of the agent from the [time zone
	// database](https://www.iana.org/time-zones), e.g., America/New_York,
	// Europe/Paris.
	TimeZone string `protobuf:"bytes,5,opt,name=time_zone,json=timeZone,proto3" json:"time_zone,omitempty"`
	// The description of the agent. The maximum length is 500 characters. If
	// exceeded, the request is rejected.
	Description string `protobuf:"bytes,6,opt,name=description,proto3" json:"description,omitempty"`
	// The URI of the agent's avatar. Avatars are used throughout the Dialogflow
	// console and in the self-hosted [Web
	// Demo](https://cloud.google.com/dialogflow/docs/integrations/web-demo)
	// integration.
	AvatarUri string `protobuf:"bytes,7,opt,name=avatar_uri,json=avatarUri,proto3" json:"avatar_uri,omitempty"`
	// Speech recognition related settings.
	SpeechToTextSettings *SpeechToTextSettings `protobuf:"bytes,13,opt,name=speech_to_text_settings,json=speechToTextSettings,proto3" json:"speech_to_text_settings,omitempty"`
	// Immutable. Name of the start flow in this agent. A start flow will be
	// automatically created when the agent is created, and can only be deleted by
	// deleting the agent. Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/flows/<FlowID>`.
	StartFlow string `protobuf:"bytes,16,opt,name=start_flow,json=startFlow,proto3" json:"start_flow,omitempty"`
	// Name of the
	// [SecuritySettings][google.cloud.dialogflow.cx.v3.SecuritySettings]
	// reference for the agent. Format:
	// `projects/<ProjectID>/locations/<LocationID>/securitySettings/<SecuritySettingsID>`.
	SecuritySettings string `protobuf:"bytes,17,opt,name=security_settings,json=securitySettings,proto3" json:"security_settings,omitempty"`
	// Indicates if stackdriver logging is enabled for the agent.
	// Please use
	// [agent.advanced_settings][google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings]
	// instead.
	//
	// Deprecated: Marked as deprecated in google/cloud/dialogflow/cx/v3/agent.proto.
	EnableStackdriverLogging bool `protobuf:"varint,18,opt,name=enable_stackdriver_logging,json=enableStackdriverLogging,proto3" json:"enable_stackdriver_logging,omitempty"`
	// Indicates if automatic spell correction is enabled in detect intent
	// requests.
	EnableSpellCorrection bool `protobuf:"varint,20,opt,name=enable_spell_correction,json=enableSpellCorrection,proto3" json:"enable_spell_correction,omitempty"`
	// Optional. Enable training multi-lingual models for this agent. These models
	// will be trained on all the languages supported by the agent.
	EnableMultiLanguageTraining bool `protobuf:"varint,40,opt,name=enable_multi_language_training,json=enableMultiLanguageTraining,proto3" json:"enable_multi_language_training,omitempty"`
	// Indicates whether the agent is locked for changes. If the agent is locked,
	// modifications to the agent will be rejected except for [RestoreAgent][].
	Locked bool `protobuf:"varint,27,opt,name=locked,proto3" json:"locked,omitempty"`
	// Hierarchical advanced settings for this agent. The settings exposed at the
	// lower level overrides the settings exposed at the higher level.
	AdvancedSettings *AdvancedSettings `protobuf:"bytes,22,opt,name=advanced_settings,json=advancedSettings,proto3" json:"advanced_settings,omitempty"`
	// Git integration settings for this agent.
	GitIntegrationSettings *Agent_GitIntegrationSettings `protobuf:"bytes,30,opt,name=git_integration_settings,json=gitIntegrationSettings,proto3" json:"git_integration_settings,omitempty"`
	// Settings on instructing the speech synthesizer on how to generate the
	// output audio content.
	TextToSpeechSettings *TextToSpeechSettings `protobuf:"bytes,31,opt,name=text_to_speech_settings,json=textToSpeechSettings,proto3" json:"text_to_speech_settings,omitempty"`
	// Gen App Builder-related agent-level settings.
	GenAppBuilderSettings *Agent_GenAppBuilderSettings `protobuf:"bytes,33,opt,name=gen_app_builder_settings,json=genAppBuilderSettings,proto3,oneof" json:"gen_app_builder_settings,omitempty"`
	// Optional. Answer feedback collection settings.
	AnswerFeedbackSettings *Agent_AnswerFeedbackSettings `protobuf:"bytes,38,opt,name=answer_feedback_settings,json=answerFeedbackSettings,proto3" json:"answer_feedback_settings,omitempty"`
	// Optional. Settings for end user personalization.
	PersonalizationSettings *Agent_PersonalizationSettings `protobuf:"bytes,42,opt,name=personalization_settings,json=personalizationSettings,proto3" json:"personalization_settings,omitempty"`
	// Optional. Settings for custom client certificates.
	ClientCertificateSettings *Agent_ClientCertificateSettings `protobuf:"bytes,43,opt,name=client_certificate_settings,json=clientCertificateSettings,proto3" json:"client_certificate_settings,omitempty"`
	// Optional. Output only. A read only boolean field reflecting Zone Separation
	// status of the agent.
	SatisfiesPzs *bool `protobuf:"varint,45,opt,name=satisfies_pzs,json=satisfiesPzs,proto3,oneof" json:"satisfies_pzs,omitempty"`
	// Optional. Output only. A read only boolean field reflecting Zone Isolation
	// status of the agent.
	SatisfiesPzi *bool `protobuf:"varint,46,opt,name=satisfies_pzi,json=satisfiesPzi,proto3,oneof" json:"satisfies_pzi,omitempty"`
}

func (x *Agent) Reset() {
	*x = Agent{}
	mi := &file_google_cloud_dialogflow_cx_v3_agent_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Agent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Agent) ProtoMessage() {}

func (x *Agent) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_agent_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Agent.ProtoReflect.Descriptor instead.
func (*Agent) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_agent_proto_rawDescGZIP(), []int{1}
}

func (x *Agent) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Agent) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Agent) GetDefaultLanguageCode() string {
	if x != nil {
		return x.DefaultLanguageCode
	}
	return ""
}

func (x *Agent) GetSupportedLanguageCodes() []string {
	if x != nil {
		return x.SupportedLanguageCodes
	}
	return nil
}

func (x *Agent) GetTimeZone() string {
	if x != nil {
		return x.TimeZone
	}
	return ""
}

func (x *Agent) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Agent) GetAvatarUri() string {
	if x != nil {
		return x.AvatarUri
	}
	return ""
}

func (x *Agent) GetSpeechToTextSettings() *SpeechToTextSettings {
	if x != nil {
		return x.SpeechToTextSettings
	}
	return nil
}

func (x *Agent) GetStartFlow() string {
	if x != nil {
		return x.StartFlow
	}
	return ""
}

func (x *Agent) GetSecuritySettings() string {
	if x != nil {
		return x.SecuritySettings
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/dialogflow/cx/v3/agent.proto.
func (x *Agent) GetEnableStackdriverLogging() bool {
	if x != nil {
		return x.EnableStackdriverLogging
	}
	return false
}

func (x *Agent) GetEnableSpellCorrection() bool {
	if x != nil {
		return x.EnableSpellCorrection
	}
	return false
}

func (x *Agent) GetEnableMultiLanguageTraining() bool {
	if x != nil {
		return x.EnableMultiLanguageTraining
	}
	return false
}

func (x *Agent) GetLocked() bool {
	if x != nil {
		return x.Locked
	}
	return false
}

func (x *Agent) GetAdvancedSettings() *AdvancedSettings {
	if x != nil {
		return x.AdvancedSettings
	}
	return nil
}

func (x *Agent) GetGitIntegrationSettings() *Agent_GitIntegrationSettings {
	if x != nil {
		return x.GitIntegrationSettings
	}
	return nil
}

func (x *Agent) GetTextToSpeechSettings() *TextToSpeechSettings {
	if x != nil {
		return x.TextToSpeechSettings
	}
	return nil
}

func (x *Agent) GetGenAppBuilderSettings() *Agent_GenAppBuilderSettings {
	if x != nil {
		return x.GenAppBuilderSettings
	}
	return nil
}

func (x *Agent) GetAnswerFeedbackSettings() *Agent_AnswerFeedbackSettings {
	if x != nil {
		return x.AnswerFeedbackSettings
	}
	return nil
}

func (x *Agent) GetPersonalizationSettings() *Agent_PersonalizationSettings {
	if x != nil {
		return x.PersonalizationSettings
	}
	return nil
}

func (x *Agent) GetClientCertificateSettings() *Agent_ClientCertificateSettings {
	if x != nil {
		return x.ClientCertificateSettings
	}
	return nil
}

func (x *Agent) GetSatisfiesPzs() bool {
	if x != nil && x.SatisfiesPzs != nil {
		return *x.SatisfiesPzs
	}
	return false
}

func (x *Agent) GetSatisfiesPzi() bool {
	if x != nil && x.SatisfiesPzi != nil {
		return *x.SatisfiesPzi
	}
	return false
}

// The request message for
// [Agents.ListAgents][google.cloud.dialogflow.cx.v3.Agents.ListAgents].
type ListAgentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The location to list all agents for.
	// Format: `projects/<ProjectID>/locations/<LocationID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return in a single page. By default 100 and
	// at most 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListAgentsRequest) Reset() {
	*x = ListAgentsRequest{}
	mi := &file_google_cloud_dialogflow_cx_v3_agent_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListAgentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAgentsRequest) ProtoMessage() {}

func (x *ListAgentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_agent_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAgentsRequest.ProtoReflect.Descriptor instead.
func (*ListAgentsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_agent_proto_rawDescGZIP(), []int{2}
}

func (x *ListAgentsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAgentsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAgentsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response message for
// [Agents.ListAgents][google.cloud.dialogflow.cx.v3.Agents.ListAgents].
type ListAgentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of agents. There will be a maximum number of items returned based
	// on the page_size field in the request.
	Agents []*Agent `protobuf:"bytes,1,rep,name=agents,proto3" json:"agents,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAgentsResponse) Reset() {
	*x = ListAgentsResponse{}
	mi := &file_google_cloud_dialogflow_cx_v3_agent_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListAgentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAgentsResponse) ProtoMessage() {}

func (x *ListAgentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_agent_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAgentsResponse.ProtoReflect.Descriptor instead.
func (*ListAgentsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_agent_proto_rawDescGZIP(), []int{3}
}

func (x *ListAgentsResponse) GetAgents() []*Agent {
	if x != nil {
		return x.Agents
	}
	return nil
}

func (x *ListAgentsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request message for
// [Agents.GetAgent][google.cloud.dialogflow.cx.v3.Agents.GetAgent].
type GetAgentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the agent.
	// Format: `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAgentRequest) Reset() {
	*x = GetAgentRequest{}
	mi := &file_google_cloud_dialogflow_cx_v3_agent_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetAgentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAgentRequest) ProtoMessage() {}

func (x *GetAgentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_agent_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAgentRequest.ProtoReflect.Descriptor instead.
func (*GetAgentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_agent_proto_rawDescGZIP(), []int{4}
}

func (x *GetAgentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for
// [Agents.CreateAgent][google.cloud.dialogflow.cx.v3.Agents.CreateAgent].
type CreateAgentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The location to create a agent for.
	// Format: `projects/<ProjectID>/locations/<LocationID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The agent to create.
	Agent *Agent `protobuf:"bytes,2,opt,name=agent,proto3" json:"agent,omitempty"`
}

func (x *CreateAgentRequest) Reset() {
	*x = CreateAgentRequest{}
	mi := &file_google_cloud_dialogflow_cx_v3_agent_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateAgentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAgentRequest) ProtoMessage() {}

func (x *CreateAgentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_agent_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAgentRequest.ProtoReflect.Descriptor instead.
func (*CreateAgentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_agent_proto_rawDescGZIP(), []int{5}
}

func (x *CreateAgentRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateAgentRequest) GetAgent() *Agent {
	if x != nil {
		return x.Agent
	}
	return nil
}

// The request message for
// [Agents.UpdateAgent][google.cloud.dialogflow.cx.v3.Agents.UpdateAgent].
type UpdateAgentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The agent to update.
	Agent *Agent `protobuf:"bytes,1,opt,name=agent,proto3" json:"agent,omitempty"`
	// The mask to control which fields get updated. If the mask is not present,
	// all fields will be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateAgentRequest) Reset() {
	*x = UpdateAgentRequest{}
	mi := &file_google_cloud_dialogflow_cx_v3_agent_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateAgentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAgentRequest) ProtoMessage() {}

func (x *UpdateAgentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_agent_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAgentRequest.ProtoReflect.Descriptor instead.
func (*UpdateAgentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_agent_proto_rawDescGZIP(), []int{6}
}

func (x *UpdateAgentRequest) GetAgent() *Agent {
	if x != nil {
		return x.Agent
	}
	return nil
}

func (x *UpdateAgentRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The request message for
// [Agents.DeleteAgent][google.cloud.dialogflow.cx.v3.Agents.DeleteAgent].
type DeleteAgentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the agent to delete.
	// Format: `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteAgentRequest) Reset() {
	*x = DeleteAgentRequest{}
	mi := &file_google_cloud_dialogflow_cx_v3_agent_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteAgentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAgentRequest) ProtoMessage() {}

func (x *DeleteAgentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_agent_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAgentRequest.ProtoReflect.Descriptor instead.
func (*DeleteAgentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_agent_proto_rawDescGZIP(), []int{7}
}

func (x *DeleteAgentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for
// [Agents.ExportAgent][google.cloud.dialogflow.cx.v3.Agents.ExportAgent].
type ExportAgentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the agent to export.
	// Format: `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The [Google Cloud
	// Storage](https://cloud.google.com/storage/docs/) URI to export the agent
	// to. The format of this URI must be `gs://<bucket-name>/<object-name>`. If
	// left unspecified, the serialized agent is returned inline.
	//
	// Dialogflow performs a write operation for the Cloud Storage object
	// on the caller's behalf, so your request authentication must
	// have write permissions for the object. For more information, see
	// [Dialogflow access
	// control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
	AgentUri string `protobuf:"bytes,2,opt,name=agent_uri,json=agentUri,proto3" json:"agent_uri,omitempty"`
	// Optional. The data format of the exported agent. If not specified, `BLOB`
	// is assumed.
	DataFormat ExportAgentRequest_DataFormat `protobuf:"varint,3,opt,name=data_format,json=dataFormat,proto3,enum=google.cloud.dialogflow.cx.v3.ExportAgentRequest_DataFormat" json:"data_format,omitempty"`
	// Optional. Environment name. If not set, draft environment is assumed.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/environments/<EnvironmentID>`.
	Environment string `protobuf:"bytes,5,opt,name=environment,proto3" json:"environment,omitempty"`
	// Optional. The Git branch to export the agent to.
	GitDestination *ExportAgentRequest_GitDestination `protobuf:"bytes,6,opt,name=git_destination,json=gitDestination,proto3" json:"git_destination,omitempty"`
	// Optional. Whether to include BigQuery Export setting.
	IncludeBigqueryExportSettings bool `protobuf:"varint,7,opt,name=include_bigquery_export_settings,json=includeBigqueryExportSettings,proto3" json:"include_bigquery_export_settings,omitempty"`
}

func (x *ExportAgentRequest) Reset() {
	*x = ExportAgentRequest{}
	mi := &file_google_cloud_dialogflow_cx_v3_agent_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExportAgentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportAgentRequest) ProtoMessage() {}

func (x *ExportAgentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_agent_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportAgentRequest.ProtoReflect.Descriptor instead.
func (*ExportAgentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_agent_proto_rawDescGZIP(), []int{8}
}

func (x *ExportAgentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ExportAgentRequest) GetAgentUri() string {
	if x != nil {
		return x.AgentUri
	}
	return ""
}

func (x *ExportAgentRequest) GetDataFormat() ExportAgentRequest_DataFormat {
	if x != nil {
		return x.DataFormat
	}
	return ExportAgentRequest_DATA_FORMAT_UNSPECIFIED
}

func (x *ExportAgentRequest) GetEnvironment() string {
	if x != nil {
		return x.Environment
	}
	return ""
}

func (x *ExportAgentRequest) GetGitDestination() *ExportAgentRequest_GitDestination {
	if x != nil {
		return x.GitDestination
	}
	return nil
}

func (x *ExportAgentRequest) GetIncludeBigqueryExportSettings() bool {
	if x != nil {
		return x.IncludeBigqueryExportSettings
	}
	return false
}

// The response message for
// [Agents.ExportAgent][google.cloud.dialogflow.cx.v3.Agents.ExportAgent].
type ExportAgentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The exported agent.
	//
	// Types that are assignable to Agent:
	//
	//	*ExportAgentResponse_AgentUri
	//	*ExportAgentResponse_AgentContent
	//	*ExportAgentResponse_CommitSha
	Agent isExportAgentResponse_Agent `protobuf_oneof:"agent"`
}

func (x *ExportAgentResponse) Reset() {
	*x = ExportAgentResponse{}
	mi := &file_google_cloud_dialogflow_cx_v3_agent_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExportAgentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportAgentResponse) ProtoMessage() {}

func (x *ExportAgentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_agent_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportAgentResponse.ProtoReflect.Descriptor instead.
func (*ExportAgentResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_agent_proto_rawDescGZIP(), []int{9}
}

func (m *ExportAgentResponse) GetAgent() isExportAgentResponse_Agent {
	if m != nil {
		return m.Agent
	}
	return nil
}

func (x *ExportAgentResponse) GetAgentUri() string {
	if x, ok := x.GetAgent().(*ExportAgentResponse_AgentUri); ok {
		return x.AgentUri
	}
	return ""
}

func (x *ExportAgentResponse) GetAgentContent() []byte {
	if x, ok := x.GetAgent().(*ExportAgentResponse_AgentContent); ok {
		return x.AgentContent
	}
	return nil
}

func (x *ExportAgentResponse) GetCommitSha() string {
	if x, ok := x.GetAgent().(*ExportAgentResponse_CommitSha); ok {
		return x.CommitSha
	}
	return ""
}

type isExportAgentResponse_Agent interface {
	isExportAgentResponse_Agent()
}

type ExportAgentResponse_AgentUri struct {
	// The URI to a file containing the exported agent. This field is populated
	// if `agent_uri` is specified in
	// [ExportAgentRequest][google.cloud.dialogflow.cx.v3.ExportAgentRequest].
	AgentUri string `protobuf:"bytes,1,opt,name=agent_uri,json=agentUri,proto3,oneof"`
}

type ExportAgentResponse_AgentContent struct {
	// Uncompressed raw byte content for agent. This field is populated
	// if none of `agent_uri` and `git_destination` are specified in
	// [ExportAgentRequest][google.cloud.dialogflow.cx.v3.ExportAgentRequest].
	AgentContent []byte `protobuf:"bytes,2,opt,name=agent_content,json=agentContent,proto3,oneof"`
}

type ExportAgentResponse_CommitSha struct {
	// Commit SHA of the git push. This field is populated if
	// `git_destination` is specified in
	// [ExportAgentRequest][google.cloud.dialogflow.cx.v3.ExportAgentRequest].
	CommitSha string `protobuf:"bytes,3,opt,name=commit_sha,json=commitSha,proto3,oneof"`
}

func (*ExportAgentResponse_AgentUri) isExportAgentResponse_Agent() {}

func (*ExportAgentResponse_AgentContent) isExportAgentResponse_Agent() {}

func (*ExportAgentResponse_CommitSha) isExportAgentResponse_Agent() {}

// The request message for
// [Agents.RestoreAgent][google.cloud.dialogflow.cx.v3.Agents.RestoreAgent].
type RestoreAgentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the agent to restore into.
	// Format: `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The agent to restore.
	//
	// Types that are assignable to Agent:
	//
	//	*RestoreAgentRequest_AgentUri
	//	*RestoreAgentRequest_AgentContent
	//	*RestoreAgentRequest_GitSource_
	Agent isRestoreAgentRequest_Agent `protobuf_oneof:"agent"`
	// Agent restore mode. If not specified, `KEEP` is assumed.
	RestoreOption RestoreAgentRequest_RestoreOption `protobuf:"varint,5,opt,name=restore_option,json=restoreOption,proto3,enum=google.cloud.dialogflow.cx.v3.RestoreAgentRequest_RestoreOption" json:"restore_option,omitempty"`
}

func (x *RestoreAgentRequest) Reset() {
	*x = RestoreAgentRequest{}
	mi := &file_google_cloud_dialogflow_cx_v3_agent_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RestoreAgentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RestoreAgentRequest) ProtoMessage() {}

func (x *RestoreAgentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_agent_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RestoreAgentRequest.ProtoReflect.Descriptor instead.
func (*RestoreAgentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_agent_proto_rawDescGZIP(), []int{10}
}

func (x *RestoreAgentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (m *RestoreAgentRequest) GetAgent() isRestoreAgentRequest_Agent {
	if m != nil {
		return m.Agent
	}
	return nil
}

func (x *RestoreAgentRequest) GetAgentUri() string {
	if x, ok := x.GetAgent().(*RestoreAgentRequest_AgentUri); ok {
		return x.AgentUri
	}
	return ""
}

func (x *RestoreAgentRequest) GetAgentContent() []byte {
	if x, ok := x.GetAgent().(*RestoreAgentRequest_AgentContent); ok {
		return x.AgentContent
	}
	return nil
}

func (x *RestoreAgentRequest) GetGitSource() *RestoreAgentRequest_GitSource {
	if x, ok := x.GetAgent().(*RestoreAgentRequest_GitSource_); ok {
		return x.GitSource
	}
	return nil
}

func (x *RestoreAgentRequest) GetRestoreOption() RestoreAgentRequest_RestoreOption {
	if x != nil {
		return x.RestoreOption
	}
	return RestoreAgentRequest_RESTORE_OPTION_UNSPECIFIED
}

type isRestoreAgentRequest_Agent interface {
	isRestoreAgentRequest_Agent()
}

type RestoreAgentRequest_AgentUri struct {
	// The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
	// to restore agent from. The format of this URI must be
	// `gs://<bucket-name>/<object-name>`.
	//
	// Dialogflow performs a read operation for the Cloud Storage object
	// on the caller's behalf, so your request authentication must
	// have read permissions for the object. For more information, see
	// [Dialogflow access
	// control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
	AgentUri string `protobuf:"bytes,2,opt,name=agent_uri,json=agentUri,proto3,oneof"`
}

type RestoreAgentRequest_AgentContent struct {
	// Uncompressed raw byte content for agent.
	AgentContent []byte `protobuf:"bytes,3,opt,name=agent_content,json=agentContent,proto3,oneof"`
}

type RestoreAgentRequest_GitSource_ struct {
	// Setting for restoring from a git branch
	GitSource *RestoreAgentRequest_GitSource `protobuf:"bytes,6,opt,name=git_source,json=gitSource,proto3,oneof"`
}

func (*RestoreAgentRequest_AgentUri) isRestoreAgentRequest_Agent() {}

func (*RestoreAgentRequest_AgentContent) isRestoreAgentRequest_Agent() {}

func (*RestoreAgentRequest_GitSource_) isRestoreAgentRequest_Agent() {}

// The request message for
// [Agents.ValidateAgent][google.cloud.dialogflow.cx.v3.Agents.ValidateAgent].
type ValidateAgentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The agent to validate.
	// Format: `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If not specified, the agent's default language is used.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *ValidateAgentRequest) Reset() {
	*x = ValidateAgentRequest{}
	mi := &file_google_cloud_dialogflow_cx_v3_agent_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateAgentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateAgentRequest) ProtoMessage() {}

func (x *ValidateAgentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_agent_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateAgentRequest.ProtoReflect.Descriptor instead.
func (*ValidateAgentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_agent_proto_rawDescGZIP(), []int{11}
}

func (x *ValidateAgentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ValidateAgentRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// The request message for
// [Agents.GetAgentValidationResult][google.cloud.dialogflow.cx.v3.Agents.GetAgentValidationResult].
type GetAgentValidationResultRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The agent name.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/validationResult`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If not specified, the agent's default language is used.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *GetAgentValidationResultRequest) Reset() {
	*x = GetAgentValidationResultRequest{}
	mi := &file_google_cloud_dialogflow_cx_v3_agent_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetAgentValidationResultRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAgentValidationResultRequest) ProtoMessage() {}

func (x *GetAgentValidationResultRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_agent_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAgentValidationResultRequest.ProtoReflect.Descriptor instead.
func (*GetAgentValidationResultRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_agent_proto_rawDescGZIP(), []int{12}
}

func (x *GetAgentValidationResultRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetAgentValidationResultRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// The response message for
// [Agents.GetAgentValidationResult][google.cloud.dialogflow.cx.v3.Agents.GetAgentValidationResult].
type AgentValidationResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique identifier of the agent validation result.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/validationResult`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Contains all flow validation results.
	FlowValidationResults []*FlowValidationResult `protobuf:"bytes,2,rep,name=flow_validation_results,json=flowValidationResults,proto3" json:"flow_validation_results,omitempty"`
}

func (x *AgentValidationResult) Reset() {
	*x = AgentValidationResult{}
	mi := &file_google_cloud_dialogflow_cx_v3_agent_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AgentValidationResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AgentValidationResult) ProtoMessage() {}

func (x *AgentValidationResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_agent_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AgentValidationResult.ProtoReflect.Descriptor instead.
func (*AgentValidationResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_agent_proto_rawDescGZIP(), []int{13}
}

func (x *AgentValidationResult) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AgentValidationResult) GetFlowValidationResults() []*FlowValidationResult {
	if x != nil {
		return x.FlowValidationResults
	}
	return nil
}

// Request for
// [GetGenerativeSettings][google.cloud.dialogflow.cx.v3.Agents.GetGenerativeSettings]
// RPC.
type GetGenerativeSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/generativeSettings`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Language code of the generative settings.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *GetGenerativeSettingsRequest) Reset() {
	*x = GetGenerativeSettingsRequest{}
	mi := &file_google_cloud_dialogflow_cx_v3_agent_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetGenerativeSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGenerativeSettingsRequest) ProtoMessage() {}

func (x *GetGenerativeSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_agent_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGenerativeSettingsRequest.ProtoReflect.Descriptor instead.
func (*GetGenerativeSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_agent_proto_rawDescGZIP(), []int{14}
}

func (x *GetGenerativeSettingsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetGenerativeSettingsRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// Request for
// [UpdateGenerativeSettings][google.cloud.dialogflow.cx.v3.Agents.UpdateGenerativeSettings]
// RPC.
type UpdateGenerativeSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Generative settings to update.
	GenerativeSettings *GenerativeSettings `protobuf:"bytes,1,opt,name=generative_settings,json=generativeSettings,proto3" json:"generative_settings,omitempty"`
	// Optional. The mask to control which fields get updated. If the mask is not
	// present, all fields will be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateGenerativeSettingsRequest) Reset() {
	*x = UpdateGenerativeSettingsRequest{}
	mi := &file_google_cloud_dialogflow_cx_v3_agent_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateGenerativeSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateGenerativeSettingsRequest) ProtoMessage() {}

func (x *UpdateGenerativeSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_agent_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateGenerativeSettingsRequest.ProtoReflect.Descriptor instead.
func (*UpdateGenerativeSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_agent_proto_rawDescGZIP(), []int{15}
}

func (x *UpdateGenerativeSettingsRequest) GetGenerativeSettings() *GenerativeSettings {
	if x != nil {
		return x.GenerativeSettings
	}
	return nil
}

func (x *UpdateGenerativeSettingsRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Settings for connecting to Git repository for an agent.
type Agent_GitIntegrationSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The git settings to specific systems.
	//
	// Types that are assignable to GitSettings:
	//
	//	*Agent_GitIntegrationSettings_GithubSettings_
	GitSettings isAgent_GitIntegrationSettings_GitSettings `protobuf_oneof:"git_settings"`
}

func (x *Agent_GitIntegrationSettings) Reset() {
	*x = Agent_GitIntegrationSettings{}
	mi := &file_google_cloud_dialogflow_cx_v3_agent_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Agent_GitIntegrationSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Agent_GitIntegrationSettings) ProtoMessage() {}

func (x *Agent_GitIntegrationSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_agent_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Agent_GitIntegrationSettings.ProtoReflect.Descriptor instead.
func (*Agent_GitIntegrationSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_agent_proto_rawDescGZIP(), []int{1, 0}
}

func (m *Agent_GitIntegrationSettings) GetGitSettings() isAgent_GitIntegrationSettings_GitSettings {
	if m != nil {
		return m.GitSettings
	}
	return nil
}

func (x *Agent_GitIntegrationSettings) GetGithubSettings() *Agent_GitIntegrationSettings_GithubSettings {
	if x, ok := x.GetGitSettings().(*Agent_GitIntegrationSettings_GithubSettings_); ok {
		return x.GithubSettings
	}
	return nil
}

type isAgent_GitIntegrationSettings_GitSettings interface {
	isAgent_GitIntegrationSettings_GitSettings()
}

type Agent_GitIntegrationSettings_GithubSettings_ struct {
	// GitHub settings.
	GithubSettings *Agent_GitIntegrationSettings_GithubSettings `protobuf:"bytes,1,opt,name=github_settings,json=githubSettings,proto3,oneof"`
}

func (*Agent_GitIntegrationSettings_GithubSettings_) isAgent_GitIntegrationSettings_GitSettings() {}

// Settings for Gen App Builder.
type Agent_GenAppBuilderSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The full name of the Gen App Builder engine related to this
	// agent if there is one. Format: `projects/{Project ID}/locations/{Location
	// ID}/collections/{Collection ID}/engines/{Engine ID}`
	Engine string `protobuf:"bytes,1,opt,name=engine,proto3" json:"engine,omitempty"`
}

func (x *Agent_GenAppBuilderSettings) Reset() {
	*x = Agent_GenAppBuilderSettings{}
	mi := &file_google_cloud_dialogflow_cx_v3_agent_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Agent_GenAppBuilderSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Agent_GenAppBuilderSettings) ProtoMessage() {}

func (x *Agent_GenAppBuilderSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_agent_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Agent_GenAppBuilderSettings.ProtoReflect.Descriptor instead.
func (*Agent_GenAppBuilderSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_agent_proto_rawDescGZIP(), []int{1, 1}
}

func (x *Agent_GenAppBuilderSettings) GetEngine() string {
	if x != nil {
		return x.Engine
	}
	return ""
}

// Settings for answer feedback collection.
type Agent_AnswerFeedbackSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. If enabled, end users will be able to provide
	// [answer feedback][google.cloud.dialogflow.cx.v3.AnswerFeedback] to
	// Dialogflow responses. Feature works only if interaction logging is
	// enabled in the Dialogflow agent.
	EnableAnswerFeedback bool `protobuf:"varint,1,opt,name=enable_answer_feedback,json=enableAnswerFeedback,proto3" json:"enable_answer_feedback,omitempty"`
}

func (x *Agent_AnswerFeedbackSettings) Reset() {
	*x = Agent_AnswerFeedbackSettings{}
	mi := &file_google_cloud_dialogflow_cx_v3_agent_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Agent_AnswerFeedbackSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Agent_AnswerFeedbackSettings) ProtoMessage() {}

func (x *Agent_AnswerFeedbackSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_agent_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Agent_AnswerFeedbackSettings.ProtoReflect.Descriptor instead.
func (*Agent_AnswerFeedbackSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_agent_proto_rawDescGZIP(), []int{1, 2}
}

func (x *Agent_AnswerFeedbackSettings) GetEnableAnswerFeedback() bool {
	if x != nil {
		return x.EnableAnswerFeedback
	}
	return false
}

// Settings for end user personalization.
type Agent_PersonalizationSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Default end user metadata, used when processing DetectIntent
	// requests. Recommended to be filled as a template instead of hard-coded
	// value, for example { "age": "$session.params.age" }. The data will be
	// merged with the
	// [QueryParameters.end_user_metadata][google.cloud.dialogflow.cx.v3.QueryParameters.end_user_metadata]
	// in
	// [DetectIntentRequest.query_params][google.cloud.dialogflow.cx.v3.DetectIntentRequest.query_params]
	// during query processing.
	DefaultEndUserMetadata *structpb.Struct `protobuf:"bytes,1,opt,name=default_end_user_metadata,json=defaultEndUserMetadata,proto3" json:"default_end_user_metadata,omitempty"`
}

func (x *Agent_PersonalizationSettings) Reset() {
	*x = Agent_PersonalizationSettings{}
	mi := &file_google_cloud_dialogflow_cx_v3_agent_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Agent_PersonalizationSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Agent_PersonalizationSettings) ProtoMessage() {}

func (x *Agent_PersonalizationSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_agent_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Agent_PersonalizationSettings.ProtoReflect.Descriptor instead.
func (*Agent_PersonalizationSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_agent_proto_rawDescGZIP(), []int{1, 3}
}

func (x *Agent_PersonalizationSettings) GetDefaultEndUserMetadata() *structpb.Struct {
	if x != nil {
		return x.DefaultEndUserMetadata
	}
	return nil
}

// Settings for custom client certificates.
type Agent_ClientCertificateSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ssl certificate encoded in PEM format. This string must
	// include the begin header and end footer lines.
	SslCertificate string `protobuf:"bytes,1,opt,name=ssl_certificate,json=sslCertificate,proto3" json:"ssl_certificate,omitempty"`
	// Required. The name of the SecretManager secret version resource storing
	// the private key encoded in PEM format. Format:
	// `projects/{project}/secrets/{secret}/versions/{version}`
	PrivateKey string `protobuf:"bytes,2,opt,name=private_key,json=privateKey,proto3" json:"private_key,omitempty"`
	// Optional. The name of the SecretManager secret version resource storing
	// the passphrase. 'passphrase' should be left unset if the private key is
	// not encrypted.
	// Format: `projects/{project}/secrets/{secret}/versions/{version}`
	Passphrase string `protobuf:"bytes,3,opt,name=passphrase,proto3" json:"passphrase,omitempty"`
}

func (x *Agent_ClientCertificateSettings) Reset() {
	*x = Agent_ClientCertificateSettings{}
	mi := &file_google_cloud_dialogflow_cx_v3_agent_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Agent_ClientCertificateSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Agent_ClientCertificateSettings) ProtoMessage() {}

func (x *Agent_ClientCertificateSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_agent_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Agent_ClientCertificateSettings.ProtoReflect.Descriptor instead.
func (*Agent_ClientCertificateSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_agent_proto_rawDescGZIP(), []int{1, 4}
}

func (x *Agent_ClientCertificateSettings) GetSslCertificate() string {
	if x != nil {
		return x.SslCertificate
	}
	return ""
}

func (x *Agent_ClientCertificateSettings) GetPrivateKey() string {
	if x != nil {
		return x.PrivateKey
	}
	return ""
}

func (x *Agent_ClientCertificateSettings) GetPassphrase() string {
	if x != nil {
		return x.Passphrase
	}
	return ""
}

// Settings of integration with GitHub.
type Agent_GitIntegrationSettings_GithubSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique repository display name for the GitHub repository.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The GitHub repository URI related to the agent.
	RepositoryUri string `protobuf:"bytes,2,opt,name=repository_uri,json=repositoryUri,proto3" json:"repository_uri,omitempty"`
	// The branch of the GitHub repository tracked for this agent.
	TrackingBranch string `protobuf:"bytes,3,opt,name=tracking_branch,json=trackingBranch,proto3" json:"tracking_branch,omitempty"`
	// The access token used to authenticate the access to the GitHub
	// repository.
	AccessToken string `protobuf:"bytes,4,opt,name=access_token,json=accessToken,proto3" json:"access_token,omitempty"`
	// A list of branches configured to be used from Dialogflow.
	Branches []string `protobuf:"bytes,5,rep,name=branches,proto3" json:"branches,omitempty"`
}

func (x *Agent_GitIntegrationSettings_GithubSettings) Reset() {
	*x = Agent_GitIntegrationSettings_GithubSettings{}
	mi := &file_google_cloud_dialogflow_cx_v3_agent_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Agent_GitIntegrationSettings_GithubSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Agent_GitIntegrationSettings_GithubSettings) ProtoMessage() {}

func (x *Agent_GitIntegrationSettings_GithubSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_agent_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Agent_GitIntegrationSettings_GithubSettings.ProtoReflect.Descriptor instead.
func (*Agent_GitIntegrationSettings_GithubSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_agent_proto_rawDescGZIP(), []int{1, 0, 0}
}

func (x *Agent_GitIntegrationSettings_GithubSettings) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Agent_GitIntegrationSettings_GithubSettings) GetRepositoryUri() string {
	if x != nil {
		return x.RepositoryUri
	}
	return ""
}

func (x *Agent_GitIntegrationSettings_GithubSettings) GetTrackingBranch() string {
	if x != nil {
		return x.TrackingBranch
	}
	return ""
}

func (x *Agent_GitIntegrationSettings_GithubSettings) GetAccessToken() string {
	if x != nil {
		return x.AccessToken
	}
	return ""
}

func (x *Agent_GitIntegrationSettings_GithubSettings) GetBranches() []string {
	if x != nil {
		return x.Branches
	}
	return nil
}

// Settings for exporting to a git branch.
type ExportAgentRequest_GitDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Tracking branch for the git push.
	TrackingBranch string `protobuf:"bytes,1,opt,name=tracking_branch,json=trackingBranch,proto3" json:"tracking_branch,omitempty"`
	// Commit message for the git push.
	CommitMessage string `protobuf:"bytes,2,opt,name=commit_message,json=commitMessage,proto3" json:"commit_message,omitempty"`
}

func (x *ExportAgentRequest_GitDestination) Reset() {
	*x = ExportAgentRequest_GitDestination{}
	mi := &file_google_cloud_dialogflow_cx_v3_agent_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExportAgentRequest_GitDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportAgentRequest_GitDestination) ProtoMessage() {}

func (x *ExportAgentRequest_GitDestination) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_agent_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportAgentRequest_GitDestination.ProtoReflect.Descriptor instead.
func (*ExportAgentRequest_GitDestination) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_agent_proto_rawDescGZIP(), []int{8, 0}
}

func (x *ExportAgentRequest_GitDestination) GetTrackingBranch() string {
	if x != nil {
		return x.TrackingBranch
	}
	return ""
}

func (x *ExportAgentRequest_GitDestination) GetCommitMessage() string {
	if x != nil {
		return x.CommitMessage
	}
	return ""
}

// Settings for restoring from a git branch
type RestoreAgentRequest_GitSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// tracking branch for the git pull
	TrackingBranch string `protobuf:"bytes,1,opt,name=tracking_branch,json=trackingBranch,proto3" json:"tracking_branch,omitempty"`
}

func (x *RestoreAgentRequest_GitSource) Reset() {
	*x = RestoreAgentRequest_GitSource{}
	mi := &file_google_cloud_dialogflow_cx_v3_agent_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RestoreAgentRequest_GitSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RestoreAgentRequest_GitSource) ProtoMessage() {}

func (x *RestoreAgentRequest_GitSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_agent_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RestoreAgentRequest_GitSource.ProtoReflect.Descriptor instead.
func (*RestoreAgentRequest_GitSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_agent_proto_rawDescGZIP(), []int{10, 0}
}

func (x *RestoreAgentRequest_GitSource) GetTrackingBranch() string {
	if x != nil {
		return x.TrackingBranch
	}
	return ""
}

var File_google_cloud_dialogflow_cx_v3_agent_proto protoreflect.FileDescriptor

var file_google_cloud_dialogflow_cx_v3_agent_proto_rawDesc = []byte{
	0x0a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x2f,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1d, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x35, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x2f, 0x61, 0x64, 0x76,
	0x61, 0x6e, 0x63, 0x65, 0x64, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78,
	0x2f, 0x76, 0x33, 0x2f, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f,
	0x63, 0x78, 0x2f, 0x76, 0x33, 0x2f, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x2f,
	0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x50, 0x0a, 0x14, 0x53,
	0x70, 0x65, 0x65, 0x63, 0x68, 0x54, 0x6f, 0x54, 0x65, 0x78, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x12, 0x38, 0x0a, 0x18, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x70,
	0x65, 0x65, 0x63, 0x68, 0x5f, 0x61, 0x64, 0x61, 0x70, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x16, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x70, 0x65,
	0x65, 0x63, 0x68, 0x41, 0x64, 0x61, 0x70, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa2, 0x15,
	0x0a, 0x05, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x15, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05, 0x52, 0x13, 0x64, 0x65, 0x66, 0x61,
	0x75, 0x6c, 0x74, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12,
	0x38, 0x0a, 0x18, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x16, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x73, 0x12, 0x20, 0x0a, 0x09, 0x74, 0x69, 0x6d,
	0x65, 0x5f, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x08, 0x74, 0x69, 0x6d, 0x65, 0x5a, 0x6f, 0x6e, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a,
	0x0a, 0x61, 0x76, 0x61, 0x74, 0x61, 0x72, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x61, 0x76, 0x61, 0x74, 0x61, 0x72, 0x55, 0x72, 0x69, 0x12, 0x6a, 0x0a, 0x17,
	0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x5f, 0x74, 0x6f, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x73,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x53, 0x70,
	0x65, 0x65, 0x63, 0x68, 0x54, 0x6f, 0x54, 0x65, 0x78, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x52, 0x14, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x54, 0x6f, 0x54, 0x65, 0x78, 0x74,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x45, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x5f, 0x66, 0x6c, 0x6f, 0x77, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41,
	0x05, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x46, 0x6c, 0x6f, 0x77, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x46, 0x6c, 0x6f, 0x77, 0x12,
	0x5c, 0x0a, 0x11, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x73, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x18, 0x11, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xfa, 0x41, 0x2c, 0x0a,
	0x2a, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x10, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x40, 0x0a,
	0x1a, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x64, 0x72, 0x69,
	0x76, 0x65, 0x72, 0x5f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x18, 0x12, 0x20, 0x01, 0x28,
	0x08, 0x42, 0x02, 0x18, 0x01, 0x52, 0x18, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x74, 0x61,
	0x63, 0x6b, 0x64, 0x72, 0x69, 0x76, 0x65, 0x72, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x12,
	0x36, 0x0a, 0x17, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x70, 0x65, 0x6c, 0x6c, 0x5f,
	0x63, 0x6f, 0x72, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x14, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x15, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x70, 0x65, 0x6c, 0x6c, 0x43, 0x6f, 0x72,
	0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x48, 0x0a, 0x1e, 0x65, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x5f, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x18, 0x28, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x1b, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x4d, 0x75, 0x6c, 0x74,
	0x69, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e,
	0x67, 0x12, 0x16, 0x0a, 0x06, 0x6c, 0x6f, 0x63, 0x6b, 0x65, 0x64, 0x18, 0x1b, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x06, 0x6c, 0x6f, 0x63, 0x6b, 0x65, 0x64, 0x12, 0x5c, 0x0a, 0x11, 0x61, 0x64, 0x76,
	0x61, 0x6e, 0x63, 0x65, 0x64, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x16,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x10, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x75, 0x0a, 0x18, 0x67, 0x69, 0x74, 0x5f, 0x69,
	0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x2e,
	0x47, 0x69, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x16, 0x67, 0x69, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x6a,
	0x0a, 0x17, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x74, 0x6f, 0x5f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68,
	0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x1f, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e,
	0x54, 0x65, 0x78, 0x74, 0x54, 0x6f, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x52, 0x14, 0x74, 0x65, 0x78, 0x74, 0x54, 0x6f, 0x53, 0x70, 0x65, 0x65,
	0x63, 0x68, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x78, 0x0a, 0x18, 0x67, 0x65,
	0x6e, 0x5f, 0x61, 0x70, 0x70, 0x5f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x65, 0x72, 0x5f, 0x73, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x21, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x67, 0x65,
	0x6e, 0x74, 0x2e, 0x47, 0x65, 0x6e, 0x41, 0x70, 0x70, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x65, 0x72,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x48, 0x00, 0x52, 0x15, 0x67, 0x65, 0x6e, 0x41,
	0x70, 0x70, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x88, 0x01, 0x01, 0x12, 0x7a, 0x0a, 0x18, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x5f, 0x66,
	0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x18, 0x26, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x2e, 0x41, 0x6e, 0x73,
	0x77, 0x65, 0x72, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x16, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72,
	0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x12, 0x7c, 0x0a, 0x18, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x2a, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e,
	0x76, 0x33, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61,
	0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x17, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x83,
	0x01, 0x0a, 0x1b, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x2b,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x2e, 0x43, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x19, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x12, 0x30, 0x0a, 0x0d, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65,
	0x73, 0x5f, 0x70, 0x7a, 0x73, 0x18, 0x2d, 0x20, 0x01, 0x28, 0x08, 0x42, 0x06, 0xe0, 0x41, 0x01,
	0xe0, 0x41, 0x03, 0x48, 0x01, 0x52, 0x0c, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73,
	0x50, 0x7a, 0x73, 0x88, 0x01, 0x01, 0x12, 0x30, 0x0a, 0x0d, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66,
	0x69, 0x65, 0x73, 0x5f, 0x70, 0x7a, 0x69, 0x18, 0x2e, 0x20, 0x01, 0x28, 0x08, 0x42, 0x06, 0xe0,
	0x41, 0x01, 0xe0, 0x41, 0x03, 0x48, 0x02, 0x52, 0x0c, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69,
	0x65, 0x73, 0x50, 0x7a, 0x69, 0x88, 0x01, 0x01, 0x1a, 0xe4, 0x02, 0x0a, 0x16, 0x47, 0x69, 0x74,
	0x49, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x12, 0x75, 0x0a, 0x0f, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x5f, 0x73, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x67, 0x65,
	0x6e, 0x74, 0x2e, 0x47, 0x69, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x47, 0x69, 0x74, 0x68, 0x75, 0x62,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x48, 0x00, 0x52, 0x0e, 0x67, 0x69, 0x74, 0x68,
	0x75, 0x62, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x1a, 0xc2, 0x01, 0x0a, 0x0e, 0x47,
	0x69, 0x74, 0x68, 0x75, 0x62, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x21, 0x0a,
	0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x25, 0x0a, 0x0e, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x75,
	0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x6f, 0x72, 0x79, 0x55, 0x72, 0x69, 0x12, 0x27, 0x0a, 0x0f, 0x74, 0x72, 0x61, 0x63, 0x6b,
	0x69, 0x6e, 0x67, 0x5f, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0e, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x42, 0x72, 0x61, 0x6e, 0x63, 0x68,
	0x12, 0x21, 0x0a, 0x0c, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x1a, 0x0a, 0x08, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x65, 0x73, 0x18,
	0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x65, 0x73, 0x42,
	0x0e, 0x0a, 0x0c, 0x67, 0x69, 0x74, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x1a,
	0x34, 0x0a, 0x15, 0x47, 0x65, 0x6e, 0x41, 0x70, 0x70, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x65, 0x72,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x1b, 0x0a, 0x06, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x1a, 0x53, 0x0a, 0x16, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x46,
	0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12,
	0x39, 0x0a, 0x16, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72,
	0x5f, 0x66, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x41, 0x6e, 0x73, 0x77,
	0x65, 0x72, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x1a, 0x72, 0x0a, 0x17, 0x50, 0x65,
	0x72, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x57, 0x0a, 0x19, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74,
	0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x16, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x45,
	0x6e, 0x64, 0x55, 0x73, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x1a, 0xf2,
	0x01, 0x0a, 0x19, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x2c, 0x0a, 0x0f,
	0x73, 0x73, 0x6c, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x73, 0x73, 0x6c, 0x43,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x53, 0x0a, 0x0b, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x12,
	0x52, 0x0a, 0x0a, 0x70, 0x61, 0x73, 0x73, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x73, 0x65, 0x63,
	0x72, 0x65, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x70, 0x61, 0x73, 0x73, 0x70, 0x68, 0x72,
	0x61, 0x73, 0x65, 0x3a, 0x5c, 0xea, 0x41, 0x59, 0x0a, 0x1f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x12, 0x36, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x7d, 0x42, 0x1b, 0x0a, 0x19, 0x5f, 0x67, 0x65, 0x6e, 0x5f, 0x61, 0x70, 0x70, 0x5f, 0x62, 0x75,
	0x69, 0x6c, 0x64, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x10,
	0x0a, 0x0e, 0x5f, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x5f, 0x70, 0x7a, 0x73,
	0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x5f, 0x70,
	0x7a, 0x69, 0x22, 0x90, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x67, 0x65, 0x6e, 0x74,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21,
	0x12, 0x1f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x67, 0x65, 0x6e,
	0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x7a, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x67, 0x65,
	0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3c, 0x0a, 0x06, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x67, 0x65, 0x6e,
	0x74, 0x52, 0x06, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0x4e, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0x96, 0x01, 0x0a, 0x12, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x67, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21,
	0x12, 0x1f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x67, 0x65, 0x6e,
	0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x3f, 0x0a, 0x05, 0x61, 0x67, 0x65,
	0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x05, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x22, 0x92, 0x01, 0x0a, 0x12, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x3f, 0x0a, 0x05, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33,
	0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x61, 0x67, 0x65,
	0x6e, 0x74, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d,
	0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22,
	0x51, 0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0x8f, 0x05, 0x0a, 0x12, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x67, 0x65,
	0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a,
	0x1f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x67, 0x65, 0x6e, 0x74,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f,
	0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x55, 0x72, 0x69, 0x12, 0x62, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61,
	0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x78,
	0x70, 0x6f, 0x72, 0x74, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x4f, 0x0a, 0x0b,
	0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2d, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x6e, 0x0a,
	0x0f, 0x67, 0x69, 0x74, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x67, 0x65,
	0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x47, 0x69, 0x74, 0x44, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x67,
	0x69, 0x74, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4c, 0x0a,
	0x20, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1d, 0x69, 0x6e,
	0x63, 0x6c, 0x75, 0x64, 0x65, 0x42, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70,
	0x6f, 0x72, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x1a, 0x60, 0x0a, 0x0e, 0x47,
	0x69, 0x74, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x27, 0x0a,
	0x0f, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67,
	0x42, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74,
	0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0x45, 0x0a,
	0x0a, 0x44, 0x61, 0x74, 0x61, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x1b, 0x0a, 0x17, 0x44,
	0x41, 0x54, 0x41, 0x5f, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x42, 0x4c, 0x4f, 0x42,
	0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x4a, 0x53, 0x4f, 0x4e, 0x5f, 0x50, 0x41, 0x43, 0x4b, 0x41,
	0x47, 0x45, 0x10, 0x04, 0x22, 0x85, 0x01, 0x0a, 0x13, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x41,
	0x67, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1d, 0x0a, 0x09,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x00, 0x52, 0x08, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x55, 0x72, 0x69, 0x12, 0x25, 0x0a, 0x0d, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0c, 0x48, 0x00, 0x52, 0x0c, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x12, 0x1f, 0x0a, 0x0a, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x73, 0x68, 0x61,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74,
	0x53, 0x68, 0x61, 0x42, 0x07, 0x0a, 0x05, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x22, 0xe8, 0x03, 0x0a,
	0x13, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x1d, 0x0a, 0x09, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x08, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x55, 0x72, 0x69,
	0x12, 0x25, 0x0a, 0x0d, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x0c, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x5d, 0x0a, 0x0a, 0x67, 0x69, 0x74, 0x5f, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e,
	0x47, 0x69, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x09, 0x67, 0x69, 0x74,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x67, 0x0a, 0x0e, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x40,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x52,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x0d, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x1a,
	0x34, 0x0a, 0x09, 0x47, 0x69, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x27, 0x0a, 0x0f,
	0x74, 0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x42,
	0x72, 0x61, 0x6e, 0x63, 0x68, 0x22, 0x47, 0x0a, 0x0d, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1e, 0x0a, 0x1a, 0x52, 0x45, 0x53, 0x54, 0x4f, 0x52,
	0x45, 0x5f, 0x4f, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x4b, 0x45, 0x45, 0x50, 0x10, 0x01,
	0x12, 0x0c, 0x0a, 0x08, 0x46, 0x41, 0x4c, 0x4c, 0x42, 0x41, 0x43, 0x4b, 0x10, 0x02, 0x42, 0x07,
	0x0a, 0x05, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x22, 0x78, 0x0a, 0x14, 0x56, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x65, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x3b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64,
	0x65, 0x22, 0x93, 0x01, 0x0a, 0x1f, 0x47, 0x65, 0x74, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x56, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x56, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63,
	0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x22, 0x97, 0x02, 0x0a, 0x15, 0x41, 0x67, 0x65, 0x6e,
	0x74, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x6b, 0x0a, 0x17, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x46, 0x6c, 0x6f, 0x77, 0x56, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x15, 0x66, 0x6c, 0x6f,
	0x77, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x73, 0x3a, 0x7d, 0xea, 0x41, 0x7a, 0x0a, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x47, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x7d,
	0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x22, 0x97, 0x01, 0x0a, 0x1c, 0x47, 0x65, 0x74, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x76, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x4d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x39, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x33, 0x0a, 0x31, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x76, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f,
	0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x22, 0xcc, 0x01, 0x0a, 0x1f,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x67, 0x0a, 0x13, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x73, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x32, 0xa2, 0x12, 0x0a, 0x06, 0x41,
	0x67, 0x65, 0x6e, 0x74, 0x73, 0x12, 0xae, 0x01, 0x0a, 0x0a, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x67,
	0x65, 0x6e, 0x74, 0x73, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x67, 0x65, 0x6e, 0x74,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3b, 0xda, 0x41, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2c, 0x12, 0x2a, 0x2f, 0x76, 0x33, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x9b, 0x01, 0x0a, 0x08, 0x47, 0x65, 0x74, 0x41, 0x67,
	0x65, 0x6e, 0x74, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78,
	0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78,
	0x2e, 0x76, 0x33, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x22, 0x39, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2c, 0x12, 0x2a, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xb0, 0x01, 0x0a, 0x0b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41,
	0x67, 0x65, 0x6e, 0x74, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x67, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x22, 0x48, 0xda,
	0x41, 0x0c, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x33, 0x3a, 0x05, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x22, 0x2a, 0x2f, 0x76, 0x33,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x12, 0xbb, 0x01, 0x0a, 0x0b, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x67,
	0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74,
	0x22, 0x53, 0xda, 0x41, 0x11, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x3a, 0x05, 0x61, 0x67,
	0x65, 0x6e, 0x74, 0x32, 0x30, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e,
	0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x93, 0x01, 0x0a, 0x0b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x41, 0x67, 0x65, 0x6e, 0x74, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x67, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79,
	0x22, 0x39, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2c, 0x2a,
	0x2a, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xcd, 0x01, 0x0a, 0x0b,
	0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x12, 0x31, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x78, 0x70, 0x6f,
	0x72, 0x74, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6c, 0xca,
	0x41, 0x2d, 0x0a, 0x13, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x36, 0x3a, 0x01, 0x2a, 0x22, 0x31, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x12, 0xd2, 0x01, 0x0a, 0x0c,
	0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x12, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x6f, 0xca, 0x41, 0x2f, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x16, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37, 0x3a, 0x01, 0x2a, 0x22, 0x32, 0x2f, 0x76,
	0x33, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x12, 0xba, 0x01, 0x0a, 0x0d, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x41, 0x67, 0x65,
	0x6e, 0x74, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e,
	0x76, 0x33, 0x2e, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x41, 0x67, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x56, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0x3e, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x38, 0x3a, 0x01, 0x2a, 0x22, 0x33, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x12, 0xdc, 0x01,
	0x0a, 0x18, 0x47, 0x65, 0x74, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x67,
	0x65, 0x6e, 0x74, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74,
	0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x22, 0x4a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x12,
	0x3b, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x7d, 0x12, 0xe3, 0x01, 0x0a,
	0x15, 0x47, 0x65, 0x74, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65, 0x74, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x76, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78,
	0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x5a, 0xda, 0x41, 0x12, 0x6e, 0x61, 0x6d, 0x65, 0x2c,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x3f, 0x12, 0x3d, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x7d, 0x12, 0xa0, 0x02, 0x0a, 0x18, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x47, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12,
	0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x22, 0x90, 0x01, 0xda, 0x41, 0x1f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x76, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2c, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x68, 0x3a, 0x13, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x32, 0x51, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x76, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x7d, 0x1a, 0x78, 0xca, 0x41, 0x19, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x59, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77,
	0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x61, 0x75, 0x74, 0x68, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x42,
	0x94, 0x02, 0xea, 0x41, 0x64, 0x0a, 0x2a, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x36, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x73,
	0x65, 0x63, 0x72, 0x65, 0x74, 0x7d, 0x2f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x7d, 0x0a, 0x21, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x42, 0x0a, 0x41, 0x67,
	0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x31, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x61, 0x70,
	0x69, 0x76, 0x33, 0x2f, 0x63, 0x78, 0x70, 0x62, 0x3b, 0x63, 0x78, 0x70, 0x62, 0xa2, 0x02, 0x02,
	0x44, 0x46, 0xaa, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x43, 0x78, 0x2e,
	0x56, 0x33, 0xea, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x3a, 0x3a, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x3a, 0x3a,
	0x43, 0x58, 0x3a, 0x3a, 0x56, 0x33, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_dialogflow_cx_v3_agent_proto_rawDescOnce sync.Once
	file_google_cloud_dialogflow_cx_v3_agent_proto_rawDescData = file_google_cloud_dialogflow_cx_v3_agent_proto_rawDesc
)

func file_google_cloud_dialogflow_cx_v3_agent_proto_rawDescGZIP() []byte {
	file_google_cloud_dialogflow_cx_v3_agent_proto_rawDescOnce.Do(func() {
		file_google_cloud_dialogflow_cx_v3_agent_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dialogflow_cx_v3_agent_proto_rawDescData)
	})
	return file_google_cloud_dialogflow_cx_v3_agent_proto_rawDescData
}

var file_google_cloud_dialogflow_cx_v3_agent_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_dialogflow_cx_v3_agent_proto_msgTypes = make([]protoimpl.MessageInfo, 24)
var file_google_cloud_dialogflow_cx_v3_agent_proto_goTypes = []any{
	(ExportAgentRequest_DataFormat)(0),                  // 0: google.cloud.dialogflow.cx.v3.ExportAgentRequest.DataFormat
	(RestoreAgentRequest_RestoreOption)(0),              // 1: google.cloud.dialogflow.cx.v3.RestoreAgentRequest.RestoreOption
	(*SpeechToTextSettings)(nil),                        // 2: google.cloud.dialogflow.cx.v3.SpeechToTextSettings
	(*Agent)(nil),                                       // 3: google.cloud.dialogflow.cx.v3.Agent
	(*ListAgentsRequest)(nil),                           // 4: google.cloud.dialogflow.cx.v3.ListAgentsRequest
	(*ListAgentsResponse)(nil),                          // 5: google.cloud.dialogflow.cx.v3.ListAgentsResponse
	(*GetAgentRequest)(nil),                             // 6: google.cloud.dialogflow.cx.v3.GetAgentRequest
	(*CreateAgentRequest)(nil),                          // 7: google.cloud.dialogflow.cx.v3.CreateAgentRequest
	(*UpdateAgentRequest)(nil),                          // 8: google.cloud.dialogflow.cx.v3.UpdateAgentRequest
	(*DeleteAgentRequest)(nil),                          // 9: google.cloud.dialogflow.cx.v3.DeleteAgentRequest
	(*ExportAgentRequest)(nil),                          // 10: google.cloud.dialogflow.cx.v3.ExportAgentRequest
	(*ExportAgentResponse)(nil),                         // 11: google.cloud.dialogflow.cx.v3.ExportAgentResponse
	(*RestoreAgentRequest)(nil),                         // 12: google.cloud.dialogflow.cx.v3.RestoreAgentRequest
	(*ValidateAgentRequest)(nil),                        // 13: google.cloud.dialogflow.cx.v3.ValidateAgentRequest
	(*GetAgentValidationResultRequest)(nil),             // 14: google.cloud.dialogflow.cx.v3.GetAgentValidationResultRequest
	(*AgentValidationResult)(nil),                       // 15: google.cloud.dialogflow.cx.v3.AgentValidationResult
	(*GetGenerativeSettingsRequest)(nil),                // 16: google.cloud.dialogflow.cx.v3.GetGenerativeSettingsRequest
	(*UpdateGenerativeSettingsRequest)(nil),             // 17: google.cloud.dialogflow.cx.v3.UpdateGenerativeSettingsRequest
	(*Agent_GitIntegrationSettings)(nil),                // 18: google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings
	(*Agent_GenAppBuilderSettings)(nil),                 // 19: google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings
	(*Agent_AnswerFeedbackSettings)(nil),                // 20: google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings
	(*Agent_PersonalizationSettings)(nil),               // 21: google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings
	(*Agent_ClientCertificateSettings)(nil),             // 22: google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings
	(*Agent_GitIntegrationSettings_GithubSettings)(nil), // 23: google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings
	(*ExportAgentRequest_GitDestination)(nil),           // 24: google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination
	(*RestoreAgentRequest_GitSource)(nil),               // 25: google.cloud.dialogflow.cx.v3.RestoreAgentRequest.GitSource
	(*AdvancedSettings)(nil),                            // 26: google.cloud.dialogflow.cx.v3.AdvancedSettings
	(*TextToSpeechSettings)(nil),                        // 27: google.cloud.dialogflow.cx.v3.TextToSpeechSettings
	(*fieldmaskpb.FieldMask)(nil),                       // 28: google.protobuf.FieldMask
	(*FlowValidationResult)(nil),                        // 29: google.cloud.dialogflow.cx.v3.FlowValidationResult
	(*GenerativeSettings)(nil),                          // 30: google.cloud.dialogflow.cx.v3.GenerativeSettings
	(*structpb.Struct)(nil),                             // 31: google.protobuf.Struct
	(*emptypb.Empty)(nil),                               // 32: google.protobuf.Empty
	(*longrunningpb.Operation)(nil),                     // 33: google.longrunning.Operation
}
var file_google_cloud_dialogflow_cx_v3_agent_proto_depIdxs = []int32{
	2,  // 0: google.cloud.dialogflow.cx.v3.Agent.speech_to_text_settings:type_name -> google.cloud.dialogflow.cx.v3.SpeechToTextSettings
	26, // 1: google.cloud.dialogflow.cx.v3.Agent.advanced_settings:type_name -> google.cloud.dialogflow.cx.v3.AdvancedSettings
	18, // 2: google.cloud.dialogflow.cx.v3.Agent.git_integration_settings:type_name -> google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings
	27, // 3: google.cloud.dialogflow.cx.v3.Agent.text_to_speech_settings:type_name -> google.cloud.dialogflow.cx.v3.TextToSpeechSettings
	19, // 4: google.cloud.dialogflow.cx.v3.Agent.gen_app_builder_settings:type_name -> google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings
	20, // 5: google.cloud.dialogflow.cx.v3.Agent.answer_feedback_settings:type_name -> google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings
	21, // 6: google.cloud.dialogflow.cx.v3.Agent.personalization_settings:type_name -> google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings
	22, // 7: google.cloud.dialogflow.cx.v3.Agent.client_certificate_settings:type_name -> google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings
	3,  // 8: google.cloud.dialogflow.cx.v3.ListAgentsResponse.agents:type_name -> google.cloud.dialogflow.cx.v3.Agent
	3,  // 9: google.cloud.dialogflow.cx.v3.CreateAgentRequest.agent:type_name -> google.cloud.dialogflow.cx.v3.Agent
	3,  // 10: google.cloud.dialogflow.cx.v3.UpdateAgentRequest.agent:type_name -> google.cloud.dialogflow.cx.v3.Agent
	28, // 11: google.cloud.dialogflow.cx.v3.UpdateAgentRequest.update_mask:type_name -> google.protobuf.FieldMask
	0,  // 12: google.cloud.dialogflow.cx.v3.ExportAgentRequest.data_format:type_name -> google.cloud.dialogflow.cx.v3.ExportAgentRequest.DataFormat
	24, // 13: google.cloud.dialogflow.cx.v3.ExportAgentRequest.git_destination:type_name -> google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination
	25, // 14: google.cloud.dialogflow.cx.v3.RestoreAgentRequest.git_source:type_name -> google.cloud.dialogflow.cx.v3.RestoreAgentRequest.GitSource
	1,  // 15: google.cloud.dialogflow.cx.v3.RestoreAgentRequest.restore_option:type_name -> google.cloud.dialogflow.cx.v3.RestoreAgentRequest.RestoreOption
	29, // 16: google.cloud.dialogflow.cx.v3.AgentValidationResult.flow_validation_results:type_name -> google.cloud.dialogflow.cx.v3.FlowValidationResult
	30, // 17: google.cloud.dialogflow.cx.v3.UpdateGenerativeSettingsRequest.generative_settings:type_name -> google.cloud.dialogflow.cx.v3.GenerativeSettings
	28, // 18: google.cloud.dialogflow.cx.v3.UpdateGenerativeSettingsRequest.update_mask:type_name -> google.protobuf.FieldMask
	23, // 19: google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.github_settings:type_name -> google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings
	31, // 20: google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings.default_end_user_metadata:type_name -> google.protobuf.Struct
	4,  // 21: google.cloud.dialogflow.cx.v3.Agents.ListAgents:input_type -> google.cloud.dialogflow.cx.v3.ListAgentsRequest
	6,  // 22: google.cloud.dialogflow.cx.v3.Agents.GetAgent:input_type -> google.cloud.dialogflow.cx.v3.GetAgentRequest
	7,  // 23: google.cloud.dialogflow.cx.v3.Agents.CreateAgent:input_type -> google.cloud.dialogflow.cx.v3.CreateAgentRequest
	8,  // 24: google.cloud.dialogflow.cx.v3.Agents.UpdateAgent:input_type -> google.cloud.dialogflow.cx.v3.UpdateAgentRequest
	9,  // 25: google.cloud.dialogflow.cx.v3.Agents.DeleteAgent:input_type -> google.cloud.dialogflow.cx.v3.DeleteAgentRequest
	10, // 26: google.cloud.dialogflow.cx.v3.Agents.ExportAgent:input_type -> google.cloud.dialogflow.cx.v3.ExportAgentRequest
	12, // 27: google.cloud.dialogflow.cx.v3.Agents.RestoreAgent:input_type -> google.cloud.dialogflow.cx.v3.RestoreAgentRequest
	13, // 28: google.cloud.dialogflow.cx.v3.Agents.ValidateAgent:input_type -> google.cloud.dialogflow.cx.v3.ValidateAgentRequest
	14, // 29: google.cloud.dialogflow.cx.v3.Agents.GetAgentValidationResult:input_type -> google.cloud.dialogflow.cx.v3.GetAgentValidationResultRequest
	16, // 30: google.cloud.dialogflow.cx.v3.Agents.GetGenerativeSettings:input_type -> google.cloud.dialogflow.cx.v3.GetGenerativeSettingsRequest
	17, // 31: google.cloud.dialogflow.cx.v3.Agents.UpdateGenerativeSettings:input_type -> google.cloud.dialogflow.cx.v3.UpdateGenerativeSettingsRequest
	5,  // 32: google.cloud.dialogflow.cx.v3.Agents.ListAgents:output_type -> google.cloud.dialogflow.cx.v3.ListAgentsResponse
	3,  // 33: google.cloud.dialogflow.cx.v3.Agents.GetAgent:output_type -> google.cloud.dialogflow.cx.v3.Agent
	3,  // 34: google.cloud.dialogflow.cx.v3.Agents.CreateAgent:output_type -> google.cloud.dialogflow.cx.v3.Agent
	3,  // 35: google.cloud.dialogflow.cx.v3.Agents.UpdateAgent:output_type -> google.cloud.dialogflow.cx.v3.Agent
	32, // 36: google.cloud.dialogflow.cx.v3.Agents.DeleteAgent:output_type -> google.protobuf.Empty
	33, // 37: google.cloud.dialogflow.cx.v3.Agents.ExportAgent:output_type -> google.longrunning.Operation
	33, // 38: google.cloud.dialogflow.cx.v3.Agents.RestoreAgent:output_type -> google.longrunning.Operation
	15, // 39: google.cloud.dialogflow.cx.v3.Agents.ValidateAgent:output_type -> google.cloud.dialogflow.cx.v3.AgentValidationResult
	15, // 40: google.cloud.dialogflow.cx.v3.Agents.GetAgentValidationResult:output_type -> google.cloud.dialogflow.cx.v3.AgentValidationResult
	30, // 41: google.cloud.dialogflow.cx.v3.Agents.GetGenerativeSettings:output_type -> google.cloud.dialogflow.cx.v3.GenerativeSettings
	30, // 42: google.cloud.dialogflow.cx.v3.Agents.UpdateGenerativeSettings:output_type -> google.cloud.dialogflow.cx.v3.GenerativeSettings
	32, // [32:43] is the sub-list for method output_type
	21, // [21:32] is the sub-list for method input_type
	21, // [21:21] is the sub-list for extension type_name
	21, // [21:21] is the sub-list for extension extendee
	0,  // [0:21] is the sub-list for field type_name
}

func init() { file_google_cloud_dialogflow_cx_v3_agent_proto_init() }
func file_google_cloud_dialogflow_cx_v3_agent_proto_init() {
	if File_google_cloud_dialogflow_cx_v3_agent_proto != nil {
		return
	}
	file_google_cloud_dialogflow_cx_v3_advanced_settings_proto_init()
	file_google_cloud_dialogflow_cx_v3_audio_config_proto_init()
	file_google_cloud_dialogflow_cx_v3_flow_proto_init()
	file_google_cloud_dialogflow_cx_v3_generative_settings_proto_init()
	file_google_cloud_dialogflow_cx_v3_agent_proto_msgTypes[1].OneofWrappers = []any{}
	file_google_cloud_dialogflow_cx_v3_agent_proto_msgTypes[9].OneofWrappers = []any{
		(*ExportAgentResponse_AgentUri)(nil),
		(*ExportAgentResponse_AgentContent)(nil),
		(*ExportAgentResponse_CommitSha)(nil),
	}
	file_google_cloud_dialogflow_cx_v3_agent_proto_msgTypes[10].OneofWrappers = []any{
		(*RestoreAgentRequest_AgentUri)(nil),
		(*RestoreAgentRequest_AgentContent)(nil),
		(*RestoreAgentRequest_GitSource_)(nil),
	}
	file_google_cloud_dialogflow_cx_v3_agent_proto_msgTypes[16].OneofWrappers = []any{
		(*Agent_GitIntegrationSettings_GithubSettings_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dialogflow_cx_v3_agent_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   24,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_dialogflow_cx_v3_agent_proto_goTypes,
		DependencyIndexes: file_google_cloud_dialogflow_cx_v3_agent_proto_depIdxs,
		EnumInfos:         file_google_cloud_dialogflow_cx_v3_agent_proto_enumTypes,
		MessageInfos:      file_google_cloud_dialogflow_cx_v3_agent_proto_msgTypes,
	}.Build()
	File_google_cloud_dialogflow_cx_v3_agent_proto = out.File
	file_google_cloud_dialogflow_cx_v3_agent_proto_rawDesc = nil
	file_google_cloud_dialogflow_cx_v3_agent_proto_goTypes = nil
	file_google_cloud_dialogflow_cx_v3_agent_proto_depIdxs = nil
}
