/*
 * Decompiled with CFR 0.152.
 */
package rundeck.services;

import com.dtolabs.rundeck.core.authorization.AuthContext;
import com.dtolabs.rundeck.core.authorization.UserAndRolesAuthContext;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.common.INodeSet;
import com.dtolabs.rundeck.core.common.NodeSetImpl;
import com.dtolabs.rundeck.core.execution.ExecArgList;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.ExecutionException;
import com.dtolabs.rundeck.core.execution.NodeExecutionService;
import com.dtolabs.rundeck.core.execution.UnauthorizedException;
import com.dtolabs.rundeck.core.execution.service.FileCopierException;
import com.dtolabs.rundeck.core.execution.service.NodeExecutorResult;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.rundeck.app.authorization.AppAuthContextEvaluator;
import org.rundeck.core.auth.AuthConstants;

public class AuthorizingNodeExecutionService
implements NodeExecutionService,
GroovyObject {
    public static final Set<String> RUN_ACTION_SET;
    private final AppAuthContextEvaluator rundeckAuthContextEvaluator;
    private final NodeExecutionService nodeExecutionService;
    private final UserAndRolesAuthContext authContext;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public AuthorizingNodeExecutionService(AppAuthContextEvaluator rundeckAuthContextEvaluator, NodeExecutionService nodeExecutionService, UserAndRolesAuthContext authContext) {
        UserAndRolesAuthContext userAndRolesAuthContext;
        NodeExecutionService nodeExecutionService2;
        AppAuthContextEvaluator appAuthContextEvaluator;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.rundeckAuthContextEvaluator = appAuthContextEvaluator = rundeckAuthContextEvaluator;
        this.nodeExecutionService = nodeExecutionService2 = nodeExecutionService;
        this.authContext = userAndRolesAuthContext = authContext;
    }

    private boolean authCheckNode(String project, AuthContext auth, INodeEntry node) {
        NodeSetImpl nodes = new NodeSetImpl();
        nodes.putNode(node);
        INodeSet result = this.rundeckAuthContextEvaluator.filterAuthorizedNodes(project, RUN_ACTION_SET, (INodeSet)nodes, auth);
        return result.getNodeNames().contains(node.getNodename());
    }

    public NodeExecutorResult executeCommand(ExecutionContext context, ExecArgList command, INodeEntry node) throws ExecutionException {
        if (!this.authCheckNode(context.getFrameworkProject(), (AuthContext)this.authContext, node)) {
            throw (Throwable)new UnauthorizedException(StringGroovyMethods.plus((String)"Unauthorized: cannot execute on node: ", (CharSequence)node.getNodename()));
        }
        return this.nodeExecutionService.executeCommand(context, command, node);
    }

    public String fileCopyFileStream(ExecutionContext context, InputStream input, INodeEntry node, String destinationPath) throws FileCopierException, ExecutionException {
        if (!this.authCheckNode(context.getFrameworkProject(), (AuthContext)this.authContext, node)) {
            throw (Throwable)new UnauthorizedException(StringGroovyMethods.plus((String)"Unauthorized: cannot copy file to node: ", (CharSequence)node.getNodename()));
        }
        return this.nodeExecutionService.fileCopyFileStream(context, input, node, destinationPath);
    }

    public String fileCopyFile(ExecutionContext context, File file, INodeEntry node, String destinationPath) throws FileCopierException, ExecutionException {
        if (!this.authCheckNode(context.getFrameworkProject(), (AuthContext)this.authContext, node)) {
            throw (Throwable)new UnauthorizedException(StringGroovyMethods.plus((String)"Unauthorized: cannot copy file to node: ", (CharSequence)node.getNodename()));
        }
        return this.nodeExecutionService.fileCopyFile(context, file, node, destinationPath);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AuthorizingNodeExecutionService.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Set set;
        RUN_ACTION_SET = set = Collections.unmodifiableSet(new HashSet(ScriptBytecodeAdapter.createList((Object[])new Object[]{AuthConstants.ACTION_RUN})));
    }

    @Generated
    public final AppAuthContextEvaluator getRundeckAuthContextEvaluator() {
        return this.rundeckAuthContextEvaluator;
    }

    @Generated
    public final NodeExecutionService getNodeExecutionService() {
        return this.nodeExecutionService;
    }

    @Generated
    public final UserAndRolesAuthContext getAuthContext() {
        return this.authContext;
    }
}

