// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/healthcare/logging/hl7v2.proto

package logging

import (
	reflect "reflect"
	sync "sync"

	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A log entry for a HL7v2 import long-running operation.
type ImportHl7V2LogEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The source in Cloud Storage (for example,
	// `gs://{bucket_id}/{path/to/file}`).
	Source string `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	// The error code and message.
	Error *status.Status `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *ImportHl7V2LogEntry) Reset() {
	*x = ImportHl7V2LogEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_healthcare_logging_hl7v2_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportHl7V2LogEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportHl7V2LogEntry) ProtoMessage() {}

func (x *ImportHl7V2LogEntry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_healthcare_logging_hl7v2_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportHl7V2LogEntry.ProtoReflect.Descriptor instead.
func (*ImportHl7V2LogEntry) Descriptor() ([]byte, []int) {
	return file_google_cloud_healthcare_logging_hl7v2_proto_rawDescGZIP(), []int{0}
}

func (x *ImportHl7V2LogEntry) GetSource() string {
	if x != nil {
		return x.Source
	}
	return ""
}

func (x *ImportHl7V2LogEntry) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

// A log entry for a HL7v2 store Pub/Sub notification.
type Hl7V2NotificationLogEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The HL7v2 message being created (for example,
	// `projects/{projectId}/locations/{locationId}/datasets/{datasetId}/hl7V2Stores/{hl7v2StoreId}/messages/{hl7v2MessageId}`).
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// The Pub/Sub topic that the notification is published on.
	PubsubTopic string `protobuf:"bytes,2,opt,name=pubsub_topic,json=pubsubTopic,proto3" json:"pubsub_topic,omitempty"`
	// The error code and message.
	Error *status.Status `protobuf:"bytes,3,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *Hl7V2NotificationLogEntry) Reset() {
	*x = Hl7V2NotificationLogEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_healthcare_logging_hl7v2_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Hl7V2NotificationLogEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Hl7V2NotificationLogEntry) ProtoMessage() {}

func (x *Hl7V2NotificationLogEntry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_healthcare_logging_hl7v2_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Hl7V2NotificationLogEntry.ProtoReflect.Descriptor instead.
func (*Hl7V2NotificationLogEntry) Descriptor() ([]byte, []int) {
	return file_google_cloud_healthcare_logging_hl7v2_proto_rawDescGZIP(), []int{1}
}

func (x *Hl7V2NotificationLogEntry) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

func (x *Hl7V2NotificationLogEntry) GetPubsubTopic() string {
	if x != nil {
		return x.PubsubTopic
	}
	return ""
}

func (x *Hl7V2NotificationLogEntry) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

var File_google_cloud_healthcare_logging_hl7v2_proto protoreflect.FileDescriptor

var file_google_cloud_healthcare_logging_hl7v2_proto_rawDesc = []byte{
	0x0a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x68,
	0x65, 0x61, 0x6c, 0x74, 0x68, 0x63, 0x61, 0x72, 0x65, 0x2f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e,
	0x67, 0x2f, 0x68, 0x6c, 0x37, 0x76, 0x32, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x68, 0x65, 0x61, 0x6c,
	0x74, 0x68, 0x63, 0x61, 0x72, 0x65, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x1a, 0x17,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x57, 0x0a, 0x13, 0x49, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x48, 0x6c, 0x37, 0x56, 0x32, 0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x16,
	0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x28, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72,
	0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x22, 0x8d, 0x01, 0x0a, 0x19, 0x48, 0x6c, 0x37, 0x56, 0x32, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x23,
	0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x5f, 0x74, 0x6f,
	0x70, 0x69, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x70, 0x75, 0x62, 0x73, 0x75,
	0x62, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x28, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72,
	0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x42, 0x6d, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x63, 0x61, 0x72, 0x65, 0x2e,
	0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x5a, 0x46, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x63, 0x61, 0x72, 0x65, 0x2f,
	0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x3b, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_healthcare_logging_hl7v2_proto_rawDescOnce sync.Once
	file_google_cloud_healthcare_logging_hl7v2_proto_rawDescData = file_google_cloud_healthcare_logging_hl7v2_proto_rawDesc
)

func file_google_cloud_healthcare_logging_hl7v2_proto_rawDescGZIP() []byte {
	file_google_cloud_healthcare_logging_hl7v2_proto_rawDescOnce.Do(func() {
		file_google_cloud_healthcare_logging_hl7v2_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_healthcare_logging_hl7v2_proto_rawDescData)
	})
	return file_google_cloud_healthcare_logging_hl7v2_proto_rawDescData
}

var file_google_cloud_healthcare_logging_hl7v2_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_google_cloud_healthcare_logging_hl7v2_proto_goTypes = []interface{}{
	(*ImportHl7V2LogEntry)(nil),       // 0: google.cloud.healthcare.logging.ImportHl7V2LogEntry
	(*Hl7V2NotificationLogEntry)(nil), // 1: google.cloud.healthcare.logging.Hl7V2NotificationLogEntry
	(*status.Status)(nil),             // 2: google.rpc.Status
}
var file_google_cloud_healthcare_logging_hl7v2_proto_depIdxs = []int32{
	2, // 0: google.cloud.healthcare.logging.ImportHl7V2LogEntry.error:type_name -> google.rpc.Status
	2, // 1: google.cloud.healthcare.logging.Hl7V2NotificationLogEntry.error:type_name -> google.rpc.Status
	2, // [2:2] is the sub-list for method output_type
	2, // [2:2] is the sub-list for method input_type
	2, // [2:2] is the sub-list for extension type_name
	2, // [2:2] is the sub-list for extension extendee
	0, // [0:2] is the sub-list for field type_name
}

func init() { file_google_cloud_healthcare_logging_hl7v2_proto_init() }
func file_google_cloud_healthcare_logging_hl7v2_proto_init() {
	if File_google_cloud_healthcare_logging_hl7v2_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_healthcare_logging_hl7v2_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportHl7V2LogEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_healthcare_logging_hl7v2_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Hl7V2NotificationLogEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_healthcare_logging_hl7v2_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_healthcare_logging_hl7v2_proto_goTypes,
		DependencyIndexes: file_google_cloud_healthcare_logging_hl7v2_proto_depIdxs,
		MessageInfos:      file_google_cloud_healthcare_logging_hl7v2_proto_msgTypes,
	}.Build()
	File_google_cloud_healthcare_logging_hl7v2_proto = out.File
	file_google_cloud_healthcare_logging_hl7v2_proto_rawDesc = nil
	file_google_cloud_healthcare_logging_hl7v2_proto_goTypes = nil
	file_google_cloud_healthcare_logging_hl7v2_proto_depIdxs = nil
}
