// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/spanner/v1/commit_response.proto

package spannerpb

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The response for [Commit][google.spanner.v1.Spanner.Commit].
type CommitResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Cloud Spanner timestamp at which the transaction committed.
	CommitTimestamp *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=commit_timestamp,json=commitTimestamp,proto3" json:"commit_timestamp,omitempty"`
	// The statistics about this `Commit`. Not returned by default.
	// For more information, see
	// [CommitRequest.return_commit_stats][google.spanner.v1.CommitRequest.return_commit_stats].
	CommitStats *CommitResponse_CommitStats `protobuf:"bytes,2,opt,name=commit_stats,json=commitStats,proto3" json:"commit_stats,omitempty"`
	// You must examine and retry the commit if the following is populated.
	//
	// Types that are assignable to MultiplexedSessionRetry:
	//
	//	*CommitResponse_PrecommitToken
	MultiplexedSessionRetry isCommitResponse_MultiplexedSessionRetry `protobuf_oneof:"MultiplexedSessionRetry"`
	// If `TransactionOptions.isolation_level` is set to
	// `IsolationLevel.REPEATABLE_READ`, then the snapshot timestamp is the
	// timestamp at which all reads in the transaction ran. This timestamp is
	// never returned.
	SnapshotTimestamp *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=snapshot_timestamp,json=snapshotTimestamp,proto3" json:"snapshot_timestamp,omitempty"`
}

func (x *CommitResponse) Reset() {
	*x = CommitResponse{}
	mi := &file_google_spanner_v1_commit_response_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CommitResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommitResponse) ProtoMessage() {}

func (x *CommitResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_commit_response_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommitResponse.ProtoReflect.Descriptor instead.
func (*CommitResponse) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_commit_response_proto_rawDescGZIP(), []int{0}
}

func (x *CommitResponse) GetCommitTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.CommitTimestamp
	}
	return nil
}

func (x *CommitResponse) GetCommitStats() *CommitResponse_CommitStats {
	if x != nil {
		return x.CommitStats
	}
	return nil
}

func (m *CommitResponse) GetMultiplexedSessionRetry() isCommitResponse_MultiplexedSessionRetry {
	if m != nil {
		return m.MultiplexedSessionRetry
	}
	return nil
}

func (x *CommitResponse) GetPrecommitToken() *MultiplexedSessionPrecommitToken {
	if x, ok := x.GetMultiplexedSessionRetry().(*CommitResponse_PrecommitToken); ok {
		return x.PrecommitToken
	}
	return nil
}

func (x *CommitResponse) GetSnapshotTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.SnapshotTimestamp
	}
	return nil
}

type isCommitResponse_MultiplexedSessionRetry interface {
	isCommitResponse_MultiplexedSessionRetry()
}

type CommitResponse_PrecommitToken struct {
	// If specified, transaction has not committed yet.
	// You must retry the commit with the new precommit token.
	PrecommitToken *MultiplexedSessionPrecommitToken `protobuf:"bytes,4,opt,name=precommit_token,json=precommitToken,proto3,oneof"`
}

func (*CommitResponse_PrecommitToken) isCommitResponse_MultiplexedSessionRetry() {}

// Additional statistics about a commit.
type CommitResponse_CommitStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The total number of mutations for the transaction. Knowing the
	// `mutation_count` value can help you maximize the number of mutations
	// in a transaction and minimize the number of API round trips. You can
	// also monitor this value to prevent transactions from exceeding the system
	// [limit](https://cloud.google.com/spanner/quotas#limits_for_creating_reading_updating_and_deleting_data).
	// If the number of mutations exceeds the limit, the server returns
	// [INVALID_ARGUMENT](https://cloud.google.com/spanner/docs/reference/rest/v1/Code#ENUM_VALUES.INVALID_ARGUMENT).
	MutationCount int64 `protobuf:"varint,1,opt,name=mutation_count,json=mutationCount,proto3" json:"mutation_count,omitempty"`
}

func (x *CommitResponse_CommitStats) Reset() {
	*x = CommitResponse_CommitStats{}
	mi := &file_google_spanner_v1_commit_response_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CommitResponse_CommitStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommitResponse_CommitStats) ProtoMessage() {}

func (x *CommitResponse_CommitStats) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_commit_response_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommitResponse_CommitStats.ProtoReflect.Descriptor instead.
func (*CommitResponse_CommitStats) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_commit_response_proto_rawDescGZIP(), []int{0, 0}
}

func (x *CommitResponse_CommitStats) GetMutationCount() int64 {
	if x != nil {
		return x.MutationCount
	}
	return 0
}

var File_google_spanner_v1_commit_response_proto protoreflect.FileDescriptor

var file_google_spanner_v1_commit_response_proto_rawDesc = []byte{
	0x0a, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72,
	0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x11, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2f, 0x76, 0x31,
	0x2f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0xa5, 0x03, 0x0a, 0x0e, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x45, 0x0a, 0x10, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0f, 0x63, 0x6f, 0x6d,
	0x6d, 0x69, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x50, 0x0a, 0x0c,
	0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e,
	0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x53, 0x74, 0x61, 0x74,
	0x73, 0x52, 0x0b, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x5e,
	0x0a, 0x0f, 0x70, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x75, 0x6c, 0x74,
	0x69, 0x70, 0x6c, 0x65, 0x78, 0x65, 0x64, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72,
	0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x48, 0x00, 0x52, 0x0e,
	0x70, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x49,
	0x0a, 0x12, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x11, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x1a, 0x34, 0x0a, 0x0b, 0x43, 0x6f, 0x6d,
	0x6d, 0x69, 0x74, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x6d, 0x75, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x0d, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x42,
	0x19, 0x0a, 0x17, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x70, 0x6c, 0x65, 0x78, 0x65, 0x64, 0x53, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x74, 0x72, 0x79, 0x42, 0xb6, 0x01, 0x0a, 0x15, 0x63,
	0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x42, 0x13, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x35, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f,
	0x2f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x73,
	0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x70, 0x62, 0x3b, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72,
	0x70, 0x62, 0xaa, 0x02, 0x17, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x53, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x17, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x53, 0x70, 0x61, 0x6e,
	0x6e, 0x65, 0x72, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a,
	0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x53, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x3a,
	0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_spanner_v1_commit_response_proto_rawDescOnce sync.Once
	file_google_spanner_v1_commit_response_proto_rawDescData = file_google_spanner_v1_commit_response_proto_rawDesc
)

func file_google_spanner_v1_commit_response_proto_rawDescGZIP() []byte {
	file_google_spanner_v1_commit_response_proto_rawDescOnce.Do(func() {
		file_google_spanner_v1_commit_response_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_spanner_v1_commit_response_proto_rawDescData)
	})
	return file_google_spanner_v1_commit_response_proto_rawDescData
}

var file_google_spanner_v1_commit_response_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_google_spanner_v1_commit_response_proto_goTypes = []any{
	(*CommitResponse)(nil),                   // 0: google.spanner.v1.CommitResponse
	(*CommitResponse_CommitStats)(nil),       // 1: google.spanner.v1.CommitResponse.CommitStats
	(*timestamppb.Timestamp)(nil),            // 2: google.protobuf.Timestamp
	(*MultiplexedSessionPrecommitToken)(nil), // 3: google.spanner.v1.MultiplexedSessionPrecommitToken
}
var file_google_spanner_v1_commit_response_proto_depIdxs = []int32{
	2, // 0: google.spanner.v1.CommitResponse.commit_timestamp:type_name -> google.protobuf.Timestamp
	1, // 1: google.spanner.v1.CommitResponse.commit_stats:type_name -> google.spanner.v1.CommitResponse.CommitStats
	3, // 2: google.spanner.v1.CommitResponse.precommit_token:type_name -> google.spanner.v1.MultiplexedSessionPrecommitToken
	2, // 3: google.spanner.v1.CommitResponse.snapshot_timestamp:type_name -> google.protobuf.Timestamp
	4, // [4:4] is the sub-list for method output_type
	4, // [4:4] is the sub-list for method input_type
	4, // [4:4] is the sub-list for extension type_name
	4, // [4:4] is the sub-list for extension extendee
	0, // [0:4] is the sub-list for field type_name
}

func init() { file_google_spanner_v1_commit_response_proto_init() }
func file_google_spanner_v1_commit_response_proto_init() {
	if File_google_spanner_v1_commit_response_proto != nil {
		return
	}
	file_google_spanner_v1_transaction_proto_init()
	file_google_spanner_v1_commit_response_proto_msgTypes[0].OneofWrappers = []any{
		(*CommitResponse_PrecommitToken)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_spanner_v1_commit_response_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_spanner_v1_commit_response_proto_goTypes,
		DependencyIndexes: file_google_spanner_v1_commit_response_proto_depIdxs,
		MessageInfos:      file_google_spanner_v1_commit_response_proto_msgTypes,
	}.Build()
	File_google_spanner_v1_commit_response_proto = out.File
	file_google_spanner_v1_commit_response_proto_rawDesc = nil
	file_google_spanner_v1_commit_response_proto_goTypes = nil
	file_google_spanner_v1_commit_response_proto_depIdxs = nil
}
