// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/spanner/v1/spanner.proto

package spannerpb

import (
	context "context"

	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Spanner_CreateSession_FullMethodName       = "/google.spanner.v1.Spanner/CreateSession"
	Spanner_BatchCreateSessions_FullMethodName = "/google.spanner.v1.Spanner/BatchCreateSessions"
	Spanner_GetSession_FullMethodName          = "/google.spanner.v1.Spanner/GetSession"
	Spanner_ListSessions_FullMethodName        = "/google.spanner.v1.Spanner/ListSessions"
	Spanner_DeleteSession_FullMethodName       = "/google.spanner.v1.Spanner/DeleteSession"
	Spanner_ExecuteSql_FullMethodName          = "/google.spanner.v1.Spanner/ExecuteSql"
	Spanner_ExecuteStreamingSql_FullMethodName = "/google.spanner.v1.Spanner/ExecuteStreamingSql"
	Spanner_ExecuteBatchDml_FullMethodName     = "/google.spanner.v1.Spanner/ExecuteBatchDml"
	Spanner_Read_FullMethodName                = "/google.spanner.v1.Spanner/Read"
	Spanner_StreamingRead_FullMethodName       = "/google.spanner.v1.Spanner/StreamingRead"
	Spanner_BeginTransaction_FullMethodName    = "/google.spanner.v1.Spanner/BeginTransaction"
	Spanner_Commit_FullMethodName              = "/google.spanner.v1.Spanner/Commit"
	Spanner_Rollback_FullMethodName            = "/google.spanner.v1.Spanner/Rollback"
	Spanner_PartitionQuery_FullMethodName      = "/google.spanner.v1.Spanner/PartitionQuery"
	Spanner_PartitionRead_FullMethodName       = "/google.spanner.v1.Spanner/PartitionRead"
	Spanner_BatchWrite_FullMethodName          = "/google.spanner.v1.Spanner/BatchWrite"
)

// SpannerClient is the client API for Spanner service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type SpannerClient interface {
	// Creates a new session. A session can be used to perform
	// transactions that read and/or modify data in a Cloud Spanner database.
	// Sessions are meant to be reused for many consecutive
	// transactions.
	//
	// Sessions can only execute one transaction at a time. To execute
	// multiple concurrent read-write/write-only transactions, create
	// multiple sessions. Note that standalone reads and queries use a
	// transaction internally, and count toward the one transaction
	// limit.
	//
	// Active sessions use additional server resources, so it's a good idea to
	// delete idle and unneeded sessions.
	// Aside from explicit deletes, Cloud Spanner can delete sessions when no
	// operations are sent for more than an hour. If a session is deleted,
	// requests to it return `NOT_FOUND`.
	//
	// Idle sessions can be kept alive by sending a trivial SQL query
	// periodically, for example, `"SELECT 1"`.
	CreateSession(ctx context.Context, in *CreateSessionRequest, opts ...grpc.CallOption) (*Session, error)
	// Creates multiple new sessions.
	//
	// This API can be used to initialize a session cache on the clients.
	// See https://goo.gl/TgSFN2 for best practices on session cache management.
	BatchCreateSessions(ctx context.Context, in *BatchCreateSessionsRequest, opts ...grpc.CallOption) (*BatchCreateSessionsResponse, error)
	// Gets a session. Returns `NOT_FOUND` if the session doesn't exist.
	// This is mainly useful for determining whether a session is still
	// alive.
	GetSession(ctx context.Context, in *GetSessionRequest, opts ...grpc.CallOption) (*Session, error)
	// Lists all sessions in a given database.
	ListSessions(ctx context.Context, in *ListSessionsRequest, opts ...grpc.CallOption) (*ListSessionsResponse, error)
	// Ends a session, releasing server resources associated with it. This
	// asynchronously triggers the cancellation of any operations that are running
	// with this session.
	DeleteSession(ctx context.Context, in *DeleteSessionRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Executes an SQL statement, returning all results in a single reply. This
	// method can't be used to return a result set larger than 10 MiB;
	// if the query yields more data than that, the query fails with
	// a `FAILED_PRECONDITION` error.
	//
	// Operations inside read-write transactions might return `ABORTED`. If
	// this occurs, the application should restart the transaction from
	// the beginning. See [Transaction][google.spanner.v1.Transaction] for more
	// details.
	//
	// Larger result sets can be fetched in streaming fashion by calling
	// [ExecuteStreamingSql][google.spanner.v1.Spanner.ExecuteStreamingSql]
	// instead.
	//
	// The query string can be SQL or [Graph Query Language
	// (GQL)](https://cloud.google.com/spanner/docs/reference/standard-sql/graph-intro).
	ExecuteSql(ctx context.Context, in *ExecuteSqlRequest, opts ...grpc.CallOption) (*ResultSet, error)
	// Like [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql], except returns the
	// result set as a stream. Unlike
	// [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql], there is no limit on
	// the size of the returned result set. However, no individual row in the
	// result set can exceed 100 MiB, and no column value can exceed 10 MiB.
	//
	// The query string can be SQL or [Graph Query Language
	// (GQL)](https://cloud.google.com/spanner/docs/reference/standard-sql/graph-intro).
	ExecuteStreamingSql(ctx context.Context, in *ExecuteSqlRequest, opts ...grpc.CallOption) (Spanner_ExecuteStreamingSqlClient, error)
	// Executes a batch of SQL DML statements. This method allows many statements
	// to be run with lower latency than submitting them sequentially with
	// [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql].
	//
	// Statements are executed in sequential order. A request can succeed even if
	// a statement fails. The
	// [ExecuteBatchDmlResponse.status][google.spanner.v1.ExecuteBatchDmlResponse.status]
	// field in the response provides information about the statement that failed.
	// Clients must inspect this field to determine whether an error occurred.
	//
	// Execution stops after the first failed statement; the remaining statements
	// are not executed.
	ExecuteBatchDml(ctx context.Context, in *ExecuteBatchDmlRequest, opts ...grpc.CallOption) (*ExecuteBatchDmlResponse, error)
	// Reads rows from the database using key lookups and scans, as a
	// simple key/value style alternative to
	// [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql]. This method can't be
	// used to return a result set larger than 10 MiB; if the read matches more
	// data than that, the read fails with a `FAILED_PRECONDITION`
	// error.
	//
	// Reads inside read-write transactions might return `ABORTED`. If
	// this occurs, the application should restart the transaction from
	// the beginning. See [Transaction][google.spanner.v1.Transaction] for more
	// details.
	//
	// Larger result sets can be yielded in streaming fashion by calling
	// [StreamingRead][google.spanner.v1.Spanner.StreamingRead] instead.
	Read(ctx context.Context, in *ReadRequest, opts ...grpc.CallOption) (*ResultSet, error)
	// Like [Read][google.spanner.v1.Spanner.Read], except returns the result set
	// as a stream. Unlike [Read][google.spanner.v1.Spanner.Read], there is no
	// limit on the size of the returned result set. However, no individual row in
	// the result set can exceed 100 MiB, and no column value can exceed
	// 10 MiB.
	StreamingRead(ctx context.Context, in *ReadRequest, opts ...grpc.CallOption) (Spanner_StreamingReadClient, error)
	// Begins a new transaction. This step can often be skipped:
	// [Read][google.spanner.v1.Spanner.Read],
	// [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql] and
	// [Commit][google.spanner.v1.Spanner.Commit] can begin a new transaction as a
	// side-effect.
	BeginTransaction(ctx context.Context, in *BeginTransactionRequest, opts ...grpc.CallOption) (*Transaction, error)
	// Commits a transaction. The request includes the mutations to be
	// applied to rows in the database.
	//
	// `Commit` might return an `ABORTED` error. This can occur at any time;
	// commonly, the cause is conflicts with concurrent
	// transactions. However, it can also happen for a variety of other
	// reasons. If `Commit` returns `ABORTED`, the caller should retry
	// the transaction from the beginning, reusing the same session.
	//
	// On very rare occasions, `Commit` might return `UNKNOWN`. This can happen,
	// for example, if the client job experiences a 1+ hour networking failure.
	// At that point, Cloud Spanner has lost track of the transaction outcome and
	// we recommend that you perform another read from the database to see the
	// state of things as they are now.
	Commit(ctx context.Context, in *CommitRequest, opts ...grpc.CallOption) (*CommitResponse, error)
	// Rolls back a transaction, releasing any locks it holds. It's a good
	// idea to call this for any transaction that includes one or more
	// [Read][google.spanner.v1.Spanner.Read] or
	// [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql] requests and ultimately
	// decides not to commit.
	//
	// `Rollback` returns `OK` if it successfully aborts the transaction, the
	// transaction was already aborted, or the transaction isn't
	// found. `Rollback` never returns `ABORTED`.
	Rollback(ctx context.Context, in *RollbackRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Creates a set of partition tokens that can be used to execute a query
	// operation in parallel. Each of the returned partition tokens can be used
	// by [ExecuteStreamingSql][google.spanner.v1.Spanner.ExecuteStreamingSql] to
	// specify a subset of the query result to read. The same session and
	// read-only transaction must be used by the `PartitionQueryRequest` used to
	// create the partition tokens and the `ExecuteSqlRequests` that use the
	// partition tokens.
	//
	// Partition tokens become invalid when the session used to create them
	// is deleted, is idle for too long, begins a new transaction, or becomes too
	// old. When any of these happen, it isn't possible to resume the query, and
	// the whole operation must be restarted from the beginning.
	PartitionQuery(ctx context.Context, in *PartitionQueryRequest, opts ...grpc.CallOption) (*PartitionResponse, error)
	// Creates a set of partition tokens that can be used to execute a read
	// operation in parallel. Each of the returned partition tokens can be used
	// by [StreamingRead][google.spanner.v1.Spanner.StreamingRead] to specify a
	// subset of the read result to read. The same session and read-only
	// transaction must be used by the `PartitionReadRequest` used to create the
	// partition tokens and the `ReadRequests` that use the partition tokens.
	// There are no ordering guarantees on rows returned among the returned
	// partition tokens, or even within each individual `StreamingRead` call
	// issued with a `partition_token`.
	//
	// Partition tokens become invalid when the session used to create them
	// is deleted, is idle for too long, begins a new transaction, or becomes too
	// old. When any of these happen, it isn't possible to resume the read, and
	// the whole operation must be restarted from the beginning.
	PartitionRead(ctx context.Context, in *PartitionReadRequest, opts ...grpc.CallOption) (*PartitionResponse, error)
	// Batches the supplied mutation groups in a collection of efficient
	// transactions. All mutations in a group are committed atomically. However,
	// mutations across groups can be committed non-atomically in an unspecified
	// order and thus, they must be independent of each other. Partial failure is
	// possible, that is, some groups might have been committed successfully,
	// while some might have failed. The results of individual batches are
	// streamed into the response as the batches are applied.
	//
	// `BatchWrite` requests are not replay protected, meaning that each mutation
	// group can be applied more than once. Replays of non-idempotent mutations
	// can have undesirable effects. For example, replays of an insert mutation
	// can produce an already exists error or if you use generated or commit
	// timestamp-based keys, it can result in additional rows being added to the
	// mutation's table. We recommend structuring your mutation groups to be
	// idempotent to avoid this issue.
	BatchWrite(ctx context.Context, in *BatchWriteRequest, opts ...grpc.CallOption) (Spanner_BatchWriteClient, error)
}

type spannerClient struct {
	cc grpc.ClientConnInterface
}

func NewSpannerClient(cc grpc.ClientConnInterface) SpannerClient {
	return &spannerClient{cc}
}

func (c *spannerClient) CreateSession(ctx context.Context, in *CreateSessionRequest, opts ...grpc.CallOption) (*Session, error) {
	out := new(Session)
	err := c.cc.Invoke(ctx, Spanner_CreateSession_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) BatchCreateSessions(ctx context.Context, in *BatchCreateSessionsRequest, opts ...grpc.CallOption) (*BatchCreateSessionsResponse, error) {
	out := new(BatchCreateSessionsResponse)
	err := c.cc.Invoke(ctx, Spanner_BatchCreateSessions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) GetSession(ctx context.Context, in *GetSessionRequest, opts ...grpc.CallOption) (*Session, error) {
	out := new(Session)
	err := c.cc.Invoke(ctx, Spanner_GetSession_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) ListSessions(ctx context.Context, in *ListSessionsRequest, opts ...grpc.CallOption) (*ListSessionsResponse, error) {
	out := new(ListSessionsResponse)
	err := c.cc.Invoke(ctx, Spanner_ListSessions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) DeleteSession(ctx context.Context, in *DeleteSessionRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Spanner_DeleteSession_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) ExecuteSql(ctx context.Context, in *ExecuteSqlRequest, opts ...grpc.CallOption) (*ResultSet, error) {
	out := new(ResultSet)
	err := c.cc.Invoke(ctx, Spanner_ExecuteSql_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) ExecuteStreamingSql(ctx context.Context, in *ExecuteSqlRequest, opts ...grpc.CallOption) (Spanner_ExecuteStreamingSqlClient, error) {
	stream, err := c.cc.NewStream(ctx, &Spanner_ServiceDesc.Streams[0], Spanner_ExecuteStreamingSql_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &spannerExecuteStreamingSqlClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Spanner_ExecuteStreamingSqlClient interface {
	Recv() (*PartialResultSet, error)
	grpc.ClientStream
}

type spannerExecuteStreamingSqlClient struct {
	grpc.ClientStream
}

func (x *spannerExecuteStreamingSqlClient) Recv() (*PartialResultSet, error) {
	m := new(PartialResultSet)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *spannerClient) ExecuteBatchDml(ctx context.Context, in *ExecuteBatchDmlRequest, opts ...grpc.CallOption) (*ExecuteBatchDmlResponse, error) {
	out := new(ExecuteBatchDmlResponse)
	err := c.cc.Invoke(ctx, Spanner_ExecuteBatchDml_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) Read(ctx context.Context, in *ReadRequest, opts ...grpc.CallOption) (*ResultSet, error) {
	out := new(ResultSet)
	err := c.cc.Invoke(ctx, Spanner_Read_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) StreamingRead(ctx context.Context, in *ReadRequest, opts ...grpc.CallOption) (Spanner_StreamingReadClient, error) {
	stream, err := c.cc.NewStream(ctx, &Spanner_ServiceDesc.Streams[1], Spanner_StreamingRead_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &spannerStreamingReadClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Spanner_StreamingReadClient interface {
	Recv() (*PartialResultSet, error)
	grpc.ClientStream
}

type spannerStreamingReadClient struct {
	grpc.ClientStream
}

func (x *spannerStreamingReadClient) Recv() (*PartialResultSet, error) {
	m := new(PartialResultSet)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *spannerClient) BeginTransaction(ctx context.Context, in *BeginTransactionRequest, opts ...grpc.CallOption) (*Transaction, error) {
	out := new(Transaction)
	err := c.cc.Invoke(ctx, Spanner_BeginTransaction_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) Commit(ctx context.Context, in *CommitRequest, opts ...grpc.CallOption) (*CommitResponse, error) {
	out := new(CommitResponse)
	err := c.cc.Invoke(ctx, Spanner_Commit_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) Rollback(ctx context.Context, in *RollbackRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Spanner_Rollback_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) PartitionQuery(ctx context.Context, in *PartitionQueryRequest, opts ...grpc.CallOption) (*PartitionResponse, error) {
	out := new(PartitionResponse)
	err := c.cc.Invoke(ctx, Spanner_PartitionQuery_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) PartitionRead(ctx context.Context, in *PartitionReadRequest, opts ...grpc.CallOption) (*PartitionResponse, error) {
	out := new(PartitionResponse)
	err := c.cc.Invoke(ctx, Spanner_PartitionRead_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) BatchWrite(ctx context.Context, in *BatchWriteRequest, opts ...grpc.CallOption) (Spanner_BatchWriteClient, error) {
	stream, err := c.cc.NewStream(ctx, &Spanner_ServiceDesc.Streams[2], Spanner_BatchWrite_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &spannerBatchWriteClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Spanner_BatchWriteClient interface {
	Recv() (*BatchWriteResponse, error)
	grpc.ClientStream
}

type spannerBatchWriteClient struct {
	grpc.ClientStream
}

func (x *spannerBatchWriteClient) Recv() (*BatchWriteResponse, error) {
	m := new(BatchWriteResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// SpannerServer is the server API for Spanner service.
// All implementations should embed UnimplementedSpannerServer
// for forward compatibility
type SpannerServer interface {
	// Creates a new session. A session can be used to perform
	// transactions that read and/or modify data in a Cloud Spanner database.
	// Sessions are meant to be reused for many consecutive
	// transactions.
	//
	// Sessions can only execute one transaction at a time. To execute
	// multiple concurrent read-write/write-only transactions, create
	// multiple sessions. Note that standalone reads and queries use a
	// transaction internally, and count toward the one transaction
	// limit.
	//
	// Active sessions use additional server resources, so it's a good idea to
	// delete idle and unneeded sessions.
	// Aside from explicit deletes, Cloud Spanner can delete sessions when no
	// operations are sent for more than an hour. If a session is deleted,
	// requests to it return `NOT_FOUND`.
	//
	// Idle sessions can be kept alive by sending a trivial SQL query
	// periodically, for example, `"SELECT 1"`.
	CreateSession(context.Context, *CreateSessionRequest) (*Session, error)
	// Creates multiple new sessions.
	//
	// This API can be used to initialize a session cache on the clients.
	// See https://goo.gl/TgSFN2 for best practices on session cache management.
	BatchCreateSessions(context.Context, *BatchCreateSessionsRequest) (*BatchCreateSessionsResponse, error)
	// Gets a session. Returns `NOT_FOUND` if the session doesn't exist.
	// This is mainly useful for determining whether a session is still
	// alive.
	GetSession(context.Context, *GetSessionRequest) (*Session, error)
	// Lists all sessions in a given database.
	ListSessions(context.Context, *ListSessionsRequest) (*ListSessionsResponse, error)
	// Ends a session, releasing server resources associated with it. This
	// asynchronously triggers the cancellation of any operations that are running
	// with this session.
	DeleteSession(context.Context, *DeleteSessionRequest) (*emptypb.Empty, error)
	// Executes an SQL statement, returning all results in a single reply. This
	// method can't be used to return a result set larger than 10 MiB;
	// if the query yields more data than that, the query fails with
	// a `FAILED_PRECONDITION` error.
	//
	// Operations inside read-write transactions might return `ABORTED`. If
	// this occurs, the application should restart the transaction from
	// the beginning. See [Transaction][google.spanner.v1.Transaction] for more
	// details.
	//
	// Larger result sets can be fetched in streaming fashion by calling
	// [ExecuteStreamingSql][google.spanner.v1.Spanner.ExecuteStreamingSql]
	// instead.
	//
	// The query string can be SQL or [Graph Query Language
	// (GQL)](https://cloud.google.com/spanner/docs/reference/standard-sql/graph-intro).
	ExecuteSql(context.Context, *ExecuteSqlRequest) (*ResultSet, error)
	// Like [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql], except returns the
	// result set as a stream. Unlike
	// [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql], there is no limit on
	// the size of the returned result set. However, no individual row in the
	// result set can exceed 100 MiB, and no column value can exceed 10 MiB.
	//
	// The query string can be SQL or [Graph Query Language
	// (GQL)](https://cloud.google.com/spanner/docs/reference/standard-sql/graph-intro).
	ExecuteStreamingSql(*ExecuteSqlRequest, Spanner_ExecuteStreamingSqlServer) error
	// Executes a batch of SQL DML statements. This method allows many statements
	// to be run with lower latency than submitting them sequentially with
	// [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql].
	//
	// Statements are executed in sequential order. A request can succeed even if
	// a statement fails. The
	// [ExecuteBatchDmlResponse.status][google.spanner.v1.ExecuteBatchDmlResponse.status]
	// field in the response provides information about the statement that failed.
	// Clients must inspect this field to determine whether an error occurred.
	//
	// Execution stops after the first failed statement; the remaining statements
	// are not executed.
	ExecuteBatchDml(context.Context, *ExecuteBatchDmlRequest) (*ExecuteBatchDmlResponse, error)
	// Reads rows from the database using key lookups and scans, as a
	// simple key/value style alternative to
	// [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql]. This method can't be
	// used to return a result set larger than 10 MiB; if the read matches more
	// data than that, the read fails with a `FAILED_PRECONDITION`
	// error.
	//
	// Reads inside read-write transactions might return `ABORTED`. If
	// this occurs, the application should restart the transaction from
	// the beginning. See [Transaction][google.spanner.v1.Transaction] for more
	// details.
	//
	// Larger result sets can be yielded in streaming fashion by calling
	// [StreamingRead][google.spanner.v1.Spanner.StreamingRead] instead.
	Read(context.Context, *ReadRequest) (*ResultSet, error)
	// Like [Read][google.spanner.v1.Spanner.Read], except returns the result set
	// as a stream. Unlike [Read][google.spanner.v1.Spanner.Read], there is no
	// limit on the size of the returned result set. However, no individual row in
	// the result set can exceed 100 MiB, and no column value can exceed
	// 10 MiB.
	StreamingRead(*ReadRequest, Spanner_StreamingReadServer) error
	// Begins a new transaction. This step can often be skipped:
	// [Read][google.spanner.v1.Spanner.Read],
	// [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql] and
	// [Commit][google.spanner.v1.Spanner.Commit] can begin a new transaction as a
	// side-effect.
	BeginTransaction(context.Context, *BeginTransactionRequest) (*Transaction, error)
	// Commits a transaction. The request includes the mutations to be
	// applied to rows in the database.
	//
	// `Commit` might return an `ABORTED` error. This can occur at any time;
	// commonly, the cause is conflicts with concurrent
	// transactions. However, it can also happen for a variety of other
	// reasons. If `Commit` returns `ABORTED`, the caller should retry
	// the transaction from the beginning, reusing the same session.
	//
	// On very rare occasions, `Commit` might return `UNKNOWN`. This can happen,
	// for example, if the client job experiences a 1+ hour networking failure.
	// At that point, Cloud Spanner has lost track of the transaction outcome and
	// we recommend that you perform another read from the database to see the
	// state of things as they are now.
	Commit(context.Context, *CommitRequest) (*CommitResponse, error)
	// Rolls back a transaction, releasing any locks it holds. It's a good
	// idea to call this for any transaction that includes one or more
	// [Read][google.spanner.v1.Spanner.Read] or
	// [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql] requests and ultimately
	// decides not to commit.
	//
	// `Rollback` returns `OK` if it successfully aborts the transaction, the
	// transaction was already aborted, or the transaction isn't
	// found. `Rollback` never returns `ABORTED`.
	Rollback(context.Context, *RollbackRequest) (*emptypb.Empty, error)
	// Creates a set of partition tokens that can be used to execute a query
	// operation in parallel. Each of the returned partition tokens can be used
	// by [ExecuteStreamingSql][google.spanner.v1.Spanner.ExecuteStreamingSql] to
	// specify a subset of the query result to read. The same session and
	// read-only transaction must be used by the `PartitionQueryRequest` used to
	// create the partition tokens and the `ExecuteSqlRequests` that use the
	// partition tokens.
	//
	// Partition tokens become invalid when the session used to create them
	// is deleted, is idle for too long, begins a new transaction, or becomes too
	// old. When any of these happen, it isn't possible to resume the query, and
	// the whole operation must be restarted from the beginning.
	PartitionQuery(context.Context, *PartitionQueryRequest) (*PartitionResponse, error)
	// Creates a set of partition tokens that can be used to execute a read
	// operation in parallel. Each of the returned partition tokens can be used
	// by [StreamingRead][google.spanner.v1.Spanner.StreamingRead] to specify a
	// subset of the read result to read. The same session and read-only
	// transaction must be used by the `PartitionReadRequest` used to create the
	// partition tokens and the `ReadRequests` that use the partition tokens.
	// There are no ordering guarantees on rows returned among the returned
	// partition tokens, or even within each individual `StreamingRead` call
	// issued with a `partition_token`.
	//
	// Partition tokens become invalid when the session used to create them
	// is deleted, is idle for too long, begins a new transaction, or becomes too
	// old. When any of these happen, it isn't possible to resume the read, and
	// the whole operation must be restarted from the beginning.
	PartitionRead(context.Context, *PartitionReadRequest) (*PartitionResponse, error)
	// Batches the supplied mutation groups in a collection of efficient
	// transactions. All mutations in a group are committed atomically. However,
	// mutations across groups can be committed non-atomically in an unspecified
	// order and thus, they must be independent of each other. Partial failure is
	// possible, that is, some groups might have been committed successfully,
	// while some might have failed. The results of individual batches are
	// streamed into the response as the batches are applied.
	//
	// `BatchWrite` requests are not replay protected, meaning that each mutation
	// group can be applied more than once. Replays of non-idempotent mutations
	// can have undesirable effects. For example, replays of an insert mutation
	// can produce an already exists error or if you use generated or commit
	// timestamp-based keys, it can result in additional rows being added to the
	// mutation's table. We recommend structuring your mutation groups to be
	// idempotent to avoid this issue.
	BatchWrite(*BatchWriteRequest, Spanner_BatchWriteServer) error
}

// UnimplementedSpannerServer should be embedded to have forward compatible implementations.
type UnimplementedSpannerServer struct {
}

func (UnimplementedSpannerServer) CreateSession(context.Context, *CreateSessionRequest) (*Session, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSession not implemented")
}
func (UnimplementedSpannerServer) BatchCreateSessions(context.Context, *BatchCreateSessionsRequest) (*BatchCreateSessionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchCreateSessions not implemented")
}
func (UnimplementedSpannerServer) GetSession(context.Context, *GetSessionRequest) (*Session, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSession not implemented")
}
func (UnimplementedSpannerServer) ListSessions(context.Context, *ListSessionsRequest) (*ListSessionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSessions not implemented")
}
func (UnimplementedSpannerServer) DeleteSession(context.Context, *DeleteSessionRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSession not implemented")
}
func (UnimplementedSpannerServer) ExecuteSql(context.Context, *ExecuteSqlRequest) (*ResultSet, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExecuteSql not implemented")
}
func (UnimplementedSpannerServer) ExecuteStreamingSql(*ExecuteSqlRequest, Spanner_ExecuteStreamingSqlServer) error {
	return status.Errorf(codes.Unimplemented, "method ExecuteStreamingSql not implemented")
}
func (UnimplementedSpannerServer) ExecuteBatchDml(context.Context, *ExecuteBatchDmlRequest) (*ExecuteBatchDmlResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExecuteBatchDml not implemented")
}
func (UnimplementedSpannerServer) Read(context.Context, *ReadRequest) (*ResultSet, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Read not implemented")
}
func (UnimplementedSpannerServer) StreamingRead(*ReadRequest, Spanner_StreamingReadServer) error {
	return status.Errorf(codes.Unimplemented, "method StreamingRead not implemented")
}
func (UnimplementedSpannerServer) BeginTransaction(context.Context, *BeginTransactionRequest) (*Transaction, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BeginTransaction not implemented")
}
func (UnimplementedSpannerServer) Commit(context.Context, *CommitRequest) (*CommitResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Commit not implemented")
}
func (UnimplementedSpannerServer) Rollback(context.Context, *RollbackRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Rollback not implemented")
}
func (UnimplementedSpannerServer) PartitionQuery(context.Context, *PartitionQueryRequest) (*PartitionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PartitionQuery not implemented")
}
func (UnimplementedSpannerServer) PartitionRead(context.Context, *PartitionReadRequest) (*PartitionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PartitionRead not implemented")
}
func (UnimplementedSpannerServer) BatchWrite(*BatchWriteRequest, Spanner_BatchWriteServer) error {
	return status.Errorf(codes.Unimplemented, "method BatchWrite not implemented")
}

// UnsafeSpannerServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to SpannerServer will
// result in compilation errors.
type UnsafeSpannerServer interface {
	mustEmbedUnimplementedSpannerServer()
}

func RegisterSpannerServer(s grpc.ServiceRegistrar, srv SpannerServer) {
	s.RegisterService(&Spanner_ServiceDesc, srv)
}

func _Spanner_CreateSession_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSessionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).CreateSession(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Spanner_CreateSession_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).CreateSession(ctx, req.(*CreateSessionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_BatchCreateSessions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCreateSessionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).BatchCreateSessions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Spanner_BatchCreateSessions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).BatchCreateSessions(ctx, req.(*BatchCreateSessionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_GetSession_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSessionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).GetSession(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Spanner_GetSession_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).GetSession(ctx, req.(*GetSessionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_ListSessions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSessionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).ListSessions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Spanner_ListSessions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).ListSessions(ctx, req.(*ListSessionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_DeleteSession_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSessionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).DeleteSession(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Spanner_DeleteSession_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).DeleteSession(ctx, req.(*DeleteSessionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_ExecuteSql_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExecuteSqlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).ExecuteSql(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Spanner_ExecuteSql_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).ExecuteSql(ctx, req.(*ExecuteSqlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_ExecuteStreamingSql_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ExecuteSqlRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(SpannerServer).ExecuteStreamingSql(m, &spannerExecuteStreamingSqlServer{stream})
}

type Spanner_ExecuteStreamingSqlServer interface {
	Send(*PartialResultSet) error
	grpc.ServerStream
}

type spannerExecuteStreamingSqlServer struct {
	grpc.ServerStream
}

func (x *spannerExecuteStreamingSqlServer) Send(m *PartialResultSet) error {
	return x.ServerStream.SendMsg(m)
}

func _Spanner_ExecuteBatchDml_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExecuteBatchDmlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).ExecuteBatchDml(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Spanner_ExecuteBatchDml_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).ExecuteBatchDml(ctx, req.(*ExecuteBatchDmlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_Read_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReadRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).Read(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Spanner_Read_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).Read(ctx, req.(*ReadRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_StreamingRead_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ReadRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(SpannerServer).StreamingRead(m, &spannerStreamingReadServer{stream})
}

type Spanner_StreamingReadServer interface {
	Send(*PartialResultSet) error
	grpc.ServerStream
}

type spannerStreamingReadServer struct {
	grpc.ServerStream
}

func (x *spannerStreamingReadServer) Send(m *PartialResultSet) error {
	return x.ServerStream.SendMsg(m)
}

func _Spanner_BeginTransaction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BeginTransactionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).BeginTransaction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Spanner_BeginTransaction_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).BeginTransaction(ctx, req.(*BeginTransactionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_Commit_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CommitRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).Commit(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Spanner_Commit_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).Commit(ctx, req.(*CommitRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_Rollback_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RollbackRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).Rollback(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Spanner_Rollback_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).Rollback(ctx, req.(*RollbackRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_PartitionQuery_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PartitionQueryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).PartitionQuery(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Spanner_PartitionQuery_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).PartitionQuery(ctx, req.(*PartitionQueryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_PartitionRead_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PartitionReadRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).PartitionRead(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Spanner_PartitionRead_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).PartitionRead(ctx, req.(*PartitionReadRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_BatchWrite_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(BatchWriteRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(SpannerServer).BatchWrite(m, &spannerBatchWriteServer{stream})
}

type Spanner_BatchWriteServer interface {
	Send(*BatchWriteResponse) error
	grpc.ServerStream
}

type spannerBatchWriteServer struct {
	grpc.ServerStream
}

func (x *spannerBatchWriteServer) Send(m *BatchWriteResponse) error {
	return x.ServerStream.SendMsg(m)
}

// Spanner_ServiceDesc is the grpc.ServiceDesc for Spanner service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Spanner_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.spanner.v1.Spanner",
	HandlerType: (*SpannerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateSession",
			Handler:    _Spanner_CreateSession_Handler,
		},
		{
			MethodName: "BatchCreateSessions",
			Handler:    _Spanner_BatchCreateSessions_Handler,
		},
		{
			MethodName: "GetSession",
			Handler:    _Spanner_GetSession_Handler,
		},
		{
			MethodName: "ListSessions",
			Handler:    _Spanner_ListSessions_Handler,
		},
		{
			MethodName: "DeleteSession",
			Handler:    _Spanner_DeleteSession_Handler,
		},
		{
			MethodName: "ExecuteSql",
			Handler:    _Spanner_ExecuteSql_Handler,
		},
		{
			MethodName: "ExecuteBatchDml",
			Handler:    _Spanner_ExecuteBatchDml_Handler,
		},
		{
			MethodName: "Read",
			Handler:    _Spanner_Read_Handler,
		},
		{
			MethodName: "BeginTransaction",
			Handler:    _Spanner_BeginTransaction_Handler,
		},
		{
			MethodName: "Commit",
			Handler:    _Spanner_Commit_Handler,
		},
		{
			MethodName: "Rollback",
			Handler:    _Spanner_Rollback_Handler,
		},
		{
			MethodName: "PartitionQuery",
			Handler:    _Spanner_PartitionQuery_Handler,
		},
		{
			MethodName: "PartitionRead",
			Handler:    _Spanner_PartitionRead_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "ExecuteStreamingSql",
			Handler:       _Spanner_ExecuteStreamingSql_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "StreamingRead",
			Handler:       _Spanner_StreamingRead_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "BatchWrite",
			Handler:       _Spanner_BatchWrite_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "google/spanner/v1/spanner.proto",
}
