// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package omics

import (
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
)

// WaitUntilAnnotationImportJobCreated uses the Amazon Omics API operation
// GetAnnotationImportJob to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *Omics) WaitUntilAnnotationImportJobCreated(input *GetAnnotationImportJobInput) error {
	return c.WaitUntilAnnotationImportJobCreatedWithContext(aws.BackgroundContext(), input)
}

// WaitUntilAnnotationImportJobCreatedWithContext is an extended version of WaitUntilAnnotationImportJobCreated.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) WaitUntilAnnotationImportJobCreatedWithContext(ctx aws.Context, input *GetAnnotationImportJobInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilAnnotationImportJobCreated",
		MaxAttempts: 20,
		Delay:       request.ConstantWaiterDelay(30 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:   request.RetryWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "SUBMITTED",
			},
			{
				State:   request.RetryWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "IN_PROGRESS",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "FAILED",
			},
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "CANCELLED",
			},
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "COMPLETED",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *GetAnnotationImportJobInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetAnnotationImportJobRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}

// WaitUntilAnnotationStoreCreated uses the Amazon Omics API operation
// GetAnnotationStore to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *Omics) WaitUntilAnnotationStoreCreated(input *GetAnnotationStoreInput) error {
	return c.WaitUntilAnnotationStoreCreatedWithContext(aws.BackgroundContext(), input)
}

// WaitUntilAnnotationStoreCreatedWithContext is an extended version of WaitUntilAnnotationStoreCreated.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) WaitUntilAnnotationStoreCreatedWithContext(ctx aws.Context, input *GetAnnotationStoreInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilAnnotationStoreCreated",
		MaxAttempts: 20,
		Delay:       request.ConstantWaiterDelay(30 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "ACTIVE",
			},
			{
				State:   request.RetryWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "CREATING",
			},
			{
				State:   request.RetryWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "UPDATING",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "FAILED",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *GetAnnotationStoreInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetAnnotationStoreRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}

// WaitUntilAnnotationStoreDeleted uses the Amazon Omics API operation
// GetAnnotationStore to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *Omics) WaitUntilAnnotationStoreDeleted(input *GetAnnotationStoreInput) error {
	return c.WaitUntilAnnotationStoreDeletedWithContext(aws.BackgroundContext(), input)
}

// WaitUntilAnnotationStoreDeletedWithContext is an extended version of WaitUntilAnnotationStoreDeleted.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) WaitUntilAnnotationStoreDeletedWithContext(ctx aws.Context, input *GetAnnotationStoreInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilAnnotationStoreDeleted",
		MaxAttempts: 20,
		Delay:       request.ConstantWaiterDelay(30 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "DELETED",
			},
			{
				State:    request.SuccessWaiterState,
				Matcher:  request.ErrorWaiterMatch,
				Expected: "ResourceNotFoundException",
			},
			{
				State:   request.RetryWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "DELETING",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *GetAnnotationStoreInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetAnnotationStoreRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}

// WaitUntilReadSetActivationJobCompleted uses the Amazon Omics API operation
// GetReadSetActivationJob to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *Omics) WaitUntilReadSetActivationJobCompleted(input *GetReadSetActivationJobInput) error {
	return c.WaitUntilReadSetActivationJobCompletedWithContext(aws.BackgroundContext(), input)
}

// WaitUntilReadSetActivationJobCompletedWithContext is an extended version of WaitUntilReadSetActivationJobCompleted.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) WaitUntilReadSetActivationJobCompletedWithContext(ctx aws.Context, input *GetReadSetActivationJobInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilReadSetActivationJobCompleted",
		MaxAttempts: 20,
		Delay:       request.ConstantWaiterDelay(30 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "COMPLETED",
			},
			{
				State:   request.RetryWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "SUBMITTED",
			},
			{
				State:   request.RetryWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "IN_PROGRESS",
			},
			{
				State:   request.RetryWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "CANCELLING",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "CANCELLED",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "FAILED",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "COMPLETED_WITH_FAILURES",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *GetReadSetActivationJobInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetReadSetActivationJobRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}

// WaitUntilReadSetExportJobCompleted uses the Amazon Omics API operation
// GetReadSetExportJob to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *Omics) WaitUntilReadSetExportJobCompleted(input *GetReadSetExportJobInput) error {
	return c.WaitUntilReadSetExportJobCompletedWithContext(aws.BackgroundContext(), input)
}

// WaitUntilReadSetExportJobCompletedWithContext is an extended version of WaitUntilReadSetExportJobCompleted.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) WaitUntilReadSetExportJobCompletedWithContext(ctx aws.Context, input *GetReadSetExportJobInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilReadSetExportJobCompleted",
		MaxAttempts: 20,
		Delay:       request.ConstantWaiterDelay(30 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "COMPLETED",
			},
			{
				State:   request.RetryWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "SUBMITTED",
			},
			{
				State:   request.RetryWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "IN_PROGRESS",
			},
			{
				State:   request.RetryWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "CANCELLING",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "CANCELLED",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "FAILED",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "COMPLETED_WITH_FAILURES",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *GetReadSetExportJobInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetReadSetExportJobRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}

// WaitUntilReadSetImportJobCompleted uses the Amazon Omics API operation
// GetReadSetImportJob to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *Omics) WaitUntilReadSetImportJobCompleted(input *GetReadSetImportJobInput) error {
	return c.WaitUntilReadSetImportJobCompletedWithContext(aws.BackgroundContext(), input)
}

// WaitUntilReadSetImportJobCompletedWithContext is an extended version of WaitUntilReadSetImportJobCompleted.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) WaitUntilReadSetImportJobCompletedWithContext(ctx aws.Context, input *GetReadSetImportJobInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilReadSetImportJobCompleted",
		MaxAttempts: 20,
		Delay:       request.ConstantWaiterDelay(30 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "COMPLETED",
			},
			{
				State:   request.RetryWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "SUBMITTED",
			},
			{
				State:   request.RetryWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "IN_PROGRESS",
			},
			{
				State:   request.RetryWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "CANCELLING",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "CANCELLED",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "FAILED",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "COMPLETED_WITH_FAILURES",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *GetReadSetImportJobInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetReadSetImportJobRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}

// WaitUntilReferenceImportJobCompleted uses the Amazon Omics API operation
// GetReferenceImportJob to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *Omics) WaitUntilReferenceImportJobCompleted(input *GetReferenceImportJobInput) error {
	return c.WaitUntilReferenceImportJobCompletedWithContext(aws.BackgroundContext(), input)
}

// WaitUntilReferenceImportJobCompletedWithContext is an extended version of WaitUntilReferenceImportJobCompleted.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) WaitUntilReferenceImportJobCompletedWithContext(ctx aws.Context, input *GetReferenceImportJobInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilReferenceImportJobCompleted",
		MaxAttempts: 20,
		Delay:       request.ConstantWaiterDelay(30 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "COMPLETED",
			},
			{
				State:   request.RetryWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "SUBMITTED",
			},
			{
				State:   request.RetryWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "IN_PROGRESS",
			},
			{
				State:   request.RetryWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "CANCELLING",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "CANCELLED",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "FAILED",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "COMPLETED_WITH_FAILURES",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *GetReferenceImportJobInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetReferenceImportJobRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}

// WaitUntilRunCompleted uses the Amazon Omics API operation
// GetRun to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *Omics) WaitUntilRunCompleted(input *GetRunInput) error {
	return c.WaitUntilRunCompletedWithContext(aws.BackgroundContext(), input)
}

// WaitUntilRunCompletedWithContext is an extended version of WaitUntilRunCompleted.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) WaitUntilRunCompletedWithContext(ctx aws.Context, input *GetRunInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilRunCompleted",
		MaxAttempts: 20,
		Delay:       request.ConstantWaiterDelay(30 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "COMPLETED",
			},
			{
				State:   request.RetryWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "PENDING",
			},
			{
				State:   request.RetryWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "STARTING",
			},
			{
				State:   request.RetryWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "RUNNING",
			},
			{
				State:   request.RetryWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "STOPPING",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "FAILED",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *GetRunInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetRunRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}

// WaitUntilRunRunning uses the Amazon Omics API operation
// GetRun to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *Omics) WaitUntilRunRunning(input *GetRunInput) error {
	return c.WaitUntilRunRunningWithContext(aws.BackgroundContext(), input)
}

// WaitUntilRunRunningWithContext is an extended version of WaitUntilRunRunning.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) WaitUntilRunRunningWithContext(ctx aws.Context, input *GetRunInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilRunRunning",
		MaxAttempts: 20,
		Delay:       request.ConstantWaiterDelay(30 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "RUNNING",
			},
			{
				State:   request.RetryWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "PENDING",
			},
			{
				State:   request.RetryWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "STARTING",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "FAILED",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "CANCELLED",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *GetRunInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetRunRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}

// WaitUntilTaskCompleted uses the Amazon Omics API operation
// GetRunTask to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *Omics) WaitUntilTaskCompleted(input *GetRunTaskInput) error {
	return c.WaitUntilTaskCompletedWithContext(aws.BackgroundContext(), input)
}

// WaitUntilTaskCompletedWithContext is an extended version of WaitUntilTaskCompleted.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) WaitUntilTaskCompletedWithContext(ctx aws.Context, input *GetRunTaskInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilTaskCompleted",
		MaxAttempts: 20,
		Delay:       request.ConstantWaiterDelay(30 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "COMPLETED",
			},
			{
				State:   request.RetryWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "PENDING",
			},
			{
				State:   request.RetryWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "STARTING",
			},
			{
				State:   request.RetryWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "RUNNING",
			},
			{
				State:   request.RetryWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "STOPPING",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "FAILED",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *GetRunTaskInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetRunTaskRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}

// WaitUntilTaskRunning uses the Amazon Omics API operation
// GetRunTask to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *Omics) WaitUntilTaskRunning(input *GetRunTaskInput) error {
	return c.WaitUntilTaskRunningWithContext(aws.BackgroundContext(), input)
}

// WaitUntilTaskRunningWithContext is an extended version of WaitUntilTaskRunning.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) WaitUntilTaskRunningWithContext(ctx aws.Context, input *GetRunTaskInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilTaskRunning",
		MaxAttempts: 20,
		Delay:       request.ConstantWaiterDelay(30 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "RUNNING",
			},
			{
				State:   request.RetryWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "PENDING",
			},
			{
				State:   request.RetryWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "STARTING",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "FAILED",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "CANCELLED",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *GetRunTaskInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetRunTaskRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}

// WaitUntilVariantImportJobCreated uses the Amazon Omics API operation
// GetVariantImportJob to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *Omics) WaitUntilVariantImportJobCreated(input *GetVariantImportJobInput) error {
	return c.WaitUntilVariantImportJobCreatedWithContext(aws.BackgroundContext(), input)
}

// WaitUntilVariantImportJobCreatedWithContext is an extended version of WaitUntilVariantImportJobCreated.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) WaitUntilVariantImportJobCreatedWithContext(ctx aws.Context, input *GetVariantImportJobInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilVariantImportJobCreated",
		MaxAttempts: 20,
		Delay:       request.ConstantWaiterDelay(30 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:   request.RetryWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "SUBMITTED",
			},
			{
				State:   request.RetryWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "IN_PROGRESS",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "FAILED",
			},
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "CANCELLED",
			},
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "COMPLETED",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *GetVariantImportJobInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetVariantImportJobRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}

// WaitUntilVariantStoreCreated uses the Amazon Omics API operation
// GetVariantStore to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *Omics) WaitUntilVariantStoreCreated(input *GetVariantStoreInput) error {
	return c.WaitUntilVariantStoreCreatedWithContext(aws.BackgroundContext(), input)
}

// WaitUntilVariantStoreCreatedWithContext is an extended version of WaitUntilVariantStoreCreated.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) WaitUntilVariantStoreCreatedWithContext(ctx aws.Context, input *GetVariantStoreInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilVariantStoreCreated",
		MaxAttempts: 20,
		Delay:       request.ConstantWaiterDelay(30 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "ACTIVE",
			},
			{
				State:   request.RetryWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "CREATING",
			},
			{
				State:   request.RetryWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "UPDATING",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "FAILED",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *GetVariantStoreInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetVariantStoreRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}

// WaitUntilVariantStoreDeleted uses the Amazon Omics API operation
// GetVariantStore to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *Omics) WaitUntilVariantStoreDeleted(input *GetVariantStoreInput) error {
	return c.WaitUntilVariantStoreDeletedWithContext(aws.BackgroundContext(), input)
}

// WaitUntilVariantStoreDeletedWithContext is an extended version of WaitUntilVariantStoreDeleted.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) WaitUntilVariantStoreDeletedWithContext(ctx aws.Context, input *GetVariantStoreInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilVariantStoreDeleted",
		MaxAttempts: 20,
		Delay:       request.ConstantWaiterDelay(30 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "DELETED",
			},
			{
				State:    request.SuccessWaiterState,
				Matcher:  request.ErrorWaiterMatch,
				Expected: "ResourceNotFoundException",
			},
			{
				State:   request.RetryWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "DELETING",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *GetVariantStoreInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetVariantStoreRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}

// WaitUntilWorkflowActive uses the Amazon Omics API operation
// GetWorkflow to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *Omics) WaitUntilWorkflowActive(input *GetWorkflowInput) error {
	return c.WaitUntilWorkflowActiveWithContext(aws.BackgroundContext(), input)
}

// WaitUntilWorkflowActiveWithContext is an extended version of WaitUntilWorkflowActive.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Omics) WaitUntilWorkflowActiveWithContext(ctx aws.Context, input *GetWorkflowInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilWorkflowActive",
		MaxAttempts: 10,
		Delay:       request.ConstantWaiterDelay(3 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "ACTIVE",
			},
			{
				State:   request.RetryWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "CREATING",
			},
			{
				State:   request.RetryWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "UPDATING",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "status",
				Expected: "FAILED",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *GetWorkflowInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetWorkflowRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}
