// Code generated by smithy-go-codegen DO NOT EDIT.

package outposts

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/outposts/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// A list of Amazon EC2 instances running on the Outpost and belonging to the
// account that initiated the capacity task. Use this list to specify the instances
// you cannot stop to free up capacity to run the capacity task.
func (c *Client) ListBlockingInstancesForCapacityTask(ctx context.Context, params *ListBlockingInstancesForCapacityTaskInput, optFns ...func(*Options)) (*ListBlockingInstancesForCapacityTaskOutput, error) {
	if params == nil {
		params = &ListBlockingInstancesForCapacityTaskInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListBlockingInstancesForCapacityTask", params, optFns, c.addOperationListBlockingInstancesForCapacityTaskMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListBlockingInstancesForCapacityTaskOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListBlockingInstancesForCapacityTaskInput struct {

	// The ID of the capacity task.
	//
	// This member is required.
	CapacityTaskId *string

	// The ID or ARN of the Outpost associated with the specified capacity task.
	//
	// This member is required.
	OutpostIdentifier *string

	// The maximum page size.
	MaxResults *int32

	// The pagination token.
	NextToken *string

	noSmithyDocumentSerde
}

type ListBlockingInstancesForCapacityTaskOutput struct {

	// A list of all running Amazon EC2 instances on the Outpost. Stopping one or more
	// of these instances can free up the capacity needed to run the capacity task.
	BlockingInstances []types.BlockingInstance

	// The pagination token.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListBlockingInstancesForCapacityTaskMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListBlockingInstancesForCapacityTask{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListBlockingInstancesForCapacityTask{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListBlockingInstancesForCapacityTask"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListBlockingInstancesForCapacityTaskValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListBlockingInstancesForCapacityTask(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListBlockingInstancesForCapacityTaskPaginatorOptions is the paginator options
// for ListBlockingInstancesForCapacityTask
type ListBlockingInstancesForCapacityTaskPaginatorOptions struct {
	// The maximum page size.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListBlockingInstancesForCapacityTaskPaginator is a paginator for
// ListBlockingInstancesForCapacityTask
type ListBlockingInstancesForCapacityTaskPaginator struct {
	options   ListBlockingInstancesForCapacityTaskPaginatorOptions
	client    ListBlockingInstancesForCapacityTaskAPIClient
	params    *ListBlockingInstancesForCapacityTaskInput
	nextToken *string
	firstPage bool
}

// NewListBlockingInstancesForCapacityTaskPaginator returns a new
// ListBlockingInstancesForCapacityTaskPaginator
func NewListBlockingInstancesForCapacityTaskPaginator(client ListBlockingInstancesForCapacityTaskAPIClient, params *ListBlockingInstancesForCapacityTaskInput, optFns ...func(*ListBlockingInstancesForCapacityTaskPaginatorOptions)) *ListBlockingInstancesForCapacityTaskPaginator {
	if params == nil {
		params = &ListBlockingInstancesForCapacityTaskInput{}
	}

	options := ListBlockingInstancesForCapacityTaskPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListBlockingInstancesForCapacityTaskPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListBlockingInstancesForCapacityTaskPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListBlockingInstancesForCapacityTask page.
func (p *ListBlockingInstancesForCapacityTaskPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListBlockingInstancesForCapacityTaskOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListBlockingInstancesForCapacityTask(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListBlockingInstancesForCapacityTaskAPIClient is a client that implements the
// ListBlockingInstancesForCapacityTask operation.
type ListBlockingInstancesForCapacityTaskAPIClient interface {
	ListBlockingInstancesForCapacityTask(context.Context, *ListBlockingInstancesForCapacityTaskInput, ...func(*Options)) (*ListBlockingInstancesForCapacityTaskOutput, error)
}

var _ ListBlockingInstancesForCapacityTaskAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListBlockingInstancesForCapacityTask(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListBlockingInstancesForCapacityTask",
	}
}
