/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class WrapLayout
implements LayoutManager {
    private static final int MAX_COMPRESS_TRIES = 3;
    private HorizontalAlignment horizontalAlignment = HorizontalAlignment.CENTER;
    private LayoutStyle layoutStyle = LayoutStyle.BALANCED;
    private HorizontalGap horizontalGap = HorizontalGap.AUTO;
    private Dimension forceComponentSize = null;
    private boolean allComponentsWithTheSameSize = false;
    private int minHorizontalGap = 0;
    private int minVerticalGap = 0;
    private int maxHorizontalGap = 0;

    public WrapLayout withHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        this.horizontalAlignment = Objects.requireNonNull(horizontalAlignment, "horizontalAlignment");
        return this;
    }

    public WrapLayout withLayoutStyle(LayoutStyle layoutStyle) {
        this.layoutStyle = Objects.requireNonNull(layoutStyle, "layoutStyle");
        return this;
    }

    public WrapLayout withHorizontalGap(HorizontalGap horizontalGap) {
        this.horizontalGap = Objects.requireNonNull(horizontalGap, "horizontalGap");
        this.minHorizontalGap = 0;
        this.maxHorizontalGap = Integer.MAX_VALUE;
        return this;
    }

    public WrapLayout withHorizontalGap(HorizontalGap horizontalGap, int minHorizontalGap, int maxHorizontalGap) {
        if (maxHorizontalGap < 0) {
            throw new IllegalArgumentException("maxHorizontalGap must be >= 0. Argument: " + maxHorizontalGap);
        }
        this.minHorizontalGap = minHorizontalGap;
        this.horizontalGap = Objects.requireNonNull(horizontalGap, "horizontalGap");
        this.maxHorizontalGap = maxHorizontalGap;
        return this;
    }

    public WrapLayout withForceComponentSize(Dimension forceComponentSize) {
        this.forceComponentSize = forceComponentSize;
        this.allComponentsWithTheSameSize = false;
        return this;
    }

    public WrapLayout withAllComponentsWithTheSameSize(boolean allComponentsWithTheSameSize) {
        this.allComponentsWithTheSameSize = allComponentsWithTheSameSize;
        this.forceComponentSize = null;
        return this;
    }

    @Override
    public Dimension preferredLayoutSize(Container target) {
        return this.layoutSize(target, true);
    }

    @Override
    public Dimension minimumLayoutSize(Container target) {
        Dimension minimum = this.layoutSize(target, false);
        return minimum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension layoutSize(Container target, int targetWidth, boolean preferred) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Layout mostCompactLayout = this.determineLayout(target, targetWidth, preferred);
            return mostCompactLayout.dimension;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension layoutSize(Container target, boolean preferred) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Layout mostCompactLayout = this.determineLayout(target, preferred);
            return mostCompactLayout.dimension;
        }
    }

    private Layout determineLayout(Container target, boolean preferred) {
        int targetWidth = target.getSize().width;
        Container container = target;
        while (container.getSize().width == 0 && container.getParent() != null) {
            container = container.getParent();
        }
        targetWidth = container.getSize().width;
        if (targetWidth == 0) {
            targetWidth = Integer.MAX_VALUE;
        }
        return this.determineLayout(target, targetWidth, preferred);
    }

    private Layout determineLayout(Container target, int targetWidth, boolean preferred) {
        boolean reverseComponentOrder = this.layoutStyle == LayoutStyle.PREFER_BOTTOM;
        Layout mostCompactLayout = this.internalLayoutSize(target, targetWidth, preferred, reverseComponentOrder);
        if (targetWidth <= 0) {
            return mostCompactLayout;
        }
        if (this.layoutStyle != LayoutStyle.BALANCED) {
            return mostCompactLayout;
        }
        for (int i = 0; i < 3; ++i) {
            Layout candidateLayout = this.internalLayoutSize(target, mostCompactLayout.getWidestColumnWidth() - 1, preferred, reverseComponentOrder);
            if (candidateLayout.dimension.height > mostCompactLayout.dimension.height) break;
            mostCompactLayout = candidateLayout;
        }
        return mostCompactLayout;
    }

    private Layout internalLayoutSize(Container target, int targetWidth, boolean preferred, boolean layoutBottomToTop) {
        Insets insets = target.getInsets();
        int horizontalInsetsAndGap = insets.left + insets.right + this.minHorizontalGap * 2;
        int maxWidth = targetWidth - horizontalInsetsAndGap;
        ArrayList<Row> rows = new ArrayList<Row>();
        Dimension currentLayoutSize = new Dimension(0, 0);
        Dimension sharedComponentSize = this.forceComponentSize;
        if (this.allComponentsWithTheSameSize) {
            sharedComponentSize = new Dimension(0, 0);
            for (Component component : this.getVisibleComponents(target, layoutBottomToTop)) {
                Object d;
                Object object = d = preferred ? component.getPreferredSize() : component.getMinimumSize();
                if (((Dimension)d).width > sharedComponentSize.width) {
                    sharedComponentSize.width = ((Dimension)d).width;
                }
                if (((Dimension)d).height <= sharedComponentSize.height) continue;
                sharedComponentSize.height = ((Dimension)d).height;
            }
        }
        ArrayList<Child> currentChildren = new ArrayList<Child>();
        Dimension currentRowSize = new Dimension(0, 0);
        for (Component component : this.getVisibleComponents(target, layoutBottomToTop)) {
            Dimension d;
            if (sharedComponentSize != null) {
                d = sharedComponentSize;
            } else {
                Dimension dimension = d = preferred ? component.getPreferredSize() : component.getMinimumSize();
            }
            if (currentRowSize.width + d.width > maxWidth) {
                this.updateCurrentLayoutSize(currentLayoutSize, currentRowSize);
                rows.add(new Row(currentRowSize, currentChildren));
                currentChildren = new ArrayList();
                currentRowSize = new Dimension(0, 0);
            }
            if (currentRowSize.width != 0) {
                currentRowSize.width += this.minHorizontalGap;
            }
            currentChildren.add(new Child(component, new Rectangle(currentRowSize.width, currentLayoutSize.height, d.width, d.height)));
            currentRowSize.width += d.width;
            currentRowSize.height = Math.max(currentRowSize.height, d.height);
        }
        currentLayoutSize.width = Math.max(currentLayoutSize.width, currentRowSize.width);
        currentLayoutSize.height += currentRowSize.height;
        rows.add(new Row(currentRowSize, currentChildren));
        currentLayoutSize.width += horizontalInsetsAndGap;
        currentLayoutSize.height += insets.top + insets.bottom;
        Container scrollPane = SwingUtilities.getAncestorOfClass(JScrollPane.class, target);
        if (scrollPane != null && target.isValid()) {
            currentLayoutSize.width -= this.minHorizontalGap + 1;
        }
        if (layoutBottomToTop) {
            this.reverseLayout(rows);
        }
        return new Layout(currentLayoutSize, rows);
    }

    private void reverseLayout(List<Row> rows) {
        if (rows.isEmpty()) {
            return;
        }
        Collections.reverse(rows);
        int y = 0;
        int rowNum = 0;
        int lastRowIndex = rows.size() - 1;
        for (Row row : rows) {
            Collections.reverse(row.children);
            int x = 0;
            int childNum = 0;
            int lastChildIndex = row.children.size() - 1;
            for (Child child : row.children) {
                child.bounds.x = x;
                child.bounds.y = y;
                x += child.bounds.width;
                if (childNum != lastChildIndex) {
                    x += this.minHorizontalGap;
                }
                ++childNum;
            }
            y += row.size.height;
            if (rowNum != lastRowIndex) {
                y += this.minVerticalGap;
            }
            ++rowNum;
        }
    }

    private void updateCurrentLayoutSize(Dimension currentLayoutSize, Dimension newRowSize) {
        currentLayoutSize.width = Math.max(currentLayoutSize.width, newRowSize.width);
        currentLayoutSize.height += this.minVerticalGap;
        currentLayoutSize.height += newRowSize.height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Dimension size = parent.getSize();
            Layout layout = this.determineLayout(parent, size.width, true);
            if (layout.dimension.width > size.width || layout.dimension.height > size.height) {
                layout = this.determineLayout(parent, size.width, false);
            }
            this.applyLayout(parent, size, layout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container parent, boolean preferred) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Dimension size = parent.getSize();
            Layout layout = this.determineLayout(parent, size.width, preferred);
            this.applyLayout(parent, size, layout);
        }
    }

    private void applyLayout(Container parent, Dimension size, Layout layout) {
        Point offsetAll = this.determineOffsetForCentering(size, layout.dimension);
        int rowsSize = layout.rows.size();
        int rowNum = 0;
        for (Row row : layout.rows) {
            int additionalGapWidthPerChild = this.determineAdditionalGapWidthPerChild(size, rowsSize, rowNum, row);
            int totalAdditionalWidthFromAllChildren = row.children.size() > 1 ? additionalGapWidthPerChild * (row.children.size() - 1) : 0;
            int additionalWidth = size.width - row.size.width;
            int childNum = 0;
            int offsetRowX = (size.width - row.size.width - totalAdditionalWidthFromAllChildren) / 2;
            for (Child child : row.children) {
                Rectangle bounds = child.bounds;
                if (additionalGapWidthPerChild > 0 && childNum != 0) {
                    bounds.x += additionalGapWidthPerChild * childNum;
                }
                if (this.horizontalAlignment == HorizontalAlignment.CENTER) {
                    bounds.x += offsetRowX;
                } else if (this.horizontalAlignment != HorizontalAlignment.LEFT) {
                    if (this.horizontalAlignment == HorizontalAlignment.RIGHT) {
                        bounds.x += additionalWidth;
                    } else {
                        throw new IllegalStateException("Unknown horizontalAlignment: " + this.horizontalAlignment);
                    }
                }
                bounds.y += offsetAll.y;
                child.component.setBounds(bounds);
                ++childNum;
            }
            ++rowNum;
        }
    }

    private int determineAdditionalGapWidthPerChild(Dimension size, int rowsSize, int rowNum, Row row) {
        if (row.children.size() <= 1) {
            return 0;
        }
        if (!this.hasAutoHorizontalGap(rowsSize, rowNum)) {
            return 0;
        }
        return Math.min(this.maxHorizontalGap, (size.width - row.size.width) / (row.children.size() - 1));
    }

    private boolean hasAutoHorizontalGap(int rowsSize, int rowNum) {
        return this.horizontalGap == HorizontalGap.AUTO || this.horizontalGap == HorizontalGap.AUTO_TOP && rowNum == 0 || this.horizontalGap == HorizontalGap.AUTO_BOTTOM && rowNum == rowsSize - 1;
    }

    private List<Component> getVisibleComponents(Container parent, boolean reverseComponentOrder) {
        ArrayList<Component> components = new ArrayList<Component>(parent.getComponentCount());
        for (Component c : parent.getComponents()) {
            if (!c.isVisible()) continue;
            components.add(c);
        }
        if (reverseComponentOrder) {
            Collections.reverse(components);
        }
        return components;
    }

    private final Point determineOffsetForCentering(Dimension displaySize, Dimension contentSize) {
        return new Point((displaySize.width - contentSize.width) / 2, (displaySize.height - contentSize.height) / 2);
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    private static class Child {
        private Component component;
        private Rectangle bounds;

        public Child(Component component, Rectangle bounds) {
            this.component = component;
            this.bounds = bounds;
        }
    }

    private static class Row {
        private Dimension size;
        private List<Child> children;

        public Row(Dimension size, List<Child> children) {
            this.size = size;
            this.children = children;
        }
    }

    private static class Layout {
        private Dimension dimension;
        private List<Row> rows;

        private Layout(Dimension dimension, List<Row> rows) {
            this.dimension = dimension;
            this.rows = rows;
        }

        int getWidestColumnWidth() {
            return this.rows.stream().mapToInt(r -> r.size.width).max().orElse(0);
        }
    }

    public static enum HorizontalGap {
        NONE,
        AUTO,
        AUTO_TOP,
        AUTO_BOTTOM;

    }

    public static enum LayoutStyle {
        BALANCED,
        PREFER_TOP,
        PREFER_BOTTOM;

    }

    public static enum HorizontalAlignment {
        LEFT,
        CENTER,
        RIGHT;

    }
}

