/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.util.CollectionUtils;

public class UnitIterator
implements Iterator<Unit> {
    private final Player owner;
    private final Predicate<Unit> predicate;
    private final List<Unit> units = new ArrayList<Unit>();

    public UnitIterator(Player owner, Predicate<Unit> predicate) {
        this.owner = owner;
        this.predicate = predicate;
        this.update();
    }

    private final void update() {
        this.units.clear();
        this.units.addAll(CollectionUtils.transform(this.owner.getUnits(), u -> this.predicate.test((Unit)u), Function.identity(), Unit.locComparator));
    }

    public boolean setNext(Unit unit) {
        if (this.predicate.test(unit)) {
            Unit sentinel = CollectionUtils.first(this.units);
            while (!this.units.isEmpty()) {
                if (this.units.get(0) == unit) {
                    return true;
                }
                this.units.remove(0);
            }
            this.update();
            while (!this.units.isEmpty() && this.units.get(0) != sentinel) {
                if (this.units.get(0) == unit) {
                    return true;
                }
                this.units.remove(0);
            }
        }
        return false;
    }

    public boolean remove(Unit u) {
        return this.units.remove(u);
    }

    public void reset() {
        this.update();
    }

    @Override
    public boolean hasNext() {
        while (!this.units.isEmpty()) {
            if (this.predicate.test(this.units.get(0))) {
                return true;
            }
            this.units.remove(0);
        }
        this.update();
        return !this.units.isEmpty();
    }

    @Override
    public Unit next() {
        return this.hasNext() ? this.units.remove(0) : null;
    }

    @Override
    public void remove() {
        this.next();
    }
}

