// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

package azcosmos

// Headers
const (
	cosmosHeaderRequestCharge                      string = "x-ms-request-charge"
	cosmosHeaderActivityId                         string = "x-ms-activity-id"
	cosmosHeaderEtag                               string = "etag"
	cosmosHeaderSubstatus                          string = "x-ms-substatus"
	cosmosHeaderPopulateQuotaInfo                  string = "x-ms-documentdb-populatequotainfo"
	cosmosHeaderPreTriggerInclude                  string = "x-ms-documentdb-pre-trigger-include"
	cosmosHeaderPostTriggerInclude                 string = "x-ms-documentdb-post-trigger-include"
	cosmosHeaderIndexingDirective                  string = "x-ms-indexing-directive"
	cosmosHeaderSessionToken                       string = "x-ms-session-token"
	cosmosHeaderConsistencyLevel                   string = "x-ms-consistency-level"
	cosmosHeaderPartitionKey                       string = "x-ms-documentdb-partitionkey"
	cosmosHeaderPrefer                             string = "Prefer"
	cosmosHeaderIsUpsert                           string = "x-ms-documentdb-is-upsert"
	cosmosHeaderOfferThroughput                    string = "x-ms-offer-throughput"
	cosmosHeaderOfferAutoscale                     string = "x-ms-cosmos-offer-autopilot-settings"
	cosmosHeaderQuery                              string = "x-ms-documentdb-query"
	cosmosHeaderOfferReplacePending                string = "x-ms-offer-replace-pending"
	cosmosHeaderOfferMinimumThroughput             string = "x-ms-cosmos-min-throughput"
	cosmosHeaderResponseContinuationTokenLimitInKb string = "x-ms-documentdb-responsecontinuationtokenlimitinkb"
	cosmosHeaderEnableScanInQuery                  string = "x-ms-documentdb-force-query-scan"
	cosmosHeaderMaxItemCount                       string = "x-ms-max-item-count"
	cosmosHeaderContinuationToken                  string = "x-ms-continuation"
	cosmosHeaderPopulateIndexMetrics               string = "x-ms-cosmos-populateindexmetrics"
	cosmosHeaderPopulateQueryMetrics               string = "x-ms-documentdb-populatequerymetrics"
	cosmosHeaderQueryMetrics                       string = "x-ms-documentdb-query-metrics"
	cosmosHeaderIndexUtilization                   string = "x-ms-cosmos-index-utilization"
	cosmosHeaderCorrelatedActivityId               string = "x-ms-cosmos-correlated-activityid"
	cosmosHeaderIsBatchRequest                     string = "x-ms-cosmos-is-batch-request"
	cosmosHeaderIsBatchAtomic                      string = "x-ms-cosmos-batch-atomic"
	cosmosHeaderIsBatchOrdered                     string = "x-ms-cosmos-batch-ordered"
	cosmosHeaderSDKSupportedCapabilities           string = "x-ms-cosmos-sdk-supportedcapabilities"
	cosmosHeaderEnableCrossPartitionQuery          string = "x-ms-documentdb-query-enablecrosspartition"
	cosmosHeaderIsQueryPlanRequest                 string = "x-ms-cosmos-is-query-plan-request"
	cosmosHeaderSupportedQueryFeatures             string = "x-ms-cosmos-supported-query-features"
	cosmosHeaderAllowTentativeWrites               string = "x-ms-cosmos-allow-tentative-writes"
	cosmosHeaderPartitionKeyRangeId                string = "x-ms-documentdb-partitionkeyrangeid"
	headerXmsDate                                  string = "x-ms-date"
	headerAuthorization                            string = "Authorization"
	headerContentType                              string = "Content-Type"
	headerIfMatch                                  string = "If-Match"
	headerIfNoneMatch                              string = "If-None-Match"
	headerXmsVersion                               string = "x-ms-version"
	headerContentLocation                          string = "content-location"
	headerXmsGatewayVersion                        string = "x-ms-gatewayversion"
	headerLsn                                      string = "lsn"
	headerXmsCosmosLlsn                            string = "x-ms-cosmos-llsn"
	headerXmsCosmosItemLlsn                        string = "x-ms-cosmos-item-llsn"
	headerXmsItemLsn                               string = "x-ms-item-lsn"
	headerXmsCosmosQuorumAckedLlsn                 string = "x-ms-cosmos-quorum-acked-llsn"
	headerXmsCurrentReplicaSetSize                 string = "x-ms-current-replica-set-size"
	headerXmsCurrentWriteQuorum                    string = "x-ms-current-write-quorum"
	headerXmsGlobalCommittedLsn                    string = "x-ms-global-committed-lsn"
	headerXmsLastStateChangeUtc                    string = "x-ms-last-state-change-utc"
	headerXmsNumberOfReadRegions                   string = "x-ms-number-of-read-regions"
	headerXmsQuorumAckedLsn                        string = "x-ms-quorum-acked-lsn"
	headerXmsRequestDurationMs                     string = "x-ms-request-duration-ms"
	headerXmsResourceQuota                         string = "x-ms-resource-quota"
	headerXmsResourceUsage                         string = "x-ms-resource-usage"
	headerXmsSchemaVersion                         string = "x-ms-schemaversion"
	headerXmsServiceVersion                        string = "x-ms-serviceversion"
	headerXmsTransportRequestId                    string = "x-ms-transport-request-id"
	headerXmsXpRole                                string = "x-ms-xp-role"
	headerCollectionPartitionIndex                 string = "collection-partition-index"
	headerCollectionServiceIndex                   string = "collection-service-index"
	headerXmsDocumentDbPartitionKeyRangeId         string = "x-ms-documentdb-partitionkeyrangeid"
	cosmosHeaderPhysicalPartitionId                string = "x-ms-cosmos-physical-partition-id"
	headerStrictTransportSecurity                  string = "strict-transport-security"
	headerXmsDatabaseAccountConsumedMb             string = "x-ms-databaseaccount-consumed-mb"
	headerXmsDatabaseAccountProvisionedMb          string = "x-ms-databaseaccount-provisioned-mb"
	headerXmsDatabaseAccountReservedMb             string = "x-ms-databaseaccount-reserved-mb"
	headerXmsMaxMediaStorageUsageMb                string = "x-ms-max-media-storage-usage-mb"
	headerXmsMediaStorageUsageMb                   string = "x-ms-media-storage-usage-mb"
	headerXmsContentPath                           string = "x-ms-content-path"
	headerXmsAltContentPath                        string = "x-ms-alt-content-path"
	cosmosHeaderMaxContentLength                   string = "x-ms-cosmos-max-content-length"
	cosmosHeaderIsPartitionKeyDeletePending        string = "x-ms-cosmos-is-partition-key-delete-pending"
	cosmosHeaderQueryExecutionInfo                 string = "x-ms-cosmos-query-execution-info"
	headerXmsItemCount                             string = "x-ms-item-count"
	headerDedicatedGatewayMaxAge                   string = "x-ms-dedicatedgateway-max-age"
)

const (
	cosmosHeaderValuesPreferMinimal string = "return=minimal"
	cosmosHeaderValuesQuery         string = "application/query+json"
)

// Substatus Codes
const (
	subStatusWriteForbidden          string = "3"
	subStatusDatabaseAccountNotFound string = "1008"
	subStatusReadSessionNotAvailable string = "1002"
)
