// Code generated by go generate. DO NOT EDIT.

package opt

import (
	"encoding/json"
	"testing"

	"github.com/algolia/algoliasearch-client-go/v3/algolia/opt"
	"github.com/stretchr/testify/require"
)

func TestExtractExtraHeaders(t *testing.T) {
	for _, c := range []struct {
		opts     []interface{}
		expected *opt.ExtraHeadersOption
	}{
		{
			opts:     []interface{}{nil},
			expected: opt.ExtraHeaders(map[string]string{}),
		},
		{
			opts:     []interface{}{opt.ExtraHeaders(map[string]string{})},
			expected: opt.ExtraHeaders(map[string]string{}),
		},
		{
			opts:     []interface{}{opt.ExtraHeaders(map[string]string{"k1": "v1", "k2": "v2"})},
			expected: opt.ExtraHeaders(map[string]string{"k1": "v1", "k2": "v2"}),
		},
		{
			opts: []interface{}{
				opt.ExtraHeaders(map[string]string{"k1": "v1", "k2": "v2"}),
				opt.ExtraHeaders(map[string]string{"k2": "v2", "k3": "v3"}),
			},
			expected: opt.ExtraHeaders(map[string]string{"k1": "v1", "k2": "v2", "k3": "v3"}),
		},
	} {
		var (
			in  = ExtractExtraHeaders(c.opts...)
			out opt.ExtraHeadersOption
		)
		data, err := json.Marshal(&in)
		require.NoError(t, err)
		err = json.Unmarshal(data, &out)
		require.NoError(t, err)
		require.Equal(t, *c.expected, out)
	}
}
