// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ivsrealtime

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateParticipantToken = "CreateParticipantToken"

// CreateParticipantTokenRequest generates a "aws/request.Request" representing the
// client's request for the CreateParticipantToken operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateParticipantToken for more information on using the CreateParticipantToken
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateParticipantTokenRequest method.
//	req, resp := client.CreateParticipantTokenRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/CreateParticipantToken
func (c *IVSRealTime) CreateParticipantTokenRequest(input *CreateParticipantTokenInput) (req *request.Request, output *CreateParticipantTokenOutput) {
	op := &request.Operation{
		Name:       opCreateParticipantToken,
		HTTPMethod: "POST",
		HTTPPath:   "/CreateParticipantToken",
	}

	if input == nil {
		input = &CreateParticipantTokenInput{}
	}

	output = &CreateParticipantTokenOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateParticipantToken API operation for Amazon Interactive Video Service RealTime.
//
// Creates an additional token for a specified stage. This can be done after
// stage creation or when tokens expire. Tokens always are scoped to the stage
// for which they are created.
//
// Encryption keys are owned by Amazon IVS and never used directly by your application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation CreateParticipantToken for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
//   - AccessDeniedException
//
//   - ServiceQuotaExceededException
//
//   - PendingVerification
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/CreateParticipantToken
func (c *IVSRealTime) CreateParticipantToken(input *CreateParticipantTokenInput) (*CreateParticipantTokenOutput, error) {
	req, out := c.CreateParticipantTokenRequest(input)
	return out, req.Send()
}

// CreateParticipantTokenWithContext is the same as CreateParticipantToken with the addition of
// the ability to pass a context and additional request options.
//
// See CreateParticipantToken for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) CreateParticipantTokenWithContext(ctx aws.Context, input *CreateParticipantTokenInput, opts ...request.Option) (*CreateParticipantTokenOutput, error) {
	req, out := c.CreateParticipantTokenRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateStage = "CreateStage"

// CreateStageRequest generates a "aws/request.Request" representing the
// client's request for the CreateStage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateStage for more information on using the CreateStage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateStageRequest method.
//	req, resp := client.CreateStageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/CreateStage
func (c *IVSRealTime) CreateStageRequest(input *CreateStageInput) (req *request.Request, output *CreateStageOutput) {
	op := &request.Operation{
		Name:       opCreateStage,
		HTTPMethod: "POST",
		HTTPPath:   "/CreateStage",
	}

	if input == nil {
		input = &CreateStageInput{}
	}

	output = &CreateStageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateStage API operation for Amazon Interactive Video Service RealTime.
//
// Creates a new stage (and optionally participant tokens).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation CreateStage for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//
//   - AccessDeniedException
//
//   - ServiceQuotaExceededException
//
//   - PendingVerification
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/CreateStage
func (c *IVSRealTime) CreateStage(input *CreateStageInput) (*CreateStageOutput, error) {
	req, out := c.CreateStageRequest(input)
	return out, req.Send()
}

// CreateStageWithContext is the same as CreateStage with the addition of
// the ability to pass a context and additional request options.
//
// See CreateStage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) CreateStageWithContext(ctx aws.Context, input *CreateStageInput, opts ...request.Option) (*CreateStageOutput, error) {
	req, out := c.CreateStageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteStage = "DeleteStage"

// DeleteStageRequest generates a "aws/request.Request" representing the
// client's request for the DeleteStage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteStage for more information on using the DeleteStage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteStageRequest method.
//	req, resp := client.DeleteStageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/DeleteStage
func (c *IVSRealTime) DeleteStageRequest(input *DeleteStageInput) (req *request.Request, output *DeleteStageOutput) {
	op := &request.Operation{
		Name:       opDeleteStage,
		HTTPMethod: "POST",
		HTTPPath:   "/DeleteStage",
	}

	if input == nil {
		input = &DeleteStageInput{}
	}

	output = &DeleteStageOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteStage API operation for Amazon Interactive Video Service RealTime.
//
// Shuts down and deletes the specified stage (disconnecting all participants).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation DeleteStage for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
//   - AccessDeniedException
//
//   - ConflictException
//
//   - PendingVerification
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/DeleteStage
func (c *IVSRealTime) DeleteStage(input *DeleteStageInput) (*DeleteStageOutput, error) {
	req, out := c.DeleteStageRequest(input)
	return out, req.Send()
}

// DeleteStageWithContext is the same as DeleteStage with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteStage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) DeleteStageWithContext(ctx aws.Context, input *DeleteStageInput, opts ...request.Option) (*DeleteStageOutput, error) {
	req, out := c.DeleteStageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisconnectParticipant = "DisconnectParticipant"

// DisconnectParticipantRequest generates a "aws/request.Request" representing the
// client's request for the DisconnectParticipant operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisconnectParticipant for more information on using the DisconnectParticipant
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisconnectParticipantRequest method.
//	req, resp := client.DisconnectParticipantRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/DisconnectParticipant
func (c *IVSRealTime) DisconnectParticipantRequest(input *DisconnectParticipantInput) (req *request.Request, output *DisconnectParticipantOutput) {
	op := &request.Operation{
		Name:       opDisconnectParticipant,
		HTTPMethod: "POST",
		HTTPPath:   "/DisconnectParticipant",
	}

	if input == nil {
		input = &DisconnectParticipantInput{}
	}

	output = &DisconnectParticipantOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisconnectParticipant API operation for Amazon Interactive Video Service RealTime.
//
// Disconnects a specified participant and revokes the participant permanently
// from a specified stage.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation DisconnectParticipant for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
//   - AccessDeniedException
//
//   - PendingVerification
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/DisconnectParticipant
func (c *IVSRealTime) DisconnectParticipant(input *DisconnectParticipantInput) (*DisconnectParticipantOutput, error) {
	req, out := c.DisconnectParticipantRequest(input)
	return out, req.Send()
}

// DisconnectParticipantWithContext is the same as DisconnectParticipant with the addition of
// the ability to pass a context and additional request options.
//
// See DisconnectParticipant for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) DisconnectParticipantWithContext(ctx aws.Context, input *DisconnectParticipantInput, opts ...request.Option) (*DisconnectParticipantOutput, error) {
	req, out := c.DisconnectParticipantRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetParticipant = "GetParticipant"

// GetParticipantRequest generates a "aws/request.Request" representing the
// client's request for the GetParticipant operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetParticipant for more information on using the GetParticipant
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetParticipantRequest method.
//	req, resp := client.GetParticipantRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/GetParticipant
func (c *IVSRealTime) GetParticipantRequest(input *GetParticipantInput) (req *request.Request, output *GetParticipantOutput) {
	op := &request.Operation{
		Name:       opGetParticipant,
		HTTPMethod: "POST",
		HTTPPath:   "/GetParticipant",
	}

	if input == nil {
		input = &GetParticipantInput{}
	}

	output = &GetParticipantOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetParticipant API operation for Amazon Interactive Video Service RealTime.
//
// Gets information about the specified participant token.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation GetParticipant for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
//   - AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/GetParticipant
func (c *IVSRealTime) GetParticipant(input *GetParticipantInput) (*GetParticipantOutput, error) {
	req, out := c.GetParticipantRequest(input)
	return out, req.Send()
}

// GetParticipantWithContext is the same as GetParticipant with the addition of
// the ability to pass a context and additional request options.
//
// See GetParticipant for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) GetParticipantWithContext(ctx aws.Context, input *GetParticipantInput, opts ...request.Option) (*GetParticipantOutput, error) {
	req, out := c.GetParticipantRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetStage = "GetStage"

// GetStageRequest generates a "aws/request.Request" representing the
// client's request for the GetStage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetStage for more information on using the GetStage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetStageRequest method.
//	req, resp := client.GetStageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/GetStage
func (c *IVSRealTime) GetStageRequest(input *GetStageInput) (req *request.Request, output *GetStageOutput) {
	op := &request.Operation{
		Name:       opGetStage,
		HTTPMethod: "POST",
		HTTPPath:   "/GetStage",
	}

	if input == nil {
		input = &GetStageInput{}
	}

	output = &GetStageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetStage API operation for Amazon Interactive Video Service RealTime.
//
// Gets information for the specified stage.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation GetStage for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
//   - AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/GetStage
func (c *IVSRealTime) GetStage(input *GetStageInput) (*GetStageOutput, error) {
	req, out := c.GetStageRequest(input)
	return out, req.Send()
}

// GetStageWithContext is the same as GetStage with the addition of
// the ability to pass a context and additional request options.
//
// See GetStage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) GetStageWithContext(ctx aws.Context, input *GetStageInput, opts ...request.Option) (*GetStageOutput, error) {
	req, out := c.GetStageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetStageSession = "GetStageSession"

// GetStageSessionRequest generates a "aws/request.Request" representing the
// client's request for the GetStageSession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetStageSession for more information on using the GetStageSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetStageSessionRequest method.
//	req, resp := client.GetStageSessionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/GetStageSession
func (c *IVSRealTime) GetStageSessionRequest(input *GetStageSessionInput) (req *request.Request, output *GetStageSessionOutput) {
	op := &request.Operation{
		Name:       opGetStageSession,
		HTTPMethod: "POST",
		HTTPPath:   "/GetStageSession",
	}

	if input == nil {
		input = &GetStageSessionInput{}
	}

	output = &GetStageSessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetStageSession API operation for Amazon Interactive Video Service RealTime.
//
// Gets information for the specified stage session.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation GetStageSession for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
//   - AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/GetStageSession
func (c *IVSRealTime) GetStageSession(input *GetStageSessionInput) (*GetStageSessionOutput, error) {
	req, out := c.GetStageSessionRequest(input)
	return out, req.Send()
}

// GetStageSessionWithContext is the same as GetStageSession with the addition of
// the ability to pass a context and additional request options.
//
// See GetStageSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) GetStageSessionWithContext(ctx aws.Context, input *GetStageSessionInput, opts ...request.Option) (*GetStageSessionOutput, error) {
	req, out := c.GetStageSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListParticipantEvents = "ListParticipantEvents"

// ListParticipantEventsRequest generates a "aws/request.Request" representing the
// client's request for the ListParticipantEvents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListParticipantEvents for more information on using the ListParticipantEvents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListParticipantEventsRequest method.
//	req, resp := client.ListParticipantEventsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListParticipantEvents
func (c *IVSRealTime) ListParticipantEventsRequest(input *ListParticipantEventsInput) (req *request.Request, output *ListParticipantEventsOutput) {
	op := &request.Operation{
		Name:       opListParticipantEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/ListParticipantEvents",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListParticipantEventsInput{}
	}

	output = &ListParticipantEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListParticipantEvents API operation for Amazon Interactive Video Service RealTime.
//
// Lists events for a specified participant that occurred during a specified
// stage session.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation ListParticipantEvents for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//
//   - AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListParticipantEvents
func (c *IVSRealTime) ListParticipantEvents(input *ListParticipantEventsInput) (*ListParticipantEventsOutput, error) {
	req, out := c.ListParticipantEventsRequest(input)
	return out, req.Send()
}

// ListParticipantEventsWithContext is the same as ListParticipantEvents with the addition of
// the ability to pass a context and additional request options.
//
// See ListParticipantEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) ListParticipantEventsWithContext(ctx aws.Context, input *ListParticipantEventsInput, opts ...request.Option) (*ListParticipantEventsOutput, error) {
	req, out := c.ListParticipantEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListParticipantEventsPages iterates over the pages of a ListParticipantEvents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListParticipantEvents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListParticipantEvents operation.
//	pageNum := 0
//	err := client.ListParticipantEventsPages(params,
//	    func(page *ivsrealtime.ListParticipantEventsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *IVSRealTime) ListParticipantEventsPages(input *ListParticipantEventsInput, fn func(*ListParticipantEventsOutput, bool) bool) error {
	return c.ListParticipantEventsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListParticipantEventsPagesWithContext same as ListParticipantEventsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) ListParticipantEventsPagesWithContext(ctx aws.Context, input *ListParticipantEventsInput, fn func(*ListParticipantEventsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListParticipantEventsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListParticipantEventsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListParticipantEventsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListParticipants = "ListParticipants"

// ListParticipantsRequest generates a "aws/request.Request" representing the
// client's request for the ListParticipants operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListParticipants for more information on using the ListParticipants
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListParticipantsRequest method.
//	req, resp := client.ListParticipantsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListParticipants
func (c *IVSRealTime) ListParticipantsRequest(input *ListParticipantsInput) (req *request.Request, output *ListParticipantsOutput) {
	op := &request.Operation{
		Name:       opListParticipants,
		HTTPMethod: "POST",
		HTTPPath:   "/ListParticipants",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListParticipantsInput{}
	}

	output = &ListParticipantsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListParticipants API operation for Amazon Interactive Video Service RealTime.
//
// Lists all participants in a specified stage session.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation ListParticipants for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//
//   - AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListParticipants
func (c *IVSRealTime) ListParticipants(input *ListParticipantsInput) (*ListParticipantsOutput, error) {
	req, out := c.ListParticipantsRequest(input)
	return out, req.Send()
}

// ListParticipantsWithContext is the same as ListParticipants with the addition of
// the ability to pass a context and additional request options.
//
// See ListParticipants for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) ListParticipantsWithContext(ctx aws.Context, input *ListParticipantsInput, opts ...request.Option) (*ListParticipantsOutput, error) {
	req, out := c.ListParticipantsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListParticipantsPages iterates over the pages of a ListParticipants operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListParticipants method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListParticipants operation.
//	pageNum := 0
//	err := client.ListParticipantsPages(params,
//	    func(page *ivsrealtime.ListParticipantsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *IVSRealTime) ListParticipantsPages(input *ListParticipantsInput, fn func(*ListParticipantsOutput, bool) bool) error {
	return c.ListParticipantsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListParticipantsPagesWithContext same as ListParticipantsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) ListParticipantsPagesWithContext(ctx aws.Context, input *ListParticipantsInput, fn func(*ListParticipantsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListParticipantsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListParticipantsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListParticipantsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListStageSessions = "ListStageSessions"

// ListStageSessionsRequest generates a "aws/request.Request" representing the
// client's request for the ListStageSessions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStageSessions for more information on using the ListStageSessions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListStageSessionsRequest method.
//	req, resp := client.ListStageSessionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListStageSessions
func (c *IVSRealTime) ListStageSessionsRequest(input *ListStageSessionsInput) (req *request.Request, output *ListStageSessionsOutput) {
	op := &request.Operation{
		Name:       opListStageSessions,
		HTTPMethod: "POST",
		HTTPPath:   "/ListStageSessions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStageSessionsInput{}
	}

	output = &ListStageSessionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListStageSessions API operation for Amazon Interactive Video Service RealTime.
//
// Gets all sessions for a specified stage.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation ListStageSessions for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//
//   - AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListStageSessions
func (c *IVSRealTime) ListStageSessions(input *ListStageSessionsInput) (*ListStageSessionsOutput, error) {
	req, out := c.ListStageSessionsRequest(input)
	return out, req.Send()
}

// ListStageSessionsWithContext is the same as ListStageSessions with the addition of
// the ability to pass a context and additional request options.
//
// See ListStageSessions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) ListStageSessionsWithContext(ctx aws.Context, input *ListStageSessionsInput, opts ...request.Option) (*ListStageSessionsOutput, error) {
	req, out := c.ListStageSessionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListStageSessionsPages iterates over the pages of a ListStageSessions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListStageSessions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListStageSessions operation.
//	pageNum := 0
//	err := client.ListStageSessionsPages(params,
//	    func(page *ivsrealtime.ListStageSessionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *IVSRealTime) ListStageSessionsPages(input *ListStageSessionsInput, fn func(*ListStageSessionsOutput, bool) bool) error {
	return c.ListStageSessionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListStageSessionsPagesWithContext same as ListStageSessionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) ListStageSessionsPagesWithContext(ctx aws.Context, input *ListStageSessionsInput, fn func(*ListStageSessionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListStageSessionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListStageSessionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListStageSessionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListStages = "ListStages"

// ListStagesRequest generates a "aws/request.Request" representing the
// client's request for the ListStages operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStages for more information on using the ListStages
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListStagesRequest method.
//	req, resp := client.ListStagesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListStages
func (c *IVSRealTime) ListStagesRequest(input *ListStagesInput) (req *request.Request, output *ListStagesOutput) {
	op := &request.Operation{
		Name:       opListStages,
		HTTPMethod: "POST",
		HTTPPath:   "/ListStages",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStagesInput{}
	}

	output = &ListStagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListStages API operation for Amazon Interactive Video Service RealTime.
//
// Gets summary information about all stages in your account, in the AWS region
// where the API request is processed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation ListStages for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//
//   - AccessDeniedException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListStages
func (c *IVSRealTime) ListStages(input *ListStagesInput) (*ListStagesOutput, error) {
	req, out := c.ListStagesRequest(input)
	return out, req.Send()
}

// ListStagesWithContext is the same as ListStages with the addition of
// the ability to pass a context and additional request options.
//
// See ListStages for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) ListStagesWithContext(ctx aws.Context, input *ListStagesInput, opts ...request.Option) (*ListStagesOutput, error) {
	req, out := c.ListStagesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListStagesPages iterates over the pages of a ListStages operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListStages method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListStages operation.
//	pageNum := 0
//	err := client.ListStagesPages(params,
//	    func(page *ivsrealtime.ListStagesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *IVSRealTime) ListStagesPages(input *ListStagesInput, fn func(*ListStagesOutput, bool) bool) error {
	return c.ListStagesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListStagesPagesWithContext same as ListStagesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) ListStagesPagesWithContext(ctx aws.Context, input *ListStagesInput, fn func(*ListStagesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListStagesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListStagesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListStagesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListTagsForResource
func (c *IVSRealTime) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Interactive Video Service RealTime.
//
// Gets information about AWS tags for the specified ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
//   - InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListTagsForResource
func (c *IVSRealTime) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/TagResource
func (c *IVSRealTime) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Interactive Video Service RealTime.
//
// Adds or updates tags for the AWS resource with the specified ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
//   - InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/TagResource
func (c *IVSRealTime) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/UntagResource
func (c *IVSRealTime) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Interactive Video Service RealTime.
//
// Removes tags from the resource with the specified ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
//   - InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/UntagResource
func (c *IVSRealTime) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateStage = "UpdateStage"

// UpdateStageRequest generates a "aws/request.Request" representing the
// client's request for the UpdateStage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateStage for more information on using the UpdateStage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateStageRequest method.
//	req, resp := client.UpdateStageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/UpdateStage
func (c *IVSRealTime) UpdateStageRequest(input *UpdateStageInput) (req *request.Request, output *UpdateStageOutput) {
	op := &request.Operation{
		Name:       opUpdateStage,
		HTTPMethod: "POST",
		HTTPPath:   "/UpdateStage",
	}

	if input == nil {
		input = &UpdateStageInput{}
	}

	output = &UpdateStageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateStage API operation for Amazon Interactive Video Service RealTime.
//
// Updates a stage’s configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation UpdateStage for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
//   - AccessDeniedException
//
//   - ServiceQuotaExceededException
//
//   - PendingVerification
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/UpdateStage
func (c *IVSRealTime) UpdateStage(input *UpdateStageInput) (*UpdateStageOutput, error) {
	req, out := c.UpdateStageRequest(input)
	return out, req.Send()
}

// UpdateStageWithContext is the same as UpdateStage with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateStage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) UpdateStageWithContext(ctx aws.Context, input *UpdateStageInput, opts ...request.Option) (*UpdateStageOutput, error) {
	req, out := c.UpdateStageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// User does not have sufficient access to perform this action.
	ExceptionMessage *string `locationName:"exceptionMessage" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Updating or deleting a resource can cause an inconsistent state.
	ExceptionMessage *string `locationName:"exceptionMessage" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateParticipantTokenInput struct {
	_ struct{} `type:"structure"`

	// Application-provided attributes to encode into the token and attach to a
	// stage. Map keys and values can contain UTF-8 encoded text. The maximum length
	// of this field is 1 KB total. This field is exposed to all stage participants
	// and should not be used for personally identifying, confidential, or sensitive
	// information.
	Attributes map[string]*string `locationName:"attributes" type:"map"`

	// Set of capabilities that the user is allowed to perform in the stage. Default:
	// PUBLISH, SUBSCRIBE.
	Capabilities []*string `locationName:"capabilities" type:"list" enum:"ParticipantTokenCapability"`

	// Duration (in minutes), after which the token expires. Default: 720 (12 hours).
	Duration *int64 `locationName:"duration" min:"1" type:"integer"`

	// ARN of the stage to which this token is scoped.
	//
	// StageArn is a required field
	StageArn *string `locationName:"stageArn" min:"1" type:"string" required:"true"`

	// Name that can be specified to help identify the token. This can be any UTF-8
	// encoded text. This field is exposed to all stage participants and should
	// not be used for personally identifying, confidential, or sensitive information.
	UserId *string `locationName:"userId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateParticipantTokenInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateParticipantTokenInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateParticipantTokenInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateParticipantTokenInput"}
	if s.Duration != nil && *s.Duration < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Duration", 1))
	}
	if s.StageArn == nil {
		invalidParams.Add(request.NewErrParamRequired("StageArn"))
	}
	if s.StageArn != nil && len(*s.StageArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StageArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *CreateParticipantTokenInput) SetAttributes(v map[string]*string) *CreateParticipantTokenInput {
	s.Attributes = v
	return s
}

// SetCapabilities sets the Capabilities field's value.
func (s *CreateParticipantTokenInput) SetCapabilities(v []*string) *CreateParticipantTokenInput {
	s.Capabilities = v
	return s
}

// SetDuration sets the Duration field's value.
func (s *CreateParticipantTokenInput) SetDuration(v int64) *CreateParticipantTokenInput {
	s.Duration = &v
	return s
}

// SetStageArn sets the StageArn field's value.
func (s *CreateParticipantTokenInput) SetStageArn(v string) *CreateParticipantTokenInput {
	s.StageArn = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *CreateParticipantTokenInput) SetUserId(v string) *CreateParticipantTokenInput {
	s.UserId = &v
	return s
}

type CreateParticipantTokenOutput struct {
	_ struct{} `type:"structure"`

	// The participant token that was created.
	ParticipantToken *ParticipantToken `locationName:"participantToken" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateParticipantTokenOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateParticipantTokenOutput) GoString() string {
	return s.String()
}

// SetParticipantToken sets the ParticipantToken field's value.
func (s *CreateParticipantTokenOutput) SetParticipantToken(v *ParticipantToken) *CreateParticipantTokenOutput {
	s.ParticipantToken = v
	return s
}

type CreateStageInput struct {
	_ struct{} `type:"structure"`

	// Optional name that can be specified for the stage being created.
	Name *string `locationName:"name" type:"string"`

	// Array of participant token configuration objects to attach to the new stage.
	ParticipantTokenConfigurations []*ParticipantTokenConfiguration `locationName:"participantTokenConfigurations" type:"list"`

	// Tags attached to the resource. Array of maps, each of the form string:string
	// (key:value). See Tagging AWS Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// for details, including restrictions that apply to tags and "Tag naming limits
	// and requirements"; Amazon IVS has no constraints on tags beyond what is documented
	// there.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateStageInput"}
	if s.ParticipantTokenConfigurations != nil {
		for i, v := range s.ParticipantTokenConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ParticipantTokenConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CreateStageInput) SetName(v string) *CreateStageInput {
	s.Name = &v
	return s
}

// SetParticipantTokenConfigurations sets the ParticipantTokenConfigurations field's value.
func (s *CreateStageInput) SetParticipantTokenConfigurations(v []*ParticipantTokenConfiguration) *CreateStageInput {
	s.ParticipantTokenConfigurations = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateStageInput) SetTags(v map[string]*string) *CreateStageInput {
	s.Tags = v
	return s
}

type CreateStageOutput struct {
	_ struct{} `type:"structure"`

	// Participant tokens attached to the stage. These correspond to the participants
	// in the request.
	ParticipantTokens []*ParticipantToken `locationName:"participantTokens" type:"list"`

	// The stage that was created.
	Stage *Stage `locationName:"stage" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStageOutput) GoString() string {
	return s.String()
}

// SetParticipantTokens sets the ParticipantTokens field's value.
func (s *CreateStageOutput) SetParticipantTokens(v []*ParticipantToken) *CreateStageOutput {
	s.ParticipantTokens = v
	return s
}

// SetStage sets the Stage field's value.
func (s *CreateStageOutput) SetStage(v *Stage) *CreateStageOutput {
	s.Stage = v
	return s
}

type DeleteStageInput struct {
	_ struct{} `type:"structure"`

	// ARN of the stage to be deleted.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteStageInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DeleteStageInput) SetArn(v string) *DeleteStageInput {
	s.Arn = &v
	return s
}

type DeleteStageOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStageOutput) GoString() string {
	return s.String()
}

type DisconnectParticipantInput struct {
	_ struct{} `type:"structure"`

	// Identifier of the participant to be disconnected. This is assigned by IVS
	// and returned by CreateParticipantToken.
	//
	// ParticipantId is a required field
	ParticipantId *string `locationName:"participantId" type:"string" required:"true"`

	// Description of why this participant is being disconnected.
	Reason *string `locationName:"reason" type:"string"`

	// ARN of the stage to which the participant is attached.
	//
	// StageArn is a required field
	StageArn *string `locationName:"stageArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisconnectParticipantInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisconnectParticipantInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisconnectParticipantInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisconnectParticipantInput"}
	if s.ParticipantId == nil {
		invalidParams.Add(request.NewErrParamRequired("ParticipantId"))
	}
	if s.StageArn == nil {
		invalidParams.Add(request.NewErrParamRequired("StageArn"))
	}
	if s.StageArn != nil && len(*s.StageArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StageArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetParticipantId sets the ParticipantId field's value.
func (s *DisconnectParticipantInput) SetParticipantId(v string) *DisconnectParticipantInput {
	s.ParticipantId = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *DisconnectParticipantInput) SetReason(v string) *DisconnectParticipantInput {
	s.Reason = &v
	return s
}

// SetStageArn sets the StageArn field's value.
func (s *DisconnectParticipantInput) SetStageArn(v string) *DisconnectParticipantInput {
	s.StageArn = &v
	return s
}

type DisconnectParticipantOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisconnectParticipantOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisconnectParticipantOutput) GoString() string {
	return s.String()
}

// An occurrence during a stage session.
type Event struct {
	_ struct{} `type:"structure"`

	// If the event is an error event, the error code is provided to give insight
	// into the specific error that occurred. If the event is not an error event,
	// this field is null. INSUFFICIENT_CAPABILITIES indicates that the participant
	// tried to take an action that the participant’s token is not allowed to
	// do. For more information about participant capabilities, see the capabilities
	// field in CreateParticipantToken. QUOTA_EXCEEDED indicates that the number
	// of participants who want to publish/subscribe to a stage exceeds the quota;
	// for more information, see Service Quotas (https://docs.aws.amazon.com/ivs/latest/RealTimeUserGuide/service-quotas.html).
	// PUBLISHER_NOT_FOUND indicates that the participant tried to subscribe to
	// a publisher that doesn’t exist.
	ErrorCode *string `locationName:"errorCode" type:"string" enum:"EventErrorCode"`

	// ISO 8601 timestamp (returned as a string) for when the event occurred.
	EventTime *time.Time `locationName:"eventTime" type:"timestamp" timestampFormat:"iso8601"`

	// The name of the event.
	Name *string `locationName:"name" type:"string" enum:"EventName"`

	// Unique identifier for the participant who triggered the event. This is assigned
	// by IVS.
	ParticipantId *string `locationName:"participantId" type:"string"`

	// Unique identifier for the remote participant. For a subscribe event, this
	// is the publisher. For a publish or join event, this is null. This is assigned
	// by IVS.
	RemoteParticipantId *string `locationName:"remoteParticipantId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Event) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Event) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *Event) SetErrorCode(v string) *Event {
	s.ErrorCode = &v
	return s
}

// SetEventTime sets the EventTime field's value.
func (s *Event) SetEventTime(v time.Time) *Event {
	s.EventTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *Event) SetName(v string) *Event {
	s.Name = &v
	return s
}

// SetParticipantId sets the ParticipantId field's value.
func (s *Event) SetParticipantId(v string) *Event {
	s.ParticipantId = &v
	return s
}

// SetRemoteParticipantId sets the RemoteParticipantId field's value.
func (s *Event) SetRemoteParticipantId(v string) *Event {
	s.RemoteParticipantId = &v
	return s
}

type GetParticipantInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for the participant. This is assigned by IVS and returned
	// by CreateParticipantToken.
	//
	// ParticipantId is a required field
	ParticipantId *string `locationName:"participantId" type:"string" required:"true"`

	// ID of a session within the stage.
	//
	// SessionId is a required field
	SessionId *string `locationName:"sessionId" min:"16" type:"string" required:"true"`

	// Stage ARN.
	//
	// StageArn is a required field
	StageArn *string `locationName:"stageArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetParticipantInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetParticipantInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetParticipantInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetParticipantInput"}
	if s.ParticipantId == nil {
		invalidParams.Add(request.NewErrParamRequired("ParticipantId"))
	}
	if s.SessionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SessionId"))
	}
	if s.SessionId != nil && len(*s.SessionId) < 16 {
		invalidParams.Add(request.NewErrParamMinLen("SessionId", 16))
	}
	if s.StageArn == nil {
		invalidParams.Add(request.NewErrParamRequired("StageArn"))
	}
	if s.StageArn != nil && len(*s.StageArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StageArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetParticipantId sets the ParticipantId field's value.
func (s *GetParticipantInput) SetParticipantId(v string) *GetParticipantInput {
	s.ParticipantId = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *GetParticipantInput) SetSessionId(v string) *GetParticipantInput {
	s.SessionId = &v
	return s
}

// SetStageArn sets the StageArn field's value.
func (s *GetParticipantInput) SetStageArn(v string) *GetParticipantInput {
	s.StageArn = &v
	return s
}

type GetParticipantOutput struct {
	_ struct{} `type:"structure"`

	// The participant that is returned.
	Participant *Participant `locationName:"participant" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetParticipantOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetParticipantOutput) GoString() string {
	return s.String()
}

// SetParticipant sets the Participant field's value.
func (s *GetParticipantOutput) SetParticipant(v *Participant) *GetParticipantOutput {
	s.Participant = v
	return s
}

type GetStageInput struct {
	_ struct{} `type:"structure"`

	// ARN of the stage for which the information is to be retrieved.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetStageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetStageInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetStageInput) SetArn(v string) *GetStageInput {
	s.Arn = &v
	return s
}

type GetStageOutput struct {
	_ struct{} `type:"structure"`

	// The stage that is returned.
	Stage *Stage `locationName:"stage" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStageOutput) GoString() string {
	return s.String()
}

// SetStage sets the Stage field's value.
func (s *GetStageOutput) SetStage(v *Stage) *GetStageOutput {
	s.Stage = v
	return s
}

type GetStageSessionInput struct {
	_ struct{} `type:"structure"`

	// ID of a session within the stage.
	//
	// SessionId is a required field
	SessionId *string `locationName:"sessionId" min:"16" type:"string" required:"true"`

	// ARN of the stage for which the information is to be retrieved.
	//
	// StageArn is a required field
	StageArn *string `locationName:"stageArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStageSessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStageSessionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetStageSessionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetStageSessionInput"}
	if s.SessionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SessionId"))
	}
	if s.SessionId != nil && len(*s.SessionId) < 16 {
		invalidParams.Add(request.NewErrParamMinLen("SessionId", 16))
	}
	if s.StageArn == nil {
		invalidParams.Add(request.NewErrParamRequired("StageArn"))
	}
	if s.StageArn != nil && len(*s.StageArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StageArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSessionId sets the SessionId field's value.
func (s *GetStageSessionInput) SetSessionId(v string) *GetStageSessionInput {
	s.SessionId = &v
	return s
}

// SetStageArn sets the StageArn field's value.
func (s *GetStageSessionInput) SetStageArn(v string) *GetStageSessionInput {
	s.StageArn = &v
	return s
}

type GetStageSessionOutput struct {
	_ struct{} `type:"structure"`

	// The stage session that is returned.
	StageSession *StageSession `locationName:"stageSession" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStageSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStageSessionOutput) GoString() string {
	return s.String()
}

// SetStageSession sets the StageSession field's value.
func (s *GetStageSessionOutput) SetStageSession(v *StageSession) *GetStageSessionOutput {
	s.StageSession = v
	return s
}

type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Unexpected error during processing of request.
	ExceptionMessage *string `locationName:"exceptionMessage" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListParticipantEventsInput struct {
	_ struct{} `type:"structure"`

	// Maximum number of results to return. Default: 50.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The first participant to retrieve. This is used for pagination; see the nextToken
	// response field.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Unique identifier for this participant. This is assigned by IVS and returned
	// by CreateParticipantToken.
	//
	// ParticipantId is a required field
	ParticipantId *string `locationName:"participantId" type:"string" required:"true"`

	// ID of a session within the stage.
	//
	// SessionId is a required field
	SessionId *string `locationName:"sessionId" min:"16" type:"string" required:"true"`

	// Stage ARN.
	//
	// StageArn is a required field
	StageArn *string `locationName:"stageArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListParticipantEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListParticipantEventsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListParticipantEventsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListParticipantEventsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ParticipantId == nil {
		invalidParams.Add(request.NewErrParamRequired("ParticipantId"))
	}
	if s.SessionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SessionId"))
	}
	if s.SessionId != nil && len(*s.SessionId) < 16 {
		invalidParams.Add(request.NewErrParamMinLen("SessionId", 16))
	}
	if s.StageArn == nil {
		invalidParams.Add(request.NewErrParamRequired("StageArn"))
	}
	if s.StageArn != nil && len(*s.StageArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StageArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListParticipantEventsInput) SetMaxResults(v int64) *ListParticipantEventsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListParticipantEventsInput) SetNextToken(v string) *ListParticipantEventsInput {
	s.NextToken = &v
	return s
}

// SetParticipantId sets the ParticipantId field's value.
func (s *ListParticipantEventsInput) SetParticipantId(v string) *ListParticipantEventsInput {
	s.ParticipantId = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *ListParticipantEventsInput) SetSessionId(v string) *ListParticipantEventsInput {
	s.SessionId = &v
	return s
}

// SetStageArn sets the StageArn field's value.
func (s *ListParticipantEventsInput) SetStageArn(v string) *ListParticipantEventsInput {
	s.StageArn = &v
	return s
}

type ListParticipantEventsOutput struct {
	_ struct{} `type:"structure"`

	// List of the matching events.
	//
	// Events is a required field
	Events []*Event `locationName:"events" type:"list" required:"true"`

	// If there are more rooms than maxResults, use nextToken in the request to
	// get the next set.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListParticipantEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListParticipantEventsOutput) GoString() string {
	return s.String()
}

// SetEvents sets the Events field's value.
func (s *ListParticipantEventsOutput) SetEvents(v []*Event) *ListParticipantEventsOutput {
	s.Events = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListParticipantEventsOutput) SetNextToken(v string) *ListParticipantEventsOutput {
	s.NextToken = &v
	return s
}

type ListParticipantsInput struct {
	_ struct{} `type:"structure"`

	// Filters the response list to only show participants who published during
	// the stage session. Only one of filterByUserId, filterByPublished, or filterByState
	// can be provided per request.
	FilterByPublished *bool `locationName:"filterByPublished" type:"boolean"`

	// Filters the response list to only show participants in the specified state.
	// Only one of filterByUserId, filterByPublished, or filterByState can be provided
	// per request.
	FilterByState *string `locationName:"filterByState" type:"string" enum:"ParticipantState"`

	// Filters the response list to match the specified user ID. Only one of filterByUserId,
	// filterByPublished, or filterByState can be provided per request. A userId
	// is a customer-assigned name to help identify the token; this can be used
	// to link a participant to a user in the customer’s own systems.
	FilterByUserId *string `locationName:"filterByUserId" type:"string"`

	// Maximum number of results to return. Default: 50.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The first participant to retrieve. This is used for pagination; see the nextToken
	// response field.
	NextToken *string `locationName:"nextToken" type:"string"`

	// ID of the session within the stage.
	//
	// SessionId is a required field
	SessionId *string `locationName:"sessionId" min:"16" type:"string" required:"true"`

	// Stage ARN.
	//
	// StageArn is a required field
	StageArn *string `locationName:"stageArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListParticipantsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListParticipantsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListParticipantsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListParticipantsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.SessionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SessionId"))
	}
	if s.SessionId != nil && len(*s.SessionId) < 16 {
		invalidParams.Add(request.NewErrParamMinLen("SessionId", 16))
	}
	if s.StageArn == nil {
		invalidParams.Add(request.NewErrParamRequired("StageArn"))
	}
	if s.StageArn != nil && len(*s.StageArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StageArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilterByPublished sets the FilterByPublished field's value.
func (s *ListParticipantsInput) SetFilterByPublished(v bool) *ListParticipantsInput {
	s.FilterByPublished = &v
	return s
}

// SetFilterByState sets the FilterByState field's value.
func (s *ListParticipantsInput) SetFilterByState(v string) *ListParticipantsInput {
	s.FilterByState = &v
	return s
}

// SetFilterByUserId sets the FilterByUserId field's value.
func (s *ListParticipantsInput) SetFilterByUserId(v string) *ListParticipantsInput {
	s.FilterByUserId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListParticipantsInput) SetMaxResults(v int64) *ListParticipantsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListParticipantsInput) SetNextToken(v string) *ListParticipantsInput {
	s.NextToken = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *ListParticipantsInput) SetSessionId(v string) *ListParticipantsInput {
	s.SessionId = &v
	return s
}

// SetStageArn sets the StageArn field's value.
func (s *ListParticipantsInput) SetStageArn(v string) *ListParticipantsInput {
	s.StageArn = &v
	return s
}

type ListParticipantsOutput struct {
	_ struct{} `type:"structure"`

	// If there are more rooms than maxResults, use nextToken in the request to
	// get the next set.
	NextToken *string `locationName:"nextToken" type:"string"`

	// List of the matching participants (summary information only).
	//
	// Participants is a required field
	Participants []*ParticipantSummary `locationName:"participants" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListParticipantsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListParticipantsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListParticipantsOutput) SetNextToken(v string) *ListParticipantsOutput {
	s.NextToken = &v
	return s
}

// SetParticipants sets the Participants field's value.
func (s *ListParticipantsOutput) SetParticipants(v []*ParticipantSummary) *ListParticipantsOutput {
	s.Participants = v
	return s
}

type ListStageSessionsInput struct {
	_ struct{} `type:"structure"`

	// Maximum number of results to return. Default: 50.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The first stage to retrieve. This is used for pagination; see the nextToken
	// response field.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Stage ARN.
	//
	// StageArn is a required field
	StageArn *string `locationName:"stageArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStageSessionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStageSessionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStageSessionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListStageSessionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.StageArn == nil {
		invalidParams.Add(request.NewErrParamRequired("StageArn"))
	}
	if s.StageArn != nil && len(*s.StageArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StageArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListStageSessionsInput) SetMaxResults(v int64) *ListStageSessionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListStageSessionsInput) SetNextToken(v string) *ListStageSessionsInput {
	s.NextToken = &v
	return s
}

// SetStageArn sets the StageArn field's value.
func (s *ListStageSessionsInput) SetStageArn(v string) *ListStageSessionsInput {
	s.StageArn = &v
	return s
}

type ListStageSessionsOutput struct {
	_ struct{} `type:"structure"`

	// If there are more rooms than maxResults, use nextToken in the request to
	// get the next set.
	NextToken *string `locationName:"nextToken" type:"string"`

	// List of matching stage sessions.
	//
	// StageSessions is a required field
	StageSessions []*StageSessionSummary `locationName:"stageSessions" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStageSessionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStageSessionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListStageSessionsOutput) SetNextToken(v string) *ListStageSessionsOutput {
	s.NextToken = &v
	return s
}

// SetStageSessions sets the StageSessions field's value.
func (s *ListStageSessionsOutput) SetStageSessions(v []*StageSessionSummary) *ListStageSessionsOutput {
	s.StageSessions = v
	return s
}

type ListStagesInput struct {
	_ struct{} `type:"structure"`

	// Maximum number of results to return. Default: 50.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The first stage to retrieve. This is used for pagination; see the nextToken
	// response field.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStagesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStagesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStagesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListStagesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListStagesInput) SetMaxResults(v int64) *ListStagesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListStagesInput) SetNextToken(v string) *ListStagesInput {
	s.NextToken = &v
	return s
}

type ListStagesOutput struct {
	_ struct{} `type:"structure"`

	// If there are more rooms than maxResults, use nextToken in the request to
	// get the next set.
	NextToken *string `locationName:"nextToken" type:"string"`

	// List of the matching stages (summary information only).
	//
	// Stages is a required field
	Stages []*StageSummary `locationName:"stages" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStagesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStagesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListStagesOutput) SetNextToken(v string) *ListStagesOutput {
	s.NextToken = &v
	return s
}

// SetStages sets the Stages field's value.
func (s *ListStagesOutput) SetStages(v []*StageSummary) *ListStagesOutput {
	s.Stages = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the resource to be retrieved. The ARN must be URL-encoded.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// Tags attached to the resource. Array of maps, each of the form string:string
	// (key:value).
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Object describing a participant that has joined a stage.
type Participant struct {
	_ struct{} `type:"structure"`

	// Application-provided attributes to encode into the token and attach to a
	// stage. Map keys and values can contain UTF-8 encoded text. The maximum length
	// of this field is 1 KB total. This field is exposed to all stage participants
	// and should not be used for personally identifying, confidential, or sensitive
	// information.
	Attributes map[string]*string `locationName:"attributes" type:"map"`

	// The participant’s browser.
	BrowserName *string `locationName:"browserName" type:"string"`

	// The participant’s browser version.
	BrowserVersion *string `locationName:"browserVersion" type:"string"`

	// ISO 8601 timestamp (returned as a string) when the participant first joined
	// the stage session.
	FirstJoinTime *time.Time `locationName:"firstJoinTime" type:"timestamp" timestampFormat:"iso8601"`

	// The participant’s Internet Service Provider.
	IspName *string `locationName:"ispName" type:"string"`

	// The participant’s operating system.
	OsName *string `locationName:"osName" type:"string"`

	// The participant’s operating system version.
	OsVersion *string `locationName:"osVersion" type:"string"`

	// Unique identifier for this participant, assigned by IVS.
	ParticipantId *string `locationName:"participantId" type:"string"`

	// Whether the participant ever published to the stage session.
	Published *bool `locationName:"published" type:"boolean"`

	// The participant’s SDK version.
	SdkVersion *string `locationName:"sdkVersion" type:"string"`

	// Whether the participant is connected to or disconnected from the stage.
	State *string `locationName:"state" type:"string" enum:"ParticipantState"`

	// Customer-assigned name to help identify the token; this can be used to link
	// a participant to a user in the customer’s own systems. This can be any
	// UTF-8 encoded text. This field is exposed to all stage participants and should
	// not be used for personally identifying, confidential, or sensitive information.
	UserId *string `locationName:"userId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Participant) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Participant) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *Participant) SetAttributes(v map[string]*string) *Participant {
	s.Attributes = v
	return s
}

// SetBrowserName sets the BrowserName field's value.
func (s *Participant) SetBrowserName(v string) *Participant {
	s.BrowserName = &v
	return s
}

// SetBrowserVersion sets the BrowserVersion field's value.
func (s *Participant) SetBrowserVersion(v string) *Participant {
	s.BrowserVersion = &v
	return s
}

// SetFirstJoinTime sets the FirstJoinTime field's value.
func (s *Participant) SetFirstJoinTime(v time.Time) *Participant {
	s.FirstJoinTime = &v
	return s
}

// SetIspName sets the IspName field's value.
func (s *Participant) SetIspName(v string) *Participant {
	s.IspName = &v
	return s
}

// SetOsName sets the OsName field's value.
func (s *Participant) SetOsName(v string) *Participant {
	s.OsName = &v
	return s
}

// SetOsVersion sets the OsVersion field's value.
func (s *Participant) SetOsVersion(v string) *Participant {
	s.OsVersion = &v
	return s
}

// SetParticipantId sets the ParticipantId field's value.
func (s *Participant) SetParticipantId(v string) *Participant {
	s.ParticipantId = &v
	return s
}

// SetPublished sets the Published field's value.
func (s *Participant) SetPublished(v bool) *Participant {
	s.Published = &v
	return s
}

// SetSdkVersion sets the SdkVersion field's value.
func (s *Participant) SetSdkVersion(v string) *Participant {
	s.SdkVersion = &v
	return s
}

// SetState sets the State field's value.
func (s *Participant) SetState(v string) *Participant {
	s.State = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *Participant) SetUserId(v string) *Participant {
	s.UserId = &v
	return s
}

// Summary object describing a participant that has joined a stage.
type ParticipantSummary struct {
	_ struct{} `type:"structure"`

	// ISO 8601 timestamp (returned as a string) when the participant first joined
	// the stage session.
	FirstJoinTime *time.Time `locationName:"firstJoinTime" type:"timestamp" timestampFormat:"iso8601"`

	// Unique identifier for this participant, assigned by IVS.
	ParticipantId *string `locationName:"participantId" type:"string"`

	// Whether the participant ever published to the stage session.
	Published *bool `locationName:"published" type:"boolean"`

	// Whether the participant is connected to or disconnected from the stage.
	State *string `locationName:"state" type:"string" enum:"ParticipantState"`

	// Customer-assigned name to help identify the token; this can be used to link
	// a participant to a user in the customer’s own systems. This can be any
	// UTF-8 encoded text. This field is exposed to all stage participants and should
	// not be used for personally identifying, confidential, or sensitive information.
	UserId *string `locationName:"userId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParticipantSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParticipantSummary) GoString() string {
	return s.String()
}

// SetFirstJoinTime sets the FirstJoinTime field's value.
func (s *ParticipantSummary) SetFirstJoinTime(v time.Time) *ParticipantSummary {
	s.FirstJoinTime = &v
	return s
}

// SetParticipantId sets the ParticipantId field's value.
func (s *ParticipantSummary) SetParticipantId(v string) *ParticipantSummary {
	s.ParticipantId = &v
	return s
}

// SetPublished sets the Published field's value.
func (s *ParticipantSummary) SetPublished(v bool) *ParticipantSummary {
	s.Published = &v
	return s
}

// SetState sets the State field's value.
func (s *ParticipantSummary) SetState(v string) *ParticipantSummary {
	s.State = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *ParticipantSummary) SetUserId(v string) *ParticipantSummary {
	s.UserId = &v
	return s
}

// Object specifying a participant token in a stage.
//
// Important: Treat tokens as opaque; i.e., do not build functionality based
// on token contents. The format of tokens could change in the future.
type ParticipantToken struct {
	_ struct{} `type:"structure"`

	// Application-provided attributes to encode into the token and attach to a
	// stage. This field is exposed to all stage participants and should not be
	// used for personally identifying, confidential, or sensitive information.
	Attributes map[string]*string `locationName:"attributes" type:"map"`

	// Set of capabilities that the user is allowed to perform in the stage.
	Capabilities []*string `locationName:"capabilities" type:"list" enum:"ParticipantTokenCapability"`

	// Duration (in minutes), after which the participant token expires. Default:
	// 720 (12 hours).
	Duration *int64 `locationName:"duration" min:"1" type:"integer"`

	// ISO 8601 timestamp (returned as a string) for when this token expires.
	ExpirationTime *time.Time `locationName:"expirationTime" type:"timestamp" timestampFormat:"iso8601"`

	// Unique identifier for this participant token, assigned by IVS.
	ParticipantId *string `locationName:"participantId" type:"string"`

	// The issued client token, encrypted.
	//
	// Token is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ParticipantToken's
	// String and GoString methods.
	Token *string `locationName:"token" type:"string" sensitive:"true"`

	// Customer-assigned name to help identify the token; this can be used to link
	// a participant to a user in the customer’s own systems. This can be any
	// UTF-8 encoded text. This field is exposed to all stage participants and should
	// not be used for personally identifying, confidential, or sensitive information.
	UserId *string `locationName:"userId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParticipantToken) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParticipantToken) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *ParticipantToken) SetAttributes(v map[string]*string) *ParticipantToken {
	s.Attributes = v
	return s
}

// SetCapabilities sets the Capabilities field's value.
func (s *ParticipantToken) SetCapabilities(v []*string) *ParticipantToken {
	s.Capabilities = v
	return s
}

// SetDuration sets the Duration field's value.
func (s *ParticipantToken) SetDuration(v int64) *ParticipantToken {
	s.Duration = &v
	return s
}

// SetExpirationTime sets the ExpirationTime field's value.
func (s *ParticipantToken) SetExpirationTime(v time.Time) *ParticipantToken {
	s.ExpirationTime = &v
	return s
}

// SetParticipantId sets the ParticipantId field's value.
func (s *ParticipantToken) SetParticipantId(v string) *ParticipantToken {
	s.ParticipantId = &v
	return s
}

// SetToken sets the Token field's value.
func (s *ParticipantToken) SetToken(v string) *ParticipantToken {
	s.Token = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *ParticipantToken) SetUserId(v string) *ParticipantToken {
	s.UserId = &v
	return s
}

// Object specifying a participant token configuration in a stage.
type ParticipantTokenConfiguration struct {
	_ struct{} `type:"structure"`

	// Application-provided attributes to encode into the corresponding participant
	// token and attach to a stage. Map keys and values can contain UTF-8 encoded
	// text. The maximum length of this field is 1 KB total. This field is exposed
	// to all stage participants and should not be used for personally identifying,
	// confidential, or sensitive information.
	Attributes map[string]*string `locationName:"attributes" type:"map"`

	// Set of capabilities that the user is allowed to perform in the stage.
	Capabilities []*string `locationName:"capabilities" type:"list" enum:"ParticipantTokenCapability"`

	// Duration (in minutes), after which the corresponding participant token expires.
	// Default: 720 (12 hours).
	Duration *int64 `locationName:"duration" min:"1" type:"integer"`

	// Customer-assigned name to help identify the token; this can be used to link
	// a participant to a user in the customer’s own systems. This can be any
	// UTF-8 encoded text. This field is exposed to all stage participants and should
	// not be used for personally identifying, confidential, or sensitive information.
	UserId *string `locationName:"userId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParticipantTokenConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParticipantTokenConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ParticipantTokenConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ParticipantTokenConfiguration"}
	if s.Duration != nil && *s.Duration < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Duration", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *ParticipantTokenConfiguration) SetAttributes(v map[string]*string) *ParticipantTokenConfiguration {
	s.Attributes = v
	return s
}

// SetCapabilities sets the Capabilities field's value.
func (s *ParticipantTokenConfiguration) SetCapabilities(v []*string) *ParticipantTokenConfiguration {
	s.Capabilities = v
	return s
}

// SetDuration sets the Duration field's value.
func (s *ParticipantTokenConfiguration) SetDuration(v int64) *ParticipantTokenConfiguration {
	s.Duration = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *ParticipantTokenConfiguration) SetUserId(v string) *ParticipantTokenConfiguration {
	s.UserId = &v
	return s
}

type PendingVerification struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Your account is pending verification.
	ExceptionMessage *string `locationName:"exceptionMessage" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PendingVerification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PendingVerification) GoString() string {
	return s.String()
}

func newErrorPendingVerification(v protocol.ResponseMetadata) error {
	return &PendingVerification{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *PendingVerification) Code() string {
	return "PendingVerification"
}

// Message returns the exception's message.
func (s *PendingVerification) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *PendingVerification) OrigErr() error {
	return nil
}

func (s *PendingVerification) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *PendingVerification) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *PendingVerification) RequestID() string {
	return s.RespMetadata.RequestID
}

type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Request references a resource which does not exist.
	ExceptionMessage *string `locationName:"exceptionMessage" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Request would cause a service quota to be exceeded.
	ExceptionMessage *string `locationName:"exceptionMessage" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Object specifying a stage.
type Stage struct {
	_ struct{} `type:"structure"`

	// ID of the active session within the stage.
	ActiveSessionId *string `locationName:"activeSessionId" min:"16" type:"string"`

	// Stage ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// Stage name.
	Name *string `locationName:"name" type:"string"`

	// Tags attached to the resource. Array of maps, each of the form string:string
	// (key:value). See Tagging AWS Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// for details, including restrictions that apply to tags and "Tag naming limits
	// and requirements"; Amazon IVS has no constraints on tags beyond what is documented
	// there.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Stage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Stage) GoString() string {
	return s.String()
}

// SetActiveSessionId sets the ActiveSessionId field's value.
func (s *Stage) SetActiveSessionId(v string) *Stage {
	s.ActiveSessionId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *Stage) SetArn(v string) *Stage {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *Stage) SetName(v string) *Stage {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Stage) SetTags(v map[string]*string) *Stage {
	s.Tags = v
	return s
}

// A stage session begins when the first participant joins a stage and ends
// after the last participant leaves the stage. A stage session helps with debugging
// stages by grouping events and participants into shorter periods of time (i.e.,
// a session), which is helpful when stages are used over long periods of time.
type StageSession struct {
	_ struct{} `type:"structure"`

	// ISO 8601 timestamp (returned as a string) when the stage session ended. This
	// is null if the stage is active.
	EndTime *time.Time `locationName:"endTime" type:"timestamp" timestampFormat:"iso8601"`

	// ID of the session within the stage.
	SessionId *string `locationName:"sessionId" min:"16" type:"string"`

	// ISO 8601 timestamp (returned as a string) when this stage session began.
	StartTime *time.Time `locationName:"startTime" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StageSession) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StageSession) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *StageSession) SetEndTime(v time.Time) *StageSession {
	s.EndTime = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *StageSession) SetSessionId(v string) *StageSession {
	s.SessionId = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *StageSession) SetStartTime(v time.Time) *StageSession {
	s.StartTime = &v
	return s
}

// Summary information about a stage session.
type StageSessionSummary struct {
	_ struct{} `type:"structure"`

	// ISO 8601 timestamp (returned as a string) when the stage session ended. This
	// is null if the stage is active.
	EndTime *time.Time `locationName:"endTime" type:"timestamp" timestampFormat:"iso8601"`

	// ID of the session within the stage.
	SessionId *string `locationName:"sessionId" min:"16" type:"string"`

	// ISO 8601 timestamp (returned as a string) when this stage session began.
	StartTime *time.Time `locationName:"startTime" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StageSessionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StageSessionSummary) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *StageSessionSummary) SetEndTime(v time.Time) *StageSessionSummary {
	s.EndTime = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *StageSessionSummary) SetSessionId(v string) *StageSessionSummary {
	s.SessionId = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *StageSessionSummary) SetStartTime(v time.Time) *StageSessionSummary {
	s.StartTime = &v
	return s
}

// Summary information about a stage.
type StageSummary struct {
	_ struct{} `type:"structure"`

	// ID of the active session within the stage.
	ActiveSessionId *string `locationName:"activeSessionId" min:"16" type:"string"`

	// Stage ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// Stage name.
	Name *string `locationName:"name" type:"string"`

	// Tags attached to the resource. Array of maps, each of the form string:string
	// (key:value). See Tagging AWS Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// for details, including restrictions that apply to tags and "Tag naming limits
	// and requirements"; Amazon IVS has no constraints on tags beyond what is documented
	// there.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StageSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StageSummary) GoString() string {
	return s.String()
}

// SetActiveSessionId sets the ActiveSessionId field's value.
func (s *StageSummary) SetActiveSessionId(v string) *StageSummary {
	s.ActiveSessionId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *StageSummary) SetArn(v string) *StageSummary {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *StageSummary) SetName(v string) *StageSummary {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *StageSummary) SetTags(v map[string]*string) *StageSummary {
	s.Tags = v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource to be tagged. The ARN must be URL-encoded.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// Array of tags to be added or updated. Array of maps, each of the form string:string
	// (key:value). See Tagging AWS Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// for details, including restrictions that apply to tags and "Tag naming limits
	// and requirements"; Amazon IVS has no constraints beyond what is documented
	// there.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the resource to be untagged. The ARN must be URL-encoded.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// Array of tags to be removed. Array of maps, each of the form string:string
	// (key:value). See Tagging AWS Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// for details, including restrictions that apply to tags and "Tag naming limits
	// and requirements"; Amazon IVS has no constraints beyond what is documented
	// there.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateStageInput struct {
	_ struct{} `type:"structure"`

	// ARN of the stage to be updated.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// Name of the stage to be updated.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateStageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateStageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateStageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateStageInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *UpdateStageInput) SetArn(v string) *UpdateStageInput {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateStageInput) SetName(v string) *UpdateStageInput {
	s.Name = &v
	return s
}

type UpdateStageOutput struct {
	_ struct{} `type:"structure"`

	// The updated stage.
	Stage *Stage `locationName:"stage" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateStageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateStageOutput) GoString() string {
	return s.String()
}

// SetStage sets the Stage field's value.
func (s *UpdateStageOutput) SetStage(v *Stage) *UpdateStageOutput {
	s.Stage = v
	return s
}

type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The input fails to satisfy the constraints specified by an Amazon Web Services
	// service.
	ExceptionMessage *string `locationName:"exceptionMessage" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// EventErrorCodeInsufficientCapabilities is a EventErrorCode enum value
	EventErrorCodeInsufficientCapabilities = "INSUFFICIENT_CAPABILITIES"

	// EventErrorCodeQuotaExceeded is a EventErrorCode enum value
	EventErrorCodeQuotaExceeded = "QUOTA_EXCEEDED"

	// EventErrorCodePublisherNotFound is a EventErrorCode enum value
	EventErrorCodePublisherNotFound = "PUBLISHER_NOT_FOUND"
)

// EventErrorCode_Values returns all elements of the EventErrorCode enum
func EventErrorCode_Values() []string {
	return []string{
		EventErrorCodeInsufficientCapabilities,
		EventErrorCodeQuotaExceeded,
		EventErrorCodePublisherNotFound,
	}
}

const (
	// EventNameJoined is a EventName enum value
	EventNameJoined = "JOINED"

	// EventNameLeft is a EventName enum value
	EventNameLeft = "LEFT"

	// EventNamePublishStarted is a EventName enum value
	EventNamePublishStarted = "PUBLISH_STARTED"

	// EventNamePublishStopped is a EventName enum value
	EventNamePublishStopped = "PUBLISH_STOPPED"

	// EventNameSubscribeStarted is a EventName enum value
	EventNameSubscribeStarted = "SUBSCRIBE_STARTED"

	// EventNameSubscribeStopped is a EventName enum value
	EventNameSubscribeStopped = "SUBSCRIBE_STOPPED"

	// EventNamePublishError is a EventName enum value
	EventNamePublishError = "PUBLISH_ERROR"

	// EventNameSubscribeError is a EventName enum value
	EventNameSubscribeError = "SUBSCRIBE_ERROR"

	// EventNameJoinError is a EventName enum value
	EventNameJoinError = "JOIN_ERROR"
)

// EventName_Values returns all elements of the EventName enum
func EventName_Values() []string {
	return []string{
		EventNameJoined,
		EventNameLeft,
		EventNamePublishStarted,
		EventNamePublishStopped,
		EventNameSubscribeStarted,
		EventNameSubscribeStopped,
		EventNamePublishError,
		EventNameSubscribeError,
		EventNameJoinError,
	}
}

const (
	// ParticipantStateConnected is a ParticipantState enum value
	ParticipantStateConnected = "CONNECTED"

	// ParticipantStateDisconnected is a ParticipantState enum value
	ParticipantStateDisconnected = "DISCONNECTED"
)

// ParticipantState_Values returns all elements of the ParticipantState enum
func ParticipantState_Values() []string {
	return []string{
		ParticipantStateConnected,
		ParticipantStateDisconnected,
	}
}

const (
	// ParticipantTokenCapabilityPublish is a ParticipantTokenCapability enum value
	ParticipantTokenCapabilityPublish = "PUBLISH"

	// ParticipantTokenCapabilitySubscribe is a ParticipantTokenCapability enum value
	ParticipantTokenCapabilitySubscribe = "SUBSCRIBE"
)

// ParticipantTokenCapability_Values returns all elements of the ParticipantTokenCapability enum
func ParticipantTokenCapability_Values() []string {
	return []string{
		ParticipantTokenCapabilityPublish,
		ParticipantTokenCapabilitySubscribe,
	}
}
