// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lakeformation

import (
	"fmt"
	"io"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAddLFTagsToResource = "AddLFTagsToResource"

// AddLFTagsToResourceRequest generates a "aws/request.Request" representing the
// client's request for the AddLFTagsToResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddLFTagsToResource for more information on using the AddLFTagsToResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AddLFTagsToResourceRequest method.
//	req, resp := client.AddLFTagsToResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/AddLFTagsToResource
func (c *LakeFormation) AddLFTagsToResourceRequest(input *AddLFTagsToResourceInput) (req *request.Request, output *AddLFTagsToResourceOutput) {
	op := &request.Operation{
		Name:       opAddLFTagsToResource,
		HTTPMethod: "POST",
		HTTPPath:   "/AddLFTagsToResource",
	}

	if input == nil {
		input = &AddLFTagsToResourceInput{}
	}

	output = &AddLFTagsToResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddLFTagsToResource API operation for AWS Lake Formation.
//
// Attaches one or more LF-tags to an existing resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation AddLFTagsToResource for usage and error information.
//
// Returned Error Types:
//
//   - EntityNotFoundException
//     A specified entity does not exist.
//
//   - InvalidInputException
//     The input provided was not valid.
//
//   - InternalServiceException
//     An internal service error occurred.
//
//   - OperationTimeoutException
//     The operation timed out.
//
//   - AccessDeniedException
//     Access to a resource was denied.
//
//   - ConcurrentModificationException
//     Two processes are trying to modify a resource simultaneously.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/AddLFTagsToResource
func (c *LakeFormation) AddLFTagsToResource(input *AddLFTagsToResourceInput) (*AddLFTagsToResourceOutput, error) {
	req, out := c.AddLFTagsToResourceRequest(input)
	return out, req.Send()
}

// AddLFTagsToResourceWithContext is the same as AddLFTagsToResource with the addition of
// the ability to pass a context and additional request options.
//
// See AddLFTagsToResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) AddLFTagsToResourceWithContext(ctx aws.Context, input *AddLFTagsToResourceInput, opts ...request.Option) (*AddLFTagsToResourceOutput, error) {
	req, out := c.AddLFTagsToResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssumeDecoratedRoleWithSAML = "AssumeDecoratedRoleWithSAML"

// AssumeDecoratedRoleWithSAMLRequest generates a "aws/request.Request" representing the
// client's request for the AssumeDecoratedRoleWithSAML operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssumeDecoratedRoleWithSAML for more information on using the AssumeDecoratedRoleWithSAML
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssumeDecoratedRoleWithSAMLRequest method.
//	req, resp := client.AssumeDecoratedRoleWithSAMLRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/AssumeDecoratedRoleWithSAML
func (c *LakeFormation) AssumeDecoratedRoleWithSAMLRequest(input *AssumeDecoratedRoleWithSAMLInput) (req *request.Request, output *AssumeDecoratedRoleWithSAMLOutput) {
	op := &request.Operation{
		Name:       opAssumeDecoratedRoleWithSAML,
		HTTPMethod: "POST",
		HTTPPath:   "/AssumeDecoratedRoleWithSAML",
	}

	if input == nil {
		input = &AssumeDecoratedRoleWithSAMLInput{}
	}

	output = &AssumeDecoratedRoleWithSAMLOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssumeDecoratedRoleWithSAML API operation for AWS Lake Formation.
//
// Allows a caller to assume an IAM role decorated as the SAML user specified
// in the SAML assertion included in the request. This decoration allows Lake
// Formation to enforce access policies against the SAML users and groups. This
// API operation requires SAML federation setup in the caller’s account as
// it can only be called with valid SAML assertions. Lake Formation does not
// scope down the permission of the assumed role. All permissions attached to
// the role via the SAML federation setup will be included in the role session.
//
// This decorated role is expected to access data in Amazon S3 by getting temporary
// access from Lake Formation which is authorized via the virtual API GetDataAccess.
// Therefore, all SAML roles that can be assumed via AssumeDecoratedRoleWithSAML
// must at a minimum include lakeformation:GetDataAccess in their role policies.
// A typical IAM policy attached to such a role would look as follows:
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation AssumeDecoratedRoleWithSAML for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     The input provided was not valid.
//
//   - InternalServiceException
//     An internal service error occurred.
//
//   - OperationTimeoutException
//     The operation timed out.
//
//   - EntityNotFoundException
//     A specified entity does not exist.
//
//   - AccessDeniedException
//     Access to a resource was denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/AssumeDecoratedRoleWithSAML
func (c *LakeFormation) AssumeDecoratedRoleWithSAML(input *AssumeDecoratedRoleWithSAMLInput) (*AssumeDecoratedRoleWithSAMLOutput, error) {
	req, out := c.AssumeDecoratedRoleWithSAMLRequest(input)
	return out, req.Send()
}

// AssumeDecoratedRoleWithSAMLWithContext is the same as AssumeDecoratedRoleWithSAML with the addition of
// the ability to pass a context and additional request options.
//
// See AssumeDecoratedRoleWithSAML for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) AssumeDecoratedRoleWithSAMLWithContext(ctx aws.Context, input *AssumeDecoratedRoleWithSAMLInput, opts ...request.Option) (*AssumeDecoratedRoleWithSAMLOutput, error) {
	req, out := c.AssumeDecoratedRoleWithSAMLRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchGrantPermissions = "BatchGrantPermissions"

// BatchGrantPermissionsRequest generates a "aws/request.Request" representing the
// client's request for the BatchGrantPermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGrantPermissions for more information on using the BatchGrantPermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchGrantPermissionsRequest method.
//	req, resp := client.BatchGrantPermissionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/BatchGrantPermissions
func (c *LakeFormation) BatchGrantPermissionsRequest(input *BatchGrantPermissionsInput) (req *request.Request, output *BatchGrantPermissionsOutput) {
	op := &request.Operation{
		Name:       opBatchGrantPermissions,
		HTTPMethod: "POST",
		HTTPPath:   "/BatchGrantPermissions",
	}

	if input == nil {
		input = &BatchGrantPermissionsInput{}
	}

	output = &BatchGrantPermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGrantPermissions API operation for AWS Lake Formation.
//
// Batch operation to grant permissions to the principal.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation BatchGrantPermissions for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     The input provided was not valid.
//
//   - OperationTimeoutException
//     The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/BatchGrantPermissions
func (c *LakeFormation) BatchGrantPermissions(input *BatchGrantPermissionsInput) (*BatchGrantPermissionsOutput, error) {
	req, out := c.BatchGrantPermissionsRequest(input)
	return out, req.Send()
}

// BatchGrantPermissionsWithContext is the same as BatchGrantPermissions with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGrantPermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) BatchGrantPermissionsWithContext(ctx aws.Context, input *BatchGrantPermissionsInput, opts ...request.Option) (*BatchGrantPermissionsOutput, error) {
	req, out := c.BatchGrantPermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchRevokePermissions = "BatchRevokePermissions"

// BatchRevokePermissionsRequest generates a "aws/request.Request" representing the
// client's request for the BatchRevokePermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchRevokePermissions for more information on using the BatchRevokePermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchRevokePermissionsRequest method.
//	req, resp := client.BatchRevokePermissionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/BatchRevokePermissions
func (c *LakeFormation) BatchRevokePermissionsRequest(input *BatchRevokePermissionsInput) (req *request.Request, output *BatchRevokePermissionsOutput) {
	op := &request.Operation{
		Name:       opBatchRevokePermissions,
		HTTPMethod: "POST",
		HTTPPath:   "/BatchRevokePermissions",
	}

	if input == nil {
		input = &BatchRevokePermissionsInput{}
	}

	output = &BatchRevokePermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchRevokePermissions API operation for AWS Lake Formation.
//
// Batch operation to revoke permissions from the principal.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation BatchRevokePermissions for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     The input provided was not valid.
//
//   - OperationTimeoutException
//     The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/BatchRevokePermissions
func (c *LakeFormation) BatchRevokePermissions(input *BatchRevokePermissionsInput) (*BatchRevokePermissionsOutput, error) {
	req, out := c.BatchRevokePermissionsRequest(input)
	return out, req.Send()
}

// BatchRevokePermissionsWithContext is the same as BatchRevokePermissions with the addition of
// the ability to pass a context and additional request options.
//
// See BatchRevokePermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) BatchRevokePermissionsWithContext(ctx aws.Context, input *BatchRevokePermissionsInput, opts ...request.Option) (*BatchRevokePermissionsOutput, error) {
	req, out := c.BatchRevokePermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelTransaction = "CancelTransaction"

// CancelTransactionRequest generates a "aws/request.Request" representing the
// client's request for the CancelTransaction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelTransaction for more information on using the CancelTransaction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelTransactionRequest method.
//	req, resp := client.CancelTransactionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/CancelTransaction
func (c *LakeFormation) CancelTransactionRequest(input *CancelTransactionInput) (req *request.Request, output *CancelTransactionOutput) {
	op := &request.Operation{
		Name:       opCancelTransaction,
		HTTPMethod: "POST",
		HTTPPath:   "/CancelTransaction",
	}

	if input == nil {
		input = &CancelTransactionInput{}
	}

	output = &CancelTransactionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CancelTransaction API operation for AWS Lake Formation.
//
// Attempts to cancel the specified transaction. Returns an exception if the
// transaction was previously committed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation CancelTransaction for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     The input provided was not valid.
//
//   - EntityNotFoundException
//     A specified entity does not exist.
//
//   - InternalServiceException
//     An internal service error occurred.
//
//   - OperationTimeoutException
//     The operation timed out.
//
//   - TransactionCommittedException
//     Contains details about an error where the specified transaction has already
//     been committed and cannot be used for UpdateTableObjects.
//
//   - TransactionCommitInProgressException
//     Contains details about an error related to a transaction commit that was
//     in progress.
//
//   - ConcurrentModificationException
//     Two processes are trying to modify a resource simultaneously.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/CancelTransaction
func (c *LakeFormation) CancelTransaction(input *CancelTransactionInput) (*CancelTransactionOutput, error) {
	req, out := c.CancelTransactionRequest(input)
	return out, req.Send()
}

// CancelTransactionWithContext is the same as CancelTransaction with the addition of
// the ability to pass a context and additional request options.
//
// See CancelTransaction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) CancelTransactionWithContext(ctx aws.Context, input *CancelTransactionInput, opts ...request.Option) (*CancelTransactionOutput, error) {
	req, out := c.CancelTransactionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCommitTransaction = "CommitTransaction"

// CommitTransactionRequest generates a "aws/request.Request" representing the
// client's request for the CommitTransaction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CommitTransaction for more information on using the CommitTransaction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CommitTransactionRequest method.
//	req, resp := client.CommitTransactionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/CommitTransaction
func (c *LakeFormation) CommitTransactionRequest(input *CommitTransactionInput) (req *request.Request, output *CommitTransactionOutput) {
	op := &request.Operation{
		Name:       opCommitTransaction,
		HTTPMethod: "POST",
		HTTPPath:   "/CommitTransaction",
	}

	if input == nil {
		input = &CommitTransactionInput{}
	}

	output = &CommitTransactionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CommitTransaction API operation for AWS Lake Formation.
//
// Attempts to commit the specified transaction. Returns an exception if the
// transaction was previously aborted. This API action is idempotent if called
// multiple times for the same transaction.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation CommitTransaction for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     The input provided was not valid.
//
//   - EntityNotFoundException
//     A specified entity does not exist.
//
//   - InternalServiceException
//     An internal service error occurred.
//
//   - OperationTimeoutException
//     The operation timed out.
//
//   - TransactionCanceledException
//     Contains details about an error related to a transaction that was cancelled.
//
//   - ConcurrentModificationException
//     Two processes are trying to modify a resource simultaneously.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/CommitTransaction
func (c *LakeFormation) CommitTransaction(input *CommitTransactionInput) (*CommitTransactionOutput, error) {
	req, out := c.CommitTransactionRequest(input)
	return out, req.Send()
}

// CommitTransactionWithContext is the same as CommitTransaction with the addition of
// the ability to pass a context and additional request options.
//
// See CommitTransaction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) CommitTransactionWithContext(ctx aws.Context, input *CommitTransactionInput, opts ...request.Option) (*CommitTransactionOutput, error) {
	req, out := c.CommitTransactionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDataCellsFilter = "CreateDataCellsFilter"

// CreateDataCellsFilterRequest generates a "aws/request.Request" representing the
// client's request for the CreateDataCellsFilter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDataCellsFilter for more information on using the CreateDataCellsFilter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateDataCellsFilterRequest method.
//	req, resp := client.CreateDataCellsFilterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/CreateDataCellsFilter
func (c *LakeFormation) CreateDataCellsFilterRequest(input *CreateDataCellsFilterInput) (req *request.Request, output *CreateDataCellsFilterOutput) {
	op := &request.Operation{
		Name:       opCreateDataCellsFilter,
		HTTPMethod: "POST",
		HTTPPath:   "/CreateDataCellsFilter",
	}

	if input == nil {
		input = &CreateDataCellsFilterInput{}
	}

	output = &CreateDataCellsFilterOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateDataCellsFilter API operation for AWS Lake Formation.
//
// Creates a data cell filter to allow one to grant access to certain columns
// on certain rows.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation CreateDataCellsFilter for usage and error information.
//
// Returned Error Types:
//
//   - AlreadyExistsException
//     A resource to be created or added already exists.
//
//   - InvalidInputException
//     The input provided was not valid.
//
//   - EntityNotFoundException
//     A specified entity does not exist.
//
//   - ResourceNumberLimitExceededException
//     A resource numerical limit was exceeded.
//
//   - InternalServiceException
//     An internal service error occurred.
//
//   - OperationTimeoutException
//     The operation timed out.
//
//   - AccessDeniedException
//     Access to a resource was denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/CreateDataCellsFilter
func (c *LakeFormation) CreateDataCellsFilter(input *CreateDataCellsFilterInput) (*CreateDataCellsFilterOutput, error) {
	req, out := c.CreateDataCellsFilterRequest(input)
	return out, req.Send()
}

// CreateDataCellsFilterWithContext is the same as CreateDataCellsFilter with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDataCellsFilter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) CreateDataCellsFilterWithContext(ctx aws.Context, input *CreateDataCellsFilterInput, opts ...request.Option) (*CreateDataCellsFilterOutput, error) {
	req, out := c.CreateDataCellsFilterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLFTag = "CreateLFTag"

// CreateLFTagRequest generates a "aws/request.Request" representing the
// client's request for the CreateLFTag operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLFTag for more information on using the CreateLFTag
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateLFTagRequest method.
//	req, resp := client.CreateLFTagRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/CreateLFTag
func (c *LakeFormation) CreateLFTagRequest(input *CreateLFTagInput) (req *request.Request, output *CreateLFTagOutput) {
	op := &request.Operation{
		Name:       opCreateLFTag,
		HTTPMethod: "POST",
		HTTPPath:   "/CreateLFTag",
	}

	if input == nil {
		input = &CreateLFTagInput{}
	}

	output = &CreateLFTagOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateLFTag API operation for AWS Lake Formation.
//
// Creates an LF-tag with the specified name and values.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation CreateLFTag for usage and error information.
//
// Returned Error Types:
//
//   - EntityNotFoundException
//     A specified entity does not exist.
//
//   - InvalidInputException
//     The input provided was not valid.
//
//   - ResourceNumberLimitExceededException
//     A resource numerical limit was exceeded.
//
//   - InternalServiceException
//     An internal service error occurred.
//
//   - OperationTimeoutException
//     The operation timed out.
//
//   - AccessDeniedException
//     Access to a resource was denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/CreateLFTag
func (c *LakeFormation) CreateLFTag(input *CreateLFTagInput) (*CreateLFTagOutput, error) {
	req, out := c.CreateLFTagRequest(input)
	return out, req.Send()
}

// CreateLFTagWithContext is the same as CreateLFTag with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLFTag for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) CreateLFTagWithContext(ctx aws.Context, input *CreateLFTagInput, opts ...request.Option) (*CreateLFTagOutput, error) {
	req, out := c.CreateLFTagRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLakeFormationIdentityCenterConfiguration = "CreateLakeFormationIdentityCenterConfiguration"

// CreateLakeFormationIdentityCenterConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the CreateLakeFormationIdentityCenterConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLakeFormationIdentityCenterConfiguration for more information on using the CreateLakeFormationIdentityCenterConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateLakeFormationIdentityCenterConfigurationRequest method.
//	req, resp := client.CreateLakeFormationIdentityCenterConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/CreateLakeFormationIdentityCenterConfiguration
func (c *LakeFormation) CreateLakeFormationIdentityCenterConfigurationRequest(input *CreateLakeFormationIdentityCenterConfigurationInput) (req *request.Request, output *CreateLakeFormationIdentityCenterConfigurationOutput) {
	op := &request.Operation{
		Name:       opCreateLakeFormationIdentityCenterConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/CreateLakeFormationIdentityCenterConfiguration",
	}

	if input == nil {
		input = &CreateLakeFormationIdentityCenterConfigurationInput{}
	}

	output = &CreateLakeFormationIdentityCenterConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLakeFormationIdentityCenterConfiguration API operation for AWS Lake Formation.
//
// Creates an IAM Identity Center connection with Lake Formation to allow IAM
// Identity Center users and groups to access Data Catalog resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation CreateLakeFormationIdentityCenterConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     The input provided was not valid.
//
//   - AlreadyExistsException
//     A resource to be created or added already exists.
//
//   - InternalServiceException
//     An internal service error occurred.
//
//   - OperationTimeoutException
//     The operation timed out.
//
//   - AccessDeniedException
//     Access to a resource was denied.
//
//   - ConcurrentModificationException
//     Two processes are trying to modify a resource simultaneously.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/CreateLakeFormationIdentityCenterConfiguration
func (c *LakeFormation) CreateLakeFormationIdentityCenterConfiguration(input *CreateLakeFormationIdentityCenterConfigurationInput) (*CreateLakeFormationIdentityCenterConfigurationOutput, error) {
	req, out := c.CreateLakeFormationIdentityCenterConfigurationRequest(input)
	return out, req.Send()
}

// CreateLakeFormationIdentityCenterConfigurationWithContext is the same as CreateLakeFormationIdentityCenterConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLakeFormationIdentityCenterConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) CreateLakeFormationIdentityCenterConfigurationWithContext(ctx aws.Context, input *CreateLakeFormationIdentityCenterConfigurationInput, opts ...request.Option) (*CreateLakeFormationIdentityCenterConfigurationOutput, error) {
	req, out := c.CreateLakeFormationIdentityCenterConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLakeFormationOptIn = "CreateLakeFormationOptIn"

// CreateLakeFormationOptInRequest generates a "aws/request.Request" representing the
// client's request for the CreateLakeFormationOptIn operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLakeFormationOptIn for more information on using the CreateLakeFormationOptIn
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateLakeFormationOptInRequest method.
//	req, resp := client.CreateLakeFormationOptInRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/CreateLakeFormationOptIn
func (c *LakeFormation) CreateLakeFormationOptInRequest(input *CreateLakeFormationOptInInput) (req *request.Request, output *CreateLakeFormationOptInOutput) {
	op := &request.Operation{
		Name:       opCreateLakeFormationOptIn,
		HTTPMethod: "POST",
		HTTPPath:   "/CreateLakeFormationOptIn",
	}

	if input == nil {
		input = &CreateLakeFormationOptInInput{}
	}

	output = &CreateLakeFormationOptInOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateLakeFormationOptIn API operation for AWS Lake Formation.
//
// Enforce Lake Formation permissions for the given databases, tables, and principals.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation CreateLakeFormationOptIn for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     The input provided was not valid.
//
//   - InternalServiceException
//     An internal service error occurred.
//
//   - OperationTimeoutException
//     The operation timed out.
//
//   - EntityNotFoundException
//     A specified entity does not exist.
//
//   - AccessDeniedException
//     Access to a resource was denied.
//
//   - ConcurrentModificationException
//     Two processes are trying to modify a resource simultaneously.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/CreateLakeFormationOptIn
func (c *LakeFormation) CreateLakeFormationOptIn(input *CreateLakeFormationOptInInput) (*CreateLakeFormationOptInOutput, error) {
	req, out := c.CreateLakeFormationOptInRequest(input)
	return out, req.Send()
}

// CreateLakeFormationOptInWithContext is the same as CreateLakeFormationOptIn with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLakeFormationOptIn for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) CreateLakeFormationOptInWithContext(ctx aws.Context, input *CreateLakeFormationOptInInput, opts ...request.Option) (*CreateLakeFormationOptInOutput, error) {
	req, out := c.CreateLakeFormationOptInRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDataCellsFilter = "DeleteDataCellsFilter"

// DeleteDataCellsFilterRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDataCellsFilter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDataCellsFilter for more information on using the DeleteDataCellsFilter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteDataCellsFilterRequest method.
//	req, resp := client.DeleteDataCellsFilterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/DeleteDataCellsFilter
func (c *LakeFormation) DeleteDataCellsFilterRequest(input *DeleteDataCellsFilterInput) (req *request.Request, output *DeleteDataCellsFilterOutput) {
	op := &request.Operation{
		Name:       opDeleteDataCellsFilter,
		HTTPMethod: "POST",
		HTTPPath:   "/DeleteDataCellsFilter",
	}

	if input == nil {
		input = &DeleteDataCellsFilterInput{}
	}

	output = &DeleteDataCellsFilterOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDataCellsFilter API operation for AWS Lake Formation.
//
// Deletes a data cell filter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation DeleteDataCellsFilter for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     The input provided was not valid.
//
//   - EntityNotFoundException
//     A specified entity does not exist.
//
//   - InternalServiceException
//     An internal service error occurred.
//
//   - OperationTimeoutException
//     The operation timed out.
//
//   - AccessDeniedException
//     Access to a resource was denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/DeleteDataCellsFilter
func (c *LakeFormation) DeleteDataCellsFilter(input *DeleteDataCellsFilterInput) (*DeleteDataCellsFilterOutput, error) {
	req, out := c.DeleteDataCellsFilterRequest(input)
	return out, req.Send()
}

// DeleteDataCellsFilterWithContext is the same as DeleteDataCellsFilter with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDataCellsFilter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) DeleteDataCellsFilterWithContext(ctx aws.Context, input *DeleteDataCellsFilterInput, opts ...request.Option) (*DeleteDataCellsFilterOutput, error) {
	req, out := c.DeleteDataCellsFilterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLFTag = "DeleteLFTag"

// DeleteLFTagRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLFTag operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLFTag for more information on using the DeleteLFTag
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteLFTagRequest method.
//	req, resp := client.DeleteLFTagRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/DeleteLFTag
func (c *LakeFormation) DeleteLFTagRequest(input *DeleteLFTagInput) (req *request.Request, output *DeleteLFTagOutput) {
	op := &request.Operation{
		Name:       opDeleteLFTag,
		HTTPMethod: "POST",
		HTTPPath:   "/DeleteLFTag",
	}

	if input == nil {
		input = &DeleteLFTagInput{}
	}

	output = &DeleteLFTagOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteLFTag API operation for AWS Lake Formation.
//
// Deletes the specified LF-tag given a key name. If the input parameter tag
// key was not found, then the operation will throw an exception. When you delete
// an LF-tag, the LFTagPolicy attached to the LF-tag becomes invalid. If the
// deleted LF-tag was still assigned to any resource, the tag policy attach
// to the deleted LF-tag will no longer be applied to the resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation DeleteLFTag for usage and error information.
//
// Returned Error Types:
//
//   - EntityNotFoundException
//     A specified entity does not exist.
//
//   - InvalidInputException
//     The input provided was not valid.
//
//   - InternalServiceException
//     An internal service error occurred.
//
//   - OperationTimeoutException
//     The operation timed out.
//
//   - AccessDeniedException
//     Access to a resource was denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/DeleteLFTag
func (c *LakeFormation) DeleteLFTag(input *DeleteLFTagInput) (*DeleteLFTagOutput, error) {
	req, out := c.DeleteLFTagRequest(input)
	return out, req.Send()
}

// DeleteLFTagWithContext is the same as DeleteLFTag with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLFTag for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) DeleteLFTagWithContext(ctx aws.Context, input *DeleteLFTagInput, opts ...request.Option) (*DeleteLFTagOutput, error) {
	req, out := c.DeleteLFTagRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLakeFormationIdentityCenterConfiguration = "DeleteLakeFormationIdentityCenterConfiguration"

// DeleteLakeFormationIdentityCenterConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLakeFormationIdentityCenterConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLakeFormationIdentityCenterConfiguration for more information on using the DeleteLakeFormationIdentityCenterConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteLakeFormationIdentityCenterConfigurationRequest method.
//	req, resp := client.DeleteLakeFormationIdentityCenterConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/DeleteLakeFormationIdentityCenterConfiguration
func (c *LakeFormation) DeleteLakeFormationIdentityCenterConfigurationRequest(input *DeleteLakeFormationIdentityCenterConfigurationInput) (req *request.Request, output *DeleteLakeFormationIdentityCenterConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteLakeFormationIdentityCenterConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/DeleteLakeFormationIdentityCenterConfiguration",
	}

	if input == nil {
		input = &DeleteLakeFormationIdentityCenterConfigurationInput{}
	}

	output = &DeleteLakeFormationIdentityCenterConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteLakeFormationIdentityCenterConfiguration API operation for AWS Lake Formation.
//
// Deletes an IAM Identity Center connection with Lake Formation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation DeleteLakeFormationIdentityCenterConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     The input provided was not valid.
//
//   - EntityNotFoundException
//     A specified entity does not exist.
//
//   - InternalServiceException
//     An internal service error occurred.
//
//   - OperationTimeoutException
//     The operation timed out.
//
//   - AccessDeniedException
//     Access to a resource was denied.
//
//   - ConcurrentModificationException
//     Two processes are trying to modify a resource simultaneously.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/DeleteLakeFormationIdentityCenterConfiguration
func (c *LakeFormation) DeleteLakeFormationIdentityCenterConfiguration(input *DeleteLakeFormationIdentityCenterConfigurationInput) (*DeleteLakeFormationIdentityCenterConfigurationOutput, error) {
	req, out := c.DeleteLakeFormationIdentityCenterConfigurationRequest(input)
	return out, req.Send()
}

// DeleteLakeFormationIdentityCenterConfigurationWithContext is the same as DeleteLakeFormationIdentityCenterConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLakeFormationIdentityCenterConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) DeleteLakeFormationIdentityCenterConfigurationWithContext(ctx aws.Context, input *DeleteLakeFormationIdentityCenterConfigurationInput, opts ...request.Option) (*DeleteLakeFormationIdentityCenterConfigurationOutput, error) {
	req, out := c.DeleteLakeFormationIdentityCenterConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLakeFormationOptIn = "DeleteLakeFormationOptIn"

// DeleteLakeFormationOptInRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLakeFormationOptIn operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLakeFormationOptIn for more information on using the DeleteLakeFormationOptIn
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteLakeFormationOptInRequest method.
//	req, resp := client.DeleteLakeFormationOptInRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/DeleteLakeFormationOptIn
func (c *LakeFormation) DeleteLakeFormationOptInRequest(input *DeleteLakeFormationOptInInput) (req *request.Request, output *DeleteLakeFormationOptInOutput) {
	op := &request.Operation{
		Name:       opDeleteLakeFormationOptIn,
		HTTPMethod: "POST",
		HTTPPath:   "/DeleteLakeFormationOptIn",
	}

	if input == nil {
		input = &DeleteLakeFormationOptInInput{}
	}

	output = &DeleteLakeFormationOptInOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteLakeFormationOptIn API operation for AWS Lake Formation.
//
// Remove the Lake Formation permissions enforcement of the given databases,
// tables, and principals.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation DeleteLakeFormationOptIn for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     The input provided was not valid.
//
//   - InternalServiceException
//     An internal service error occurred.
//
//   - OperationTimeoutException
//     The operation timed out.
//
//   - EntityNotFoundException
//     A specified entity does not exist.
//
//   - AccessDeniedException
//     Access to a resource was denied.
//
//   - ConcurrentModificationException
//     Two processes are trying to modify a resource simultaneously.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/DeleteLakeFormationOptIn
func (c *LakeFormation) DeleteLakeFormationOptIn(input *DeleteLakeFormationOptInInput) (*DeleteLakeFormationOptInOutput, error) {
	req, out := c.DeleteLakeFormationOptInRequest(input)
	return out, req.Send()
}

// DeleteLakeFormationOptInWithContext is the same as DeleteLakeFormationOptIn with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLakeFormationOptIn for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) DeleteLakeFormationOptInWithContext(ctx aws.Context, input *DeleteLakeFormationOptInInput, opts ...request.Option) (*DeleteLakeFormationOptInOutput, error) {
	req, out := c.DeleteLakeFormationOptInRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteObjectsOnCancel = "DeleteObjectsOnCancel"

// DeleteObjectsOnCancelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteObjectsOnCancel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteObjectsOnCancel for more information on using the DeleteObjectsOnCancel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteObjectsOnCancelRequest method.
//	req, resp := client.DeleteObjectsOnCancelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/DeleteObjectsOnCancel
func (c *LakeFormation) DeleteObjectsOnCancelRequest(input *DeleteObjectsOnCancelInput) (req *request.Request, output *DeleteObjectsOnCancelOutput) {
	op := &request.Operation{
		Name:       opDeleteObjectsOnCancel,
		HTTPMethod: "POST",
		HTTPPath:   "/DeleteObjectsOnCancel",
	}

	if input == nil {
		input = &DeleteObjectsOnCancelInput{}
	}

	output = &DeleteObjectsOnCancelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteObjectsOnCancel API operation for AWS Lake Formation.
//
// For a specific governed table, provides a list of Amazon S3 objects that
// will be written during the current transaction and that can be automatically
// deleted if the transaction is canceled. Without this call, no Amazon S3 objects
// are automatically deleted when a transaction cancels.
//
// The Glue ETL library function write_dynamic_frame.from_catalog() includes
// an option to automatically call DeleteObjectsOnCancel before writes. For
// more information, see Rolling Back Amazon S3 Writes (https://docs.aws.amazon.com/lake-formation/latest/dg/transactions-data-operations.html#rolling-back-writes).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation DeleteObjectsOnCancel for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceException
//     An internal service error occurred.
//
//   - InvalidInputException
//     The input provided was not valid.
//
//   - OperationTimeoutException
//     The operation timed out.
//
//   - EntityNotFoundException
//     A specified entity does not exist.
//
//   - TransactionCommittedException
//     Contains details about an error where the specified transaction has already
//     been committed and cannot be used for UpdateTableObjects.
//
//   - TransactionCanceledException
//     Contains details about an error related to a transaction that was cancelled.
//
//   - ResourceNotReadyException
//     Contains details about an error related to a resource which is not ready
//     for a transaction.
//
//   - ConcurrentModificationException
//     Two processes are trying to modify a resource simultaneously.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/DeleteObjectsOnCancel
func (c *LakeFormation) DeleteObjectsOnCancel(input *DeleteObjectsOnCancelInput) (*DeleteObjectsOnCancelOutput, error) {
	req, out := c.DeleteObjectsOnCancelRequest(input)
	return out, req.Send()
}

// DeleteObjectsOnCancelWithContext is the same as DeleteObjectsOnCancel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteObjectsOnCancel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) DeleteObjectsOnCancelWithContext(ctx aws.Context, input *DeleteObjectsOnCancelInput, opts ...request.Option) (*DeleteObjectsOnCancelOutput, error) {
	req, out := c.DeleteObjectsOnCancelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterResource = "DeregisterResource"

// DeregisterResourceRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterResource for more information on using the DeregisterResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeregisterResourceRequest method.
//	req, resp := client.DeregisterResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/DeregisterResource
func (c *LakeFormation) DeregisterResourceRequest(input *DeregisterResourceInput) (req *request.Request, output *DeregisterResourceOutput) {
	op := &request.Operation{
		Name:       opDeregisterResource,
		HTTPMethod: "POST",
		HTTPPath:   "/DeregisterResource",
	}

	if input == nil {
		input = &DeregisterResourceInput{}
	}

	output = &DeregisterResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeregisterResource API operation for AWS Lake Formation.
//
// Deregisters the resource as managed by the Data Catalog.
//
// When you deregister a path, Lake Formation removes the path from the inline
// policy attached to your service-linked role.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation DeregisterResource for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     The input provided was not valid.
//
//   - InternalServiceException
//     An internal service error occurred.
//
//   - OperationTimeoutException
//     The operation timed out.
//
//   - EntityNotFoundException
//     A specified entity does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/DeregisterResource
func (c *LakeFormation) DeregisterResource(input *DeregisterResourceInput) (*DeregisterResourceOutput, error) {
	req, out := c.DeregisterResourceRequest(input)
	return out, req.Send()
}

// DeregisterResourceWithContext is the same as DeregisterResource with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) DeregisterResourceWithContext(ctx aws.Context, input *DeregisterResourceInput, opts ...request.Option) (*DeregisterResourceOutput, error) {
	req, out := c.DeregisterResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeLakeFormationIdentityCenterConfiguration = "DescribeLakeFormationIdentityCenterConfiguration"

// DescribeLakeFormationIdentityCenterConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLakeFormationIdentityCenterConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLakeFormationIdentityCenterConfiguration for more information on using the DescribeLakeFormationIdentityCenterConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeLakeFormationIdentityCenterConfigurationRequest method.
//	req, resp := client.DescribeLakeFormationIdentityCenterConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/DescribeLakeFormationIdentityCenterConfiguration
func (c *LakeFormation) DescribeLakeFormationIdentityCenterConfigurationRequest(input *DescribeLakeFormationIdentityCenterConfigurationInput) (req *request.Request, output *DescribeLakeFormationIdentityCenterConfigurationOutput) {
	op := &request.Operation{
		Name:       opDescribeLakeFormationIdentityCenterConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/DescribeLakeFormationIdentityCenterConfiguration",
	}

	if input == nil {
		input = &DescribeLakeFormationIdentityCenterConfigurationInput{}
	}

	output = &DescribeLakeFormationIdentityCenterConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLakeFormationIdentityCenterConfiguration API operation for AWS Lake Formation.
//
// Retrieves the instance ARN and application ARN for the connection.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation DescribeLakeFormationIdentityCenterConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     The input provided was not valid.
//
//   - EntityNotFoundException
//     A specified entity does not exist.
//
//   - InternalServiceException
//     An internal service error occurred.
//
//   - OperationTimeoutException
//     The operation timed out.
//
//   - AccessDeniedException
//     Access to a resource was denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/DescribeLakeFormationIdentityCenterConfiguration
func (c *LakeFormation) DescribeLakeFormationIdentityCenterConfiguration(input *DescribeLakeFormationIdentityCenterConfigurationInput) (*DescribeLakeFormationIdentityCenterConfigurationOutput, error) {
	req, out := c.DescribeLakeFormationIdentityCenterConfigurationRequest(input)
	return out, req.Send()
}

// DescribeLakeFormationIdentityCenterConfigurationWithContext is the same as DescribeLakeFormationIdentityCenterConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLakeFormationIdentityCenterConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) DescribeLakeFormationIdentityCenterConfigurationWithContext(ctx aws.Context, input *DescribeLakeFormationIdentityCenterConfigurationInput, opts ...request.Option) (*DescribeLakeFormationIdentityCenterConfigurationOutput, error) {
	req, out := c.DescribeLakeFormationIdentityCenterConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeResource = "DescribeResource"

// DescribeResourceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeResource for more information on using the DescribeResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeResourceRequest method.
//	req, resp := client.DescribeResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/DescribeResource
func (c *LakeFormation) DescribeResourceRequest(input *DescribeResourceInput) (req *request.Request, output *DescribeResourceOutput) {
	op := &request.Operation{
		Name:       opDescribeResource,
		HTTPMethod: "POST",
		HTTPPath:   "/DescribeResource",
	}

	if input == nil {
		input = &DescribeResourceInput{}
	}

	output = &DescribeResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeResource API operation for AWS Lake Formation.
//
// Retrieves the current data access role for the given resource registered
// in Lake Formation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation DescribeResource for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     The input provided was not valid.
//
//   - InternalServiceException
//     An internal service error occurred.
//
//   - OperationTimeoutException
//     The operation timed out.
//
//   - EntityNotFoundException
//     A specified entity does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/DescribeResource
func (c *LakeFormation) DescribeResource(input *DescribeResourceInput) (*DescribeResourceOutput, error) {
	req, out := c.DescribeResourceRequest(input)
	return out, req.Send()
}

// DescribeResourceWithContext is the same as DescribeResource with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) DescribeResourceWithContext(ctx aws.Context, input *DescribeResourceInput, opts ...request.Option) (*DescribeResourceOutput, error) {
	req, out := c.DescribeResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTransaction = "DescribeTransaction"

// DescribeTransactionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTransaction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTransaction for more information on using the DescribeTransaction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeTransactionRequest method.
//	req, resp := client.DescribeTransactionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/DescribeTransaction
func (c *LakeFormation) DescribeTransactionRequest(input *DescribeTransactionInput) (req *request.Request, output *DescribeTransactionOutput) {
	op := &request.Operation{
		Name:       opDescribeTransaction,
		HTTPMethod: "POST",
		HTTPPath:   "/DescribeTransaction",
	}

	if input == nil {
		input = &DescribeTransactionInput{}
	}

	output = &DescribeTransactionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTransaction API operation for AWS Lake Formation.
//
// Returns the details of a single transaction.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation DescribeTransaction for usage and error information.
//
// Returned Error Types:
//
//   - EntityNotFoundException
//     A specified entity does not exist.
//
//   - InvalidInputException
//     The input provided was not valid.
//
//   - InternalServiceException
//     An internal service error occurred.
//
//   - OperationTimeoutException
//     The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/DescribeTransaction
func (c *LakeFormation) DescribeTransaction(input *DescribeTransactionInput) (*DescribeTransactionOutput, error) {
	req, out := c.DescribeTransactionRequest(input)
	return out, req.Send()
}

// DescribeTransactionWithContext is the same as DescribeTransaction with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTransaction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) DescribeTransactionWithContext(ctx aws.Context, input *DescribeTransactionInput, opts ...request.Option) (*DescribeTransactionOutput, error) {
	req, out := c.DescribeTransactionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opExtendTransaction = "ExtendTransaction"

// ExtendTransactionRequest generates a "aws/request.Request" representing the
// client's request for the ExtendTransaction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ExtendTransaction for more information on using the ExtendTransaction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ExtendTransactionRequest method.
//	req, resp := client.ExtendTransactionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ExtendTransaction
func (c *LakeFormation) ExtendTransactionRequest(input *ExtendTransactionInput) (req *request.Request, output *ExtendTransactionOutput) {
	op := &request.Operation{
		Name:       opExtendTransaction,
		HTTPMethod: "POST",
		HTTPPath:   "/ExtendTransaction",
	}

	if input == nil {
		input = &ExtendTransactionInput{}
	}

	output = &ExtendTransactionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ExtendTransaction API operation for AWS Lake Formation.
//
// Indicates to the service that the specified transaction is still active and
// should not be treated as idle and aborted.
//
// Write transactions that remain idle for a long period are automatically aborted
// unless explicitly extended.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation ExtendTransaction for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     The input provided was not valid.
//
//   - EntityNotFoundException
//     A specified entity does not exist.
//
//   - InternalServiceException
//     An internal service error occurred.
//
//   - OperationTimeoutException
//     The operation timed out.
//
//   - TransactionCommittedException
//     Contains details about an error where the specified transaction has already
//     been committed and cannot be used for UpdateTableObjects.
//
//   - TransactionCanceledException
//     Contains details about an error related to a transaction that was cancelled.
//
//   - TransactionCommitInProgressException
//     Contains details about an error related to a transaction commit that was
//     in progress.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ExtendTransaction
func (c *LakeFormation) ExtendTransaction(input *ExtendTransactionInput) (*ExtendTransactionOutput, error) {
	req, out := c.ExtendTransactionRequest(input)
	return out, req.Send()
}

// ExtendTransactionWithContext is the same as ExtendTransaction with the addition of
// the ability to pass a context and additional request options.
//
// See ExtendTransaction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) ExtendTransactionWithContext(ctx aws.Context, input *ExtendTransactionInput, opts ...request.Option) (*ExtendTransactionOutput, error) {
	req, out := c.ExtendTransactionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDataCellsFilter = "GetDataCellsFilter"

// GetDataCellsFilterRequest generates a "aws/request.Request" representing the
// client's request for the GetDataCellsFilter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDataCellsFilter for more information on using the GetDataCellsFilter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDataCellsFilterRequest method.
//	req, resp := client.GetDataCellsFilterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetDataCellsFilter
func (c *LakeFormation) GetDataCellsFilterRequest(input *GetDataCellsFilterInput) (req *request.Request, output *GetDataCellsFilterOutput) {
	op := &request.Operation{
		Name:       opGetDataCellsFilter,
		HTTPMethod: "POST",
		HTTPPath:   "/GetDataCellsFilter",
	}

	if input == nil {
		input = &GetDataCellsFilterInput{}
	}

	output = &GetDataCellsFilterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDataCellsFilter API operation for AWS Lake Formation.
//
// Returns a data cells filter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation GetDataCellsFilter for usage and error information.
//
// Returned Error Types:
//
//   - EntityNotFoundException
//     A specified entity does not exist.
//
//   - InvalidInputException
//     The input provided was not valid.
//
//   - OperationTimeoutException
//     The operation timed out.
//
//   - InternalServiceException
//     An internal service error occurred.
//
//   - AccessDeniedException
//     Access to a resource was denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetDataCellsFilter
func (c *LakeFormation) GetDataCellsFilter(input *GetDataCellsFilterInput) (*GetDataCellsFilterOutput, error) {
	req, out := c.GetDataCellsFilterRequest(input)
	return out, req.Send()
}

// GetDataCellsFilterWithContext is the same as GetDataCellsFilter with the addition of
// the ability to pass a context and additional request options.
//
// See GetDataCellsFilter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) GetDataCellsFilterWithContext(ctx aws.Context, input *GetDataCellsFilterInput, opts ...request.Option) (*GetDataCellsFilterOutput, error) {
	req, out := c.GetDataCellsFilterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDataLakeSettings = "GetDataLakeSettings"

// GetDataLakeSettingsRequest generates a "aws/request.Request" representing the
// client's request for the GetDataLakeSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDataLakeSettings for more information on using the GetDataLakeSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDataLakeSettingsRequest method.
//	req, resp := client.GetDataLakeSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetDataLakeSettings
func (c *LakeFormation) GetDataLakeSettingsRequest(input *GetDataLakeSettingsInput) (req *request.Request, output *GetDataLakeSettingsOutput) {
	op := &request.Operation{
		Name:       opGetDataLakeSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/GetDataLakeSettings",
	}

	if input == nil {
		input = &GetDataLakeSettingsInput{}
	}

	output = &GetDataLakeSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDataLakeSettings API operation for AWS Lake Formation.
//
// Retrieves the list of the data lake administrators of a Lake Formation-managed
// data lake.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation GetDataLakeSettings for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceException
//     An internal service error occurred.
//
//   - InvalidInputException
//     The input provided was not valid.
//
//   - EntityNotFoundException
//     A specified entity does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetDataLakeSettings
func (c *LakeFormation) GetDataLakeSettings(input *GetDataLakeSettingsInput) (*GetDataLakeSettingsOutput, error) {
	req, out := c.GetDataLakeSettingsRequest(input)
	return out, req.Send()
}

// GetDataLakeSettingsWithContext is the same as GetDataLakeSettings with the addition of
// the ability to pass a context and additional request options.
//
// See GetDataLakeSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) GetDataLakeSettingsWithContext(ctx aws.Context, input *GetDataLakeSettingsInput, opts ...request.Option) (*GetDataLakeSettingsOutput, error) {
	req, out := c.GetDataLakeSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEffectivePermissionsForPath = "GetEffectivePermissionsForPath"

// GetEffectivePermissionsForPathRequest generates a "aws/request.Request" representing the
// client's request for the GetEffectivePermissionsForPath operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEffectivePermissionsForPath for more information on using the GetEffectivePermissionsForPath
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetEffectivePermissionsForPathRequest method.
//	req, resp := client.GetEffectivePermissionsForPathRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetEffectivePermissionsForPath
func (c *LakeFormation) GetEffectivePermissionsForPathRequest(input *GetEffectivePermissionsForPathInput) (req *request.Request, output *GetEffectivePermissionsForPathOutput) {
	op := &request.Operation{
		Name:       opGetEffectivePermissionsForPath,
		HTTPMethod: "POST",
		HTTPPath:   "/GetEffectivePermissionsForPath",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetEffectivePermissionsForPathInput{}
	}

	output = &GetEffectivePermissionsForPathOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEffectivePermissionsForPath API operation for AWS Lake Formation.
//
// Returns the Lake Formation permissions for a specified table or database
// resource located at a path in Amazon S3. GetEffectivePermissionsForPath will
// not return databases and tables if the catalog is encrypted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation GetEffectivePermissionsForPath for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     The input provided was not valid.
//
//   - EntityNotFoundException
//     A specified entity does not exist.
//
//   - OperationTimeoutException
//     The operation timed out.
//
//   - InternalServiceException
//     An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetEffectivePermissionsForPath
func (c *LakeFormation) GetEffectivePermissionsForPath(input *GetEffectivePermissionsForPathInput) (*GetEffectivePermissionsForPathOutput, error) {
	req, out := c.GetEffectivePermissionsForPathRequest(input)
	return out, req.Send()
}

// GetEffectivePermissionsForPathWithContext is the same as GetEffectivePermissionsForPath with the addition of
// the ability to pass a context and additional request options.
//
// See GetEffectivePermissionsForPath for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) GetEffectivePermissionsForPathWithContext(ctx aws.Context, input *GetEffectivePermissionsForPathInput, opts ...request.Option) (*GetEffectivePermissionsForPathOutput, error) {
	req, out := c.GetEffectivePermissionsForPathRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetEffectivePermissionsForPathPages iterates over the pages of a GetEffectivePermissionsForPath operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetEffectivePermissionsForPath method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetEffectivePermissionsForPath operation.
//	pageNum := 0
//	err := client.GetEffectivePermissionsForPathPages(params,
//	    func(page *lakeformation.GetEffectivePermissionsForPathOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LakeFormation) GetEffectivePermissionsForPathPages(input *GetEffectivePermissionsForPathInput, fn func(*GetEffectivePermissionsForPathOutput, bool) bool) error {
	return c.GetEffectivePermissionsForPathPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetEffectivePermissionsForPathPagesWithContext same as GetEffectivePermissionsForPathPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) GetEffectivePermissionsForPathPagesWithContext(ctx aws.Context, input *GetEffectivePermissionsForPathInput, fn func(*GetEffectivePermissionsForPathOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetEffectivePermissionsForPathInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetEffectivePermissionsForPathRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetEffectivePermissionsForPathOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetLFTag = "GetLFTag"

// GetLFTagRequest generates a "aws/request.Request" representing the
// client's request for the GetLFTag operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLFTag for more information on using the GetLFTag
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetLFTagRequest method.
//	req, resp := client.GetLFTagRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetLFTag
func (c *LakeFormation) GetLFTagRequest(input *GetLFTagInput) (req *request.Request, output *GetLFTagOutput) {
	op := &request.Operation{
		Name:       opGetLFTag,
		HTTPMethod: "POST",
		HTTPPath:   "/GetLFTag",
	}

	if input == nil {
		input = &GetLFTagInput{}
	}

	output = &GetLFTagOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLFTag API operation for AWS Lake Formation.
//
// Returns an LF-tag definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation GetLFTag for usage and error information.
//
// Returned Error Types:
//
//   - EntityNotFoundException
//     A specified entity does not exist.
//
//   - InvalidInputException
//     The input provided was not valid.
//
//   - InternalServiceException
//     An internal service error occurred.
//
//   - OperationTimeoutException
//     The operation timed out.
//
//   - AccessDeniedException
//     Access to a resource was denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetLFTag
func (c *LakeFormation) GetLFTag(input *GetLFTagInput) (*GetLFTagOutput, error) {
	req, out := c.GetLFTagRequest(input)
	return out, req.Send()
}

// GetLFTagWithContext is the same as GetLFTag with the addition of
// the ability to pass a context and additional request options.
//
// See GetLFTag for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) GetLFTagWithContext(ctx aws.Context, input *GetLFTagInput, opts ...request.Option) (*GetLFTagOutput, error) {
	req, out := c.GetLFTagRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetQueryState = "GetQueryState"

// GetQueryStateRequest generates a "aws/request.Request" representing the
// client's request for the GetQueryState operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetQueryState for more information on using the GetQueryState
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetQueryStateRequest method.
//	req, resp := client.GetQueryStateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetQueryState
func (c *LakeFormation) GetQueryStateRequest(input *GetQueryStateInput) (req *request.Request, output *GetQueryStateOutput) {
	op := &request.Operation{
		Name:       opGetQueryState,
		HTTPMethod: "POST",
		HTTPPath:   "/GetQueryState",
	}

	if input == nil {
		input = &GetQueryStateInput{}
	}

	output = &GetQueryStateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("query-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetQueryState API operation for AWS Lake Formation.
//
// Returns the state of a query previously submitted. Clients are expected to
// poll GetQueryState to monitor the current state of the planning before retrieving
// the work units. A query state is only visible to the principal that made
// the initial call to StartQueryPlanning.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation GetQueryState for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceException
//     An internal service error occurred.
//
//   - InvalidInputException
//     The input provided was not valid.
//
//   - AccessDeniedException
//     Access to a resource was denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetQueryState
func (c *LakeFormation) GetQueryState(input *GetQueryStateInput) (*GetQueryStateOutput, error) {
	req, out := c.GetQueryStateRequest(input)
	return out, req.Send()
}

// GetQueryStateWithContext is the same as GetQueryState with the addition of
// the ability to pass a context and additional request options.
//
// See GetQueryState for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) GetQueryStateWithContext(ctx aws.Context, input *GetQueryStateInput, opts ...request.Option) (*GetQueryStateOutput, error) {
	req, out := c.GetQueryStateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetQueryStatistics = "GetQueryStatistics"

// GetQueryStatisticsRequest generates a "aws/request.Request" representing the
// client's request for the GetQueryStatistics operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetQueryStatistics for more information on using the GetQueryStatistics
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetQueryStatisticsRequest method.
//	req, resp := client.GetQueryStatisticsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetQueryStatistics
func (c *LakeFormation) GetQueryStatisticsRequest(input *GetQueryStatisticsInput) (req *request.Request, output *GetQueryStatisticsOutput) {
	op := &request.Operation{
		Name:       opGetQueryStatistics,
		HTTPMethod: "POST",
		HTTPPath:   "/GetQueryStatistics",
	}

	if input == nil {
		input = &GetQueryStatisticsInput{}
	}

	output = &GetQueryStatisticsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("query-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetQueryStatistics API operation for AWS Lake Formation.
//
// Retrieves statistics on the planning and execution of a query.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation GetQueryStatistics for usage and error information.
//
// Returned Error Types:
//
//   - StatisticsNotReadyYetException
//     Contains details about an error related to statistics not being ready.
//
//   - InternalServiceException
//     An internal service error occurred.
//
//   - InvalidInputException
//     The input provided was not valid.
//
//   - AccessDeniedException
//     Access to a resource was denied.
//
//   - ExpiredException
//     Contains details about an error where the query request expired.
//
//   - ThrottledException
//     Contains details about an error where the query request was throttled.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetQueryStatistics
func (c *LakeFormation) GetQueryStatistics(input *GetQueryStatisticsInput) (*GetQueryStatisticsOutput, error) {
	req, out := c.GetQueryStatisticsRequest(input)
	return out, req.Send()
}

// GetQueryStatisticsWithContext is the same as GetQueryStatistics with the addition of
// the ability to pass a context and additional request options.
//
// See GetQueryStatistics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) GetQueryStatisticsWithContext(ctx aws.Context, input *GetQueryStatisticsInput, opts ...request.Option) (*GetQueryStatisticsOutput, error) {
	req, out := c.GetQueryStatisticsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResourceLFTags = "GetResourceLFTags"

// GetResourceLFTagsRequest generates a "aws/request.Request" representing the
// client's request for the GetResourceLFTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResourceLFTags for more information on using the GetResourceLFTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetResourceLFTagsRequest method.
//	req, resp := client.GetResourceLFTagsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetResourceLFTags
func (c *LakeFormation) GetResourceLFTagsRequest(input *GetResourceLFTagsInput) (req *request.Request, output *GetResourceLFTagsOutput) {
	op := &request.Operation{
		Name:       opGetResourceLFTags,
		HTTPMethod: "POST",
		HTTPPath:   "/GetResourceLFTags",
	}

	if input == nil {
		input = &GetResourceLFTagsInput{}
	}

	output = &GetResourceLFTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResourceLFTags API operation for AWS Lake Formation.
//
// Returns the LF-tags applied to a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation GetResourceLFTags for usage and error information.
//
// Returned Error Types:
//
//   - EntityNotFoundException
//     A specified entity does not exist.
//
//   - InvalidInputException
//     The input provided was not valid.
//
//   - InternalServiceException
//     An internal service error occurred.
//
//   - OperationTimeoutException
//     The operation timed out.
//
//   - GlueEncryptionException
//     An encryption operation failed.
//
//   - AccessDeniedException
//     Access to a resource was denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetResourceLFTags
func (c *LakeFormation) GetResourceLFTags(input *GetResourceLFTagsInput) (*GetResourceLFTagsOutput, error) {
	req, out := c.GetResourceLFTagsRequest(input)
	return out, req.Send()
}

// GetResourceLFTagsWithContext is the same as GetResourceLFTags with the addition of
// the ability to pass a context and additional request options.
//
// See GetResourceLFTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) GetResourceLFTagsWithContext(ctx aws.Context, input *GetResourceLFTagsInput, opts ...request.Option) (*GetResourceLFTagsOutput, error) {
	req, out := c.GetResourceLFTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTableObjects = "GetTableObjects"

// GetTableObjectsRequest generates a "aws/request.Request" representing the
// client's request for the GetTableObjects operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTableObjects for more information on using the GetTableObjects
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetTableObjectsRequest method.
//	req, resp := client.GetTableObjectsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetTableObjects
func (c *LakeFormation) GetTableObjectsRequest(input *GetTableObjectsInput) (req *request.Request, output *GetTableObjectsOutput) {
	op := &request.Operation{
		Name:       opGetTableObjects,
		HTTPMethod: "POST",
		HTTPPath:   "/GetTableObjects",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetTableObjectsInput{}
	}

	output = &GetTableObjectsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTableObjects API operation for AWS Lake Formation.
//
// Returns the set of Amazon S3 objects that make up the specified governed
// table. A transaction ID or timestamp can be specified for time-travel queries.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation GetTableObjects for usage and error information.
//
// Returned Error Types:
//
//   - EntityNotFoundException
//     A specified entity does not exist.
//
//   - InternalServiceException
//     An internal service error occurred.
//
//   - InvalidInputException
//     The input provided was not valid.
//
//   - OperationTimeoutException
//     The operation timed out.
//
//   - TransactionCommittedException
//     Contains details about an error where the specified transaction has already
//     been committed and cannot be used for UpdateTableObjects.
//
//   - TransactionCanceledException
//     Contains details about an error related to a transaction that was cancelled.
//
//   - ResourceNotReadyException
//     Contains details about an error related to a resource which is not ready
//     for a transaction.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetTableObjects
func (c *LakeFormation) GetTableObjects(input *GetTableObjectsInput) (*GetTableObjectsOutput, error) {
	req, out := c.GetTableObjectsRequest(input)
	return out, req.Send()
}

// GetTableObjectsWithContext is the same as GetTableObjects with the addition of
// the ability to pass a context and additional request options.
//
// See GetTableObjects for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) GetTableObjectsWithContext(ctx aws.Context, input *GetTableObjectsInput, opts ...request.Option) (*GetTableObjectsOutput, error) {
	req, out := c.GetTableObjectsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetTableObjectsPages iterates over the pages of a GetTableObjects operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetTableObjects method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetTableObjects operation.
//	pageNum := 0
//	err := client.GetTableObjectsPages(params,
//	    func(page *lakeformation.GetTableObjectsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LakeFormation) GetTableObjectsPages(input *GetTableObjectsInput, fn func(*GetTableObjectsOutput, bool) bool) error {
	return c.GetTableObjectsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetTableObjectsPagesWithContext same as GetTableObjectsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) GetTableObjectsPagesWithContext(ctx aws.Context, input *GetTableObjectsInput, fn func(*GetTableObjectsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetTableObjectsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetTableObjectsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetTableObjectsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetTemporaryGluePartitionCredentials = "GetTemporaryGluePartitionCredentials"

// GetTemporaryGluePartitionCredentialsRequest generates a "aws/request.Request" representing the
// client's request for the GetTemporaryGluePartitionCredentials operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTemporaryGluePartitionCredentials for more information on using the GetTemporaryGluePartitionCredentials
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetTemporaryGluePartitionCredentialsRequest method.
//	req, resp := client.GetTemporaryGluePartitionCredentialsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetTemporaryGluePartitionCredentials
func (c *LakeFormation) GetTemporaryGluePartitionCredentialsRequest(input *GetTemporaryGluePartitionCredentialsInput) (req *request.Request, output *GetTemporaryGluePartitionCredentialsOutput) {
	op := &request.Operation{
		Name:       opGetTemporaryGluePartitionCredentials,
		HTTPMethod: "POST",
		HTTPPath:   "/GetTemporaryGluePartitionCredentials",
	}

	if input == nil {
		input = &GetTemporaryGluePartitionCredentialsInput{}
	}

	output = &GetTemporaryGluePartitionCredentialsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTemporaryGluePartitionCredentials API operation for AWS Lake Formation.
//
// This API is identical to GetTemporaryTableCredentials except that this is
// used when the target Data Catalog resource is of type Partition. Lake Formation
// restricts the permission of the vended credentials with the same scope down
// policy which restricts access to a single Amazon S3 prefix.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation GetTemporaryGluePartitionCredentials for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     The input provided was not valid.
//
//   - InternalServiceException
//     An internal service error occurred.
//
//   - OperationTimeoutException
//     The operation timed out.
//
//   - EntityNotFoundException
//     A specified entity does not exist.
//
//   - AccessDeniedException
//     Access to a resource was denied.
//
//   - PermissionTypeMismatchException
//     The engine does not support filtering data based on the enforced permissions.
//     For example, if you call the GetTemporaryGlueTableCredentials operation with
//     SupportedPermissionType equal to ColumnPermission, but cell-level permissions
//     exist on the table, this exception is thrown.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetTemporaryGluePartitionCredentials
func (c *LakeFormation) GetTemporaryGluePartitionCredentials(input *GetTemporaryGluePartitionCredentialsInput) (*GetTemporaryGluePartitionCredentialsOutput, error) {
	req, out := c.GetTemporaryGluePartitionCredentialsRequest(input)
	return out, req.Send()
}

// GetTemporaryGluePartitionCredentialsWithContext is the same as GetTemporaryGluePartitionCredentials with the addition of
// the ability to pass a context and additional request options.
//
// See GetTemporaryGluePartitionCredentials for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) GetTemporaryGluePartitionCredentialsWithContext(ctx aws.Context, input *GetTemporaryGluePartitionCredentialsInput, opts ...request.Option) (*GetTemporaryGluePartitionCredentialsOutput, error) {
	req, out := c.GetTemporaryGluePartitionCredentialsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTemporaryGlueTableCredentials = "GetTemporaryGlueTableCredentials"

// GetTemporaryGlueTableCredentialsRequest generates a "aws/request.Request" representing the
// client's request for the GetTemporaryGlueTableCredentials operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTemporaryGlueTableCredentials for more information on using the GetTemporaryGlueTableCredentials
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetTemporaryGlueTableCredentialsRequest method.
//	req, resp := client.GetTemporaryGlueTableCredentialsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetTemporaryGlueTableCredentials
func (c *LakeFormation) GetTemporaryGlueTableCredentialsRequest(input *GetTemporaryGlueTableCredentialsInput) (req *request.Request, output *GetTemporaryGlueTableCredentialsOutput) {
	op := &request.Operation{
		Name:       opGetTemporaryGlueTableCredentials,
		HTTPMethod: "POST",
		HTTPPath:   "/GetTemporaryGlueTableCredentials",
	}

	if input == nil {
		input = &GetTemporaryGlueTableCredentialsInput{}
	}

	output = &GetTemporaryGlueTableCredentialsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTemporaryGlueTableCredentials API operation for AWS Lake Formation.
//
// Allows a caller in a secure environment to assume a role with permission
// to access Amazon S3. In order to vend such credentials, Lake Formation assumes
// the role associated with a registered location, for example an Amazon S3
// bucket, with a scope down policy which restricts the access to a single prefix.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation GetTemporaryGlueTableCredentials for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     The input provided was not valid.
//
//   - InternalServiceException
//     An internal service error occurred.
//
//   - OperationTimeoutException
//     The operation timed out.
//
//   - EntityNotFoundException
//     A specified entity does not exist.
//
//   - AccessDeniedException
//     Access to a resource was denied.
//
//   - PermissionTypeMismatchException
//     The engine does not support filtering data based on the enforced permissions.
//     For example, if you call the GetTemporaryGlueTableCredentials operation with
//     SupportedPermissionType equal to ColumnPermission, but cell-level permissions
//     exist on the table, this exception is thrown.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetTemporaryGlueTableCredentials
func (c *LakeFormation) GetTemporaryGlueTableCredentials(input *GetTemporaryGlueTableCredentialsInput) (*GetTemporaryGlueTableCredentialsOutput, error) {
	req, out := c.GetTemporaryGlueTableCredentialsRequest(input)
	return out, req.Send()
}

// GetTemporaryGlueTableCredentialsWithContext is the same as GetTemporaryGlueTableCredentials with the addition of
// the ability to pass a context and additional request options.
//
// See GetTemporaryGlueTableCredentials for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) GetTemporaryGlueTableCredentialsWithContext(ctx aws.Context, input *GetTemporaryGlueTableCredentialsInput, opts ...request.Option) (*GetTemporaryGlueTableCredentialsOutput, error) {
	req, out := c.GetTemporaryGlueTableCredentialsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetWorkUnitResults = "GetWorkUnitResults"

// GetWorkUnitResultsRequest generates a "aws/request.Request" representing the
// client's request for the GetWorkUnitResults operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetWorkUnitResults for more information on using the GetWorkUnitResults
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetWorkUnitResultsRequest method.
//	req, resp := client.GetWorkUnitResultsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetWorkUnitResults
func (c *LakeFormation) GetWorkUnitResultsRequest(input *GetWorkUnitResultsInput) (req *request.Request, output *GetWorkUnitResultsOutput) {
	op := &request.Operation{
		Name:       opGetWorkUnitResults,
		HTTPMethod: "POST",
		HTTPPath:   "/GetWorkUnitResults",
	}

	if input == nil {
		input = &GetWorkUnitResultsInput{}
	}

	output = &GetWorkUnitResultsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("data-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetWorkUnitResults API operation for AWS Lake Formation.
//
// Returns the work units resulting from the query. Work units can be executed
// in any order and in parallel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation GetWorkUnitResults for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceException
//     An internal service error occurred.
//
//   - InvalidInputException
//     The input provided was not valid.
//
//   - AccessDeniedException
//     Access to a resource was denied.
//
//   - ExpiredException
//     Contains details about an error where the query request expired.
//
//   - ThrottledException
//     Contains details about an error where the query request was throttled.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetWorkUnitResults
func (c *LakeFormation) GetWorkUnitResults(input *GetWorkUnitResultsInput) (*GetWorkUnitResultsOutput, error) {
	req, out := c.GetWorkUnitResultsRequest(input)
	return out, req.Send()
}

// GetWorkUnitResultsWithContext is the same as GetWorkUnitResults with the addition of
// the ability to pass a context and additional request options.
//
// See GetWorkUnitResults for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) GetWorkUnitResultsWithContext(ctx aws.Context, input *GetWorkUnitResultsInput, opts ...request.Option) (*GetWorkUnitResultsOutput, error) {
	req, out := c.GetWorkUnitResultsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetWorkUnits = "GetWorkUnits"

// GetWorkUnitsRequest generates a "aws/request.Request" representing the
// client's request for the GetWorkUnits operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetWorkUnits for more information on using the GetWorkUnits
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetWorkUnitsRequest method.
//	req, resp := client.GetWorkUnitsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetWorkUnits
func (c *LakeFormation) GetWorkUnitsRequest(input *GetWorkUnitsInput) (req *request.Request, output *GetWorkUnitsOutput) {
	op := &request.Operation{
		Name:       opGetWorkUnits,
		HTTPMethod: "POST",
		HTTPPath:   "/GetWorkUnits",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "PageSize",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetWorkUnitsInput{}
	}

	output = &GetWorkUnitsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("query-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetWorkUnits API operation for AWS Lake Formation.
//
// Retrieves the work units generated by the StartQueryPlanning operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation GetWorkUnits for usage and error information.
//
// Returned Error Types:
//
//   - WorkUnitsNotReadyYetException
//     Contains details about an error related to work units not being ready.
//
//   - InternalServiceException
//     An internal service error occurred.
//
//   - InvalidInputException
//     The input provided was not valid.
//
//   - AccessDeniedException
//     Access to a resource was denied.
//
//   - ExpiredException
//     Contains details about an error where the query request expired.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetWorkUnits
func (c *LakeFormation) GetWorkUnits(input *GetWorkUnitsInput) (*GetWorkUnitsOutput, error) {
	req, out := c.GetWorkUnitsRequest(input)
	return out, req.Send()
}

// GetWorkUnitsWithContext is the same as GetWorkUnits with the addition of
// the ability to pass a context and additional request options.
//
// See GetWorkUnits for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) GetWorkUnitsWithContext(ctx aws.Context, input *GetWorkUnitsInput, opts ...request.Option) (*GetWorkUnitsOutput, error) {
	req, out := c.GetWorkUnitsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetWorkUnitsPages iterates over the pages of a GetWorkUnits operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetWorkUnits method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetWorkUnits operation.
//	pageNum := 0
//	err := client.GetWorkUnitsPages(params,
//	    func(page *lakeformation.GetWorkUnitsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LakeFormation) GetWorkUnitsPages(input *GetWorkUnitsInput, fn func(*GetWorkUnitsOutput, bool) bool) error {
	return c.GetWorkUnitsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetWorkUnitsPagesWithContext same as GetWorkUnitsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) GetWorkUnitsPagesWithContext(ctx aws.Context, input *GetWorkUnitsInput, fn func(*GetWorkUnitsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetWorkUnitsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetWorkUnitsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetWorkUnitsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGrantPermissions = "GrantPermissions"

// GrantPermissionsRequest generates a "aws/request.Request" representing the
// client's request for the GrantPermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GrantPermissions for more information on using the GrantPermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GrantPermissionsRequest method.
//	req, resp := client.GrantPermissionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GrantPermissions
func (c *LakeFormation) GrantPermissionsRequest(input *GrantPermissionsInput) (req *request.Request, output *GrantPermissionsOutput) {
	op := &request.Operation{
		Name:       opGrantPermissions,
		HTTPMethod: "POST",
		HTTPPath:   "/GrantPermissions",
	}

	if input == nil {
		input = &GrantPermissionsInput{}
	}

	output = &GrantPermissionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// GrantPermissions API operation for AWS Lake Formation.
//
// Grants permissions to the principal to access metadata in the Data Catalog
// and data organized in underlying data storage such as Amazon S3.
//
// For information about permissions, see Security and Access Control to Metadata
// and Data (https://docs.aws.amazon.com/lake-formation/latest/dg/security-data-access.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation GrantPermissions for usage and error information.
//
// Returned Error Types:
//
//   - ConcurrentModificationException
//     Two processes are trying to modify a resource simultaneously.
//
//   - EntityNotFoundException
//     A specified entity does not exist.
//
//   - InvalidInputException
//     The input provided was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GrantPermissions
func (c *LakeFormation) GrantPermissions(input *GrantPermissionsInput) (*GrantPermissionsOutput, error) {
	req, out := c.GrantPermissionsRequest(input)
	return out, req.Send()
}

// GrantPermissionsWithContext is the same as GrantPermissions with the addition of
// the ability to pass a context and additional request options.
//
// See GrantPermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) GrantPermissionsWithContext(ctx aws.Context, input *GrantPermissionsInput, opts ...request.Option) (*GrantPermissionsOutput, error) {
	req, out := c.GrantPermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDataCellsFilter = "ListDataCellsFilter"

// ListDataCellsFilterRequest generates a "aws/request.Request" representing the
// client's request for the ListDataCellsFilter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDataCellsFilter for more information on using the ListDataCellsFilter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDataCellsFilterRequest method.
//	req, resp := client.ListDataCellsFilterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ListDataCellsFilter
func (c *LakeFormation) ListDataCellsFilterRequest(input *ListDataCellsFilterInput) (req *request.Request, output *ListDataCellsFilterOutput) {
	op := &request.Operation{
		Name:       opListDataCellsFilter,
		HTTPMethod: "POST",
		HTTPPath:   "/ListDataCellsFilter",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDataCellsFilterInput{}
	}

	output = &ListDataCellsFilterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDataCellsFilter API operation for AWS Lake Formation.
//
// Lists all the data cell filters on a table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation ListDataCellsFilter for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     The input provided was not valid.
//
//   - OperationTimeoutException
//     The operation timed out.
//
//   - InternalServiceException
//     An internal service error occurred.
//
//   - AccessDeniedException
//     Access to a resource was denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ListDataCellsFilter
func (c *LakeFormation) ListDataCellsFilter(input *ListDataCellsFilterInput) (*ListDataCellsFilterOutput, error) {
	req, out := c.ListDataCellsFilterRequest(input)
	return out, req.Send()
}

// ListDataCellsFilterWithContext is the same as ListDataCellsFilter with the addition of
// the ability to pass a context and additional request options.
//
// See ListDataCellsFilter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) ListDataCellsFilterWithContext(ctx aws.Context, input *ListDataCellsFilterInput, opts ...request.Option) (*ListDataCellsFilterOutput, error) {
	req, out := c.ListDataCellsFilterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDataCellsFilterPages iterates over the pages of a ListDataCellsFilter operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDataCellsFilter method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDataCellsFilter operation.
//	pageNum := 0
//	err := client.ListDataCellsFilterPages(params,
//	    func(page *lakeformation.ListDataCellsFilterOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LakeFormation) ListDataCellsFilterPages(input *ListDataCellsFilterInput, fn func(*ListDataCellsFilterOutput, bool) bool) error {
	return c.ListDataCellsFilterPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDataCellsFilterPagesWithContext same as ListDataCellsFilterPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) ListDataCellsFilterPagesWithContext(ctx aws.Context, input *ListDataCellsFilterInput, fn func(*ListDataCellsFilterOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDataCellsFilterInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDataCellsFilterRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDataCellsFilterOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListLFTags = "ListLFTags"

// ListLFTagsRequest generates a "aws/request.Request" representing the
// client's request for the ListLFTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLFTags for more information on using the ListLFTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListLFTagsRequest method.
//	req, resp := client.ListLFTagsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ListLFTags
func (c *LakeFormation) ListLFTagsRequest(input *ListLFTagsInput) (req *request.Request, output *ListLFTagsOutput) {
	op := &request.Operation{
		Name:       opListLFTags,
		HTTPMethod: "POST",
		HTTPPath:   "/ListLFTags",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListLFTagsInput{}
	}

	output = &ListLFTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLFTags API operation for AWS Lake Formation.
//
// Lists LF-tags that the requester has permission to view.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation ListLFTags for usage and error information.
//
// Returned Error Types:
//
//   - EntityNotFoundException
//     A specified entity does not exist.
//
//   - InvalidInputException
//     The input provided was not valid.
//
//   - InternalServiceException
//     An internal service error occurred.
//
//   - OperationTimeoutException
//     The operation timed out.
//
//   - AccessDeniedException
//     Access to a resource was denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ListLFTags
func (c *LakeFormation) ListLFTags(input *ListLFTagsInput) (*ListLFTagsOutput, error) {
	req, out := c.ListLFTagsRequest(input)
	return out, req.Send()
}

// ListLFTagsWithContext is the same as ListLFTags with the addition of
// the ability to pass a context and additional request options.
//
// See ListLFTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) ListLFTagsWithContext(ctx aws.Context, input *ListLFTagsInput, opts ...request.Option) (*ListLFTagsOutput, error) {
	req, out := c.ListLFTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListLFTagsPages iterates over the pages of a ListLFTags operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListLFTags method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListLFTags operation.
//	pageNum := 0
//	err := client.ListLFTagsPages(params,
//	    func(page *lakeformation.ListLFTagsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LakeFormation) ListLFTagsPages(input *ListLFTagsInput, fn func(*ListLFTagsOutput, bool) bool) error {
	return c.ListLFTagsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListLFTagsPagesWithContext same as ListLFTagsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) ListLFTagsPagesWithContext(ctx aws.Context, input *ListLFTagsInput, fn func(*ListLFTagsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListLFTagsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListLFTagsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListLFTagsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListLakeFormationOptIns = "ListLakeFormationOptIns"

// ListLakeFormationOptInsRequest generates a "aws/request.Request" representing the
// client's request for the ListLakeFormationOptIns operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLakeFormationOptIns for more information on using the ListLakeFormationOptIns
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListLakeFormationOptInsRequest method.
//	req, resp := client.ListLakeFormationOptInsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ListLakeFormationOptIns
func (c *LakeFormation) ListLakeFormationOptInsRequest(input *ListLakeFormationOptInsInput) (req *request.Request, output *ListLakeFormationOptInsOutput) {
	op := &request.Operation{
		Name:       opListLakeFormationOptIns,
		HTTPMethod: "POST",
		HTTPPath:   "/ListLakeFormationOptIns",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListLakeFormationOptInsInput{}
	}

	output = &ListLakeFormationOptInsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLakeFormationOptIns API operation for AWS Lake Formation.
//
// Retrieve the current list of resources and principals that are opt in to
// enforce Lake Formation permissions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation ListLakeFormationOptIns for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     The input provided was not valid.
//
//   - InternalServiceException
//     An internal service error occurred.
//
//   - OperationTimeoutException
//     The operation timed out.
//
//   - AccessDeniedException
//     Access to a resource was denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ListLakeFormationOptIns
func (c *LakeFormation) ListLakeFormationOptIns(input *ListLakeFormationOptInsInput) (*ListLakeFormationOptInsOutput, error) {
	req, out := c.ListLakeFormationOptInsRequest(input)
	return out, req.Send()
}

// ListLakeFormationOptInsWithContext is the same as ListLakeFormationOptIns with the addition of
// the ability to pass a context and additional request options.
//
// See ListLakeFormationOptIns for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) ListLakeFormationOptInsWithContext(ctx aws.Context, input *ListLakeFormationOptInsInput, opts ...request.Option) (*ListLakeFormationOptInsOutput, error) {
	req, out := c.ListLakeFormationOptInsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListLakeFormationOptInsPages iterates over the pages of a ListLakeFormationOptIns operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListLakeFormationOptIns method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListLakeFormationOptIns operation.
//	pageNum := 0
//	err := client.ListLakeFormationOptInsPages(params,
//	    func(page *lakeformation.ListLakeFormationOptInsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LakeFormation) ListLakeFormationOptInsPages(input *ListLakeFormationOptInsInput, fn func(*ListLakeFormationOptInsOutput, bool) bool) error {
	return c.ListLakeFormationOptInsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListLakeFormationOptInsPagesWithContext same as ListLakeFormationOptInsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) ListLakeFormationOptInsPagesWithContext(ctx aws.Context, input *ListLakeFormationOptInsInput, fn func(*ListLakeFormationOptInsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListLakeFormationOptInsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListLakeFormationOptInsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListLakeFormationOptInsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPermissions = "ListPermissions"

// ListPermissionsRequest generates a "aws/request.Request" representing the
// client's request for the ListPermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPermissions for more information on using the ListPermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPermissionsRequest method.
//	req, resp := client.ListPermissionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ListPermissions
func (c *LakeFormation) ListPermissionsRequest(input *ListPermissionsInput) (req *request.Request, output *ListPermissionsOutput) {
	op := &request.Operation{
		Name:       opListPermissions,
		HTTPMethod: "POST",
		HTTPPath:   "/ListPermissions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPermissionsInput{}
	}

	output = &ListPermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPermissions API operation for AWS Lake Formation.
//
// Returns a list of the principal permissions on the resource, filtered by
// the permissions of the caller. For example, if you are granted an ALTER permission,
// you are able to see only the principal permissions for ALTER.
//
// This operation returns only those permissions that have been explicitly granted.
//
// For information about permissions, see Security and Access Control to Metadata
// and Data (https://docs.aws.amazon.com/lake-formation/latest/dg/security-data-access.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation ListPermissions for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     The input provided was not valid.
//
//   - OperationTimeoutException
//     The operation timed out.
//
//   - InternalServiceException
//     An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ListPermissions
func (c *LakeFormation) ListPermissions(input *ListPermissionsInput) (*ListPermissionsOutput, error) {
	req, out := c.ListPermissionsRequest(input)
	return out, req.Send()
}

// ListPermissionsWithContext is the same as ListPermissions with the addition of
// the ability to pass a context and additional request options.
//
// See ListPermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) ListPermissionsWithContext(ctx aws.Context, input *ListPermissionsInput, opts ...request.Option) (*ListPermissionsOutput, error) {
	req, out := c.ListPermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPermissionsPages iterates over the pages of a ListPermissions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPermissions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPermissions operation.
//	pageNum := 0
//	err := client.ListPermissionsPages(params,
//	    func(page *lakeformation.ListPermissionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LakeFormation) ListPermissionsPages(input *ListPermissionsInput, fn func(*ListPermissionsOutput, bool) bool) error {
	return c.ListPermissionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPermissionsPagesWithContext same as ListPermissionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) ListPermissionsPagesWithContext(ctx aws.Context, input *ListPermissionsInput, fn func(*ListPermissionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPermissionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPermissionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPermissionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListResources = "ListResources"

// ListResourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResources for more information on using the ListResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListResourcesRequest method.
//	req, resp := client.ListResourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ListResources
func (c *LakeFormation) ListResourcesRequest(input *ListResourcesInput) (req *request.Request, output *ListResourcesOutput) {
	op := &request.Operation{
		Name:       opListResources,
		HTTPMethod: "POST",
		HTTPPath:   "/ListResources",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListResourcesInput{}
	}

	output = &ListResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResources API operation for AWS Lake Formation.
//
// Lists the resources registered to be managed by the Data Catalog.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation ListResources for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     The input provided was not valid.
//
//   - InternalServiceException
//     An internal service error occurred.
//
//   - OperationTimeoutException
//     The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ListResources
func (c *LakeFormation) ListResources(input *ListResourcesInput) (*ListResourcesOutput, error) {
	req, out := c.ListResourcesRequest(input)
	return out, req.Send()
}

// ListResourcesWithContext is the same as ListResources with the addition of
// the ability to pass a context and additional request options.
//
// See ListResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) ListResourcesWithContext(ctx aws.Context, input *ListResourcesInput, opts ...request.Option) (*ListResourcesOutput, error) {
	req, out := c.ListResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListResourcesPages iterates over the pages of a ListResources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListResources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListResources operation.
//	pageNum := 0
//	err := client.ListResourcesPages(params,
//	    func(page *lakeformation.ListResourcesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LakeFormation) ListResourcesPages(input *ListResourcesInput, fn func(*ListResourcesOutput, bool) bool) error {
	return c.ListResourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListResourcesPagesWithContext same as ListResourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) ListResourcesPagesWithContext(ctx aws.Context, input *ListResourcesInput, fn func(*ListResourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListResourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListResourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListResourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTableStorageOptimizers = "ListTableStorageOptimizers"

// ListTableStorageOptimizersRequest generates a "aws/request.Request" representing the
// client's request for the ListTableStorageOptimizers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTableStorageOptimizers for more information on using the ListTableStorageOptimizers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTableStorageOptimizersRequest method.
//	req, resp := client.ListTableStorageOptimizersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ListTableStorageOptimizers
func (c *LakeFormation) ListTableStorageOptimizersRequest(input *ListTableStorageOptimizersInput) (req *request.Request, output *ListTableStorageOptimizersOutput) {
	op := &request.Operation{
		Name:       opListTableStorageOptimizers,
		HTTPMethod: "POST",
		HTTPPath:   "/ListTableStorageOptimizers",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTableStorageOptimizersInput{}
	}

	output = &ListTableStorageOptimizersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTableStorageOptimizers API operation for AWS Lake Formation.
//
// Returns the configuration of all storage optimizers associated with a specified
// table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation ListTableStorageOptimizers for usage and error information.
//
// Returned Error Types:
//
//   - EntityNotFoundException
//     A specified entity does not exist.
//
//   - InvalidInputException
//     The input provided was not valid.
//
//   - AccessDeniedException
//     Access to a resource was denied.
//
//   - InternalServiceException
//     An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ListTableStorageOptimizers
func (c *LakeFormation) ListTableStorageOptimizers(input *ListTableStorageOptimizersInput) (*ListTableStorageOptimizersOutput, error) {
	req, out := c.ListTableStorageOptimizersRequest(input)
	return out, req.Send()
}

// ListTableStorageOptimizersWithContext is the same as ListTableStorageOptimizers with the addition of
// the ability to pass a context and additional request options.
//
// See ListTableStorageOptimizers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) ListTableStorageOptimizersWithContext(ctx aws.Context, input *ListTableStorageOptimizersInput, opts ...request.Option) (*ListTableStorageOptimizersOutput, error) {
	req, out := c.ListTableStorageOptimizersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTableStorageOptimizersPages iterates over the pages of a ListTableStorageOptimizers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTableStorageOptimizers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTableStorageOptimizers operation.
//	pageNum := 0
//	err := client.ListTableStorageOptimizersPages(params,
//	    func(page *lakeformation.ListTableStorageOptimizersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LakeFormation) ListTableStorageOptimizersPages(input *ListTableStorageOptimizersInput, fn func(*ListTableStorageOptimizersOutput, bool) bool) error {
	return c.ListTableStorageOptimizersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTableStorageOptimizersPagesWithContext same as ListTableStorageOptimizersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) ListTableStorageOptimizersPagesWithContext(ctx aws.Context, input *ListTableStorageOptimizersInput, fn func(*ListTableStorageOptimizersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTableStorageOptimizersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTableStorageOptimizersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTableStorageOptimizersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTransactions = "ListTransactions"

// ListTransactionsRequest generates a "aws/request.Request" representing the
// client's request for the ListTransactions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTransactions for more information on using the ListTransactions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTransactionsRequest method.
//	req, resp := client.ListTransactionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ListTransactions
func (c *LakeFormation) ListTransactionsRequest(input *ListTransactionsInput) (req *request.Request, output *ListTransactionsOutput) {
	op := &request.Operation{
		Name:       opListTransactions,
		HTTPMethod: "POST",
		HTTPPath:   "/ListTransactions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTransactionsInput{}
	}

	output = &ListTransactionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTransactions API operation for AWS Lake Formation.
//
// Returns metadata about transactions and their status. To prevent the response
// from growing indefinitely, only uncommitted transactions and those available
// for time-travel queries are returned.
//
// This operation can help you identify uncommitted transactions or to get information
// about transactions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation ListTransactions for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     The input provided was not valid.
//
//   - InternalServiceException
//     An internal service error occurred.
//
//   - OperationTimeoutException
//     The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ListTransactions
func (c *LakeFormation) ListTransactions(input *ListTransactionsInput) (*ListTransactionsOutput, error) {
	req, out := c.ListTransactionsRequest(input)
	return out, req.Send()
}

// ListTransactionsWithContext is the same as ListTransactions with the addition of
// the ability to pass a context and additional request options.
//
// See ListTransactions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) ListTransactionsWithContext(ctx aws.Context, input *ListTransactionsInput, opts ...request.Option) (*ListTransactionsOutput, error) {
	req, out := c.ListTransactionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTransactionsPages iterates over the pages of a ListTransactions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTransactions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTransactions operation.
//	pageNum := 0
//	err := client.ListTransactionsPages(params,
//	    func(page *lakeformation.ListTransactionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LakeFormation) ListTransactionsPages(input *ListTransactionsInput, fn func(*ListTransactionsOutput, bool) bool) error {
	return c.ListTransactionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTransactionsPagesWithContext same as ListTransactionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) ListTransactionsPagesWithContext(ctx aws.Context, input *ListTransactionsInput, fn func(*ListTransactionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTransactionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTransactionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTransactionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutDataLakeSettings = "PutDataLakeSettings"

// PutDataLakeSettingsRequest generates a "aws/request.Request" representing the
// client's request for the PutDataLakeSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutDataLakeSettings for more information on using the PutDataLakeSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutDataLakeSettingsRequest method.
//	req, resp := client.PutDataLakeSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/PutDataLakeSettings
func (c *LakeFormation) PutDataLakeSettingsRequest(input *PutDataLakeSettingsInput) (req *request.Request, output *PutDataLakeSettingsOutput) {
	op := &request.Operation{
		Name:       opPutDataLakeSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/PutDataLakeSettings",
	}

	if input == nil {
		input = &PutDataLakeSettingsInput{}
	}

	output = &PutDataLakeSettingsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutDataLakeSettings API operation for AWS Lake Formation.
//
// Sets the list of data lake administrators who have admin privileges on all
// resources managed by Lake Formation. For more information on admin privileges,
// see Granting Lake Formation Permissions (https://docs.aws.amazon.com/lake-formation/latest/dg/lake-formation-permissions.html).
//
// This API replaces the current list of data lake admins with the new list
// being passed. To add an admin, fetch the current list and add the new admin
// to that list and pass that list in this API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation PutDataLakeSettings for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceException
//     An internal service error occurred.
//
//   - InvalidInputException
//     The input provided was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/PutDataLakeSettings
func (c *LakeFormation) PutDataLakeSettings(input *PutDataLakeSettingsInput) (*PutDataLakeSettingsOutput, error) {
	req, out := c.PutDataLakeSettingsRequest(input)
	return out, req.Send()
}

// PutDataLakeSettingsWithContext is the same as PutDataLakeSettings with the addition of
// the ability to pass a context and additional request options.
//
// See PutDataLakeSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) PutDataLakeSettingsWithContext(ctx aws.Context, input *PutDataLakeSettingsInput, opts ...request.Option) (*PutDataLakeSettingsOutput, error) {
	req, out := c.PutDataLakeSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterResource = "RegisterResource"

// RegisterResourceRequest generates a "aws/request.Request" representing the
// client's request for the RegisterResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterResource for more information on using the RegisterResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RegisterResourceRequest method.
//	req, resp := client.RegisterResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/RegisterResource
func (c *LakeFormation) RegisterResourceRequest(input *RegisterResourceInput) (req *request.Request, output *RegisterResourceOutput) {
	op := &request.Operation{
		Name:       opRegisterResource,
		HTTPMethod: "POST",
		HTTPPath:   "/RegisterResource",
	}

	if input == nil {
		input = &RegisterResourceInput{}
	}

	output = &RegisterResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RegisterResource API operation for AWS Lake Formation.
//
// Registers the resource as managed by the Data Catalog.
//
// To add or update data, Lake Formation needs read/write access to the chosen
// Amazon S3 path. Choose a role that you know has permission to do this, or
// choose the AWSServiceRoleForLakeFormationDataAccess service-linked role.
// When you register the first Amazon S3 path, the service-linked role and a
// new inline policy are created on your behalf. Lake Formation adds the first
// path to the inline policy and attaches it to the service-linked role. When
// you register subsequent paths, Lake Formation adds the path to the existing
// policy.
//
// The following request registers a new location and gives Lake Formation permission
// to use the service-linked role to access that location.
//
// ResourceArn = arn:aws:s3:::my-bucket UseServiceLinkedRole = true
//
// If UseServiceLinkedRole is not set to true, you must provide or set the RoleArn:
//
// arn:aws:iam::12345:role/my-data-access-role
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation RegisterResource for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     The input provided was not valid.
//
//   - InternalServiceException
//     An internal service error occurred.
//
//   - OperationTimeoutException
//     The operation timed out.
//
//   - AlreadyExistsException
//     A resource to be created or added already exists.
//
//   - EntityNotFoundException
//     A specified entity does not exist.
//
//   - ResourceNumberLimitExceededException
//     A resource numerical limit was exceeded.
//
//   - AccessDeniedException
//     Access to a resource was denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/RegisterResource
func (c *LakeFormation) RegisterResource(input *RegisterResourceInput) (*RegisterResourceOutput, error) {
	req, out := c.RegisterResourceRequest(input)
	return out, req.Send()
}

// RegisterResourceWithContext is the same as RegisterResource with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) RegisterResourceWithContext(ctx aws.Context, input *RegisterResourceInput, opts ...request.Option) (*RegisterResourceOutput, error) {
	req, out := c.RegisterResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveLFTagsFromResource = "RemoveLFTagsFromResource"

// RemoveLFTagsFromResourceRequest generates a "aws/request.Request" representing the
// client's request for the RemoveLFTagsFromResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveLFTagsFromResource for more information on using the RemoveLFTagsFromResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RemoveLFTagsFromResourceRequest method.
//	req, resp := client.RemoveLFTagsFromResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/RemoveLFTagsFromResource
func (c *LakeFormation) RemoveLFTagsFromResourceRequest(input *RemoveLFTagsFromResourceInput) (req *request.Request, output *RemoveLFTagsFromResourceOutput) {
	op := &request.Operation{
		Name:       opRemoveLFTagsFromResource,
		HTTPMethod: "POST",
		HTTPPath:   "/RemoveLFTagsFromResource",
	}

	if input == nil {
		input = &RemoveLFTagsFromResourceInput{}
	}

	output = &RemoveLFTagsFromResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RemoveLFTagsFromResource API operation for AWS Lake Formation.
//
// Removes an LF-tag from the resource. Only database, table, or tableWithColumns
// resource are allowed. To tag columns, use the column inclusion list in tableWithColumns
// to specify column input.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation RemoveLFTagsFromResource for usage and error information.
//
// Returned Error Types:
//
//   - EntityNotFoundException
//     A specified entity does not exist.
//
//   - InvalidInputException
//     The input provided was not valid.
//
//   - InternalServiceException
//     An internal service error occurred.
//
//   - OperationTimeoutException
//     The operation timed out.
//
//   - GlueEncryptionException
//     An encryption operation failed.
//
//   - AccessDeniedException
//     Access to a resource was denied.
//
//   - ConcurrentModificationException
//     Two processes are trying to modify a resource simultaneously.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/RemoveLFTagsFromResource
func (c *LakeFormation) RemoveLFTagsFromResource(input *RemoveLFTagsFromResourceInput) (*RemoveLFTagsFromResourceOutput, error) {
	req, out := c.RemoveLFTagsFromResourceRequest(input)
	return out, req.Send()
}

// RemoveLFTagsFromResourceWithContext is the same as RemoveLFTagsFromResource with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveLFTagsFromResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) RemoveLFTagsFromResourceWithContext(ctx aws.Context, input *RemoveLFTagsFromResourceInput, opts ...request.Option) (*RemoveLFTagsFromResourceOutput, error) {
	req, out := c.RemoveLFTagsFromResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRevokePermissions = "RevokePermissions"

// RevokePermissionsRequest generates a "aws/request.Request" representing the
// client's request for the RevokePermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RevokePermissions for more information on using the RevokePermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RevokePermissionsRequest method.
//	req, resp := client.RevokePermissionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/RevokePermissions
func (c *LakeFormation) RevokePermissionsRequest(input *RevokePermissionsInput) (req *request.Request, output *RevokePermissionsOutput) {
	op := &request.Operation{
		Name:       opRevokePermissions,
		HTTPMethod: "POST",
		HTTPPath:   "/RevokePermissions",
	}

	if input == nil {
		input = &RevokePermissionsInput{}
	}

	output = &RevokePermissionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RevokePermissions API operation for AWS Lake Formation.
//
// Revokes permissions to the principal to access metadata in the Data Catalog
// and data organized in underlying data storage such as Amazon S3.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation RevokePermissions for usage and error information.
//
// Returned Error Types:
//
//   - ConcurrentModificationException
//     Two processes are trying to modify a resource simultaneously.
//
//   - EntityNotFoundException
//     A specified entity does not exist.
//
//   - InvalidInputException
//     The input provided was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/RevokePermissions
func (c *LakeFormation) RevokePermissions(input *RevokePermissionsInput) (*RevokePermissionsOutput, error) {
	req, out := c.RevokePermissionsRequest(input)
	return out, req.Send()
}

// RevokePermissionsWithContext is the same as RevokePermissions with the addition of
// the ability to pass a context and additional request options.
//
// See RevokePermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) RevokePermissionsWithContext(ctx aws.Context, input *RevokePermissionsInput, opts ...request.Option) (*RevokePermissionsOutput, error) {
	req, out := c.RevokePermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSearchDatabasesByLFTags = "SearchDatabasesByLFTags"

// SearchDatabasesByLFTagsRequest generates a "aws/request.Request" representing the
// client's request for the SearchDatabasesByLFTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchDatabasesByLFTags for more information on using the SearchDatabasesByLFTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SearchDatabasesByLFTagsRequest method.
//	req, resp := client.SearchDatabasesByLFTagsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/SearchDatabasesByLFTags
func (c *LakeFormation) SearchDatabasesByLFTagsRequest(input *SearchDatabasesByLFTagsInput) (req *request.Request, output *SearchDatabasesByLFTagsOutput) {
	op := &request.Operation{
		Name:       opSearchDatabasesByLFTags,
		HTTPMethod: "POST",
		HTTPPath:   "/SearchDatabasesByLFTags",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchDatabasesByLFTagsInput{}
	}

	output = &SearchDatabasesByLFTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchDatabasesByLFTags API operation for AWS Lake Formation.
//
// This operation allows a search on DATABASE resources by TagCondition. This
// operation is used by admins who want to grant user permissions on certain
// TagConditions. Before making a grant, the admin can use SearchDatabasesByTags
// to find all resources where the given TagConditions are valid to verify whether
// the returned resources can be shared.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation SearchDatabasesByLFTags for usage and error information.
//
// Returned Error Types:
//
//   - EntityNotFoundException
//     A specified entity does not exist.
//
//   - InternalServiceException
//     An internal service error occurred.
//
//   - InvalidInputException
//     The input provided was not valid.
//
//   - OperationTimeoutException
//     The operation timed out.
//
//   - GlueEncryptionException
//     An encryption operation failed.
//
//   - AccessDeniedException
//     Access to a resource was denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/SearchDatabasesByLFTags
func (c *LakeFormation) SearchDatabasesByLFTags(input *SearchDatabasesByLFTagsInput) (*SearchDatabasesByLFTagsOutput, error) {
	req, out := c.SearchDatabasesByLFTagsRequest(input)
	return out, req.Send()
}

// SearchDatabasesByLFTagsWithContext is the same as SearchDatabasesByLFTags with the addition of
// the ability to pass a context and additional request options.
//
// See SearchDatabasesByLFTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) SearchDatabasesByLFTagsWithContext(ctx aws.Context, input *SearchDatabasesByLFTagsInput, opts ...request.Option) (*SearchDatabasesByLFTagsOutput, error) {
	req, out := c.SearchDatabasesByLFTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchDatabasesByLFTagsPages iterates over the pages of a SearchDatabasesByLFTags operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchDatabasesByLFTags method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a SearchDatabasesByLFTags operation.
//	pageNum := 0
//	err := client.SearchDatabasesByLFTagsPages(params,
//	    func(page *lakeformation.SearchDatabasesByLFTagsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LakeFormation) SearchDatabasesByLFTagsPages(input *SearchDatabasesByLFTagsInput, fn func(*SearchDatabasesByLFTagsOutput, bool) bool) error {
	return c.SearchDatabasesByLFTagsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchDatabasesByLFTagsPagesWithContext same as SearchDatabasesByLFTagsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) SearchDatabasesByLFTagsPagesWithContext(ctx aws.Context, input *SearchDatabasesByLFTagsInput, fn func(*SearchDatabasesByLFTagsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchDatabasesByLFTagsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchDatabasesByLFTagsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchDatabasesByLFTagsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opSearchTablesByLFTags = "SearchTablesByLFTags"

// SearchTablesByLFTagsRequest generates a "aws/request.Request" representing the
// client's request for the SearchTablesByLFTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchTablesByLFTags for more information on using the SearchTablesByLFTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SearchTablesByLFTagsRequest method.
//	req, resp := client.SearchTablesByLFTagsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/SearchTablesByLFTags
func (c *LakeFormation) SearchTablesByLFTagsRequest(input *SearchTablesByLFTagsInput) (req *request.Request, output *SearchTablesByLFTagsOutput) {
	op := &request.Operation{
		Name:       opSearchTablesByLFTags,
		HTTPMethod: "POST",
		HTTPPath:   "/SearchTablesByLFTags",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchTablesByLFTagsInput{}
	}

	output = &SearchTablesByLFTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchTablesByLFTags API operation for AWS Lake Formation.
//
// This operation allows a search on TABLE resources by LFTags. This will be
// used by admins who want to grant user permissions on certain LF-tags. Before
// making a grant, the admin can use SearchTablesByLFTags to find all resources
// where the given LFTags are valid to verify whether the returned resources
// can be shared.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation SearchTablesByLFTags for usage and error information.
//
// Returned Error Types:
//
//   - EntityNotFoundException
//     A specified entity does not exist.
//
//   - InternalServiceException
//     An internal service error occurred.
//
//   - InvalidInputException
//     The input provided was not valid.
//
//   - OperationTimeoutException
//     The operation timed out.
//
//   - GlueEncryptionException
//     An encryption operation failed.
//
//   - AccessDeniedException
//     Access to a resource was denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/SearchTablesByLFTags
func (c *LakeFormation) SearchTablesByLFTags(input *SearchTablesByLFTagsInput) (*SearchTablesByLFTagsOutput, error) {
	req, out := c.SearchTablesByLFTagsRequest(input)
	return out, req.Send()
}

// SearchTablesByLFTagsWithContext is the same as SearchTablesByLFTags with the addition of
// the ability to pass a context and additional request options.
//
// See SearchTablesByLFTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) SearchTablesByLFTagsWithContext(ctx aws.Context, input *SearchTablesByLFTagsInput, opts ...request.Option) (*SearchTablesByLFTagsOutput, error) {
	req, out := c.SearchTablesByLFTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchTablesByLFTagsPages iterates over the pages of a SearchTablesByLFTags operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchTablesByLFTags method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a SearchTablesByLFTags operation.
//	pageNum := 0
//	err := client.SearchTablesByLFTagsPages(params,
//	    func(page *lakeformation.SearchTablesByLFTagsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LakeFormation) SearchTablesByLFTagsPages(input *SearchTablesByLFTagsInput, fn func(*SearchTablesByLFTagsOutput, bool) bool) error {
	return c.SearchTablesByLFTagsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchTablesByLFTagsPagesWithContext same as SearchTablesByLFTagsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) SearchTablesByLFTagsPagesWithContext(ctx aws.Context, input *SearchTablesByLFTagsInput, fn func(*SearchTablesByLFTagsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchTablesByLFTagsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchTablesByLFTagsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchTablesByLFTagsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opStartQueryPlanning = "StartQueryPlanning"

// StartQueryPlanningRequest generates a "aws/request.Request" representing the
// client's request for the StartQueryPlanning operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartQueryPlanning for more information on using the StartQueryPlanning
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartQueryPlanningRequest method.
//	req, resp := client.StartQueryPlanningRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/StartQueryPlanning
func (c *LakeFormation) StartQueryPlanningRequest(input *StartQueryPlanningInput) (req *request.Request, output *StartQueryPlanningOutput) {
	op := &request.Operation{
		Name:       opStartQueryPlanning,
		HTTPMethod: "POST",
		HTTPPath:   "/StartQueryPlanning",
	}

	if input == nil {
		input = &StartQueryPlanningInput{}
	}

	output = &StartQueryPlanningOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("query-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// StartQueryPlanning API operation for AWS Lake Formation.
//
// Submits a request to process a query statement.
//
// This operation generates work units that can be retrieved with the GetWorkUnits
// operation as soon as the query state is WORKUNITS_AVAILABLE or FINISHED.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation StartQueryPlanning for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceException
//     An internal service error occurred.
//
//   - InvalidInputException
//     The input provided was not valid.
//
//   - AccessDeniedException
//     Access to a resource was denied.
//
//   - ThrottledException
//     Contains details about an error where the query request was throttled.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/StartQueryPlanning
func (c *LakeFormation) StartQueryPlanning(input *StartQueryPlanningInput) (*StartQueryPlanningOutput, error) {
	req, out := c.StartQueryPlanningRequest(input)
	return out, req.Send()
}

// StartQueryPlanningWithContext is the same as StartQueryPlanning with the addition of
// the ability to pass a context and additional request options.
//
// See StartQueryPlanning for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) StartQueryPlanningWithContext(ctx aws.Context, input *StartQueryPlanningInput, opts ...request.Option) (*StartQueryPlanningOutput, error) {
	req, out := c.StartQueryPlanningRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartTransaction = "StartTransaction"

// StartTransactionRequest generates a "aws/request.Request" representing the
// client's request for the StartTransaction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartTransaction for more information on using the StartTransaction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartTransactionRequest method.
//	req, resp := client.StartTransactionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/StartTransaction
func (c *LakeFormation) StartTransactionRequest(input *StartTransactionInput) (req *request.Request, output *StartTransactionOutput) {
	op := &request.Operation{
		Name:       opStartTransaction,
		HTTPMethod: "POST",
		HTTPPath:   "/StartTransaction",
	}

	if input == nil {
		input = &StartTransactionInput{}
	}

	output = &StartTransactionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartTransaction API operation for AWS Lake Formation.
//
// Starts a new transaction and returns its transaction ID. Transaction IDs
// are opaque objects that you can use to identify a transaction.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation StartTransaction for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceException
//     An internal service error occurred.
//
//   - OperationTimeoutException
//     The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/StartTransaction
func (c *LakeFormation) StartTransaction(input *StartTransactionInput) (*StartTransactionOutput, error) {
	req, out := c.StartTransactionRequest(input)
	return out, req.Send()
}

// StartTransactionWithContext is the same as StartTransaction with the addition of
// the ability to pass a context and additional request options.
//
// See StartTransaction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) StartTransactionWithContext(ctx aws.Context, input *StartTransactionInput, opts ...request.Option) (*StartTransactionOutput, error) {
	req, out := c.StartTransactionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDataCellsFilter = "UpdateDataCellsFilter"

// UpdateDataCellsFilterRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDataCellsFilter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDataCellsFilter for more information on using the UpdateDataCellsFilter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateDataCellsFilterRequest method.
//	req, resp := client.UpdateDataCellsFilterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/UpdateDataCellsFilter
func (c *LakeFormation) UpdateDataCellsFilterRequest(input *UpdateDataCellsFilterInput) (req *request.Request, output *UpdateDataCellsFilterOutput) {
	op := &request.Operation{
		Name:       opUpdateDataCellsFilter,
		HTTPMethod: "POST",
		HTTPPath:   "/UpdateDataCellsFilter",
	}

	if input == nil {
		input = &UpdateDataCellsFilterInput{}
	}

	output = &UpdateDataCellsFilterOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateDataCellsFilter API operation for AWS Lake Formation.
//
// Updates a data cell filter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation UpdateDataCellsFilter for usage and error information.
//
// Returned Error Types:
//
//   - ConcurrentModificationException
//     Two processes are trying to modify a resource simultaneously.
//
//   - InvalidInputException
//     The input provided was not valid.
//
//   - EntityNotFoundException
//     A specified entity does not exist.
//
//   - InternalServiceException
//     An internal service error occurred.
//
//   - OperationTimeoutException
//     The operation timed out.
//
//   - AccessDeniedException
//     Access to a resource was denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/UpdateDataCellsFilter
func (c *LakeFormation) UpdateDataCellsFilter(input *UpdateDataCellsFilterInput) (*UpdateDataCellsFilterOutput, error) {
	req, out := c.UpdateDataCellsFilterRequest(input)
	return out, req.Send()
}

// UpdateDataCellsFilterWithContext is the same as UpdateDataCellsFilter with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDataCellsFilter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) UpdateDataCellsFilterWithContext(ctx aws.Context, input *UpdateDataCellsFilterInput, opts ...request.Option) (*UpdateDataCellsFilterOutput, error) {
	req, out := c.UpdateDataCellsFilterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateLFTag = "UpdateLFTag"

// UpdateLFTagRequest generates a "aws/request.Request" representing the
// client's request for the UpdateLFTag operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateLFTag for more information on using the UpdateLFTag
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateLFTagRequest method.
//	req, resp := client.UpdateLFTagRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/UpdateLFTag
func (c *LakeFormation) UpdateLFTagRequest(input *UpdateLFTagInput) (req *request.Request, output *UpdateLFTagOutput) {
	op := &request.Operation{
		Name:       opUpdateLFTag,
		HTTPMethod: "POST",
		HTTPPath:   "/UpdateLFTag",
	}

	if input == nil {
		input = &UpdateLFTagInput{}
	}

	output = &UpdateLFTagOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateLFTag API operation for AWS Lake Formation.
//
// Updates the list of possible values for the specified LF-tag key. If the
// LF-tag does not exist, the operation throws an EntityNotFoundException. The
// values in the delete key values will be deleted from list of possible values.
// If any value in the delete key values is attached to a resource, then API
// errors out with a 400 Exception - "Update not allowed". Untag the attribute
// before deleting the LF-tag key's value.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation UpdateLFTag for usage and error information.
//
// Returned Error Types:
//
//   - EntityNotFoundException
//     A specified entity does not exist.
//
//   - InvalidInputException
//     The input provided was not valid.
//
//   - InternalServiceException
//     An internal service error occurred.
//
//   - OperationTimeoutException
//     The operation timed out.
//
//   - ConcurrentModificationException
//     Two processes are trying to modify a resource simultaneously.
//
//   - AccessDeniedException
//     Access to a resource was denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/UpdateLFTag
func (c *LakeFormation) UpdateLFTag(input *UpdateLFTagInput) (*UpdateLFTagOutput, error) {
	req, out := c.UpdateLFTagRequest(input)
	return out, req.Send()
}

// UpdateLFTagWithContext is the same as UpdateLFTag with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateLFTag for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) UpdateLFTagWithContext(ctx aws.Context, input *UpdateLFTagInput, opts ...request.Option) (*UpdateLFTagOutput, error) {
	req, out := c.UpdateLFTagRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateLakeFormationIdentityCenterConfiguration = "UpdateLakeFormationIdentityCenterConfiguration"

// UpdateLakeFormationIdentityCenterConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateLakeFormationIdentityCenterConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateLakeFormationIdentityCenterConfiguration for more information on using the UpdateLakeFormationIdentityCenterConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateLakeFormationIdentityCenterConfigurationRequest method.
//	req, resp := client.UpdateLakeFormationIdentityCenterConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/UpdateLakeFormationIdentityCenterConfiguration
func (c *LakeFormation) UpdateLakeFormationIdentityCenterConfigurationRequest(input *UpdateLakeFormationIdentityCenterConfigurationInput) (req *request.Request, output *UpdateLakeFormationIdentityCenterConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateLakeFormationIdentityCenterConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/UpdateLakeFormationIdentityCenterConfiguration",
	}

	if input == nil {
		input = &UpdateLakeFormationIdentityCenterConfigurationInput{}
	}

	output = &UpdateLakeFormationIdentityCenterConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateLakeFormationIdentityCenterConfiguration API operation for AWS Lake Formation.
//
// Updates the IAM Identity Center connection parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation UpdateLakeFormationIdentityCenterConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     The input provided was not valid.
//
//   - EntityNotFoundException
//     A specified entity does not exist.
//
//   - InternalServiceException
//     An internal service error occurred.
//
//   - OperationTimeoutException
//     The operation timed out.
//
//   - AccessDeniedException
//     Access to a resource was denied.
//
//   - ConcurrentModificationException
//     Two processes are trying to modify a resource simultaneously.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/UpdateLakeFormationIdentityCenterConfiguration
func (c *LakeFormation) UpdateLakeFormationIdentityCenterConfiguration(input *UpdateLakeFormationIdentityCenterConfigurationInput) (*UpdateLakeFormationIdentityCenterConfigurationOutput, error) {
	req, out := c.UpdateLakeFormationIdentityCenterConfigurationRequest(input)
	return out, req.Send()
}

// UpdateLakeFormationIdentityCenterConfigurationWithContext is the same as UpdateLakeFormationIdentityCenterConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateLakeFormationIdentityCenterConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) UpdateLakeFormationIdentityCenterConfigurationWithContext(ctx aws.Context, input *UpdateLakeFormationIdentityCenterConfigurationInput, opts ...request.Option) (*UpdateLakeFormationIdentityCenterConfigurationOutput, error) {
	req, out := c.UpdateLakeFormationIdentityCenterConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateResource = "UpdateResource"

// UpdateResourceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateResource for more information on using the UpdateResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateResourceRequest method.
//	req, resp := client.UpdateResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/UpdateResource
func (c *LakeFormation) UpdateResourceRequest(input *UpdateResourceInput) (req *request.Request, output *UpdateResourceOutput) {
	op := &request.Operation{
		Name:       opUpdateResource,
		HTTPMethod: "POST",
		HTTPPath:   "/UpdateResource",
	}

	if input == nil {
		input = &UpdateResourceInput{}
	}

	output = &UpdateResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateResource API operation for AWS Lake Formation.
//
// Updates the data access role used for vending access to the given (registered)
// resource in Lake Formation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation UpdateResource for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInputException
//     The input provided was not valid.
//
//   - InternalServiceException
//     An internal service error occurred.
//
//   - OperationTimeoutException
//     The operation timed out.
//
//   - EntityNotFoundException
//     A specified entity does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/UpdateResource
func (c *LakeFormation) UpdateResource(input *UpdateResourceInput) (*UpdateResourceOutput, error) {
	req, out := c.UpdateResourceRequest(input)
	return out, req.Send()
}

// UpdateResourceWithContext is the same as UpdateResource with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) UpdateResourceWithContext(ctx aws.Context, input *UpdateResourceInput, opts ...request.Option) (*UpdateResourceOutput, error) {
	req, out := c.UpdateResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTableObjects = "UpdateTableObjects"

// UpdateTableObjectsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTableObjects operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTableObjects for more information on using the UpdateTableObjects
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateTableObjectsRequest method.
//	req, resp := client.UpdateTableObjectsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/UpdateTableObjects
func (c *LakeFormation) UpdateTableObjectsRequest(input *UpdateTableObjectsInput) (req *request.Request, output *UpdateTableObjectsOutput) {
	op := &request.Operation{
		Name:       opUpdateTableObjects,
		HTTPMethod: "POST",
		HTTPPath:   "/UpdateTableObjects",
	}

	if input == nil {
		input = &UpdateTableObjectsInput{}
	}

	output = &UpdateTableObjectsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateTableObjects API operation for AWS Lake Formation.
//
// Updates the manifest of Amazon S3 objects that make up the specified governed
// table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation UpdateTableObjects for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceException
//     An internal service error occurred.
//
//   - InvalidInputException
//     The input provided was not valid.
//
//   - OperationTimeoutException
//     The operation timed out.
//
//   - EntityNotFoundException
//     A specified entity does not exist.
//
//   - TransactionCommittedException
//     Contains details about an error where the specified transaction has already
//     been committed and cannot be used for UpdateTableObjects.
//
//   - TransactionCanceledException
//     Contains details about an error related to a transaction that was cancelled.
//
//   - TransactionCommitInProgressException
//     Contains details about an error related to a transaction commit that was
//     in progress.
//
//   - ResourceNotReadyException
//     Contains details about an error related to a resource which is not ready
//     for a transaction.
//
//   - ConcurrentModificationException
//     Two processes are trying to modify a resource simultaneously.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/UpdateTableObjects
func (c *LakeFormation) UpdateTableObjects(input *UpdateTableObjectsInput) (*UpdateTableObjectsOutput, error) {
	req, out := c.UpdateTableObjectsRequest(input)
	return out, req.Send()
}

// UpdateTableObjectsWithContext is the same as UpdateTableObjects with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTableObjects for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) UpdateTableObjectsWithContext(ctx aws.Context, input *UpdateTableObjectsInput, opts ...request.Option) (*UpdateTableObjectsOutput, error) {
	req, out := c.UpdateTableObjectsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTableStorageOptimizer = "UpdateTableStorageOptimizer"

// UpdateTableStorageOptimizerRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTableStorageOptimizer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTableStorageOptimizer for more information on using the UpdateTableStorageOptimizer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateTableStorageOptimizerRequest method.
//	req, resp := client.UpdateTableStorageOptimizerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/UpdateTableStorageOptimizer
func (c *LakeFormation) UpdateTableStorageOptimizerRequest(input *UpdateTableStorageOptimizerInput) (req *request.Request, output *UpdateTableStorageOptimizerOutput) {
	op := &request.Operation{
		Name:       opUpdateTableStorageOptimizer,
		HTTPMethod: "POST",
		HTTPPath:   "/UpdateTableStorageOptimizer",
	}

	if input == nil {
		input = &UpdateTableStorageOptimizerInput{}
	}

	output = &UpdateTableStorageOptimizerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTableStorageOptimizer API operation for AWS Lake Formation.
//
// Updates the configuration of the storage optimizers for a table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lake Formation's
// API operation UpdateTableStorageOptimizer for usage and error information.
//
// Returned Error Types:
//
//   - EntityNotFoundException
//     A specified entity does not exist.
//
//   - InvalidInputException
//     The input provided was not valid.
//
//   - AccessDeniedException
//     Access to a resource was denied.
//
//   - InternalServiceException
//     An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/UpdateTableStorageOptimizer
func (c *LakeFormation) UpdateTableStorageOptimizer(input *UpdateTableStorageOptimizerInput) (*UpdateTableStorageOptimizerOutput, error) {
	req, out := c.UpdateTableStorageOptimizerRequest(input)
	return out, req.Send()
}

// UpdateTableStorageOptimizerWithContext is the same as UpdateTableStorageOptimizer with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTableStorageOptimizer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LakeFormation) UpdateTableStorageOptimizerWithContext(ctx aws.Context, input *UpdateTableStorageOptimizerInput, opts ...request.Option) (*UpdateTableStorageOptimizerOutput, error) {
	req, out := c.UpdateTableStorageOptimizerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Access to a resource was denied.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message describing the problem.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type AddLFTagsToResourceInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, and other control information to manage your Lake Formation
	// environment.
	CatalogId *string `min:"1" type:"string"`

	// The LF-tags to attach to the resource.
	//
	// LFTags is a required field
	LFTags []*LFTagPair `min:"1" type:"list" required:"true"`

	// The database, table, or column resource to which to attach an LF-tag.
	//
	// Resource is a required field
	Resource *Resource `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddLFTagsToResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddLFTagsToResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddLFTagsToResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddLFTagsToResourceInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.LFTags == nil {
		invalidParams.Add(request.NewErrParamRequired("LFTags"))
	}
	if s.LFTags != nil && len(s.LFTags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LFTags", 1))
	}
	if s.Resource == nil {
		invalidParams.Add(request.NewErrParamRequired("Resource"))
	}
	if s.LFTags != nil {
		for i, v := range s.LFTags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "LFTags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Resource != nil {
		if err := s.Resource.Validate(); err != nil {
			invalidParams.AddNested("Resource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *AddLFTagsToResourceInput) SetCatalogId(v string) *AddLFTagsToResourceInput {
	s.CatalogId = &v
	return s
}

// SetLFTags sets the LFTags field's value.
func (s *AddLFTagsToResourceInput) SetLFTags(v []*LFTagPair) *AddLFTagsToResourceInput {
	s.LFTags = v
	return s
}

// SetResource sets the Resource field's value.
func (s *AddLFTagsToResourceInput) SetResource(v *Resource) *AddLFTagsToResourceInput {
	s.Resource = v
	return s
}

type AddLFTagsToResourceOutput struct {
	_ struct{} `type:"structure"`

	// A list of failures to tag the resource.
	Failures []*LFTagError `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddLFTagsToResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddLFTagsToResourceOutput) GoString() string {
	return s.String()
}

// SetFailures sets the Failures field's value.
func (s *AddLFTagsToResourceOutput) SetFailures(v []*LFTagError) *AddLFTagsToResourceOutput {
	s.Failures = v
	return s
}

// A new object to add to the governed table.
type AddObjectInput_ struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 ETag of the object. Returned by GetTableObjects for validation
	// and used to identify changes to the underlying data.
	//
	// ETag is a required field
	ETag *string `min:"1" type:"string" required:"true"`

	// A list of partition values for the object. A value must be specified for
	// each partition key associated with the table.
	//
	// The supported data types are integer, long, date(yyyy-MM-dd), timestamp(yyyy-MM-dd
	// HH:mm:ssXXX or yyyy-MM-dd HH:mm:ss"), string and decimal.
	PartitionValues []*string `min:"1" type:"list"`

	// The size of the Amazon S3 object in bytes.
	//
	// Size is a required field
	Size *int64 `type:"long" required:"true"`

	// The Amazon S3 location of the object.
	//
	// Uri is a required field
	Uri *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddObjectInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddObjectInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddObjectInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddObjectInput_"}
	if s.ETag == nil {
		invalidParams.Add(request.NewErrParamRequired("ETag"))
	}
	if s.ETag != nil && len(*s.ETag) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ETag", 1))
	}
	if s.PartitionValues != nil && len(s.PartitionValues) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PartitionValues", 1))
	}
	if s.Size == nil {
		invalidParams.Add(request.NewErrParamRequired("Size"))
	}
	if s.Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("Uri"))
	}
	if s.Uri != nil && len(*s.Uri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Uri", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetETag sets the ETag field's value.
func (s *AddObjectInput_) SetETag(v string) *AddObjectInput_ {
	s.ETag = &v
	return s
}

// SetPartitionValues sets the PartitionValues field's value.
func (s *AddObjectInput_) SetPartitionValues(v []*string) *AddObjectInput_ {
	s.PartitionValues = v
	return s
}

// SetSize sets the Size field's value.
func (s *AddObjectInput_) SetSize(v int64) *AddObjectInput_ {
	s.Size = &v
	return s
}

// SetUri sets the Uri field's value.
func (s *AddObjectInput_) SetUri(v string) *AddObjectInput_ {
	s.Uri = &v
	return s
}

// A structure that you pass to indicate you want all rows in a filter.
type AllRowsWildcard struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AllRowsWildcard) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AllRowsWildcard) GoString() string {
	return s.String()
}

// A resource to be created or added already exists.
type AlreadyExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message describing the problem.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AlreadyExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AlreadyExistsException) GoString() string {
	return s.String()
}

func newErrorAlreadyExistsException(v protocol.ResponseMetadata) error {
	return &AlreadyExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AlreadyExistsException) Code() string {
	return "AlreadyExistsException"
}

// Message returns the exception's message.
func (s *AlreadyExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AlreadyExistsException) OrigErr() error {
	return nil
}

func (s *AlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AlreadyExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AlreadyExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

type AssumeDecoratedRoleWithSAMLInput struct {
	_ struct{} `type:"structure"`

	// The time period, between 900 and 43,200 seconds, for the timeout of the temporary
	// credentials.
	DurationSeconds *int64 `min:"900" type:"integer"`

	// The Amazon Resource Name (ARN) of the SAML provider in IAM that describes
	// the IdP.
	//
	// PrincipalArn is a required field
	PrincipalArn *string `type:"string" required:"true"`

	// The role that represents an IAM principal whose scope down policy allows
	// it to call credential vending APIs such as GetTemporaryTableCredentials.
	// The caller must also have iam:PassRole permission on this role.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`

	// A SAML assertion consisting of an assertion statement for the user who needs
	// temporary credentials. This must match the SAML assertion that was issued
	// to IAM. This must be Base64 encoded.
	//
	// SAMLAssertion is a required field
	SAMLAssertion *string `min:"4" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssumeDecoratedRoleWithSAMLInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssumeDecoratedRoleWithSAMLInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssumeDecoratedRoleWithSAMLInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssumeDecoratedRoleWithSAMLInput"}
	if s.DurationSeconds != nil && *s.DurationSeconds < 900 {
		invalidParams.Add(request.NewErrParamMinValue("DurationSeconds", 900))
	}
	if s.PrincipalArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalArn"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.SAMLAssertion == nil {
		invalidParams.Add(request.NewErrParamRequired("SAMLAssertion"))
	}
	if s.SAMLAssertion != nil && len(*s.SAMLAssertion) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("SAMLAssertion", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDurationSeconds sets the DurationSeconds field's value.
func (s *AssumeDecoratedRoleWithSAMLInput) SetDurationSeconds(v int64) *AssumeDecoratedRoleWithSAMLInput {
	s.DurationSeconds = &v
	return s
}

// SetPrincipalArn sets the PrincipalArn field's value.
func (s *AssumeDecoratedRoleWithSAMLInput) SetPrincipalArn(v string) *AssumeDecoratedRoleWithSAMLInput {
	s.PrincipalArn = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *AssumeDecoratedRoleWithSAMLInput) SetRoleArn(v string) *AssumeDecoratedRoleWithSAMLInput {
	s.RoleArn = &v
	return s
}

// SetSAMLAssertion sets the SAMLAssertion field's value.
func (s *AssumeDecoratedRoleWithSAMLInput) SetSAMLAssertion(v string) *AssumeDecoratedRoleWithSAMLInput {
	s.SAMLAssertion = &v
	return s
}

type AssumeDecoratedRoleWithSAMLOutput struct {
	_ struct{} `type:"structure"`

	// The access key ID for the temporary credentials. (The access key consists
	// of an access key ID and a secret key).
	AccessKeyId *string `type:"string"`

	// The date and time when the temporary credentials expire.
	Expiration *time.Time `type:"timestamp"`

	// The secret key for the temporary credentials. (The access key consists of
	// an access key ID and a secret key).
	SecretAccessKey *string `type:"string"`

	// The session token for the temporary credentials.
	SessionToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssumeDecoratedRoleWithSAMLOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssumeDecoratedRoleWithSAMLOutput) GoString() string {
	return s.String()
}

// SetAccessKeyId sets the AccessKeyId field's value.
func (s *AssumeDecoratedRoleWithSAMLOutput) SetAccessKeyId(v string) *AssumeDecoratedRoleWithSAMLOutput {
	s.AccessKeyId = &v
	return s
}

// SetExpiration sets the Expiration field's value.
func (s *AssumeDecoratedRoleWithSAMLOutput) SetExpiration(v time.Time) *AssumeDecoratedRoleWithSAMLOutput {
	s.Expiration = &v
	return s
}

// SetSecretAccessKey sets the SecretAccessKey field's value.
func (s *AssumeDecoratedRoleWithSAMLOutput) SetSecretAccessKey(v string) *AssumeDecoratedRoleWithSAMLOutput {
	s.SecretAccessKey = &v
	return s
}

// SetSessionToken sets the SessionToken field's value.
func (s *AssumeDecoratedRoleWithSAMLOutput) SetSessionToken(v string) *AssumeDecoratedRoleWithSAMLOutput {
	s.SessionToken = &v
	return s
}

// A structure used to include auditing information on the privileged API.
type AuditContext struct {
	_ struct{} `type:"structure"`

	// The filter engine can populate the 'AdditionalAuditContext' information with
	// the request ID for you to track. This information will be displayed in CloudTrail
	// log in your account.
	AdditionalAuditContext *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuditContext) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuditContext) GoString() string {
	return s.String()
}

// SetAdditionalAuditContext sets the AdditionalAuditContext field's value.
func (s *AuditContext) SetAdditionalAuditContext(v string) *AuditContext {
	s.AdditionalAuditContext = &v
	return s
}

type BatchGrantPermissionsInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, and other control information to manage your Lake Formation
	// environment.
	CatalogId *string `min:"1" type:"string"`

	// A list of up to 20 entries for resource permissions to be granted by batch
	// operation to the principal.
	//
	// Entries is a required field
	Entries []*BatchPermissionsRequestEntry `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGrantPermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGrantPermissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGrantPermissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGrantPermissionsInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.Entries == nil {
		invalidParams.Add(request.NewErrParamRequired("Entries"))
	}
	if s.Entries != nil {
		for i, v := range s.Entries {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Entries", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *BatchGrantPermissionsInput) SetCatalogId(v string) *BatchGrantPermissionsInput {
	s.CatalogId = &v
	return s
}

// SetEntries sets the Entries field's value.
func (s *BatchGrantPermissionsInput) SetEntries(v []*BatchPermissionsRequestEntry) *BatchGrantPermissionsInput {
	s.Entries = v
	return s
}

type BatchGrantPermissionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of failures to grant permissions to the resources.
	Failures []*BatchPermissionsFailureEntry `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGrantPermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGrantPermissionsOutput) GoString() string {
	return s.String()
}

// SetFailures sets the Failures field's value.
func (s *BatchGrantPermissionsOutput) SetFailures(v []*BatchPermissionsFailureEntry) *BatchGrantPermissionsOutput {
	s.Failures = v
	return s
}

// A list of failures when performing a batch grant or batch revoke operation.
type BatchPermissionsFailureEntry struct {
	_ struct{} `type:"structure"`

	// An error message that applies to the failure of the entry.
	Error *ErrorDetail `type:"structure"`

	// An identifier for an entry of the batch request.
	RequestEntry *BatchPermissionsRequestEntry `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPermissionsFailureEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPermissionsFailureEntry) GoString() string {
	return s.String()
}

// SetError sets the Error field's value.
func (s *BatchPermissionsFailureEntry) SetError(v *ErrorDetail) *BatchPermissionsFailureEntry {
	s.Error = v
	return s
}

// SetRequestEntry sets the RequestEntry field's value.
func (s *BatchPermissionsFailureEntry) SetRequestEntry(v *BatchPermissionsRequestEntry) *BatchPermissionsFailureEntry {
	s.RequestEntry = v
	return s
}

// A permission to a resource granted by batch operation to the principal.
type BatchPermissionsRequestEntry struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the batch permissions request entry.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The permissions to be granted.
	Permissions []*string `type:"list" enum:"Permission"`

	// Indicates if the option to pass permissions is granted.
	PermissionsWithGrantOption []*string `type:"list" enum:"Permission"`

	// The principal to be granted a permission.
	Principal *DataLakePrincipal `type:"structure"`

	// The resource to which the principal is to be granted a permission.
	Resource *Resource `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPermissionsRequestEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPermissionsRequestEntry) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchPermissionsRequestEntry) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchPermissionsRequestEntry"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.Principal != nil {
		if err := s.Principal.Validate(); err != nil {
			invalidParams.AddNested("Principal", err.(request.ErrInvalidParams))
		}
	}
	if s.Resource != nil {
		if err := s.Resource.Validate(); err != nil {
			invalidParams.AddNested("Resource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *BatchPermissionsRequestEntry) SetId(v string) *BatchPermissionsRequestEntry {
	s.Id = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *BatchPermissionsRequestEntry) SetPermissions(v []*string) *BatchPermissionsRequestEntry {
	s.Permissions = v
	return s
}

// SetPermissionsWithGrantOption sets the PermissionsWithGrantOption field's value.
func (s *BatchPermissionsRequestEntry) SetPermissionsWithGrantOption(v []*string) *BatchPermissionsRequestEntry {
	s.PermissionsWithGrantOption = v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *BatchPermissionsRequestEntry) SetPrincipal(v *DataLakePrincipal) *BatchPermissionsRequestEntry {
	s.Principal = v
	return s
}

// SetResource sets the Resource field's value.
func (s *BatchPermissionsRequestEntry) SetResource(v *Resource) *BatchPermissionsRequestEntry {
	s.Resource = v
	return s
}

type BatchRevokePermissionsInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, and other control information to manage your Lake Formation
	// environment.
	CatalogId *string `min:"1" type:"string"`

	// A list of up to 20 entries for resource permissions to be revoked by batch
	// operation to the principal.
	//
	// Entries is a required field
	Entries []*BatchPermissionsRequestEntry `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchRevokePermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchRevokePermissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchRevokePermissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchRevokePermissionsInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.Entries == nil {
		invalidParams.Add(request.NewErrParamRequired("Entries"))
	}
	if s.Entries != nil {
		for i, v := range s.Entries {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Entries", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *BatchRevokePermissionsInput) SetCatalogId(v string) *BatchRevokePermissionsInput {
	s.CatalogId = &v
	return s
}

// SetEntries sets the Entries field's value.
func (s *BatchRevokePermissionsInput) SetEntries(v []*BatchPermissionsRequestEntry) *BatchRevokePermissionsInput {
	s.Entries = v
	return s
}

type BatchRevokePermissionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of failures to revoke permissions to the resources.
	Failures []*BatchPermissionsFailureEntry `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchRevokePermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchRevokePermissionsOutput) GoString() string {
	return s.String()
}

// SetFailures sets the Failures field's value.
func (s *BatchRevokePermissionsOutput) SetFailures(v []*BatchPermissionsFailureEntry) *BatchRevokePermissionsOutput {
	s.Failures = v
	return s
}

type CancelTransactionInput struct {
	_ struct{} `type:"structure"`

	// The transaction to cancel.
	//
	// TransactionId is a required field
	TransactionId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelTransactionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelTransactionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelTransactionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelTransactionInput"}
	if s.TransactionId == nil {
		invalidParams.Add(request.NewErrParamRequired("TransactionId"))
	}
	if s.TransactionId != nil && len(*s.TransactionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TransactionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTransactionId sets the TransactionId field's value.
func (s *CancelTransactionInput) SetTransactionId(v string) *CancelTransactionInput {
	s.TransactionId = &v
	return s
}

type CancelTransactionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelTransactionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelTransactionOutput) GoString() string {
	return s.String()
}

// A structure for the catalog object.
type CatalogResource struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CatalogResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CatalogResource) GoString() string {
	return s.String()
}

// A structure containing the name of a column resource and the LF-tags attached
// to it.
type ColumnLFTag struct {
	_ struct{} `type:"structure"`

	// The LF-tags attached to a column resource.
	LFTags []*LFTagPair `min:"1" type:"list"`

	// The name of a column resource.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnLFTag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnLFTag) GoString() string {
	return s.String()
}

// SetLFTags sets the LFTags field's value.
func (s *ColumnLFTag) SetLFTags(v []*LFTagPair) *ColumnLFTag {
	s.LFTags = v
	return s
}

// SetName sets the Name field's value.
func (s *ColumnLFTag) SetName(v string) *ColumnLFTag {
	s.Name = &v
	return s
}

// A wildcard object, consisting of an optional list of excluded column names
// or indexes.
type ColumnWildcard struct {
	_ struct{} `type:"structure"`

	// Excludes column names. Any column with this name will be excluded.
	ExcludedColumnNames []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnWildcard) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnWildcard) GoString() string {
	return s.String()
}

// SetExcludedColumnNames sets the ExcludedColumnNames field's value.
func (s *ColumnWildcard) SetExcludedColumnNames(v []*string) *ColumnWildcard {
	s.ExcludedColumnNames = v
	return s
}

type CommitTransactionInput struct {
	_ struct{} `type:"structure"`

	// The transaction to commit.
	//
	// TransactionId is a required field
	TransactionId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CommitTransactionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CommitTransactionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CommitTransactionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CommitTransactionInput"}
	if s.TransactionId == nil {
		invalidParams.Add(request.NewErrParamRequired("TransactionId"))
	}
	if s.TransactionId != nil && len(*s.TransactionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TransactionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTransactionId sets the TransactionId field's value.
func (s *CommitTransactionInput) SetTransactionId(v string) *CommitTransactionInput {
	s.TransactionId = &v
	return s
}

type CommitTransactionOutput struct {
	_ struct{} `type:"structure"`

	// The status of the transaction.
	TransactionStatus *string `type:"string" enum:"TransactionStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CommitTransactionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CommitTransactionOutput) GoString() string {
	return s.String()
}

// SetTransactionStatus sets the TransactionStatus field's value.
func (s *CommitTransactionOutput) SetTransactionStatus(v string) *CommitTransactionOutput {
	s.TransactionStatus = &v
	return s
}

// Two processes are trying to modify a resource simultaneously.
type ConcurrentModificationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message describing the problem.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConcurrentModificationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConcurrentModificationException) GoString() string {
	return s.String()
}

func newErrorConcurrentModificationException(v protocol.ResponseMetadata) error {
	return &ConcurrentModificationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConcurrentModificationException) Code() string {
	return "ConcurrentModificationException"
}

// Message returns the exception's message.
func (s *ConcurrentModificationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConcurrentModificationException) OrigErr() error {
	return nil
}

func (s *ConcurrentModificationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConcurrentModificationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConcurrentModificationException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateDataCellsFilterInput struct {
	_ struct{} `type:"structure"`

	// A DataCellsFilter structure containing information about the data cells filter.
	//
	// TableData is a required field
	TableData *DataCellsFilter `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataCellsFilterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataCellsFilterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDataCellsFilterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDataCellsFilterInput"}
	if s.TableData == nil {
		invalidParams.Add(request.NewErrParamRequired("TableData"))
	}
	if s.TableData != nil {
		if err := s.TableData.Validate(); err != nil {
			invalidParams.AddNested("TableData", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTableData sets the TableData field's value.
func (s *CreateDataCellsFilterInput) SetTableData(v *DataCellsFilter) *CreateDataCellsFilterInput {
	s.TableData = v
	return s
}

type CreateDataCellsFilterOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataCellsFilterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataCellsFilterOutput) GoString() string {
	return s.String()
}

type CreateLFTagInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, and other control information to manage your Lake Formation
	// environment.
	CatalogId *string `min:"1" type:"string"`

	// The key-name for the LF-tag.
	//
	// TagKey is a required field
	TagKey *string `min:"1" type:"string" required:"true"`

	// A list of possible values an attribute can take.
	//
	// TagValues is a required field
	TagValues []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLFTagInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLFTagInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLFTagInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLFTagInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.TagKey == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKey"))
	}
	if s.TagKey != nil && len(*s.TagKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKey", 1))
	}
	if s.TagValues == nil {
		invalidParams.Add(request.NewErrParamRequired("TagValues"))
	}
	if s.TagValues != nil && len(s.TagValues) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagValues", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *CreateLFTagInput) SetCatalogId(v string) *CreateLFTagInput {
	s.CatalogId = &v
	return s
}

// SetTagKey sets the TagKey field's value.
func (s *CreateLFTagInput) SetTagKey(v string) *CreateLFTagInput {
	s.TagKey = &v
	return s
}

// SetTagValues sets the TagValues field's value.
func (s *CreateLFTagInput) SetTagValues(v []*string) *CreateLFTagInput {
	s.TagValues = v
	return s
}

type CreateLFTagOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLFTagOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLFTagOutput) GoString() string {
	return s.String()
}

type CreateLakeFormationIdentityCenterConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, view definitions, and other control information to manage
	// your Lake Formation environment.
	CatalogId *string `min:"1" type:"string"`

	// A list of the account IDs of Amazon Web Services accounts of third-party
	// applications that are allowed to access data managed by Lake Formation.
	ExternalFiltering *ExternalFilteringConfiguration `type:"structure"`

	// The ARN of the IAM Identity Center instance for which the operation will
	// be executed. For more information about ARNs, see Amazon Resource Names (ARNs)
	// and Amazon Web Services Service Namespaces in the Amazon Web Services General
	// Reference.
	InstanceArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLakeFormationIdentityCenterConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLakeFormationIdentityCenterConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLakeFormationIdentityCenterConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLakeFormationIdentityCenterConfigurationInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.ExternalFiltering != nil {
		if err := s.ExternalFiltering.Validate(); err != nil {
			invalidParams.AddNested("ExternalFiltering", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *CreateLakeFormationIdentityCenterConfigurationInput) SetCatalogId(v string) *CreateLakeFormationIdentityCenterConfigurationInput {
	s.CatalogId = &v
	return s
}

// SetExternalFiltering sets the ExternalFiltering field's value.
func (s *CreateLakeFormationIdentityCenterConfigurationInput) SetExternalFiltering(v *ExternalFilteringConfiguration) *CreateLakeFormationIdentityCenterConfigurationInput {
	s.ExternalFiltering = v
	return s
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *CreateLakeFormationIdentityCenterConfigurationInput) SetInstanceArn(v string) *CreateLakeFormationIdentityCenterConfigurationInput {
	s.InstanceArn = &v
	return s
}

type CreateLakeFormationIdentityCenterConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the integrated application.
	ApplicationArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLakeFormationIdentityCenterConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLakeFormationIdentityCenterConfigurationOutput) GoString() string {
	return s.String()
}

// SetApplicationArn sets the ApplicationArn field's value.
func (s *CreateLakeFormationIdentityCenterConfigurationOutput) SetApplicationArn(v string) *CreateLakeFormationIdentityCenterConfigurationOutput {
	s.ApplicationArn = &v
	return s
}

type CreateLakeFormationOptInInput struct {
	_ struct{} `type:"structure"`

	// The Lake Formation principal. Supported principals are IAM users or IAM roles.
	//
	// Principal is a required field
	Principal *DataLakePrincipal `type:"structure" required:"true"`

	// A structure for the resource.
	//
	// Resource is a required field
	Resource *Resource `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLakeFormationOptInInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLakeFormationOptInInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLakeFormationOptInInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLakeFormationOptInInput"}
	if s.Principal == nil {
		invalidParams.Add(request.NewErrParamRequired("Principal"))
	}
	if s.Resource == nil {
		invalidParams.Add(request.NewErrParamRequired("Resource"))
	}
	if s.Principal != nil {
		if err := s.Principal.Validate(); err != nil {
			invalidParams.AddNested("Principal", err.(request.ErrInvalidParams))
		}
	}
	if s.Resource != nil {
		if err := s.Resource.Validate(); err != nil {
			invalidParams.AddNested("Resource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPrincipal sets the Principal field's value.
func (s *CreateLakeFormationOptInInput) SetPrincipal(v *DataLakePrincipal) *CreateLakeFormationOptInInput {
	s.Principal = v
	return s
}

// SetResource sets the Resource field's value.
func (s *CreateLakeFormationOptInInput) SetResource(v *Resource) *CreateLakeFormationOptInInput {
	s.Resource = v
	return s
}

type CreateLakeFormationOptInOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLakeFormationOptInOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLakeFormationOptInOutput) GoString() string {
	return s.String()
}

// A structure that describes certain columns on certain rows.
type DataCellsFilter struct {
	_ struct{} `type:"structure"`

	// A list of column names and/or nested column attributes. When specifying nested
	// attributes, use a qualified dot (.) delimited format such as "address"."zip".
	// Nested attributes within this list may not exceed a depth of 5.
	ColumnNames []*string `type:"list"`

	// A wildcard with exclusions.
	//
	// You must specify either a ColumnNames list or the ColumnWildCard.
	ColumnWildcard *ColumnWildcard `type:"structure"`

	// A database in the Glue Data Catalog.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// The name given by the user to the data filter cell.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A PartiQL predicate.
	RowFilter *RowFilter `type:"structure"`

	// The ID of the catalog to which the table belongs.
	//
	// TableCatalogId is a required field
	TableCatalogId *string `min:"1" type:"string" required:"true"`

	// A table in the database.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`

	// The ID of the data cells filter version.
	VersionId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataCellsFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataCellsFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataCellsFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataCellsFilter"}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.TableCatalogId == nil {
		invalidParams.Add(request.NewErrParamRequired("TableCatalogId"))
	}
	if s.TableCatalogId != nil && len(*s.TableCatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TableCatalogId", 1))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 1))
	}
	if s.VersionId != nil && len(*s.VersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetColumnNames sets the ColumnNames field's value.
func (s *DataCellsFilter) SetColumnNames(v []*string) *DataCellsFilter {
	s.ColumnNames = v
	return s
}

// SetColumnWildcard sets the ColumnWildcard field's value.
func (s *DataCellsFilter) SetColumnWildcard(v *ColumnWildcard) *DataCellsFilter {
	s.ColumnWildcard = v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *DataCellsFilter) SetDatabaseName(v string) *DataCellsFilter {
	s.DatabaseName = &v
	return s
}

// SetName sets the Name field's value.
func (s *DataCellsFilter) SetName(v string) *DataCellsFilter {
	s.Name = &v
	return s
}

// SetRowFilter sets the RowFilter field's value.
func (s *DataCellsFilter) SetRowFilter(v *RowFilter) *DataCellsFilter {
	s.RowFilter = v
	return s
}

// SetTableCatalogId sets the TableCatalogId field's value.
func (s *DataCellsFilter) SetTableCatalogId(v string) *DataCellsFilter {
	s.TableCatalogId = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *DataCellsFilter) SetTableName(v string) *DataCellsFilter {
	s.TableName = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *DataCellsFilter) SetVersionId(v string) *DataCellsFilter {
	s.VersionId = &v
	return s
}

// A structure for a data cells filter resource.
type DataCellsFilterResource struct {
	_ struct{} `type:"structure"`

	// A database in the Glue Data Catalog.
	DatabaseName *string `min:"1" type:"string"`

	// The name of the data cells filter.
	Name *string `min:"1" type:"string"`

	// The ID of the catalog to which the table belongs.
	TableCatalogId *string `min:"1" type:"string"`

	// The name of the table.
	TableName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataCellsFilterResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataCellsFilterResource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataCellsFilterResource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataCellsFilterResource"}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.TableCatalogId != nil && len(*s.TableCatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TableCatalogId", 1))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *DataCellsFilterResource) SetDatabaseName(v string) *DataCellsFilterResource {
	s.DatabaseName = &v
	return s
}

// SetName sets the Name field's value.
func (s *DataCellsFilterResource) SetName(v string) *DataCellsFilterResource {
	s.Name = &v
	return s
}

// SetTableCatalogId sets the TableCatalogId field's value.
func (s *DataCellsFilterResource) SetTableCatalogId(v string) *DataCellsFilterResource {
	s.TableCatalogId = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *DataCellsFilterResource) SetTableName(v string) *DataCellsFilterResource {
	s.TableName = &v
	return s
}

// The Lake Formation principal. Supported principals are IAM users or IAM roles.
type DataLakePrincipal struct {
	_ struct{} `type:"structure"`

	// An identifier for the Lake Formation principal.
	DataLakePrincipalIdentifier *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataLakePrincipal) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataLakePrincipal) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataLakePrincipal) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataLakePrincipal"}
	if s.DataLakePrincipalIdentifier != nil && len(*s.DataLakePrincipalIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataLakePrincipalIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataLakePrincipalIdentifier sets the DataLakePrincipalIdentifier field's value.
func (s *DataLakePrincipal) SetDataLakePrincipalIdentifier(v string) *DataLakePrincipal {
	s.DataLakePrincipalIdentifier = &v
	return s
}

// A structure representing a list of Lake Formation principals designated as
// data lake administrators and lists of principal permission entries for default
// create database and default create table permissions.
type DataLakeSettings struct {
	_ struct{} `type:"structure"`

	// Whether to allow Amazon EMR clusters to access data managed by Lake Formation.
	//
	// If true, you allow Amazon EMR clusters to access data in Amazon S3 locations
	// that are registered with Lake Formation.
	//
	// If false or null, no Amazon EMR clusters will be able to access data in Amazon
	// S3 locations that are registered with Lake Formation.
	//
	// For more information, see (Optional) Allow external data filtering (https://docs.aws.amazon.com/lake-formation/latest/dg/initial-LF-setup.html#external-data-filter).
	AllowExternalDataFiltering *bool `type:"boolean"`

	// Whether to allow a third-party query engine to get data access credentials
	// without session tags when a caller has full data access permissions.
	AllowFullTableExternalDataAccess *bool `type:"boolean"`

	// Lake Formation relies on a privileged process secured by Amazon EMR or the
	// third party integrator to tag the user's role while assuming it. Lake Formation
	// will publish the acceptable key-value pair, for example key = "LakeFormationTrustedCaller"
	// and value = "TRUE" and the third party integrator must properly tag the temporary
	// security credentials that will be used to call Lake Formation's administrative
	// APIs.
	AuthorizedSessionTagValueList []*string `type:"list"`

	// Specifies whether access control on newly created database is managed by
	// Lake Formation permissions or exclusively by IAM permissions.
	//
	// A null value indicates access control by Lake Formation permissions. A value
	// that assigns ALL to IAM_ALLOWED_PRINCIPALS indicates access control by IAM
	// permissions. This is referred to as the setting "Use only IAM access control,"
	// and is for backward compatibility with the Glue permission model implemented
	// by IAM permissions.
	//
	// The only permitted values are an empty array or an array that contains a
	// single JSON object that grants ALL to IAM_ALLOWED_PRINCIPALS.
	//
	// For more information, see Changing the Default Security Settings for Your
	// Data Lake (https://docs.aws.amazon.com/lake-formation/latest/dg/change-settings.html).
	CreateDatabaseDefaultPermissions []*PrincipalPermissions `type:"list"`

	// Specifies whether access control on newly created table is managed by Lake
	// Formation permissions or exclusively by IAM permissions.
	//
	// A null value indicates access control by Lake Formation permissions. A value
	// that assigns ALL to IAM_ALLOWED_PRINCIPALS indicates access control by IAM
	// permissions. This is referred to as the setting "Use only IAM access control,"
	// and is for backward compatibility with the Glue permission model implemented
	// by IAM permissions.
	//
	// The only permitted values are an empty array or an array that contains a
	// single JSON object that grants ALL to IAM_ALLOWED_PRINCIPALS.
	//
	// For more information, see Changing the Default Security Settings for Your
	// Data Lake (https://docs.aws.amazon.com/lake-formation/latest/dg/change-settings.html).
	CreateTableDefaultPermissions []*PrincipalPermissions `type:"list"`

	// A list of Lake Formation principals. Supported principals are IAM users or
	// IAM roles.
	DataLakeAdmins []*DataLakePrincipal `type:"list"`

	// A list of the account IDs of Amazon Web Services accounts with Amazon EMR
	// clusters that are to perform data filtering.>
	ExternalDataFilteringAllowList []*DataLakePrincipal `type:"list"`

	// A key-value map that provides an additional configuration on your data lake.
	// CROSS_ACCOUNT_VERSION is the key you can configure in the Parameters field.
	// Accepted values for the CrossAccountVersion key are 1, 2, 3, and 4.
	Parameters map[string]*string `type:"map"`

	// A list of Lake Formation principals with only view access to the resources,
	// without the ability to make changes. Supported principals are IAM users or
	// IAM roles.
	ReadOnlyAdmins []*DataLakePrincipal `type:"list"`

	// A list of the resource-owning account IDs that the caller's account can use
	// to share their user access details (user ARNs). The user ARNs can be logged
	// in the resource owner's CloudTrail log.
	//
	// You may want to specify this property when you are in a high-trust boundary,
	// such as the same team or company.
	TrustedResourceOwners []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataLakeSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataLakeSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataLakeSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataLakeSettings"}
	if s.CreateDatabaseDefaultPermissions != nil {
		for i, v := range s.CreateDatabaseDefaultPermissions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CreateDatabaseDefaultPermissions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.CreateTableDefaultPermissions != nil {
		for i, v := range s.CreateTableDefaultPermissions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CreateTableDefaultPermissions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.DataLakeAdmins != nil {
		for i, v := range s.DataLakeAdmins {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DataLakeAdmins", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ExternalDataFilteringAllowList != nil {
		for i, v := range s.ExternalDataFilteringAllowList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ExternalDataFilteringAllowList", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ReadOnlyAdmins != nil {
		for i, v := range s.ReadOnlyAdmins {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ReadOnlyAdmins", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowExternalDataFiltering sets the AllowExternalDataFiltering field's value.
func (s *DataLakeSettings) SetAllowExternalDataFiltering(v bool) *DataLakeSettings {
	s.AllowExternalDataFiltering = &v
	return s
}

// SetAllowFullTableExternalDataAccess sets the AllowFullTableExternalDataAccess field's value.
func (s *DataLakeSettings) SetAllowFullTableExternalDataAccess(v bool) *DataLakeSettings {
	s.AllowFullTableExternalDataAccess = &v
	return s
}

// SetAuthorizedSessionTagValueList sets the AuthorizedSessionTagValueList field's value.
func (s *DataLakeSettings) SetAuthorizedSessionTagValueList(v []*string) *DataLakeSettings {
	s.AuthorizedSessionTagValueList = v
	return s
}

// SetCreateDatabaseDefaultPermissions sets the CreateDatabaseDefaultPermissions field's value.
func (s *DataLakeSettings) SetCreateDatabaseDefaultPermissions(v []*PrincipalPermissions) *DataLakeSettings {
	s.CreateDatabaseDefaultPermissions = v
	return s
}

// SetCreateTableDefaultPermissions sets the CreateTableDefaultPermissions field's value.
func (s *DataLakeSettings) SetCreateTableDefaultPermissions(v []*PrincipalPermissions) *DataLakeSettings {
	s.CreateTableDefaultPermissions = v
	return s
}

// SetDataLakeAdmins sets the DataLakeAdmins field's value.
func (s *DataLakeSettings) SetDataLakeAdmins(v []*DataLakePrincipal) *DataLakeSettings {
	s.DataLakeAdmins = v
	return s
}

// SetExternalDataFilteringAllowList sets the ExternalDataFilteringAllowList field's value.
func (s *DataLakeSettings) SetExternalDataFilteringAllowList(v []*DataLakePrincipal) *DataLakeSettings {
	s.ExternalDataFilteringAllowList = v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *DataLakeSettings) SetParameters(v map[string]*string) *DataLakeSettings {
	s.Parameters = v
	return s
}

// SetReadOnlyAdmins sets the ReadOnlyAdmins field's value.
func (s *DataLakeSettings) SetReadOnlyAdmins(v []*DataLakePrincipal) *DataLakeSettings {
	s.ReadOnlyAdmins = v
	return s
}

// SetTrustedResourceOwners sets the TrustedResourceOwners field's value.
func (s *DataLakeSettings) SetTrustedResourceOwners(v []*string) *DataLakeSettings {
	s.TrustedResourceOwners = v
	return s
}

// A structure for a data location object where permissions are granted or revoked.
type DataLocationResource struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog where the location is registered with
	// Lake Formation. By default, it is the account ID of the caller.
	CatalogId *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) that uniquely identifies the data location
	// resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataLocationResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataLocationResource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataLocationResource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataLocationResource"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *DataLocationResource) SetCatalogId(v string) *DataLocationResource {
	s.CatalogId = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *DataLocationResource) SetResourceArn(v string) *DataLocationResource {
	s.ResourceArn = &v
	return s
}

// A structure for the database object.
type DatabaseResource struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, it is the account ID of
	// the caller.
	CatalogId *string `min:"1" type:"string"`

	// The name of the database resource. Unique to the Data Catalog.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatabaseResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatabaseResource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DatabaseResource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DatabaseResource"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *DatabaseResource) SetCatalogId(v string) *DatabaseResource {
	s.CatalogId = &v
	return s
}

// SetName sets the Name field's value.
func (s *DatabaseResource) SetName(v string) *DatabaseResource {
	s.Name = &v
	return s
}

type DeleteDataCellsFilterInput struct {
	_ struct{} `type:"structure"`

	// A database in the Glue Data Catalog.
	DatabaseName *string `min:"1" type:"string"`

	// The name given by the user to the data filter cell.
	Name *string `min:"1" type:"string"`

	// The ID of the catalog to which the table belongs.
	TableCatalogId *string `min:"1" type:"string"`

	// A table in the database.
	TableName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataCellsFilterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataCellsFilterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDataCellsFilterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDataCellsFilterInput"}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.TableCatalogId != nil && len(*s.TableCatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TableCatalogId", 1))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *DeleteDataCellsFilterInput) SetDatabaseName(v string) *DeleteDataCellsFilterInput {
	s.DatabaseName = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteDataCellsFilterInput) SetName(v string) *DeleteDataCellsFilterInput {
	s.Name = &v
	return s
}

// SetTableCatalogId sets the TableCatalogId field's value.
func (s *DeleteDataCellsFilterInput) SetTableCatalogId(v string) *DeleteDataCellsFilterInput {
	s.TableCatalogId = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *DeleteDataCellsFilterInput) SetTableName(v string) *DeleteDataCellsFilterInput {
	s.TableName = &v
	return s
}

type DeleteDataCellsFilterOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataCellsFilterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataCellsFilterOutput) GoString() string {
	return s.String()
}

type DeleteLFTagInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, and other control information to manage your Lake Formation
	// environment.
	CatalogId *string `min:"1" type:"string"`

	// The key-name for the LF-tag to delete.
	//
	// TagKey is a required field
	TagKey *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLFTagInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLFTagInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLFTagInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLFTagInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.TagKey == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKey"))
	}
	if s.TagKey != nil && len(*s.TagKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKey", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *DeleteLFTagInput) SetCatalogId(v string) *DeleteLFTagInput {
	s.CatalogId = &v
	return s
}

// SetTagKey sets the TagKey field's value.
func (s *DeleteLFTagInput) SetTagKey(v string) *DeleteLFTagInput {
	s.TagKey = &v
	return s
}

type DeleteLFTagOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLFTagOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLFTagOutput) GoString() string {
	return s.String()
}

type DeleteLakeFormationIdentityCenterConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, view definition, and other control information to manage
	// your Lake Formation environment.
	CatalogId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLakeFormationIdentityCenterConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLakeFormationIdentityCenterConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLakeFormationIdentityCenterConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLakeFormationIdentityCenterConfigurationInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *DeleteLakeFormationIdentityCenterConfigurationInput) SetCatalogId(v string) *DeleteLakeFormationIdentityCenterConfigurationInput {
	s.CatalogId = &v
	return s
}

type DeleteLakeFormationIdentityCenterConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLakeFormationIdentityCenterConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLakeFormationIdentityCenterConfigurationOutput) GoString() string {
	return s.String()
}

type DeleteLakeFormationOptInInput struct {
	_ struct{} `type:"structure"`

	// The Lake Formation principal. Supported principals are IAM users or IAM roles.
	//
	// Principal is a required field
	Principal *DataLakePrincipal `type:"structure" required:"true"`

	// A structure for the resource.
	//
	// Resource is a required field
	Resource *Resource `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLakeFormationOptInInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLakeFormationOptInInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLakeFormationOptInInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLakeFormationOptInInput"}
	if s.Principal == nil {
		invalidParams.Add(request.NewErrParamRequired("Principal"))
	}
	if s.Resource == nil {
		invalidParams.Add(request.NewErrParamRequired("Resource"))
	}
	if s.Principal != nil {
		if err := s.Principal.Validate(); err != nil {
			invalidParams.AddNested("Principal", err.(request.ErrInvalidParams))
		}
	}
	if s.Resource != nil {
		if err := s.Resource.Validate(); err != nil {
			invalidParams.AddNested("Resource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPrincipal sets the Principal field's value.
func (s *DeleteLakeFormationOptInInput) SetPrincipal(v *DataLakePrincipal) *DeleteLakeFormationOptInInput {
	s.Principal = v
	return s
}

// SetResource sets the Resource field's value.
func (s *DeleteLakeFormationOptInInput) SetResource(v *Resource) *DeleteLakeFormationOptInInput {
	s.Resource = v
	return s
}

type DeleteLakeFormationOptInOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLakeFormationOptInOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLakeFormationOptInOutput) GoString() string {
	return s.String()
}

// An object to delete from the governed table.
type DeleteObjectInput_ struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 ETag of the object. Returned by GetTableObjects for validation
	// and used to identify changes to the underlying data.
	ETag *string `min:"1" type:"string"`

	// A list of partition values for the object. A value must be specified for
	// each partition key associated with the governed table.
	PartitionValues []*string `min:"1" type:"list"`

	// The Amazon S3 location of the object to delete.
	//
	// Uri is a required field
	Uri *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteObjectInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteObjectInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteObjectInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteObjectInput_"}
	if s.ETag != nil && len(*s.ETag) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ETag", 1))
	}
	if s.PartitionValues != nil && len(s.PartitionValues) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PartitionValues", 1))
	}
	if s.Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("Uri"))
	}
	if s.Uri != nil && len(*s.Uri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Uri", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetETag sets the ETag field's value.
func (s *DeleteObjectInput_) SetETag(v string) *DeleteObjectInput_ {
	s.ETag = &v
	return s
}

// SetPartitionValues sets the PartitionValues field's value.
func (s *DeleteObjectInput_) SetPartitionValues(v []*string) *DeleteObjectInput_ {
	s.PartitionValues = v
	return s
}

// SetUri sets the Uri field's value.
func (s *DeleteObjectInput_) SetUri(v string) *DeleteObjectInput_ {
	s.Uri = &v
	return s
}

type DeleteObjectsOnCancelInput struct {
	_ struct{} `type:"structure"`

	// The Glue data catalog that contains the governed table. Defaults to the current
	// account ID.
	CatalogId *string `min:"1" type:"string"`

	// The database that contains the governed table.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// A list of VirtualObject structures, which indicates the Amazon S3 objects
	// to be deleted if the transaction cancels.
	//
	// Objects is a required field
	Objects []*VirtualObject `min:"1" type:"list" required:"true"`

	// The name of the governed table.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`

	// ID of the transaction that the writes occur in.
	//
	// TransactionId is a required field
	TransactionId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteObjectsOnCancelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteObjectsOnCancelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteObjectsOnCancelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteObjectsOnCancelInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.Objects == nil {
		invalidParams.Add(request.NewErrParamRequired("Objects"))
	}
	if s.Objects != nil && len(s.Objects) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Objects", 1))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 1))
	}
	if s.TransactionId == nil {
		invalidParams.Add(request.NewErrParamRequired("TransactionId"))
	}
	if s.TransactionId != nil && len(*s.TransactionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TransactionId", 1))
	}
	if s.Objects != nil {
		for i, v := range s.Objects {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Objects", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *DeleteObjectsOnCancelInput) SetCatalogId(v string) *DeleteObjectsOnCancelInput {
	s.CatalogId = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *DeleteObjectsOnCancelInput) SetDatabaseName(v string) *DeleteObjectsOnCancelInput {
	s.DatabaseName = &v
	return s
}

// SetObjects sets the Objects field's value.
func (s *DeleteObjectsOnCancelInput) SetObjects(v []*VirtualObject) *DeleteObjectsOnCancelInput {
	s.Objects = v
	return s
}

// SetTableName sets the TableName field's value.
func (s *DeleteObjectsOnCancelInput) SetTableName(v string) *DeleteObjectsOnCancelInput {
	s.TableName = &v
	return s
}

// SetTransactionId sets the TransactionId field's value.
func (s *DeleteObjectsOnCancelInput) SetTransactionId(v string) *DeleteObjectsOnCancelInput {
	s.TransactionId = &v
	return s
}

type DeleteObjectsOnCancelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteObjectsOnCancelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteObjectsOnCancelOutput) GoString() string {
	return s.String()
}

type DeregisterResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource that you want to deregister.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeregisterResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *DeregisterResourceInput) SetResourceArn(v string) *DeregisterResourceInput {
	s.ResourceArn = &v
	return s
}

type DeregisterResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterResourceOutput) GoString() string {
	return s.String()
}

type DescribeLakeFormationIdentityCenterConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, and other control information to manage your Lake Formation
	// environment.
	CatalogId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLakeFormationIdentityCenterConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLakeFormationIdentityCenterConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLakeFormationIdentityCenterConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeLakeFormationIdentityCenterConfigurationInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *DescribeLakeFormationIdentityCenterConfigurationInput) SetCatalogId(v string) *DescribeLakeFormationIdentityCenterConfigurationInput {
	s.CatalogId = &v
	return s
}

type DescribeLakeFormationIdentityCenterConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the integrated application.
	ApplicationArn *string `type:"string"`

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, and other control information to manage your Lake Formation
	// environment.
	CatalogId *string `min:"1" type:"string"`

	// Indicates if external filtering is enabled.
	ExternalFiltering *ExternalFilteringConfiguration `type:"structure"`

	// The Amazon Resource Name (ARN) of the connection.
	InstanceArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLakeFormationIdentityCenterConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLakeFormationIdentityCenterConfigurationOutput) GoString() string {
	return s.String()
}

// SetApplicationArn sets the ApplicationArn field's value.
func (s *DescribeLakeFormationIdentityCenterConfigurationOutput) SetApplicationArn(v string) *DescribeLakeFormationIdentityCenterConfigurationOutput {
	s.ApplicationArn = &v
	return s
}

// SetCatalogId sets the CatalogId field's value.
func (s *DescribeLakeFormationIdentityCenterConfigurationOutput) SetCatalogId(v string) *DescribeLakeFormationIdentityCenterConfigurationOutput {
	s.CatalogId = &v
	return s
}

// SetExternalFiltering sets the ExternalFiltering field's value.
func (s *DescribeLakeFormationIdentityCenterConfigurationOutput) SetExternalFiltering(v *ExternalFilteringConfiguration) *DescribeLakeFormationIdentityCenterConfigurationOutput {
	s.ExternalFiltering = v
	return s
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *DescribeLakeFormationIdentityCenterConfigurationOutput) SetInstanceArn(v string) *DescribeLakeFormationIdentityCenterConfigurationOutput {
	s.InstanceArn = &v
	return s
}

type DescribeResourceInput struct {
	_ struct{} `type:"structure"`

	// The resource ARN.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *DescribeResourceInput) SetResourceArn(v string) *DescribeResourceInput {
	s.ResourceArn = &v
	return s
}

type DescribeResourceOutput struct {
	_ struct{} `type:"structure"`

	// A structure containing information about an Lake Formation resource.
	ResourceInfo *ResourceInfo `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeResourceOutput) GoString() string {
	return s.String()
}

// SetResourceInfo sets the ResourceInfo field's value.
func (s *DescribeResourceOutput) SetResourceInfo(v *ResourceInfo) *DescribeResourceOutput {
	s.ResourceInfo = v
	return s
}

type DescribeTransactionInput struct {
	_ struct{} `type:"structure"`

	// The transaction for which to return status.
	//
	// TransactionId is a required field
	TransactionId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTransactionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTransactionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTransactionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTransactionInput"}
	if s.TransactionId == nil {
		invalidParams.Add(request.NewErrParamRequired("TransactionId"))
	}
	if s.TransactionId != nil && len(*s.TransactionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TransactionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTransactionId sets the TransactionId field's value.
func (s *DescribeTransactionInput) SetTransactionId(v string) *DescribeTransactionInput {
	s.TransactionId = &v
	return s
}

type DescribeTransactionOutput struct {
	_ struct{} `type:"structure"`

	// Returns a TransactionDescription object containing information about the
	// transaction.
	TransactionDescription *TransactionDescription `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTransactionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTransactionOutput) GoString() string {
	return s.String()
}

// SetTransactionDescription sets the TransactionDescription field's value.
func (s *DescribeTransactionOutput) SetTransactionDescription(v *TransactionDescription) *DescribeTransactionOutput {
	s.TransactionDescription = v
	return s
}

// A structure containing the additional details to be returned in the AdditionalDetails
// attribute of PrincipalResourcePermissions.
//
// If a catalog resource is shared through Resource Access Manager (RAM), then
// there will exist a corresponding RAM resource share ARN.
type DetailsMap struct {
	_ struct{} `type:"structure"`

	// A resource share ARN for a catalog resource shared through RAM.
	ResourceShare []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetailsMap) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetailsMap) GoString() string {
	return s.String()
}

// SetResourceShare sets the ResourceShare field's value.
func (s *DetailsMap) SetResourceShare(v []*string) *DetailsMap {
	s.ResourceShare = v
	return s
}

// A specified entity does not exist.
type EntityNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message describing the problem.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntityNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntityNotFoundException) GoString() string {
	return s.String()
}

func newErrorEntityNotFoundException(v protocol.ResponseMetadata) error {
	return &EntityNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *EntityNotFoundException) Code() string {
	return "EntityNotFoundException"
}

// Message returns the exception's message.
func (s *EntityNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *EntityNotFoundException) OrigErr() error {
	return nil
}

func (s *EntityNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *EntityNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *EntityNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains details about an error.
type ErrorDetail struct {
	_ struct{} `type:"structure"`

	// The code associated with this error.
	ErrorCode *string `min:"1" type:"string"`

	// A message describing the error.
	ErrorMessage *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ErrorDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ErrorDetail) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *ErrorDetail) SetErrorCode(v string) *ErrorDetail {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *ErrorDetail) SetErrorMessage(v string) *ErrorDetail {
	s.ErrorMessage = &v
	return s
}

// Statistics related to the processing of a query statement.
type ExecutionStatistics struct {
	_ struct{} `type:"structure"`

	// The average time the request took to be executed.
	AverageExecutionTimeMillis *int64 `type:"long"`

	// The amount of data that was scanned in bytes.
	DataScannedBytes *int64 `type:"long"`

	// The number of work units executed.
	WorkUnitsExecutedCount *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecutionStatistics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecutionStatistics) GoString() string {
	return s.String()
}

// SetAverageExecutionTimeMillis sets the AverageExecutionTimeMillis field's value.
func (s *ExecutionStatistics) SetAverageExecutionTimeMillis(v int64) *ExecutionStatistics {
	s.AverageExecutionTimeMillis = &v
	return s
}

// SetDataScannedBytes sets the DataScannedBytes field's value.
func (s *ExecutionStatistics) SetDataScannedBytes(v int64) *ExecutionStatistics {
	s.DataScannedBytes = &v
	return s
}

// SetWorkUnitsExecutedCount sets the WorkUnitsExecutedCount field's value.
func (s *ExecutionStatistics) SetWorkUnitsExecutedCount(v int64) *ExecutionStatistics {
	s.WorkUnitsExecutedCount = &v
	return s
}

// Contains details about an error where the query request expired.
type ExpiredException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message describing the error.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExpiredException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExpiredException) GoString() string {
	return s.String()
}

func newErrorExpiredException(v protocol.ResponseMetadata) error {
	return &ExpiredException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ExpiredException) Code() string {
	return "ExpiredException"
}

// Message returns the exception's message.
func (s *ExpiredException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ExpiredException) OrigErr() error {
	return nil
}

func (s *ExpiredException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ExpiredException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ExpiredException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ExtendTransactionInput struct {
	_ struct{} `type:"structure"`

	// The transaction to extend.
	TransactionId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExtendTransactionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExtendTransactionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExtendTransactionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExtendTransactionInput"}
	if s.TransactionId != nil && len(*s.TransactionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TransactionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTransactionId sets the TransactionId field's value.
func (s *ExtendTransactionInput) SetTransactionId(v string) *ExtendTransactionInput {
	s.TransactionId = &v
	return s
}

type ExtendTransactionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExtendTransactionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExtendTransactionOutput) GoString() string {
	return s.String()
}

// Configuration for enabling external data filtering for third-party applications
// to access data managed by Lake Formation .
type ExternalFilteringConfiguration struct {
	_ struct{} `type:"structure"`

	// List of third-party application ARNs integrated with Lake Formation.
	//
	// AuthorizedTargets is a required field
	AuthorizedTargets []*string `type:"list" required:"true"`

	// Allows to enable or disable the third-party applications that are allowed
	// to access data managed by Lake Formation.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"EnableStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExternalFilteringConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExternalFilteringConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExternalFilteringConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExternalFilteringConfiguration"}
	if s.AuthorizedTargets == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthorizedTargets"))
	}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthorizedTargets sets the AuthorizedTargets field's value.
func (s *ExternalFilteringConfiguration) SetAuthorizedTargets(v []*string) *ExternalFilteringConfiguration {
	s.AuthorizedTargets = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ExternalFilteringConfiguration) SetStatus(v string) *ExternalFilteringConfiguration {
	s.Status = &v
	return s
}

// This structure describes the filtering of columns in a table based on a filter
// condition.
type FilterCondition struct {
	_ struct{} `type:"structure"`

	// The comparison operator used in the filter condition.
	ComparisonOperator *string `type:"string" enum:"ComparisonOperator"`

	// The field to filter in the filter condition.
	Field *string `type:"string" enum:"FieldNameString"`

	// A string with values used in evaluating the filter condition.
	StringValueList []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FilterCondition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FilterCondition) GoString() string {
	return s.String()
}

// SetComparisonOperator sets the ComparisonOperator field's value.
func (s *FilterCondition) SetComparisonOperator(v string) *FilterCondition {
	s.ComparisonOperator = &v
	return s
}

// SetField sets the Field field's value.
func (s *FilterCondition) SetField(v string) *FilterCondition {
	s.Field = &v
	return s
}

// SetStringValueList sets the StringValueList field's value.
func (s *FilterCondition) SetStringValueList(v []*string) *FilterCondition {
	s.StringValueList = v
	return s
}

type GetDataCellsFilterInput struct {
	_ struct{} `type:"structure"`

	// A database in the Glue Data Catalog.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// The name given by the user to the data filter cell.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The ID of the catalog to which the table belongs.
	//
	// TableCatalogId is a required field
	TableCatalogId *string `min:"1" type:"string" required:"true"`

	// A table in the database.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataCellsFilterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataCellsFilterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDataCellsFilterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDataCellsFilterInput"}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.TableCatalogId == nil {
		invalidParams.Add(request.NewErrParamRequired("TableCatalogId"))
	}
	if s.TableCatalogId != nil && len(*s.TableCatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TableCatalogId", 1))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *GetDataCellsFilterInput) SetDatabaseName(v string) *GetDataCellsFilterInput {
	s.DatabaseName = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetDataCellsFilterInput) SetName(v string) *GetDataCellsFilterInput {
	s.Name = &v
	return s
}

// SetTableCatalogId sets the TableCatalogId field's value.
func (s *GetDataCellsFilterInput) SetTableCatalogId(v string) *GetDataCellsFilterInput {
	s.TableCatalogId = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *GetDataCellsFilterInput) SetTableName(v string) *GetDataCellsFilterInput {
	s.TableName = &v
	return s
}

type GetDataCellsFilterOutput struct {
	_ struct{} `type:"structure"`

	// A structure that describes certain columns on certain rows.
	DataCellsFilter *DataCellsFilter `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataCellsFilterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataCellsFilterOutput) GoString() string {
	return s.String()
}

// SetDataCellsFilter sets the DataCellsFilter field's value.
func (s *GetDataCellsFilterOutput) SetDataCellsFilter(v *DataCellsFilter) *GetDataCellsFilterOutput {
	s.DataCellsFilter = v
	return s
}

type GetDataLakeSettingsInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, and other control information to manage your Lake Formation
	// environment.
	CatalogId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataLakeSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataLakeSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDataLakeSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDataLakeSettingsInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *GetDataLakeSettingsInput) SetCatalogId(v string) *GetDataLakeSettingsInput {
	s.CatalogId = &v
	return s
}

type GetDataLakeSettingsOutput struct {
	_ struct{} `type:"structure"`

	// A structure representing a list of Lake Formation principals designated as
	// data lake administrators.
	DataLakeSettings *DataLakeSettings `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataLakeSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataLakeSettingsOutput) GoString() string {
	return s.String()
}

// SetDataLakeSettings sets the DataLakeSettings field's value.
func (s *GetDataLakeSettingsOutput) SetDataLakeSettings(v *DataLakeSettings) *GetDataLakeSettingsOutput {
	s.DataLakeSettings = v
	return s
}

type GetEffectivePermissionsForPathInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, and other control information to manage your Lake Formation
	// environment.
	CatalogId *string `min:"1" type:"string"`

	// The maximum number of results to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// A continuation token, if this is not the first call to retrieve this list.
	NextToken *string `type:"string"`

	// The Amazon Resource Name (ARN) of the resource for which you want to get
	// permissions.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEffectivePermissionsForPathInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEffectivePermissionsForPathInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEffectivePermissionsForPathInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEffectivePermissionsForPathInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *GetEffectivePermissionsForPathInput) SetCatalogId(v string) *GetEffectivePermissionsForPathInput {
	s.CatalogId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetEffectivePermissionsForPathInput) SetMaxResults(v int64) *GetEffectivePermissionsForPathInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetEffectivePermissionsForPathInput) SetNextToken(v string) *GetEffectivePermissionsForPathInput {
	s.NextToken = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *GetEffectivePermissionsForPathInput) SetResourceArn(v string) *GetEffectivePermissionsForPathInput {
	s.ResourceArn = &v
	return s
}

type GetEffectivePermissionsForPathOutput struct {
	_ struct{} `type:"structure"`

	// A continuation token, if this is not the first call to retrieve this list.
	NextToken *string `type:"string"`

	// A list of the permissions for the specified table or database resource located
	// at the path in Amazon S3.
	Permissions []*PrincipalResourcePermissions `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEffectivePermissionsForPathOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEffectivePermissionsForPathOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetEffectivePermissionsForPathOutput) SetNextToken(v string) *GetEffectivePermissionsForPathOutput {
	s.NextToken = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *GetEffectivePermissionsForPathOutput) SetPermissions(v []*PrincipalResourcePermissions) *GetEffectivePermissionsForPathOutput {
	s.Permissions = v
	return s
}

type GetLFTagInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, and other control information to manage your Lake Formation
	// environment.
	CatalogId *string `min:"1" type:"string"`

	// The key-name for the LF-tag.
	//
	// TagKey is a required field
	TagKey *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLFTagInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLFTagInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLFTagInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetLFTagInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.TagKey == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKey"))
	}
	if s.TagKey != nil && len(*s.TagKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKey", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *GetLFTagInput) SetCatalogId(v string) *GetLFTagInput {
	s.CatalogId = &v
	return s
}

// SetTagKey sets the TagKey field's value.
func (s *GetLFTagInput) SetTagKey(v string) *GetLFTagInput {
	s.TagKey = &v
	return s
}

type GetLFTagOutput struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, and other control information to manage your Lake Formation
	// environment.
	CatalogId *string `min:"1" type:"string"`

	// The key-name for the LF-tag.
	TagKey *string `min:"1" type:"string"`

	// A list of possible values an attribute can take.
	TagValues []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLFTagOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLFTagOutput) GoString() string {
	return s.String()
}

// SetCatalogId sets the CatalogId field's value.
func (s *GetLFTagOutput) SetCatalogId(v string) *GetLFTagOutput {
	s.CatalogId = &v
	return s
}

// SetTagKey sets the TagKey field's value.
func (s *GetLFTagOutput) SetTagKey(v string) *GetLFTagOutput {
	s.TagKey = &v
	return s
}

// SetTagValues sets the TagValues field's value.
func (s *GetLFTagOutput) SetTagValues(v []*string) *GetLFTagOutput {
	s.TagValues = v
	return s
}

type GetQueryStateInput struct {
	_ struct{} `type:"structure"`

	// The ID of the plan query operation.
	//
	// QueryId is a required field
	QueryId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetQueryStateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetQueryStateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetQueryStateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetQueryStateInput"}
	if s.QueryId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryId"))
	}
	if s.QueryId != nil && len(*s.QueryId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("QueryId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetQueryId sets the QueryId field's value.
func (s *GetQueryStateInput) SetQueryId(v string) *GetQueryStateInput {
	s.QueryId = &v
	return s
}

// A structure for the output.
type GetQueryStateOutput struct {
	_ struct{} `type:"structure"`

	// An error message when the operation fails.
	Error *string `type:"string"`

	// The state of a query previously submitted. The possible states are:
	//
	//    * PENDING: the query is pending.
	//
	//    * WORKUNITS_AVAILABLE: some work units are ready for retrieval and execution.
	//
	//    * FINISHED: the query planning finished successfully, and all work units
	//    are ready for retrieval and execution.
	//
	//    * ERROR: an error occurred with the query, such as an invalid query ID
	//    or a backend error.
	//
	// State is a required field
	State *string `type:"string" required:"true" enum:"QueryStateString"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetQueryStateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetQueryStateOutput) GoString() string {
	return s.String()
}

// SetError sets the Error field's value.
func (s *GetQueryStateOutput) SetError(v string) *GetQueryStateOutput {
	s.Error = &v
	return s
}

// SetState sets the State field's value.
func (s *GetQueryStateOutput) SetState(v string) *GetQueryStateOutput {
	s.State = &v
	return s
}

type GetQueryStatisticsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the plan query operation.
	//
	// QueryId is a required field
	QueryId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetQueryStatisticsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetQueryStatisticsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetQueryStatisticsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetQueryStatisticsInput"}
	if s.QueryId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryId"))
	}
	if s.QueryId != nil && len(*s.QueryId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("QueryId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetQueryId sets the QueryId field's value.
func (s *GetQueryStatisticsInput) SetQueryId(v string) *GetQueryStatisticsInput {
	s.QueryId = &v
	return s
}

type GetQueryStatisticsOutput struct {
	_ struct{} `type:"structure"`

	// An ExecutionStatistics structure containing execution statistics.
	ExecutionStatistics *ExecutionStatistics `type:"structure"`

	// A PlanningStatistics structure containing query planning statistics.
	PlanningStatistics *PlanningStatistics `type:"structure"`

	// The time that the query was submitted.
	QuerySubmissionTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetQueryStatisticsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetQueryStatisticsOutput) GoString() string {
	return s.String()
}

// SetExecutionStatistics sets the ExecutionStatistics field's value.
func (s *GetQueryStatisticsOutput) SetExecutionStatistics(v *ExecutionStatistics) *GetQueryStatisticsOutput {
	s.ExecutionStatistics = v
	return s
}

// SetPlanningStatistics sets the PlanningStatistics field's value.
func (s *GetQueryStatisticsOutput) SetPlanningStatistics(v *PlanningStatistics) *GetQueryStatisticsOutput {
	s.PlanningStatistics = v
	return s
}

// SetQuerySubmissionTime sets the QuerySubmissionTime field's value.
func (s *GetQueryStatisticsOutput) SetQuerySubmissionTime(v time.Time) *GetQueryStatisticsOutput {
	s.QuerySubmissionTime = &v
	return s
}

type GetResourceLFTagsInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, and other control information to manage your Lake Formation
	// environment.
	CatalogId *string `min:"1" type:"string"`

	// The database, table, or column resource for which you want to return LF-tags.
	//
	// Resource is a required field
	Resource *Resource `type:"structure" required:"true"`

	// Indicates whether to show the assigned LF-tags.
	ShowAssignedLFTags *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceLFTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceLFTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResourceLFTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResourceLFTagsInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.Resource == nil {
		invalidParams.Add(request.NewErrParamRequired("Resource"))
	}
	if s.Resource != nil {
		if err := s.Resource.Validate(); err != nil {
			invalidParams.AddNested("Resource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *GetResourceLFTagsInput) SetCatalogId(v string) *GetResourceLFTagsInput {
	s.CatalogId = &v
	return s
}

// SetResource sets the Resource field's value.
func (s *GetResourceLFTagsInput) SetResource(v *Resource) *GetResourceLFTagsInput {
	s.Resource = v
	return s
}

// SetShowAssignedLFTags sets the ShowAssignedLFTags field's value.
func (s *GetResourceLFTagsInput) SetShowAssignedLFTags(v bool) *GetResourceLFTagsInput {
	s.ShowAssignedLFTags = &v
	return s
}

type GetResourceLFTagsOutput struct {
	_ struct{} `type:"structure"`

	// A list of LF-tags applied to a database resource.
	LFTagOnDatabase []*LFTagPair `min:"1" type:"list"`

	// A list of LF-tags applied to a column resource.
	LFTagsOnColumns []*ColumnLFTag `type:"list"`

	// A list of LF-tags applied to a table resource.
	LFTagsOnTable []*LFTagPair `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceLFTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceLFTagsOutput) GoString() string {
	return s.String()
}

// SetLFTagOnDatabase sets the LFTagOnDatabase field's value.
func (s *GetResourceLFTagsOutput) SetLFTagOnDatabase(v []*LFTagPair) *GetResourceLFTagsOutput {
	s.LFTagOnDatabase = v
	return s
}

// SetLFTagsOnColumns sets the LFTagsOnColumns field's value.
func (s *GetResourceLFTagsOutput) SetLFTagsOnColumns(v []*ColumnLFTag) *GetResourceLFTagsOutput {
	s.LFTagsOnColumns = v
	return s
}

// SetLFTagsOnTable sets the LFTagsOnTable field's value.
func (s *GetResourceLFTagsOutput) SetLFTagsOnTable(v []*LFTagPair) *GetResourceLFTagsOutput {
	s.LFTagsOnTable = v
	return s
}

type GetTableObjectsInput struct {
	_ struct{} `type:"structure"`

	// The catalog containing the governed table. Defaults to the caller’s account.
	CatalogId *string `min:"1" type:"string"`

	// The database containing the governed table.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// Specifies how many values to return in a page.
	MaxResults *int64 `min:"1" type:"integer"`

	// A continuation token if this is not the first call to retrieve these objects.
	NextToken *string `type:"string"`

	// A predicate to filter the objects returned based on the partition keys defined
	// in the governed table.
	//
	//    * The comparison operators supported are: =, >, <, >=, <=
	//
	//    * The logical operators supported are: AND
	//
	//    * The data types supported are integer, long, date(yyyy-MM-dd), timestamp(yyyy-MM-dd
	//    HH:mm:ssXXX or yyyy-MM-dd HH:mm:ss"), string and decimal.
	PartitionPredicate *string `type:"string"`

	// The time as of when to read the governed table contents. If not set, the
	// most recent transaction commit time is used. Cannot be specified along with
	// TransactionId.
	QueryAsOfTime *time.Time `type:"timestamp"`

	// The governed table for which to retrieve objects.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`

	// The transaction ID at which to read the governed table contents. If this
	// transaction has aborted, an error is returned. If not set, defaults to the
	// most recent committed transaction. Cannot be specified along with QueryAsOfTime.
	TransactionId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTableObjectsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTableObjectsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTableObjectsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTableObjectsInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 1))
	}
	if s.TransactionId != nil && len(*s.TransactionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TransactionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *GetTableObjectsInput) SetCatalogId(v string) *GetTableObjectsInput {
	s.CatalogId = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *GetTableObjectsInput) SetDatabaseName(v string) *GetTableObjectsInput {
	s.DatabaseName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetTableObjectsInput) SetMaxResults(v int64) *GetTableObjectsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetTableObjectsInput) SetNextToken(v string) *GetTableObjectsInput {
	s.NextToken = &v
	return s
}

// SetPartitionPredicate sets the PartitionPredicate field's value.
func (s *GetTableObjectsInput) SetPartitionPredicate(v string) *GetTableObjectsInput {
	s.PartitionPredicate = &v
	return s
}

// SetQueryAsOfTime sets the QueryAsOfTime field's value.
func (s *GetTableObjectsInput) SetQueryAsOfTime(v time.Time) *GetTableObjectsInput {
	s.QueryAsOfTime = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *GetTableObjectsInput) SetTableName(v string) *GetTableObjectsInput {
	s.TableName = &v
	return s
}

// SetTransactionId sets the TransactionId field's value.
func (s *GetTableObjectsInput) SetTransactionId(v string) *GetTableObjectsInput {
	s.TransactionId = &v
	return s
}

type GetTableObjectsOutput struct {
	_ struct{} `type:"structure"`

	// A continuation token indicating whether additional data is available.
	NextToken *string `type:"string"`

	// A list of objects organized by partition keys.
	Objects []*PartitionObjects `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTableObjectsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTableObjectsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetTableObjectsOutput) SetNextToken(v string) *GetTableObjectsOutput {
	s.NextToken = &v
	return s
}

// SetObjects sets the Objects field's value.
func (s *GetTableObjectsOutput) SetObjects(v []*PartitionObjects) *GetTableObjectsOutput {
	s.Objects = v
	return s
}

type GetTemporaryGluePartitionCredentialsInput struct {
	_ struct{} `type:"structure"`

	// A structure representing context to access a resource (column names, query
	// ID, etc).
	AuditContext *AuditContext `type:"structure"`

	// The time period, between 900 and 21,600 seconds, for the timeout of the temporary
	// credentials.
	DurationSeconds *int64 `min:"900" type:"integer"`

	// A list of partition values identifying a single partition.
	//
	// Partition is a required field
	Partition *PartitionValueList `type:"structure" required:"true"`

	// Filters the request based on the user having been granted a list of specified
	// permissions on the requested resource(s).
	Permissions []*string `type:"list" enum:"Permission"`

	// A list of supported permission types for the partition. Valid values are
	// COLUMN_PERMISSION and CELL_FILTER_PERMISSION.
	SupportedPermissionTypes []*string `min:"1" type:"list" enum:"PermissionType"`

	// The ARN of the partitions' table.
	//
	// TableArn is a required field
	TableArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTemporaryGluePartitionCredentialsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTemporaryGluePartitionCredentialsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTemporaryGluePartitionCredentialsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTemporaryGluePartitionCredentialsInput"}
	if s.DurationSeconds != nil && *s.DurationSeconds < 900 {
		invalidParams.Add(request.NewErrParamMinValue("DurationSeconds", 900))
	}
	if s.Partition == nil {
		invalidParams.Add(request.NewErrParamRequired("Partition"))
	}
	if s.SupportedPermissionTypes != nil && len(s.SupportedPermissionTypes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SupportedPermissionTypes", 1))
	}
	if s.TableArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TableArn"))
	}
	if s.Partition != nil {
		if err := s.Partition.Validate(); err != nil {
			invalidParams.AddNested("Partition", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuditContext sets the AuditContext field's value.
func (s *GetTemporaryGluePartitionCredentialsInput) SetAuditContext(v *AuditContext) *GetTemporaryGluePartitionCredentialsInput {
	s.AuditContext = v
	return s
}

// SetDurationSeconds sets the DurationSeconds field's value.
func (s *GetTemporaryGluePartitionCredentialsInput) SetDurationSeconds(v int64) *GetTemporaryGluePartitionCredentialsInput {
	s.DurationSeconds = &v
	return s
}

// SetPartition sets the Partition field's value.
func (s *GetTemporaryGluePartitionCredentialsInput) SetPartition(v *PartitionValueList) *GetTemporaryGluePartitionCredentialsInput {
	s.Partition = v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *GetTemporaryGluePartitionCredentialsInput) SetPermissions(v []*string) *GetTemporaryGluePartitionCredentialsInput {
	s.Permissions = v
	return s
}

// SetSupportedPermissionTypes sets the SupportedPermissionTypes field's value.
func (s *GetTemporaryGluePartitionCredentialsInput) SetSupportedPermissionTypes(v []*string) *GetTemporaryGluePartitionCredentialsInput {
	s.SupportedPermissionTypes = v
	return s
}

// SetTableArn sets the TableArn field's value.
func (s *GetTemporaryGluePartitionCredentialsInput) SetTableArn(v string) *GetTemporaryGluePartitionCredentialsInput {
	s.TableArn = &v
	return s
}

type GetTemporaryGluePartitionCredentialsOutput struct {
	_ struct{} `type:"structure"`

	// The access key ID for the temporary credentials.
	AccessKeyId *string `type:"string"`

	// The date and time when the temporary credentials expire.
	Expiration *time.Time `type:"timestamp"`

	// The secret key for the temporary credentials.
	SecretAccessKey *string `type:"string"`

	// The session token for the temporary credentials.
	SessionToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTemporaryGluePartitionCredentialsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTemporaryGluePartitionCredentialsOutput) GoString() string {
	return s.String()
}

// SetAccessKeyId sets the AccessKeyId field's value.
func (s *GetTemporaryGluePartitionCredentialsOutput) SetAccessKeyId(v string) *GetTemporaryGluePartitionCredentialsOutput {
	s.AccessKeyId = &v
	return s
}

// SetExpiration sets the Expiration field's value.
func (s *GetTemporaryGluePartitionCredentialsOutput) SetExpiration(v time.Time) *GetTemporaryGluePartitionCredentialsOutput {
	s.Expiration = &v
	return s
}

// SetSecretAccessKey sets the SecretAccessKey field's value.
func (s *GetTemporaryGluePartitionCredentialsOutput) SetSecretAccessKey(v string) *GetTemporaryGluePartitionCredentialsOutput {
	s.SecretAccessKey = &v
	return s
}

// SetSessionToken sets the SessionToken field's value.
func (s *GetTemporaryGluePartitionCredentialsOutput) SetSessionToken(v string) *GetTemporaryGluePartitionCredentialsOutput {
	s.SessionToken = &v
	return s
}

type GetTemporaryGlueTableCredentialsInput struct {
	_ struct{} `type:"structure"`

	// A structure representing context to access a resource (column names, query
	// ID, etc).
	AuditContext *AuditContext `type:"structure"`

	// The time period, between 900 and 21,600 seconds, for the timeout of the temporary
	// credentials.
	DurationSeconds *int64 `min:"900" type:"integer"`

	// Filters the request based on the user having been granted a list of specified
	// permissions on the requested resource(s).
	Permissions []*string `type:"list" enum:"Permission"`

	// A structure used as a protocol between query engines and Lake Formation or
	// Glue. Contains both a Lake Formation generated authorization identifier and
	// information from the request's authorization context.
	QuerySessionContext *QuerySessionContext `type:"structure"`

	// The Amazon S3 path for the table.
	S3Path *string `type:"string"`

	// A list of supported permission types for the table. Valid values are COLUMN_PERMISSION
	// and CELL_FILTER_PERMISSION.
	SupportedPermissionTypes []*string `min:"1" type:"list" enum:"PermissionType"`

	// The ARN identifying a table in the Data Catalog for the temporary credentials
	// request.
	//
	// TableArn is a required field
	TableArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTemporaryGlueTableCredentialsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTemporaryGlueTableCredentialsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTemporaryGlueTableCredentialsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTemporaryGlueTableCredentialsInput"}
	if s.DurationSeconds != nil && *s.DurationSeconds < 900 {
		invalidParams.Add(request.NewErrParamMinValue("DurationSeconds", 900))
	}
	if s.SupportedPermissionTypes != nil && len(s.SupportedPermissionTypes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SupportedPermissionTypes", 1))
	}
	if s.TableArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TableArn"))
	}
	if s.QuerySessionContext != nil {
		if err := s.QuerySessionContext.Validate(); err != nil {
			invalidParams.AddNested("QuerySessionContext", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuditContext sets the AuditContext field's value.
func (s *GetTemporaryGlueTableCredentialsInput) SetAuditContext(v *AuditContext) *GetTemporaryGlueTableCredentialsInput {
	s.AuditContext = v
	return s
}

// SetDurationSeconds sets the DurationSeconds field's value.
func (s *GetTemporaryGlueTableCredentialsInput) SetDurationSeconds(v int64) *GetTemporaryGlueTableCredentialsInput {
	s.DurationSeconds = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *GetTemporaryGlueTableCredentialsInput) SetPermissions(v []*string) *GetTemporaryGlueTableCredentialsInput {
	s.Permissions = v
	return s
}

// SetQuerySessionContext sets the QuerySessionContext field's value.
func (s *GetTemporaryGlueTableCredentialsInput) SetQuerySessionContext(v *QuerySessionContext) *GetTemporaryGlueTableCredentialsInput {
	s.QuerySessionContext = v
	return s
}

// SetS3Path sets the S3Path field's value.
func (s *GetTemporaryGlueTableCredentialsInput) SetS3Path(v string) *GetTemporaryGlueTableCredentialsInput {
	s.S3Path = &v
	return s
}

// SetSupportedPermissionTypes sets the SupportedPermissionTypes field's value.
func (s *GetTemporaryGlueTableCredentialsInput) SetSupportedPermissionTypes(v []*string) *GetTemporaryGlueTableCredentialsInput {
	s.SupportedPermissionTypes = v
	return s
}

// SetTableArn sets the TableArn field's value.
func (s *GetTemporaryGlueTableCredentialsInput) SetTableArn(v string) *GetTemporaryGlueTableCredentialsInput {
	s.TableArn = &v
	return s
}

type GetTemporaryGlueTableCredentialsOutput struct {
	_ struct{} `type:"structure"`

	// The access key ID for the temporary credentials.
	AccessKeyId *string `type:"string"`

	// The date and time when the temporary credentials expire.
	Expiration *time.Time `type:"timestamp"`

	// The secret key for the temporary credentials.
	SecretAccessKey *string `type:"string"`

	// The session token for the temporary credentials.
	SessionToken *string `type:"string"`

	// The Amazon S3 path for the temporary credentials.
	VendedS3Path []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTemporaryGlueTableCredentialsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTemporaryGlueTableCredentialsOutput) GoString() string {
	return s.String()
}

// SetAccessKeyId sets the AccessKeyId field's value.
func (s *GetTemporaryGlueTableCredentialsOutput) SetAccessKeyId(v string) *GetTemporaryGlueTableCredentialsOutput {
	s.AccessKeyId = &v
	return s
}

// SetExpiration sets the Expiration field's value.
func (s *GetTemporaryGlueTableCredentialsOutput) SetExpiration(v time.Time) *GetTemporaryGlueTableCredentialsOutput {
	s.Expiration = &v
	return s
}

// SetSecretAccessKey sets the SecretAccessKey field's value.
func (s *GetTemporaryGlueTableCredentialsOutput) SetSecretAccessKey(v string) *GetTemporaryGlueTableCredentialsOutput {
	s.SecretAccessKey = &v
	return s
}

// SetSessionToken sets the SessionToken field's value.
func (s *GetTemporaryGlueTableCredentialsOutput) SetSessionToken(v string) *GetTemporaryGlueTableCredentialsOutput {
	s.SessionToken = &v
	return s
}

// SetVendedS3Path sets the VendedS3Path field's value.
func (s *GetTemporaryGlueTableCredentialsOutput) SetVendedS3Path(v []*string) *GetTemporaryGlueTableCredentialsOutput {
	s.VendedS3Path = v
	return s
}

type GetWorkUnitResultsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the plan query operation for which to get results.
	//
	// QueryId is a required field
	QueryId *string `min:"36" type:"string" required:"true"`

	// The work unit ID for which to get results. Value generated by enumerating
	// WorkUnitIdMin to WorkUnitIdMax (inclusive) from the WorkUnitRange in the
	// output of GetWorkUnits.
	//
	// WorkUnitId is a required field
	WorkUnitId *int64 `type:"long" required:"true"`

	// A work token used to query the execution service. Token output from GetWorkUnits.
	//
	// WorkUnitToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetWorkUnitResultsInput's
	// String and GoString methods.
	//
	// WorkUnitToken is a required field
	WorkUnitToken *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkUnitResultsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkUnitResultsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetWorkUnitResultsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetWorkUnitResultsInput"}
	if s.QueryId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryId"))
	}
	if s.QueryId != nil && len(*s.QueryId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("QueryId", 36))
	}
	if s.WorkUnitId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkUnitId"))
	}
	if s.WorkUnitToken == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkUnitToken"))
	}
	if s.WorkUnitToken != nil && len(*s.WorkUnitToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkUnitToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetQueryId sets the QueryId field's value.
func (s *GetWorkUnitResultsInput) SetQueryId(v string) *GetWorkUnitResultsInput {
	s.QueryId = &v
	return s
}

// SetWorkUnitId sets the WorkUnitId field's value.
func (s *GetWorkUnitResultsInput) SetWorkUnitId(v int64) *GetWorkUnitResultsInput {
	s.WorkUnitId = &v
	return s
}

// SetWorkUnitToken sets the WorkUnitToken field's value.
func (s *GetWorkUnitResultsInput) SetWorkUnitToken(v string) *GetWorkUnitResultsInput {
	s.WorkUnitToken = &v
	return s
}

// A structure for the output.
type GetWorkUnitResultsOutput struct {
	_ struct{} `type:"structure" payload:"ResultStream"`

	// Rows returned from the GetWorkUnitResults operation as a stream of Apache
	// Arrow v1.0 messages.
	ResultStream io.ReadCloser `type:"blob"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkUnitResultsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkUnitResultsOutput) GoString() string {
	return s.String()
}

// SetResultStream sets the ResultStream field's value.
func (s *GetWorkUnitResultsOutput) SetResultStream(v io.ReadCloser) *GetWorkUnitResultsOutput {
	s.ResultStream = v
	return s
}

type GetWorkUnitsInput struct {
	_ struct{} `type:"structure"`

	// A continuation token, if this is a continuation call.
	NextToken *string `type:"string"`

	// The size of each page to get in the Amazon Web Services service call. This
	// does not affect the number of items returned in the command's output. Setting
	// a smaller page size results in more calls to the Amazon Web Services service,
	// retrieving fewer items in each call. This can help prevent the Amazon Web
	// Services service calls from timing out.
	PageSize *int64 `type:"integer"`

	// The ID of the plan query operation.
	//
	// QueryId is a required field
	QueryId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkUnitsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkUnitsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetWorkUnitsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetWorkUnitsInput"}
	if s.QueryId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryId"))
	}
	if s.QueryId != nil && len(*s.QueryId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("QueryId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *GetWorkUnitsInput) SetNextToken(v string) *GetWorkUnitsInput {
	s.NextToken = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *GetWorkUnitsInput) SetPageSize(v int64) *GetWorkUnitsInput {
	s.PageSize = &v
	return s
}

// SetQueryId sets the QueryId field's value.
func (s *GetWorkUnitsInput) SetQueryId(v string) *GetWorkUnitsInput {
	s.QueryId = &v
	return s
}

// A structure for the output.
type GetWorkUnitsOutput struct {
	_ struct{} `type:"structure"`

	// A continuation token for paginating the returned list of tokens, returned
	// if the current segment of the list is not the last.
	NextToken *string `type:"string"`

	// The ID of the plan query operation.
	//
	// QueryId is a required field
	QueryId *string `type:"string" required:"true"`

	// A WorkUnitRangeList object that specifies the valid range of work unit IDs
	// for querying the execution service.
	//
	// WorkUnitRanges is a required field
	WorkUnitRanges []*WorkUnitRange `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkUnitsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkUnitsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetWorkUnitsOutput) SetNextToken(v string) *GetWorkUnitsOutput {
	s.NextToken = &v
	return s
}

// SetQueryId sets the QueryId field's value.
func (s *GetWorkUnitsOutput) SetQueryId(v string) *GetWorkUnitsOutput {
	s.QueryId = &v
	return s
}

// SetWorkUnitRanges sets the WorkUnitRanges field's value.
func (s *GetWorkUnitsOutput) SetWorkUnitRanges(v []*WorkUnitRange) *GetWorkUnitsOutput {
	s.WorkUnitRanges = v
	return s
}

// An encryption operation failed.
type GlueEncryptionException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message describing the problem.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GlueEncryptionException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GlueEncryptionException) GoString() string {
	return s.String()
}

func newErrorGlueEncryptionException(v protocol.ResponseMetadata) error {
	return &GlueEncryptionException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *GlueEncryptionException) Code() string {
	return "GlueEncryptionException"
}

// Message returns the exception's message.
func (s *GlueEncryptionException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *GlueEncryptionException) OrigErr() error {
	return nil
}

func (s *GlueEncryptionException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *GlueEncryptionException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *GlueEncryptionException) RequestID() string {
	return s.RespMetadata.RequestID
}

type GrantPermissionsInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, and other control information to manage your Lake Formation
	// environment.
	CatalogId *string `min:"1" type:"string"`

	// The permissions granted to the principal on the resource. Lake Formation
	// defines privileges to grant and revoke access to metadata in the Data Catalog
	// and data organized in underlying data storage such as Amazon S3. Lake Formation
	// requires that each principal be authorized to perform a specific task on
	// Lake Formation resources.
	//
	// Permissions is a required field
	Permissions []*string `type:"list" required:"true" enum:"Permission"`

	// Indicates a list of the granted permissions that the principal may pass to
	// other users. These permissions may only be a subset of the permissions granted
	// in the Privileges.
	PermissionsWithGrantOption []*string `type:"list" enum:"Permission"`

	// The principal to be granted the permissions on the resource. Supported principals
	// are IAM users or IAM roles, and they are defined by their principal type
	// and their ARN.
	//
	// Note that if you define a resource with a particular ARN, then later delete,
	// and recreate a resource with that same ARN, the resource maintains the permissions
	// already granted.
	//
	// Principal is a required field
	Principal *DataLakePrincipal `type:"structure" required:"true"`

	// The resource to which permissions are to be granted. Resources in Lake Formation
	// are the Data Catalog, databases, and tables.
	//
	// Resource is a required field
	Resource *Resource `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GrantPermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GrantPermissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GrantPermissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GrantPermissionsInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.Permissions == nil {
		invalidParams.Add(request.NewErrParamRequired("Permissions"))
	}
	if s.Principal == nil {
		invalidParams.Add(request.NewErrParamRequired("Principal"))
	}
	if s.Resource == nil {
		invalidParams.Add(request.NewErrParamRequired("Resource"))
	}
	if s.Principal != nil {
		if err := s.Principal.Validate(); err != nil {
			invalidParams.AddNested("Principal", err.(request.ErrInvalidParams))
		}
	}
	if s.Resource != nil {
		if err := s.Resource.Validate(); err != nil {
			invalidParams.AddNested("Resource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *GrantPermissionsInput) SetCatalogId(v string) *GrantPermissionsInput {
	s.CatalogId = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *GrantPermissionsInput) SetPermissions(v []*string) *GrantPermissionsInput {
	s.Permissions = v
	return s
}

// SetPermissionsWithGrantOption sets the PermissionsWithGrantOption field's value.
func (s *GrantPermissionsInput) SetPermissionsWithGrantOption(v []*string) *GrantPermissionsInput {
	s.PermissionsWithGrantOption = v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *GrantPermissionsInput) SetPrincipal(v *DataLakePrincipal) *GrantPermissionsInput {
	s.Principal = v
	return s
}

// SetResource sets the Resource field's value.
func (s *GrantPermissionsInput) SetResource(v *Resource) *GrantPermissionsInput {
	s.Resource = v
	return s
}

type GrantPermissionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GrantPermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GrantPermissionsOutput) GoString() string {
	return s.String()
}

// An internal service error occurred.
type InternalServiceException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message describing the problem.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServiceException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServiceException) GoString() string {
	return s.String()
}

func newErrorInternalServiceException(v protocol.ResponseMetadata) error {
	return &InternalServiceException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServiceException) Code() string {
	return "InternalServiceException"
}

// Message returns the exception's message.
func (s *InternalServiceException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServiceException) OrigErr() error {
	return nil
}

func (s *InternalServiceException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServiceException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServiceException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The input provided was not valid.
type InvalidInputException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message describing the problem.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidInputException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidInputException) GoString() string {
	return s.String()
}

func newErrorInvalidInputException(v protocol.ResponseMetadata) error {
	return &InvalidInputException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidInputException) Code() string {
	return "InvalidInputException"
}

// Message returns the exception's message.
func (s *InvalidInputException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidInputException) OrigErr() error {
	return nil
}

func (s *InvalidInputException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidInputException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidInputException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A structure that allows an admin to grant user permissions on certain conditions.
// For example, granting a role access to all columns that do not have the LF-tag
// 'PII' in tables that have the LF-tag 'Prod'.
type LFTag struct {
	_ struct{} `type:"structure"`

	// The key-name for the LF-tag.
	//
	// TagKey is a required field
	TagKey *string `min:"1" type:"string" required:"true"`

	// A list of possible values an attribute can take.
	//
	// The maximum number of values that can be defined for a LF-Tag is 1000. A
	// single API call supports 50 values. You can use multiple API calls to add
	// more values.
	//
	// TagValues is a required field
	TagValues []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LFTag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LFTag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LFTag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LFTag"}
	if s.TagKey == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKey"))
	}
	if s.TagKey != nil && len(*s.TagKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKey", 1))
	}
	if s.TagValues == nil {
		invalidParams.Add(request.NewErrParamRequired("TagValues"))
	}
	if s.TagValues != nil && len(s.TagValues) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagValues", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTagKey sets the TagKey field's value.
func (s *LFTag) SetTagKey(v string) *LFTag {
	s.TagKey = &v
	return s
}

// SetTagValues sets the TagValues field's value.
func (s *LFTag) SetTagValues(v []*string) *LFTag {
	s.TagValues = v
	return s
}

// A structure containing an error related to a TagResource or UnTagResource
// operation.
type LFTagError struct {
	_ struct{} `type:"structure"`

	// An error that occurred with the attachment or detachment of the LF-tag.
	Error *ErrorDetail `type:"structure"`

	// The key-name of the LF-tag.
	LFTag *LFTagPair `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LFTagError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LFTagError) GoString() string {
	return s.String()
}

// SetError sets the Error field's value.
func (s *LFTagError) SetError(v *ErrorDetail) *LFTagError {
	s.Error = v
	return s
}

// SetLFTag sets the LFTag field's value.
func (s *LFTagError) SetLFTag(v *LFTagPair) *LFTagError {
	s.LFTag = v
	return s
}

// A structure containing an LF-tag key and values for a resource.
type LFTagKeyResource struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, and other control information to manage your Lake Formation
	// environment.
	CatalogId *string `min:"1" type:"string"`

	// The key-name for the LF-tag.
	//
	// TagKey is a required field
	TagKey *string `min:"1" type:"string" required:"true"`

	// A list of possible values an attribute can take.
	//
	// TagValues is a required field
	TagValues []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LFTagKeyResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LFTagKeyResource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LFTagKeyResource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LFTagKeyResource"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.TagKey == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKey"))
	}
	if s.TagKey != nil && len(*s.TagKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKey", 1))
	}
	if s.TagValues == nil {
		invalidParams.Add(request.NewErrParamRequired("TagValues"))
	}
	if s.TagValues != nil && len(s.TagValues) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagValues", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *LFTagKeyResource) SetCatalogId(v string) *LFTagKeyResource {
	s.CatalogId = &v
	return s
}

// SetTagKey sets the TagKey field's value.
func (s *LFTagKeyResource) SetTagKey(v string) *LFTagKeyResource {
	s.TagKey = &v
	return s
}

// SetTagValues sets the TagValues field's value.
func (s *LFTagKeyResource) SetTagValues(v []*string) *LFTagKeyResource {
	s.TagValues = v
	return s
}

// A structure containing an LF-tag key-value pair.
type LFTagPair struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, and other control information to manage your Lake Formation
	// environment.
	CatalogId *string `min:"1" type:"string"`

	// The key-name for the LF-tag.
	//
	// TagKey is a required field
	TagKey *string `min:"1" type:"string" required:"true"`

	// A list of possible values an attribute can take.
	//
	// TagValues is a required field
	TagValues []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LFTagPair) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LFTagPair) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LFTagPair) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LFTagPair"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.TagKey == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKey"))
	}
	if s.TagKey != nil && len(*s.TagKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKey", 1))
	}
	if s.TagValues == nil {
		invalidParams.Add(request.NewErrParamRequired("TagValues"))
	}
	if s.TagValues != nil && len(s.TagValues) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagValues", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *LFTagPair) SetCatalogId(v string) *LFTagPair {
	s.CatalogId = &v
	return s
}

// SetTagKey sets the TagKey field's value.
func (s *LFTagPair) SetTagKey(v string) *LFTagPair {
	s.TagKey = &v
	return s
}

// SetTagValues sets the TagValues field's value.
func (s *LFTagPair) SetTagValues(v []*string) *LFTagPair {
	s.TagValues = v
	return s
}

// A structure containing a list of LF-tag conditions that apply to a resource's
// LF-tag policy.
type LFTagPolicyResource struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, and other control information to manage your Lake Formation
	// environment.
	CatalogId *string `min:"1" type:"string"`

	// A list of LF-tag conditions that apply to the resource's LF-tag policy.
	//
	// Expression is a required field
	Expression []*LFTag `type:"list" required:"true"`

	// The resource type for which the LF-tag policy applies.
	//
	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true" enum:"ResourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LFTagPolicyResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LFTagPolicyResource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LFTagPolicyResource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LFTagPolicyResource"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.Expression == nil {
		invalidParams.Add(request.NewErrParamRequired("Expression"))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}
	if s.Expression != nil {
		for i, v := range s.Expression {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Expression", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *LFTagPolicyResource) SetCatalogId(v string) *LFTagPolicyResource {
	s.CatalogId = &v
	return s
}

// SetExpression sets the Expression field's value.
func (s *LFTagPolicyResource) SetExpression(v []*LFTag) *LFTagPolicyResource {
	s.Expression = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *LFTagPolicyResource) SetResourceType(v string) *LFTagPolicyResource {
	s.ResourceType = &v
	return s
}

// A single principal-resource pair that has Lake Formation permissins enforced.
type LakeFormationOptInsInfo struct {
	_ struct{} `type:"structure"`

	// The last modified date and time of the record.
	LastModified *time.Time `type:"timestamp"`

	// The user who updated the record.
	LastUpdatedBy *string `min:"1" type:"string"`

	// The Lake Formation principal. Supported principals are IAM users or IAM roles.
	Principal *DataLakePrincipal `type:"structure"`

	// A structure for the resource.
	Resource *Resource `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LakeFormationOptInsInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LakeFormationOptInsInfo) GoString() string {
	return s.String()
}

// SetLastModified sets the LastModified field's value.
func (s *LakeFormationOptInsInfo) SetLastModified(v time.Time) *LakeFormationOptInsInfo {
	s.LastModified = &v
	return s
}

// SetLastUpdatedBy sets the LastUpdatedBy field's value.
func (s *LakeFormationOptInsInfo) SetLastUpdatedBy(v string) *LakeFormationOptInsInfo {
	s.LastUpdatedBy = &v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *LakeFormationOptInsInfo) SetPrincipal(v *DataLakePrincipal) *LakeFormationOptInsInfo {
	s.Principal = v
	return s
}

// SetResource sets the Resource field's value.
func (s *LakeFormationOptInsInfo) SetResource(v *Resource) *LakeFormationOptInsInfo {
	s.Resource = v
	return s
}

type ListDataCellsFilterInput struct {
	_ struct{} `type:"structure"`

	// The maximum size of the response.
	MaxResults *int64 `min:"1" type:"integer"`

	// A continuation token, if this is a continuation call.
	NextToken *string `type:"string"`

	// A table in the Glue Data Catalog.
	Table *TableResource `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataCellsFilterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataCellsFilterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDataCellsFilterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDataCellsFilterInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Table != nil {
		if err := s.Table.Validate(); err != nil {
			invalidParams.AddNested("Table", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDataCellsFilterInput) SetMaxResults(v int64) *ListDataCellsFilterInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDataCellsFilterInput) SetNextToken(v string) *ListDataCellsFilterInput {
	s.NextToken = &v
	return s
}

// SetTable sets the Table field's value.
func (s *ListDataCellsFilterInput) SetTable(v *TableResource) *ListDataCellsFilterInput {
	s.Table = v
	return s
}

type ListDataCellsFilterOutput struct {
	_ struct{} `type:"structure"`

	// A list of DataCellFilter structures.
	DataCellsFilters []*DataCellsFilter `type:"list"`

	// A continuation token, if not all requested data cell filters have been returned.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataCellsFilterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataCellsFilterOutput) GoString() string {
	return s.String()
}

// SetDataCellsFilters sets the DataCellsFilters field's value.
func (s *ListDataCellsFilterOutput) SetDataCellsFilters(v []*DataCellsFilter) *ListDataCellsFilterOutput {
	s.DataCellsFilters = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDataCellsFilterOutput) SetNextToken(v string) *ListDataCellsFilterOutput {
	s.NextToken = &v
	return s
}

type ListLFTagsInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, and other control information to manage your Lake Formation
	// environment.
	CatalogId *string `min:"1" type:"string"`

	// The maximum number of results to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// A continuation token, if this is not the first call to retrieve this list.
	NextToken *string `type:"string"`

	// If resource share type is ALL, returns both in-account LF-tags and shared
	// LF-tags that the requester has permission to view. If resource share type
	// is FOREIGN, returns all share LF-tags that the requester can view. If no
	// resource share type is passed, lists LF-tags in the given catalog ID that
	// the requester has permission to view.
	ResourceShareType *string `type:"string" enum:"ResourceShareType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLFTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLFTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLFTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListLFTagsInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *ListLFTagsInput) SetCatalogId(v string) *ListLFTagsInput {
	s.CatalogId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListLFTagsInput) SetMaxResults(v int64) *ListLFTagsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLFTagsInput) SetNextToken(v string) *ListLFTagsInput {
	s.NextToken = &v
	return s
}

// SetResourceShareType sets the ResourceShareType field's value.
func (s *ListLFTagsInput) SetResourceShareType(v string) *ListLFTagsInput {
	s.ResourceShareType = &v
	return s
}

type ListLFTagsOutput struct {
	_ struct{} `type:"structure"`

	// A list of LF-tags that the requested has permission to view.
	LFTags []*LFTagPair `min:"1" type:"list"`

	// A continuation token, present if the current list segment is not the last.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLFTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLFTagsOutput) GoString() string {
	return s.String()
}

// SetLFTags sets the LFTags field's value.
func (s *ListLFTagsOutput) SetLFTags(v []*LFTagPair) *ListLFTagsOutput {
	s.LFTags = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLFTagsOutput) SetNextToken(v string) *ListLFTagsOutput {
	s.NextToken = &v
	return s
}

type ListLakeFormationOptInsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// A continuation token, if this is not the first call to retrieve this list.
	NextToken *string `type:"string"`

	// The Lake Formation principal. Supported principals are IAM users or IAM roles.
	Principal *DataLakePrincipal `type:"structure"`

	// A structure for the resource.
	Resource *Resource `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLakeFormationOptInsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLakeFormationOptInsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLakeFormationOptInsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListLakeFormationOptInsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Principal != nil {
		if err := s.Principal.Validate(); err != nil {
			invalidParams.AddNested("Principal", err.(request.ErrInvalidParams))
		}
	}
	if s.Resource != nil {
		if err := s.Resource.Validate(); err != nil {
			invalidParams.AddNested("Resource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListLakeFormationOptInsInput) SetMaxResults(v int64) *ListLakeFormationOptInsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLakeFormationOptInsInput) SetNextToken(v string) *ListLakeFormationOptInsInput {
	s.NextToken = &v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *ListLakeFormationOptInsInput) SetPrincipal(v *DataLakePrincipal) *ListLakeFormationOptInsInput {
	s.Principal = v
	return s
}

// SetResource sets the Resource field's value.
func (s *ListLakeFormationOptInsInput) SetResource(v *Resource) *ListLakeFormationOptInsInput {
	s.Resource = v
	return s
}

type ListLakeFormationOptInsOutput struct {
	_ struct{} `type:"structure"`

	// A list of principal-resource pairs that have Lake Formation permissins enforced.
	LakeFormationOptInsInfoList []*LakeFormationOptInsInfo `type:"list"`

	// A continuation token, if this is not the first call to retrieve this list.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLakeFormationOptInsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLakeFormationOptInsOutput) GoString() string {
	return s.String()
}

// SetLakeFormationOptInsInfoList sets the LakeFormationOptInsInfoList field's value.
func (s *ListLakeFormationOptInsOutput) SetLakeFormationOptInsInfoList(v []*LakeFormationOptInsInfo) *ListLakeFormationOptInsOutput {
	s.LakeFormationOptInsInfoList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLakeFormationOptInsOutput) SetNextToken(v string) *ListLakeFormationOptInsOutput {
	s.NextToken = &v
	return s
}

type ListPermissionsInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, and other control information to manage your Lake Formation
	// environment.
	CatalogId *string `min:"1" type:"string"`

	// Indicates that related permissions should be included in the results.
	IncludeRelated *string `min:"1" type:"string"`

	// The maximum number of results to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// A continuation token, if this is not the first call to retrieve this list.
	NextToken *string `type:"string"`

	// Specifies a principal to filter the permissions returned.
	Principal *DataLakePrincipal `type:"structure"`

	// A resource where you will get a list of the principal permissions.
	//
	// This operation does not support getting privileges on a table with columns.
	// Instead, call this operation on the table, and the operation returns the
	// table and the table w columns.
	Resource *Resource `type:"structure"`

	// Specifies a resource type to filter the permissions returned.
	ResourceType *string `type:"string" enum:"DataLakeResourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPermissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPermissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPermissionsInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.IncludeRelated != nil && len(*s.IncludeRelated) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IncludeRelated", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Principal != nil {
		if err := s.Principal.Validate(); err != nil {
			invalidParams.AddNested("Principal", err.(request.ErrInvalidParams))
		}
	}
	if s.Resource != nil {
		if err := s.Resource.Validate(); err != nil {
			invalidParams.AddNested("Resource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *ListPermissionsInput) SetCatalogId(v string) *ListPermissionsInput {
	s.CatalogId = &v
	return s
}

// SetIncludeRelated sets the IncludeRelated field's value.
func (s *ListPermissionsInput) SetIncludeRelated(v string) *ListPermissionsInput {
	s.IncludeRelated = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPermissionsInput) SetMaxResults(v int64) *ListPermissionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPermissionsInput) SetNextToken(v string) *ListPermissionsInput {
	s.NextToken = &v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *ListPermissionsInput) SetPrincipal(v *DataLakePrincipal) *ListPermissionsInput {
	s.Principal = v
	return s
}

// SetResource sets the Resource field's value.
func (s *ListPermissionsInput) SetResource(v *Resource) *ListPermissionsInput {
	s.Resource = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ListPermissionsInput) SetResourceType(v string) *ListPermissionsInput {
	s.ResourceType = &v
	return s
}

type ListPermissionsOutput struct {
	_ struct{} `type:"structure"`

	// A continuation token, if this is not the first call to retrieve this list.
	NextToken *string `type:"string"`

	// A list of principals and their permissions on the resource for the specified
	// principal and resource types.
	PrincipalResourcePermissions []*PrincipalResourcePermissions `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPermissionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPermissionsOutput) SetNextToken(v string) *ListPermissionsOutput {
	s.NextToken = &v
	return s
}

// SetPrincipalResourcePermissions sets the PrincipalResourcePermissions field's value.
func (s *ListPermissionsOutput) SetPrincipalResourcePermissions(v []*PrincipalResourcePermissions) *ListPermissionsOutput {
	s.PrincipalResourcePermissions = v
	return s
}

type ListResourcesInput struct {
	_ struct{} `type:"structure"`

	// Any applicable row-level and/or column-level filtering conditions for the
	// resources.
	FilterConditionList []*FilterCondition `min:"1" type:"list"`

	// The maximum number of resource results.
	MaxResults *int64 `min:"1" type:"integer"`

	// A continuation token, if this is not the first call to retrieve these resources.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResourcesInput"}
	if s.FilterConditionList != nil && len(s.FilterConditionList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FilterConditionList", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilterConditionList sets the FilterConditionList field's value.
func (s *ListResourcesInput) SetFilterConditionList(v []*FilterCondition) *ListResourcesInput {
	s.FilterConditionList = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResourcesInput) SetMaxResults(v int64) *ListResourcesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourcesInput) SetNextToken(v string) *ListResourcesInput {
	s.NextToken = &v
	return s
}

type ListResourcesOutput struct {
	_ struct{} `type:"structure"`

	// A continuation token, if this is not the first call to retrieve these resources.
	NextToken *string `type:"string"`

	// A summary of the data lake resources.
	ResourceInfoList []*ResourceInfo `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourcesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourcesOutput) SetNextToken(v string) *ListResourcesOutput {
	s.NextToken = &v
	return s
}

// SetResourceInfoList sets the ResourceInfoList field's value.
func (s *ListResourcesOutput) SetResourceInfoList(v []*ResourceInfo) *ListResourcesOutput {
	s.ResourceInfoList = v
	return s
}

type ListTableStorageOptimizersInput struct {
	_ struct{} `type:"structure"`

	// The Catalog ID of the table.
	CatalogId *string `min:"1" type:"string"`

	// Name of the database where the table is present.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// The number of storage optimizers to return on each call.
	MaxResults *int64 `min:"1" type:"integer"`

	// A continuation token, if this is a continuation call.
	NextToken *string `type:"string"`

	// The specific type of storage optimizers to list. The supported value is compaction.
	StorageOptimizerType *string `type:"string" enum:"OptimizerType"`

	// Name of the table.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTableStorageOptimizersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTableStorageOptimizersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTableStorageOptimizersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTableStorageOptimizersInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *ListTableStorageOptimizersInput) SetCatalogId(v string) *ListTableStorageOptimizersInput {
	s.CatalogId = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *ListTableStorageOptimizersInput) SetDatabaseName(v string) *ListTableStorageOptimizersInput {
	s.DatabaseName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTableStorageOptimizersInput) SetMaxResults(v int64) *ListTableStorageOptimizersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTableStorageOptimizersInput) SetNextToken(v string) *ListTableStorageOptimizersInput {
	s.NextToken = &v
	return s
}

// SetStorageOptimizerType sets the StorageOptimizerType field's value.
func (s *ListTableStorageOptimizersInput) SetStorageOptimizerType(v string) *ListTableStorageOptimizersInput {
	s.StorageOptimizerType = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *ListTableStorageOptimizersInput) SetTableName(v string) *ListTableStorageOptimizersInput {
	s.TableName = &v
	return s
}

type ListTableStorageOptimizersOutput struct {
	_ struct{} `type:"structure"`

	// A continuation token for paginating the returned list of tokens, returned
	// if the current segment of the list is not the last.
	NextToken *string `type:"string"`

	// A list of the storage optimizers associated with a table.
	StorageOptimizerList []*StorageOptimizer `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTableStorageOptimizersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTableStorageOptimizersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTableStorageOptimizersOutput) SetNextToken(v string) *ListTableStorageOptimizersOutput {
	s.NextToken = &v
	return s
}

// SetStorageOptimizerList sets the StorageOptimizerList field's value.
func (s *ListTableStorageOptimizersOutput) SetStorageOptimizerList(v []*StorageOptimizer) *ListTableStorageOptimizersOutput {
	s.StorageOptimizerList = v
	return s
}

type ListTransactionsInput struct {
	_ struct{} `type:"structure"`

	// The catalog for which to list transactions. Defaults to the account ID of
	// the caller.
	CatalogId *string `min:"1" type:"string"`

	// The maximum number of transactions to return in a single call.
	MaxResults *int64 `min:"1" type:"integer"`

	// A continuation token if this is not the first call to retrieve transactions.
	NextToken *string `type:"string"`

	// A filter indicating the status of transactions to return. Options are ALL
	// | COMPLETED | COMMITTED | ABORTED | ACTIVE. The default is ALL.
	StatusFilter *string `type:"string" enum:"TransactionStatusFilter"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTransactionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTransactionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTransactionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTransactionsInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *ListTransactionsInput) SetCatalogId(v string) *ListTransactionsInput {
	s.CatalogId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTransactionsInput) SetMaxResults(v int64) *ListTransactionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTransactionsInput) SetNextToken(v string) *ListTransactionsInput {
	s.NextToken = &v
	return s
}

// SetStatusFilter sets the StatusFilter field's value.
func (s *ListTransactionsInput) SetStatusFilter(v string) *ListTransactionsInput {
	s.StatusFilter = &v
	return s
}

type ListTransactionsOutput struct {
	_ struct{} `type:"structure"`

	// A continuation token indicating whether additional data is available.
	NextToken *string `type:"string"`

	// A list of transactions. The record for each transaction is a TransactionDescription
	// object.
	Transactions []*TransactionDescription `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTransactionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTransactionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTransactionsOutput) SetNextToken(v string) *ListTransactionsOutput {
	s.NextToken = &v
	return s
}

// SetTransactions sets the Transactions field's value.
func (s *ListTransactionsOutput) SetTransactions(v []*TransactionDescription) *ListTransactionsOutput {
	s.Transactions = v
	return s
}

// The operation timed out.
type OperationTimeoutException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message describing the problem.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OperationTimeoutException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OperationTimeoutException) GoString() string {
	return s.String()
}

func newErrorOperationTimeoutException(v protocol.ResponseMetadata) error {
	return &OperationTimeoutException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *OperationTimeoutException) Code() string {
	return "OperationTimeoutException"
}

// Message returns the exception's message.
func (s *OperationTimeoutException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *OperationTimeoutException) OrigErr() error {
	return nil
}

func (s *OperationTimeoutException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *OperationTimeoutException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *OperationTimeoutException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A structure containing a list of partition values and table objects.
type PartitionObjects struct {
	_ struct{} `type:"structure"`

	// A list of table objects
	Objects []*TableObject `type:"list"`

	// A list of partition values.
	PartitionValues []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PartitionObjects) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PartitionObjects) GoString() string {
	return s.String()
}

// SetObjects sets the Objects field's value.
func (s *PartitionObjects) SetObjects(v []*TableObject) *PartitionObjects {
	s.Objects = v
	return s
}

// SetPartitionValues sets the PartitionValues field's value.
func (s *PartitionObjects) SetPartitionValues(v []*string) *PartitionObjects {
	s.PartitionValues = v
	return s
}

// Contains a list of values defining partitions.
type PartitionValueList struct {
	_ struct{} `type:"structure"`

	// The list of partition values.
	//
	// Values is a required field
	Values []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PartitionValueList) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PartitionValueList) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PartitionValueList) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PartitionValueList"}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetValues sets the Values field's value.
func (s *PartitionValueList) SetValues(v []*string) *PartitionValueList {
	s.Values = v
	return s
}

// The engine does not support filtering data based on the enforced permissions.
// For example, if you call the GetTemporaryGlueTableCredentials operation with
// SupportedPermissionType equal to ColumnPermission, but cell-level permissions
// exist on the table, this exception is thrown.
type PermissionTypeMismatchException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message describing the problem.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PermissionTypeMismatchException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PermissionTypeMismatchException) GoString() string {
	return s.String()
}

func newErrorPermissionTypeMismatchException(v protocol.ResponseMetadata) error {
	return &PermissionTypeMismatchException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *PermissionTypeMismatchException) Code() string {
	return "PermissionTypeMismatchException"
}

// Message returns the exception's message.
func (s *PermissionTypeMismatchException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *PermissionTypeMismatchException) OrigErr() error {
	return nil
}

func (s *PermissionTypeMismatchException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *PermissionTypeMismatchException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *PermissionTypeMismatchException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Statistics related to the processing of a query statement.
type PlanningStatistics struct {
	_ struct{} `type:"structure"`

	// An estimate of the data that was scanned in bytes.
	EstimatedDataToScanBytes *int64 `type:"long"`

	// The time that it took to process the request.
	PlanningTimeMillis *int64 `type:"long"`

	// The time the request was in queue to be processed.
	QueueTimeMillis *int64 `type:"long"`

	// The number of work units generated.
	WorkUnitsGeneratedCount *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlanningStatistics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlanningStatistics) GoString() string {
	return s.String()
}

// SetEstimatedDataToScanBytes sets the EstimatedDataToScanBytes field's value.
func (s *PlanningStatistics) SetEstimatedDataToScanBytes(v int64) *PlanningStatistics {
	s.EstimatedDataToScanBytes = &v
	return s
}

// SetPlanningTimeMillis sets the PlanningTimeMillis field's value.
func (s *PlanningStatistics) SetPlanningTimeMillis(v int64) *PlanningStatistics {
	s.PlanningTimeMillis = &v
	return s
}

// SetQueueTimeMillis sets the QueueTimeMillis field's value.
func (s *PlanningStatistics) SetQueueTimeMillis(v int64) *PlanningStatistics {
	s.QueueTimeMillis = &v
	return s
}

// SetWorkUnitsGeneratedCount sets the WorkUnitsGeneratedCount field's value.
func (s *PlanningStatistics) SetWorkUnitsGeneratedCount(v int64) *PlanningStatistics {
	s.WorkUnitsGeneratedCount = &v
	return s
}

// Permissions granted to a principal.
type PrincipalPermissions struct {
	_ struct{} `type:"structure"`

	// The permissions that are granted to the principal.
	Permissions []*string `type:"list" enum:"Permission"`

	// The principal who is granted permissions.
	Principal *DataLakePrincipal `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrincipalPermissions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrincipalPermissions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PrincipalPermissions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PrincipalPermissions"}
	if s.Principal != nil {
		if err := s.Principal.Validate(); err != nil {
			invalidParams.AddNested("Principal", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPermissions sets the Permissions field's value.
func (s *PrincipalPermissions) SetPermissions(v []*string) *PrincipalPermissions {
	s.Permissions = v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *PrincipalPermissions) SetPrincipal(v *DataLakePrincipal) *PrincipalPermissions {
	s.Principal = v
	return s
}

// The permissions granted or revoked on a resource.
type PrincipalResourcePermissions struct {
	_ struct{} `type:"structure"`

	// This attribute can be used to return any additional details of PrincipalResourcePermissions.
	// Currently returns only as a RAM resource share ARN.
	AdditionalDetails *DetailsMap `type:"structure"`

	// The date and time when the resource was last updated.
	LastUpdated *time.Time `type:"timestamp"`

	// The user who updated the record.
	LastUpdatedBy *string `min:"1" type:"string"`

	// The permissions to be granted or revoked on the resource.
	Permissions []*string `type:"list" enum:"Permission"`

	// Indicates whether to grant the ability to grant permissions (as a subset
	// of permissions granted).
	PermissionsWithGrantOption []*string `type:"list" enum:"Permission"`

	// The Data Lake principal to be granted or revoked permissions.
	Principal *DataLakePrincipal `type:"structure"`

	// The resource where permissions are to be granted or revoked.
	Resource *Resource `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrincipalResourcePermissions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrincipalResourcePermissions) GoString() string {
	return s.String()
}

// SetAdditionalDetails sets the AdditionalDetails field's value.
func (s *PrincipalResourcePermissions) SetAdditionalDetails(v *DetailsMap) *PrincipalResourcePermissions {
	s.AdditionalDetails = v
	return s
}

// SetLastUpdated sets the LastUpdated field's value.
func (s *PrincipalResourcePermissions) SetLastUpdated(v time.Time) *PrincipalResourcePermissions {
	s.LastUpdated = &v
	return s
}

// SetLastUpdatedBy sets the LastUpdatedBy field's value.
func (s *PrincipalResourcePermissions) SetLastUpdatedBy(v string) *PrincipalResourcePermissions {
	s.LastUpdatedBy = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *PrincipalResourcePermissions) SetPermissions(v []*string) *PrincipalResourcePermissions {
	s.Permissions = v
	return s
}

// SetPermissionsWithGrantOption sets the PermissionsWithGrantOption field's value.
func (s *PrincipalResourcePermissions) SetPermissionsWithGrantOption(v []*string) *PrincipalResourcePermissions {
	s.PermissionsWithGrantOption = v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *PrincipalResourcePermissions) SetPrincipal(v *DataLakePrincipal) *PrincipalResourcePermissions {
	s.Principal = v
	return s
}

// SetResource sets the Resource field's value.
func (s *PrincipalResourcePermissions) SetResource(v *Resource) *PrincipalResourcePermissions {
	s.Resource = v
	return s
}

type PutDataLakeSettingsInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, and other control information to manage your Lake Formation
	// environment.
	CatalogId *string `min:"1" type:"string"`

	// A structure representing a list of Lake Formation principals designated as
	// data lake administrators.
	//
	// DataLakeSettings is a required field
	DataLakeSettings *DataLakeSettings `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutDataLakeSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutDataLakeSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutDataLakeSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutDataLakeSettingsInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.DataLakeSettings == nil {
		invalidParams.Add(request.NewErrParamRequired("DataLakeSettings"))
	}
	if s.DataLakeSettings != nil {
		if err := s.DataLakeSettings.Validate(); err != nil {
			invalidParams.AddNested("DataLakeSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *PutDataLakeSettingsInput) SetCatalogId(v string) *PutDataLakeSettingsInput {
	s.CatalogId = &v
	return s
}

// SetDataLakeSettings sets the DataLakeSettings field's value.
func (s *PutDataLakeSettingsInput) SetDataLakeSettings(v *DataLakeSettings) *PutDataLakeSettingsInput {
	s.DataLakeSettings = v
	return s
}

type PutDataLakeSettingsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutDataLakeSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutDataLakeSettingsOutput) GoString() string {
	return s.String()
}

// A structure containing information about the query plan.
type QueryPlanningContext struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog where the partition in question resides. If none
	// is provided, the Amazon Web Services account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// The database containing the table.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// The time as of when to read the table contents. If not set, the most recent
	// transaction commit time will be used. Cannot be specified along with TransactionId.
	QueryAsOfTime *time.Time `type:"timestamp"`

	// A map consisting of key-value pairs.
	QueryParameters map[string]*string `type:"map"`

	// The transaction ID at which to read the table contents. If this transaction
	// is not committed, the read will be treated as part of that transaction and
	// will see its writes. If this transaction has aborted, an error will be returned.
	// If not set, defaults to the most recent committed transaction. Cannot be
	// specified along with QueryAsOfTime.
	TransactionId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueryPlanningContext) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueryPlanningContext) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *QueryPlanningContext) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "QueryPlanningContext"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.TransactionId != nil && len(*s.TransactionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TransactionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *QueryPlanningContext) SetCatalogId(v string) *QueryPlanningContext {
	s.CatalogId = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *QueryPlanningContext) SetDatabaseName(v string) *QueryPlanningContext {
	s.DatabaseName = &v
	return s
}

// SetQueryAsOfTime sets the QueryAsOfTime field's value.
func (s *QueryPlanningContext) SetQueryAsOfTime(v time.Time) *QueryPlanningContext {
	s.QueryAsOfTime = &v
	return s
}

// SetQueryParameters sets the QueryParameters field's value.
func (s *QueryPlanningContext) SetQueryParameters(v map[string]*string) *QueryPlanningContext {
	s.QueryParameters = v
	return s
}

// SetTransactionId sets the TransactionId field's value.
func (s *QueryPlanningContext) SetTransactionId(v string) *QueryPlanningContext {
	s.TransactionId = &v
	return s
}

// A structure used as a protocol between query engines and Lake Formation or
// Glue. Contains both a Lake Formation generated authorization identifier and
// information from the request's authorization context.
type QuerySessionContext struct {
	_ struct{} `type:"structure"`

	// An opaque string-string map passed by the query engine.
	AdditionalContext map[string]*string `type:"map"`

	// An identifier string for the consumer cluster.
	ClusterId *string `type:"string"`

	// A cryptographically generated query identifier generated by Glue or Lake
	// Formation.
	QueryAuthorizationId *string `min:"1" type:"string"`

	// A unique identifier generated by the query engine for the query.
	QueryId *string `min:"1" type:"string"`

	// A timestamp provided by the query engine for when the query started.
	QueryStartTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QuerySessionContext) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QuerySessionContext) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *QuerySessionContext) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "QuerySessionContext"}
	if s.QueryAuthorizationId != nil && len(*s.QueryAuthorizationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueryAuthorizationId", 1))
	}
	if s.QueryId != nil && len(*s.QueryId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueryId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdditionalContext sets the AdditionalContext field's value.
func (s *QuerySessionContext) SetAdditionalContext(v map[string]*string) *QuerySessionContext {
	s.AdditionalContext = v
	return s
}

// SetClusterId sets the ClusterId field's value.
func (s *QuerySessionContext) SetClusterId(v string) *QuerySessionContext {
	s.ClusterId = &v
	return s
}

// SetQueryAuthorizationId sets the QueryAuthorizationId field's value.
func (s *QuerySessionContext) SetQueryAuthorizationId(v string) *QuerySessionContext {
	s.QueryAuthorizationId = &v
	return s
}

// SetQueryId sets the QueryId field's value.
func (s *QuerySessionContext) SetQueryId(v string) *QuerySessionContext {
	s.QueryId = &v
	return s
}

// SetQueryStartTime sets the QueryStartTime field's value.
func (s *QuerySessionContext) SetQueryStartTime(v time.Time) *QuerySessionContext {
	s.QueryStartTime = &v
	return s
}

type RegisterResourceInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether the data access of tables pointing to the location can
	// be managed by both Lake Formation permissions as well as Amazon S3 bucket
	// policies.
	HybridAccessEnabled *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of the resource that you want to register.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`

	// The identifier for the role that registers the resource.
	RoleArn *string `type:"string"`

	// Designates an Identity and Access Management (IAM) service-linked role by
	// registering this role with the Data Catalog. A service-linked role is a unique
	// type of IAM role that is linked directly to Lake Formation.
	//
	// For more information, see Using Service-Linked Roles for Lake Formation (https://docs.aws.amazon.com/lake-formation/latest/dg/service-linked-roles.html).
	UseServiceLinkedRole *bool `type:"boolean"`

	// Whether or not the resource is a federated resource.
	WithFederation *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHybridAccessEnabled sets the HybridAccessEnabled field's value.
func (s *RegisterResourceInput) SetHybridAccessEnabled(v bool) *RegisterResourceInput {
	s.HybridAccessEnabled = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *RegisterResourceInput) SetResourceArn(v string) *RegisterResourceInput {
	s.ResourceArn = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *RegisterResourceInput) SetRoleArn(v string) *RegisterResourceInput {
	s.RoleArn = &v
	return s
}

// SetUseServiceLinkedRole sets the UseServiceLinkedRole field's value.
func (s *RegisterResourceInput) SetUseServiceLinkedRole(v bool) *RegisterResourceInput {
	s.UseServiceLinkedRole = &v
	return s
}

// SetWithFederation sets the WithFederation field's value.
func (s *RegisterResourceInput) SetWithFederation(v bool) *RegisterResourceInput {
	s.WithFederation = &v
	return s
}

type RegisterResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterResourceOutput) GoString() string {
	return s.String()
}

type RemoveLFTagsFromResourceInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, and other control information to manage your Lake Formation
	// environment.
	CatalogId *string `min:"1" type:"string"`

	// The LF-tags to be removed from the resource.
	//
	// LFTags is a required field
	LFTags []*LFTagPair `min:"1" type:"list" required:"true"`

	// The database, table, or column resource where you want to remove an LF-tag.
	//
	// Resource is a required field
	Resource *Resource `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveLFTagsFromResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveLFTagsFromResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveLFTagsFromResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveLFTagsFromResourceInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.LFTags == nil {
		invalidParams.Add(request.NewErrParamRequired("LFTags"))
	}
	if s.LFTags != nil && len(s.LFTags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LFTags", 1))
	}
	if s.Resource == nil {
		invalidParams.Add(request.NewErrParamRequired("Resource"))
	}
	if s.LFTags != nil {
		for i, v := range s.LFTags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "LFTags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Resource != nil {
		if err := s.Resource.Validate(); err != nil {
			invalidParams.AddNested("Resource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *RemoveLFTagsFromResourceInput) SetCatalogId(v string) *RemoveLFTagsFromResourceInput {
	s.CatalogId = &v
	return s
}

// SetLFTags sets the LFTags field's value.
func (s *RemoveLFTagsFromResourceInput) SetLFTags(v []*LFTagPair) *RemoveLFTagsFromResourceInput {
	s.LFTags = v
	return s
}

// SetResource sets the Resource field's value.
func (s *RemoveLFTagsFromResourceInput) SetResource(v *Resource) *RemoveLFTagsFromResourceInput {
	s.Resource = v
	return s
}

type RemoveLFTagsFromResourceOutput struct {
	_ struct{} `type:"structure"`

	// A list of failures to untag a resource.
	Failures []*LFTagError `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveLFTagsFromResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveLFTagsFromResourceOutput) GoString() string {
	return s.String()
}

// SetFailures sets the Failures field's value.
func (s *RemoveLFTagsFromResourceOutput) SetFailures(v []*LFTagError) *RemoveLFTagsFromResourceOutput {
	s.Failures = v
	return s
}

// A structure for the resource.
type Resource struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, and other control information to manage your Lake Formation
	// environment.
	Catalog *CatalogResource `type:"structure"`

	// A data cell filter.
	DataCellsFilter *DataCellsFilterResource `type:"structure"`

	// The location of an Amazon S3 path where permissions are granted or revoked.
	DataLocation *DataLocationResource `type:"structure"`

	// The database for the resource. Unique to the Data Catalog. A database is
	// a set of associated table definitions organized into a logical group. You
	// can Grant and Revoke database permissions to a principal.
	Database *DatabaseResource `type:"structure"`

	// The LF-tag key and values attached to a resource.
	LFTag *LFTagKeyResource `type:"structure"`

	// A list of LF-tag conditions that define a resource's LF-tag policy.
	LFTagPolicy *LFTagPolicyResource `type:"structure"`

	// The table for the resource. A table is a metadata definition that represents
	// your data. You can Grant and Revoke table privileges to a principal.
	Table *TableResource `type:"structure"`

	// The table with columns for the resource. A principal with permissions to
	// this resource can select metadata from the columns of a table in the Data
	// Catalog and the underlying data in Amazon S3.
	TableWithColumns *TableWithColumnsResource `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Resource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Resource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Resource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Resource"}
	if s.DataCellsFilter != nil {
		if err := s.DataCellsFilter.Validate(); err != nil {
			invalidParams.AddNested("DataCellsFilter", err.(request.ErrInvalidParams))
		}
	}
	if s.DataLocation != nil {
		if err := s.DataLocation.Validate(); err != nil {
			invalidParams.AddNested("DataLocation", err.(request.ErrInvalidParams))
		}
	}
	if s.Database != nil {
		if err := s.Database.Validate(); err != nil {
			invalidParams.AddNested("Database", err.(request.ErrInvalidParams))
		}
	}
	if s.LFTag != nil {
		if err := s.LFTag.Validate(); err != nil {
			invalidParams.AddNested("LFTag", err.(request.ErrInvalidParams))
		}
	}
	if s.LFTagPolicy != nil {
		if err := s.LFTagPolicy.Validate(); err != nil {
			invalidParams.AddNested("LFTagPolicy", err.(request.ErrInvalidParams))
		}
	}
	if s.Table != nil {
		if err := s.Table.Validate(); err != nil {
			invalidParams.AddNested("Table", err.(request.ErrInvalidParams))
		}
	}
	if s.TableWithColumns != nil {
		if err := s.TableWithColumns.Validate(); err != nil {
			invalidParams.AddNested("TableWithColumns", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalog sets the Catalog field's value.
func (s *Resource) SetCatalog(v *CatalogResource) *Resource {
	s.Catalog = v
	return s
}

// SetDataCellsFilter sets the DataCellsFilter field's value.
func (s *Resource) SetDataCellsFilter(v *DataCellsFilterResource) *Resource {
	s.DataCellsFilter = v
	return s
}

// SetDataLocation sets the DataLocation field's value.
func (s *Resource) SetDataLocation(v *DataLocationResource) *Resource {
	s.DataLocation = v
	return s
}

// SetDatabase sets the Database field's value.
func (s *Resource) SetDatabase(v *DatabaseResource) *Resource {
	s.Database = v
	return s
}

// SetLFTag sets the LFTag field's value.
func (s *Resource) SetLFTag(v *LFTagKeyResource) *Resource {
	s.LFTag = v
	return s
}

// SetLFTagPolicy sets the LFTagPolicy field's value.
func (s *Resource) SetLFTagPolicy(v *LFTagPolicyResource) *Resource {
	s.LFTagPolicy = v
	return s
}

// SetTable sets the Table field's value.
func (s *Resource) SetTable(v *TableResource) *Resource {
	s.Table = v
	return s
}

// SetTableWithColumns sets the TableWithColumns field's value.
func (s *Resource) SetTableWithColumns(v *TableWithColumnsResource) *Resource {
	s.TableWithColumns = v
	return s
}

// A structure containing information about an Lake Formation resource.
type ResourceInfo struct {
	_ struct{} `type:"structure"`

	// Indicates whether the data access of tables pointing to the location can
	// be managed by both Lake Formation permissions as well as Amazon S3 bucket
	// policies.
	HybridAccessEnabled *bool `type:"boolean"`

	// The date and time the resource was last modified.
	LastModified *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the resource.
	ResourceArn *string `type:"string"`

	// The IAM role that registered a resource.
	RoleArn *string `type:"string"`

	// Whether or not the resource is a federated resource.
	WithFederation *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceInfo) GoString() string {
	return s.String()
}

// SetHybridAccessEnabled sets the HybridAccessEnabled field's value.
func (s *ResourceInfo) SetHybridAccessEnabled(v bool) *ResourceInfo {
	s.HybridAccessEnabled = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *ResourceInfo) SetLastModified(v time.Time) *ResourceInfo {
	s.LastModified = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ResourceInfo) SetResourceArn(v string) *ResourceInfo {
	s.ResourceArn = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *ResourceInfo) SetRoleArn(v string) *ResourceInfo {
	s.RoleArn = &v
	return s
}

// SetWithFederation sets the WithFederation field's value.
func (s *ResourceInfo) SetWithFederation(v bool) *ResourceInfo {
	s.WithFederation = &v
	return s
}

// Contains details about an error related to a resource which is not ready
// for a transaction.
type ResourceNotReadyException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message describing the error.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotReadyException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotReadyException) GoString() string {
	return s.String()
}

func newErrorResourceNotReadyException(v protocol.ResponseMetadata) error {
	return &ResourceNotReadyException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotReadyException) Code() string {
	return "ResourceNotReadyException"
}

// Message returns the exception's message.
func (s *ResourceNotReadyException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotReadyException) OrigErr() error {
	return nil
}

func (s *ResourceNotReadyException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotReadyException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotReadyException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A resource numerical limit was exceeded.
type ResourceNumberLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message describing the problem.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNumberLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNumberLimitExceededException) GoString() string {
	return s.String()
}

func newErrorResourceNumberLimitExceededException(v protocol.ResponseMetadata) error {
	return &ResourceNumberLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNumberLimitExceededException) Code() string {
	return "ResourceNumberLimitExceededException"
}

// Message returns the exception's message.
func (s *ResourceNumberLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNumberLimitExceededException) OrigErr() error {
	return nil
}

func (s *ResourceNumberLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNumberLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNumberLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type RevokePermissionsInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, and other control information to manage your Lake Formation
	// environment.
	CatalogId *string `min:"1" type:"string"`

	// The permissions revoked to the principal on the resource. For information
	// about permissions, see Security and Access Control to Metadata and Data (https://docs.aws.amazon.com/lake-formation/latest/dg/security-data-access.html).
	//
	// Permissions is a required field
	Permissions []*string `type:"list" required:"true" enum:"Permission"`

	// Indicates a list of permissions for which to revoke the grant option allowing
	// the principal to pass permissions to other principals.
	PermissionsWithGrantOption []*string `type:"list" enum:"Permission"`

	// The principal to be revoked permissions on the resource.
	//
	// Principal is a required field
	Principal *DataLakePrincipal `type:"structure" required:"true"`

	// The resource to which permissions are to be revoked.
	//
	// Resource is a required field
	Resource *Resource `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevokePermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevokePermissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RevokePermissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RevokePermissionsInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.Permissions == nil {
		invalidParams.Add(request.NewErrParamRequired("Permissions"))
	}
	if s.Principal == nil {
		invalidParams.Add(request.NewErrParamRequired("Principal"))
	}
	if s.Resource == nil {
		invalidParams.Add(request.NewErrParamRequired("Resource"))
	}
	if s.Principal != nil {
		if err := s.Principal.Validate(); err != nil {
			invalidParams.AddNested("Principal", err.(request.ErrInvalidParams))
		}
	}
	if s.Resource != nil {
		if err := s.Resource.Validate(); err != nil {
			invalidParams.AddNested("Resource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *RevokePermissionsInput) SetCatalogId(v string) *RevokePermissionsInput {
	s.CatalogId = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *RevokePermissionsInput) SetPermissions(v []*string) *RevokePermissionsInput {
	s.Permissions = v
	return s
}

// SetPermissionsWithGrantOption sets the PermissionsWithGrantOption field's value.
func (s *RevokePermissionsInput) SetPermissionsWithGrantOption(v []*string) *RevokePermissionsInput {
	s.PermissionsWithGrantOption = v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *RevokePermissionsInput) SetPrincipal(v *DataLakePrincipal) *RevokePermissionsInput {
	s.Principal = v
	return s
}

// SetResource sets the Resource field's value.
func (s *RevokePermissionsInput) SetResource(v *Resource) *RevokePermissionsInput {
	s.Resource = v
	return s
}

type RevokePermissionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevokePermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevokePermissionsOutput) GoString() string {
	return s.String()
}

// A PartiQL predicate.
type RowFilter struct {
	_ struct{} `type:"structure"`

	// A wildcard for all rows.
	AllRowsWildcard *AllRowsWildcard `type:"structure"`

	// A filter expression.
	FilterExpression *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RowFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RowFilter) GoString() string {
	return s.String()
}

// SetAllRowsWildcard sets the AllRowsWildcard field's value.
func (s *RowFilter) SetAllRowsWildcard(v *AllRowsWildcard) *RowFilter {
	s.AllRowsWildcard = v
	return s
}

// SetFilterExpression sets the FilterExpression field's value.
func (s *RowFilter) SetFilterExpression(v string) *RowFilter {
	s.FilterExpression = &v
	return s
}

type SearchDatabasesByLFTagsInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, and other control information to manage your Lake Formation
	// environment.
	CatalogId *string `min:"1" type:"string"`

	// A list of conditions (LFTag structures) to search for in database resources.
	//
	// Expression is a required field
	Expression []*LFTag `type:"list" required:"true"`

	// The maximum number of results to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// A continuation token, if this is not the first call to retrieve this list.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchDatabasesByLFTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchDatabasesByLFTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchDatabasesByLFTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchDatabasesByLFTagsInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.Expression == nil {
		invalidParams.Add(request.NewErrParamRequired("Expression"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Expression != nil {
		for i, v := range s.Expression {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Expression", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *SearchDatabasesByLFTagsInput) SetCatalogId(v string) *SearchDatabasesByLFTagsInput {
	s.CatalogId = &v
	return s
}

// SetExpression sets the Expression field's value.
func (s *SearchDatabasesByLFTagsInput) SetExpression(v []*LFTag) *SearchDatabasesByLFTagsInput {
	s.Expression = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchDatabasesByLFTagsInput) SetMaxResults(v int64) *SearchDatabasesByLFTagsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchDatabasesByLFTagsInput) SetNextToken(v string) *SearchDatabasesByLFTagsInput {
	s.NextToken = &v
	return s
}

type SearchDatabasesByLFTagsOutput struct {
	_ struct{} `type:"structure"`

	// A list of databases that meet the LF-tag conditions.
	DatabaseList []*TaggedDatabase `type:"list"`

	// A continuation token, present if the current list segment is not the last.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchDatabasesByLFTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchDatabasesByLFTagsOutput) GoString() string {
	return s.String()
}

// SetDatabaseList sets the DatabaseList field's value.
func (s *SearchDatabasesByLFTagsOutput) SetDatabaseList(v []*TaggedDatabase) *SearchDatabasesByLFTagsOutput {
	s.DatabaseList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchDatabasesByLFTagsOutput) SetNextToken(v string) *SearchDatabasesByLFTagsOutput {
	s.NextToken = &v
	return s
}

type SearchTablesByLFTagsInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, and other control information to manage your Lake Formation
	// environment.
	CatalogId *string `min:"1" type:"string"`

	// A list of conditions (LFTag structures) to search for in table resources.
	//
	// Expression is a required field
	Expression []*LFTag `type:"list" required:"true"`

	// The maximum number of results to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// A continuation token, if this is not the first call to retrieve this list.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchTablesByLFTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchTablesByLFTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchTablesByLFTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchTablesByLFTagsInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.Expression == nil {
		invalidParams.Add(request.NewErrParamRequired("Expression"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Expression != nil {
		for i, v := range s.Expression {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Expression", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *SearchTablesByLFTagsInput) SetCatalogId(v string) *SearchTablesByLFTagsInput {
	s.CatalogId = &v
	return s
}

// SetExpression sets the Expression field's value.
func (s *SearchTablesByLFTagsInput) SetExpression(v []*LFTag) *SearchTablesByLFTagsInput {
	s.Expression = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchTablesByLFTagsInput) SetMaxResults(v int64) *SearchTablesByLFTagsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchTablesByLFTagsInput) SetNextToken(v string) *SearchTablesByLFTagsInput {
	s.NextToken = &v
	return s
}

type SearchTablesByLFTagsOutput struct {
	_ struct{} `type:"structure"`

	// A continuation token, present if the current list segment is not the last.
	// On the first run, if you include a not null (a value) token you can get empty
	// pages.
	NextToken *string `type:"string"`

	// A list of tables that meet the LF-tag conditions.
	TableList []*TaggedTable `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchTablesByLFTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchTablesByLFTagsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *SearchTablesByLFTagsOutput) SetNextToken(v string) *SearchTablesByLFTagsOutput {
	s.NextToken = &v
	return s
}

// SetTableList sets the TableList field's value.
func (s *SearchTablesByLFTagsOutput) SetTableList(v []*TaggedTable) *SearchTablesByLFTagsOutput {
	s.TableList = v
	return s
}

type StartQueryPlanningInput struct {
	_ struct{} `type:"structure"`

	// A structure containing information about the query plan.
	//
	// QueryPlanningContext is a required field
	QueryPlanningContext *QueryPlanningContext `type:"structure" required:"true"`

	// A PartiQL query statement used as an input to the planner service.
	//
	// QueryString is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by StartQueryPlanningInput's
	// String and GoString methods.
	//
	// QueryString is a required field
	QueryString *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartQueryPlanningInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartQueryPlanningInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartQueryPlanningInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartQueryPlanningInput"}
	if s.QueryPlanningContext == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryPlanningContext"))
	}
	if s.QueryString == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryString"))
	}
	if s.QueryString != nil && len(*s.QueryString) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueryString", 1))
	}
	if s.QueryPlanningContext != nil {
		if err := s.QueryPlanningContext.Validate(); err != nil {
			invalidParams.AddNested("QueryPlanningContext", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetQueryPlanningContext sets the QueryPlanningContext field's value.
func (s *StartQueryPlanningInput) SetQueryPlanningContext(v *QueryPlanningContext) *StartQueryPlanningInput {
	s.QueryPlanningContext = v
	return s
}

// SetQueryString sets the QueryString field's value.
func (s *StartQueryPlanningInput) SetQueryString(v string) *StartQueryPlanningInput {
	s.QueryString = &v
	return s
}

// A structure for the output.
type StartQueryPlanningOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the plan query operation can be used to fetch the actual work unit
	// descriptors that are produced as the result of the operation. The ID is also
	// used to get the query state and as an input to the Execute operation.
	//
	// QueryId is a required field
	QueryId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartQueryPlanningOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartQueryPlanningOutput) GoString() string {
	return s.String()
}

// SetQueryId sets the QueryId field's value.
func (s *StartQueryPlanningOutput) SetQueryId(v string) *StartQueryPlanningOutput {
	s.QueryId = &v
	return s
}

type StartTransactionInput struct {
	_ struct{} `type:"structure"`

	// Indicates whether this transaction should be read only or read and write.
	// Writes made using a read-only transaction ID will be rejected. Read-only
	// transactions do not need to be committed.
	TransactionType *string `type:"string" enum:"TransactionType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTransactionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTransactionInput) GoString() string {
	return s.String()
}

// SetTransactionType sets the TransactionType field's value.
func (s *StartTransactionInput) SetTransactionType(v string) *StartTransactionInput {
	s.TransactionType = &v
	return s
}

type StartTransactionOutput struct {
	_ struct{} `type:"structure"`

	// An opaque identifier for the transaction.
	TransactionId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTransactionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTransactionOutput) GoString() string {
	return s.String()
}

// SetTransactionId sets the TransactionId field's value.
func (s *StartTransactionOutput) SetTransactionId(v string) *StartTransactionOutput {
	s.TransactionId = &v
	return s
}

// Contains details about an error related to statistics not being ready.
type StatisticsNotReadyYetException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message describing the error.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StatisticsNotReadyYetException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StatisticsNotReadyYetException) GoString() string {
	return s.String()
}

func newErrorStatisticsNotReadyYetException(v protocol.ResponseMetadata) error {
	return &StatisticsNotReadyYetException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *StatisticsNotReadyYetException) Code() string {
	return "StatisticsNotReadyYetException"
}

// Message returns the exception's message.
func (s *StatisticsNotReadyYetException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *StatisticsNotReadyYetException) OrigErr() error {
	return nil
}

func (s *StatisticsNotReadyYetException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *StatisticsNotReadyYetException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *StatisticsNotReadyYetException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A structure describing the configuration and details of a storage optimizer.
type StorageOptimizer struct {
	_ struct{} `type:"structure"`

	// A map of the storage optimizer configuration. Currently contains only one
	// key-value pair: is_enabled indicates true or false for acceleration.
	Config map[string]*string `type:"map"`

	// A message that contains information about any error (if present).
	//
	// When an acceleration result has an enabled status, the error message is empty.
	//
	// When an acceleration result has a disabled status, the message describes
	// an error or simply indicates "disabled by the user".
	ErrorMessage *string `type:"string"`

	// When an acceleration result has an enabled status, contains the details of
	// the last job run.
	LastRunDetails *string `type:"string"`

	// The specific type of storage optimizer. The supported value is compaction.
	StorageOptimizerType *string `type:"string" enum:"OptimizerType"`

	// A message that contains information about any warnings (if present).
	Warnings *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StorageOptimizer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StorageOptimizer) GoString() string {
	return s.String()
}

// SetConfig sets the Config field's value.
func (s *StorageOptimizer) SetConfig(v map[string]*string) *StorageOptimizer {
	s.Config = v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *StorageOptimizer) SetErrorMessage(v string) *StorageOptimizer {
	s.ErrorMessage = &v
	return s
}

// SetLastRunDetails sets the LastRunDetails field's value.
func (s *StorageOptimizer) SetLastRunDetails(v string) *StorageOptimizer {
	s.LastRunDetails = &v
	return s
}

// SetStorageOptimizerType sets the StorageOptimizerType field's value.
func (s *StorageOptimizer) SetStorageOptimizerType(v string) *StorageOptimizer {
	s.StorageOptimizerType = &v
	return s
}

// SetWarnings sets the Warnings field's value.
func (s *StorageOptimizer) SetWarnings(v string) *StorageOptimizer {
	s.Warnings = &v
	return s
}

// Specifies the details of a governed table.
type TableObject struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 ETag of the object. Returned by GetTableObjects for validation
	// and used to identify changes to the underlying data.
	ETag *string `min:"1" type:"string"`

	// The size of the Amazon S3 object in bytes.
	Size *int64 `type:"long"`

	// The Amazon S3 location of the object.
	Uri *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TableObject) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TableObject) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *TableObject) SetETag(v string) *TableObject {
	s.ETag = &v
	return s
}

// SetSize sets the Size field's value.
func (s *TableObject) SetSize(v int64) *TableObject {
	s.Size = &v
	return s
}

// SetUri sets the Uri field's value.
func (s *TableObject) SetUri(v string) *TableObject {
	s.Uri = &v
	return s
}

// A structure for the table object. A table is a metadata definition that represents
// your data. You can Grant and Revoke table privileges to a principal.
type TableResource struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, it is the account ID of
	// the caller.
	CatalogId *string `min:"1" type:"string"`

	// The name of the database for the table. Unique to a Data Catalog. A database
	// is a set of associated table definitions organized into a logical group.
	// You can Grant and Revoke database privileges to a principal.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// The name of the table.
	Name *string `min:"1" type:"string"`

	// A wildcard object representing every table under a database.
	//
	// At least one of TableResource$Name or TableResource$TableWildcard is required.
	TableWildcard *TableWildcard `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TableResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TableResource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TableResource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TableResource"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *TableResource) SetCatalogId(v string) *TableResource {
	s.CatalogId = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *TableResource) SetDatabaseName(v string) *TableResource {
	s.DatabaseName = &v
	return s
}

// SetName sets the Name field's value.
func (s *TableResource) SetName(v string) *TableResource {
	s.Name = &v
	return s
}

// SetTableWildcard sets the TableWildcard field's value.
func (s *TableResource) SetTableWildcard(v *TableWildcard) *TableResource {
	s.TableWildcard = v
	return s
}

// A wildcard object representing every table under a database.
type TableWildcard struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TableWildcard) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TableWildcard) GoString() string {
	return s.String()
}

// A structure for a table with columns object. This object is only used when
// granting a SELECT permission.
//
// This object must take a value for at least one of ColumnsNames, ColumnsIndexes,
// or ColumnsWildcard.
type TableWithColumnsResource struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, it is the account ID of
	// the caller.
	CatalogId *string `min:"1" type:"string"`

	// The list of column names for the table. At least one of ColumnNames or ColumnWildcard
	// is required.
	ColumnNames []*string `type:"list"`

	// A wildcard specified by a ColumnWildcard object. At least one of ColumnNames
	// or ColumnWildcard is required.
	ColumnWildcard *ColumnWildcard `type:"structure"`

	// The name of the database for the table with columns resource. Unique to the
	// Data Catalog. A database is a set of associated table definitions organized
	// into a logical group. You can Grant and Revoke database privileges to a principal.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// The name of the table resource. A table is a metadata definition that represents
	// your data. You can Grant and Revoke table privileges to a principal.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TableWithColumnsResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TableWithColumnsResource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TableWithColumnsResource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TableWithColumnsResource"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *TableWithColumnsResource) SetCatalogId(v string) *TableWithColumnsResource {
	s.CatalogId = &v
	return s
}

// SetColumnNames sets the ColumnNames field's value.
func (s *TableWithColumnsResource) SetColumnNames(v []*string) *TableWithColumnsResource {
	s.ColumnNames = v
	return s
}

// SetColumnWildcard sets the ColumnWildcard field's value.
func (s *TableWithColumnsResource) SetColumnWildcard(v *ColumnWildcard) *TableWithColumnsResource {
	s.ColumnWildcard = v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *TableWithColumnsResource) SetDatabaseName(v string) *TableWithColumnsResource {
	s.DatabaseName = &v
	return s
}

// SetName sets the Name field's value.
func (s *TableWithColumnsResource) SetName(v string) *TableWithColumnsResource {
	s.Name = &v
	return s
}

// A structure describing a database resource with LF-tags.
type TaggedDatabase struct {
	_ struct{} `type:"structure"`

	// A database that has LF-tags attached to it.
	Database *DatabaseResource `type:"structure"`

	// A list of LF-tags attached to the database.
	LFTags []*LFTagPair `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TaggedDatabase) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TaggedDatabase) GoString() string {
	return s.String()
}

// SetDatabase sets the Database field's value.
func (s *TaggedDatabase) SetDatabase(v *DatabaseResource) *TaggedDatabase {
	s.Database = v
	return s
}

// SetLFTags sets the LFTags field's value.
func (s *TaggedDatabase) SetLFTags(v []*LFTagPair) *TaggedDatabase {
	s.LFTags = v
	return s
}

// A structure describing a table resource with LF-tags.
type TaggedTable struct {
	_ struct{} `type:"structure"`

	// A list of LF-tags attached to the database where the table resides.
	LFTagOnDatabase []*LFTagPair `min:"1" type:"list"`

	// A list of LF-tags attached to columns in the table.
	LFTagsOnColumns []*ColumnLFTag `type:"list"`

	// A list of LF-tags attached to the table.
	LFTagsOnTable []*LFTagPair `min:"1" type:"list"`

	// A table that has LF-tags attached to it.
	Table *TableResource `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TaggedTable) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TaggedTable) GoString() string {
	return s.String()
}

// SetLFTagOnDatabase sets the LFTagOnDatabase field's value.
func (s *TaggedTable) SetLFTagOnDatabase(v []*LFTagPair) *TaggedTable {
	s.LFTagOnDatabase = v
	return s
}

// SetLFTagsOnColumns sets the LFTagsOnColumns field's value.
func (s *TaggedTable) SetLFTagsOnColumns(v []*ColumnLFTag) *TaggedTable {
	s.LFTagsOnColumns = v
	return s
}

// SetLFTagsOnTable sets the LFTagsOnTable field's value.
func (s *TaggedTable) SetLFTagsOnTable(v []*LFTagPair) *TaggedTable {
	s.LFTagsOnTable = v
	return s
}

// SetTable sets the Table field's value.
func (s *TaggedTable) SetTable(v *TableResource) *TaggedTable {
	s.Table = v
	return s
}

// Contains details about an error where the query request was throttled.
type ThrottledException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message describing the error.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottledException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottledException) GoString() string {
	return s.String()
}

func newErrorThrottledException(v protocol.ResponseMetadata) error {
	return &ThrottledException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottledException) Code() string {
	return "ThrottledException"
}

// Message returns the exception's message.
func (s *ThrottledException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottledException) OrigErr() error {
	return nil
}

func (s *ThrottledException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottledException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottledException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains details about an error related to a transaction that was cancelled.
type TransactionCanceledException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message describing the error.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TransactionCanceledException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TransactionCanceledException) GoString() string {
	return s.String()
}

func newErrorTransactionCanceledException(v protocol.ResponseMetadata) error {
	return &TransactionCanceledException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TransactionCanceledException) Code() string {
	return "TransactionCanceledException"
}

// Message returns the exception's message.
func (s *TransactionCanceledException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TransactionCanceledException) OrigErr() error {
	return nil
}

func (s *TransactionCanceledException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TransactionCanceledException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TransactionCanceledException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains details about an error related to a transaction commit that was
// in progress.
type TransactionCommitInProgressException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message describing the error.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TransactionCommitInProgressException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TransactionCommitInProgressException) GoString() string {
	return s.String()
}

func newErrorTransactionCommitInProgressException(v protocol.ResponseMetadata) error {
	return &TransactionCommitInProgressException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TransactionCommitInProgressException) Code() string {
	return "TransactionCommitInProgressException"
}

// Message returns the exception's message.
func (s *TransactionCommitInProgressException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TransactionCommitInProgressException) OrigErr() error {
	return nil
}

func (s *TransactionCommitInProgressException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TransactionCommitInProgressException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TransactionCommitInProgressException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains details about an error where the specified transaction has already
// been committed and cannot be used for UpdateTableObjects.
type TransactionCommittedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message describing the error.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TransactionCommittedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TransactionCommittedException) GoString() string {
	return s.String()
}

func newErrorTransactionCommittedException(v protocol.ResponseMetadata) error {
	return &TransactionCommittedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TransactionCommittedException) Code() string {
	return "TransactionCommittedException"
}

// Message returns the exception's message.
func (s *TransactionCommittedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TransactionCommittedException) OrigErr() error {
	return nil
}

func (s *TransactionCommittedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TransactionCommittedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TransactionCommittedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A structure that contains information about a transaction.
type TransactionDescription struct {
	_ struct{} `type:"structure"`

	// The time when the transaction committed or aborted, if it is not currently
	// active.
	TransactionEndTime *time.Time `type:"timestamp"`

	// The ID of the transaction.
	TransactionId *string `min:"1" type:"string"`

	// The time when the transaction started.
	TransactionStartTime *time.Time `type:"timestamp"`

	// A status of ACTIVE, COMMITTED, or ABORTED.
	TransactionStatus *string `type:"string" enum:"TransactionStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TransactionDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TransactionDescription) GoString() string {
	return s.String()
}

// SetTransactionEndTime sets the TransactionEndTime field's value.
func (s *TransactionDescription) SetTransactionEndTime(v time.Time) *TransactionDescription {
	s.TransactionEndTime = &v
	return s
}

// SetTransactionId sets the TransactionId field's value.
func (s *TransactionDescription) SetTransactionId(v string) *TransactionDescription {
	s.TransactionId = &v
	return s
}

// SetTransactionStartTime sets the TransactionStartTime field's value.
func (s *TransactionDescription) SetTransactionStartTime(v time.Time) *TransactionDescription {
	s.TransactionStartTime = &v
	return s
}

// SetTransactionStatus sets the TransactionStatus field's value.
func (s *TransactionDescription) SetTransactionStatus(v string) *TransactionDescription {
	s.TransactionStatus = &v
	return s
}

type UpdateDataCellsFilterInput struct {
	_ struct{} `type:"structure"`

	// A DataCellsFilter structure containing information about the data cells filter.
	//
	// TableData is a required field
	TableData *DataCellsFilter `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDataCellsFilterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDataCellsFilterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDataCellsFilterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDataCellsFilterInput"}
	if s.TableData == nil {
		invalidParams.Add(request.NewErrParamRequired("TableData"))
	}
	if s.TableData != nil {
		if err := s.TableData.Validate(); err != nil {
			invalidParams.AddNested("TableData", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTableData sets the TableData field's value.
func (s *UpdateDataCellsFilterInput) SetTableData(v *DataCellsFilter) *UpdateDataCellsFilterInput {
	s.TableData = v
	return s
}

type UpdateDataCellsFilterOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDataCellsFilterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDataCellsFilterOutput) GoString() string {
	return s.String()
}

type UpdateLFTagInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, and other control information to manage your Lake Formation
	// environment.
	CatalogId *string `min:"1" type:"string"`

	// The key-name for the LF-tag for which to add or delete values.
	//
	// TagKey is a required field
	TagKey *string `min:"1" type:"string" required:"true"`

	// A list of LF-tag values to add from the LF-tag.
	TagValuesToAdd []*string `min:"1" type:"list"`

	// A list of LF-tag values to delete from the LF-tag.
	TagValuesToDelete []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLFTagInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLFTagInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateLFTagInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateLFTagInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.TagKey == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKey"))
	}
	if s.TagKey != nil && len(*s.TagKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKey", 1))
	}
	if s.TagValuesToAdd != nil && len(s.TagValuesToAdd) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagValuesToAdd", 1))
	}
	if s.TagValuesToDelete != nil && len(s.TagValuesToDelete) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagValuesToDelete", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *UpdateLFTagInput) SetCatalogId(v string) *UpdateLFTagInput {
	s.CatalogId = &v
	return s
}

// SetTagKey sets the TagKey field's value.
func (s *UpdateLFTagInput) SetTagKey(v string) *UpdateLFTagInput {
	s.TagKey = &v
	return s
}

// SetTagValuesToAdd sets the TagValuesToAdd field's value.
func (s *UpdateLFTagInput) SetTagValuesToAdd(v []*string) *UpdateLFTagInput {
	s.TagValuesToAdd = v
	return s
}

// SetTagValuesToDelete sets the TagValuesToDelete field's value.
func (s *UpdateLFTagInput) SetTagValuesToDelete(v []*string) *UpdateLFTagInput {
	s.TagValuesToDelete = v
	return s
}

type UpdateLFTagOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLFTagOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLFTagOutput) GoString() string {
	return s.String()
}

type UpdateLakeFormationIdentityCenterConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Allows to enable or disable the IAM Identity Center connection.
	ApplicationStatus *string `type:"string" enum:"ApplicationStatus"`

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, view definitions, and other control information to manage
	// your Lake Formation environment.
	CatalogId *string `min:"1" type:"string"`

	// A list of the account IDs of Amazon Web Services accounts of third-party
	// applications that are allowed to access data managed by Lake Formation.
	ExternalFiltering *ExternalFilteringConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLakeFormationIdentityCenterConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLakeFormationIdentityCenterConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateLakeFormationIdentityCenterConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateLakeFormationIdentityCenterConfigurationInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.ExternalFiltering != nil {
		if err := s.ExternalFiltering.Validate(); err != nil {
			invalidParams.AddNested("ExternalFiltering", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationStatus sets the ApplicationStatus field's value.
func (s *UpdateLakeFormationIdentityCenterConfigurationInput) SetApplicationStatus(v string) *UpdateLakeFormationIdentityCenterConfigurationInput {
	s.ApplicationStatus = &v
	return s
}

// SetCatalogId sets the CatalogId field's value.
func (s *UpdateLakeFormationIdentityCenterConfigurationInput) SetCatalogId(v string) *UpdateLakeFormationIdentityCenterConfigurationInput {
	s.CatalogId = &v
	return s
}

// SetExternalFiltering sets the ExternalFiltering field's value.
func (s *UpdateLakeFormationIdentityCenterConfigurationInput) SetExternalFiltering(v *ExternalFilteringConfiguration) *UpdateLakeFormationIdentityCenterConfigurationInput {
	s.ExternalFiltering = v
	return s
}

type UpdateLakeFormationIdentityCenterConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLakeFormationIdentityCenterConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLakeFormationIdentityCenterConfigurationOutput) GoString() string {
	return s.String()
}

type UpdateResourceInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether the data access of tables pointing to the location can
	// be managed by both Lake Formation permissions as well as Amazon S3 bucket
	// policies.
	HybridAccessEnabled *bool `type:"boolean"`

	// The resource ARN.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`

	// The new role to use for the given resource registered in Lake Formation.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`

	// Whether or not the resource is a federated resource.
	WithFederation *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHybridAccessEnabled sets the HybridAccessEnabled field's value.
func (s *UpdateResourceInput) SetHybridAccessEnabled(v bool) *UpdateResourceInput {
	s.HybridAccessEnabled = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UpdateResourceInput) SetResourceArn(v string) *UpdateResourceInput {
	s.ResourceArn = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *UpdateResourceInput) SetRoleArn(v string) *UpdateResourceInput {
	s.RoleArn = &v
	return s
}

// SetWithFederation sets the WithFederation field's value.
func (s *UpdateResourceInput) SetWithFederation(v bool) *UpdateResourceInput {
	s.WithFederation = &v
	return s
}

type UpdateResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateResourceOutput) GoString() string {
	return s.String()
}

type UpdateTableObjectsInput struct {
	_ struct{} `type:"structure"`

	// The catalog containing the governed table to update. Defaults to the caller’s
	// account ID.
	CatalogId *string `min:"1" type:"string"`

	// The database containing the governed table to update.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// The governed table to update.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`

	// The transaction at which to do the write.
	TransactionId *string `min:"1" type:"string"`

	// A list of WriteOperation objects that define an object to add to or delete
	// from the manifest for a governed table.
	//
	// WriteOperations is a required field
	WriteOperations []*WriteOperation `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTableObjectsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTableObjectsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTableObjectsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTableObjectsInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 1))
	}
	if s.TransactionId != nil && len(*s.TransactionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TransactionId", 1))
	}
	if s.WriteOperations == nil {
		invalidParams.Add(request.NewErrParamRequired("WriteOperations"))
	}
	if s.WriteOperations != nil && len(s.WriteOperations) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WriteOperations", 1))
	}
	if s.WriteOperations != nil {
		for i, v := range s.WriteOperations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "WriteOperations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *UpdateTableObjectsInput) SetCatalogId(v string) *UpdateTableObjectsInput {
	s.CatalogId = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *UpdateTableObjectsInput) SetDatabaseName(v string) *UpdateTableObjectsInput {
	s.DatabaseName = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *UpdateTableObjectsInput) SetTableName(v string) *UpdateTableObjectsInput {
	s.TableName = &v
	return s
}

// SetTransactionId sets the TransactionId field's value.
func (s *UpdateTableObjectsInput) SetTransactionId(v string) *UpdateTableObjectsInput {
	s.TransactionId = &v
	return s
}

// SetWriteOperations sets the WriteOperations field's value.
func (s *UpdateTableObjectsInput) SetWriteOperations(v []*WriteOperation) *UpdateTableObjectsInput {
	s.WriteOperations = v
	return s
}

type UpdateTableObjectsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTableObjectsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTableObjectsOutput) GoString() string {
	return s.String()
}

type UpdateTableStorageOptimizerInput struct {
	_ struct{} `type:"structure"`

	// The Catalog ID of the table.
	CatalogId *string `min:"1" type:"string"`

	// Name of the database where the table is present.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// Name of the table for which to enable the storage optimizer.
	//
	// StorageOptimizerConfig is a required field
	StorageOptimizerConfig map[string]map[string]*string `type:"map" required:"true"`

	// Name of the table for which to enable the storage optimizer.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTableStorageOptimizerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTableStorageOptimizerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTableStorageOptimizerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTableStorageOptimizerInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.StorageOptimizerConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("StorageOptimizerConfig"))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *UpdateTableStorageOptimizerInput) SetCatalogId(v string) *UpdateTableStorageOptimizerInput {
	s.CatalogId = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *UpdateTableStorageOptimizerInput) SetDatabaseName(v string) *UpdateTableStorageOptimizerInput {
	s.DatabaseName = &v
	return s
}

// SetStorageOptimizerConfig sets the StorageOptimizerConfig field's value.
func (s *UpdateTableStorageOptimizerInput) SetStorageOptimizerConfig(v map[string]map[string]*string) *UpdateTableStorageOptimizerInput {
	s.StorageOptimizerConfig = v
	return s
}

// SetTableName sets the TableName field's value.
func (s *UpdateTableStorageOptimizerInput) SetTableName(v string) *UpdateTableStorageOptimizerInput {
	s.TableName = &v
	return s
}

type UpdateTableStorageOptimizerOutput struct {
	_ struct{} `type:"structure"`

	// A response indicating the success of failure of the operation.
	Result *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTableStorageOptimizerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTableStorageOptimizerOutput) GoString() string {
	return s.String()
}

// SetResult sets the Result field's value.
func (s *UpdateTableStorageOptimizerOutput) SetResult(v string) *UpdateTableStorageOptimizerOutput {
	s.Result = &v
	return s
}

// An object that defines an Amazon S3 object to be deleted if a transaction
// cancels, provided that VirtualPut was called before writing the object.
type VirtualObject struct {
	_ struct{} `type:"structure"`

	// The ETag of the Amazon S3 object.
	ETag *string `min:"1" type:"string"`

	// The path to the Amazon S3 object. Must start with s3://
	//
	// Uri is a required field
	Uri *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualObject) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VirtualObject) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualObject) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VirtualObject"}
	if s.ETag != nil && len(*s.ETag) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ETag", 1))
	}
	if s.Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("Uri"))
	}
	if s.Uri != nil && len(*s.Uri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Uri", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetETag sets the ETag field's value.
func (s *VirtualObject) SetETag(v string) *VirtualObject {
	s.ETag = &v
	return s
}

// SetUri sets the Uri field's value.
func (s *VirtualObject) SetUri(v string) *VirtualObject {
	s.Uri = &v
	return s
}

// Defines the valid range of work unit IDs for querying the execution service.
type WorkUnitRange struct {
	_ struct{} `type:"structure"`

	// Defines the maximum work unit ID in the range. The maximum value is inclusive.
	//
	// WorkUnitIdMax is a required field
	WorkUnitIdMax *int64 `type:"long" required:"true"`

	// Defines the minimum work unit ID in the range.
	//
	// WorkUnitIdMin is a required field
	WorkUnitIdMin *int64 `type:"long" required:"true"`

	// A work token used to query the execution service.
	//
	// WorkUnitToken is a required field
	WorkUnitToken *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkUnitRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkUnitRange) GoString() string {
	return s.String()
}

// SetWorkUnitIdMax sets the WorkUnitIdMax field's value.
func (s *WorkUnitRange) SetWorkUnitIdMax(v int64) *WorkUnitRange {
	s.WorkUnitIdMax = &v
	return s
}

// SetWorkUnitIdMin sets the WorkUnitIdMin field's value.
func (s *WorkUnitRange) SetWorkUnitIdMin(v int64) *WorkUnitRange {
	s.WorkUnitIdMin = &v
	return s
}

// SetWorkUnitToken sets the WorkUnitToken field's value.
func (s *WorkUnitRange) SetWorkUnitToken(v string) *WorkUnitRange {
	s.WorkUnitToken = &v
	return s
}

// Contains details about an error related to work units not being ready.
type WorkUnitsNotReadyYetException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message describing the error.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkUnitsNotReadyYetException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkUnitsNotReadyYetException) GoString() string {
	return s.String()
}

func newErrorWorkUnitsNotReadyYetException(v protocol.ResponseMetadata) error {
	return &WorkUnitsNotReadyYetException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *WorkUnitsNotReadyYetException) Code() string {
	return "WorkUnitsNotReadyYetException"
}

// Message returns the exception's message.
func (s *WorkUnitsNotReadyYetException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *WorkUnitsNotReadyYetException) OrigErr() error {
	return nil
}

func (s *WorkUnitsNotReadyYetException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *WorkUnitsNotReadyYetException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *WorkUnitsNotReadyYetException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Defines an object to add to or delete from a governed table.
type WriteOperation struct {
	_ struct{} `type:"structure"`

	// A new object to add to the governed table.
	AddObject *AddObjectInput_ `type:"structure"`

	// An object to delete from the governed table.
	DeleteObject *DeleteObjectInput_ `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WriteOperation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WriteOperation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WriteOperation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WriteOperation"}
	if s.AddObject != nil {
		if err := s.AddObject.Validate(); err != nil {
			invalidParams.AddNested("AddObject", err.(request.ErrInvalidParams))
		}
	}
	if s.DeleteObject != nil {
		if err := s.DeleteObject.Validate(); err != nil {
			invalidParams.AddNested("DeleteObject", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddObject sets the AddObject field's value.
func (s *WriteOperation) SetAddObject(v *AddObjectInput_) *WriteOperation {
	s.AddObject = v
	return s
}

// SetDeleteObject sets the DeleteObject field's value.
func (s *WriteOperation) SetDeleteObject(v *DeleteObjectInput_) *WriteOperation {
	s.DeleteObject = v
	return s
}

const (
	// ApplicationStatusEnabled is a ApplicationStatus enum value
	ApplicationStatusEnabled = "ENABLED"

	// ApplicationStatusDisabled is a ApplicationStatus enum value
	ApplicationStatusDisabled = "DISABLED"
)

// ApplicationStatus_Values returns all elements of the ApplicationStatus enum
func ApplicationStatus_Values() []string {
	return []string{
		ApplicationStatusEnabled,
		ApplicationStatusDisabled,
	}
}

const (
	// ComparisonOperatorEq is a ComparisonOperator enum value
	ComparisonOperatorEq = "EQ"

	// ComparisonOperatorNe is a ComparisonOperator enum value
	ComparisonOperatorNe = "NE"

	// ComparisonOperatorLe is a ComparisonOperator enum value
	ComparisonOperatorLe = "LE"

	// ComparisonOperatorLt is a ComparisonOperator enum value
	ComparisonOperatorLt = "LT"

	// ComparisonOperatorGe is a ComparisonOperator enum value
	ComparisonOperatorGe = "GE"

	// ComparisonOperatorGt is a ComparisonOperator enum value
	ComparisonOperatorGt = "GT"

	// ComparisonOperatorContains is a ComparisonOperator enum value
	ComparisonOperatorContains = "CONTAINS"

	// ComparisonOperatorNotContains is a ComparisonOperator enum value
	ComparisonOperatorNotContains = "NOT_CONTAINS"

	// ComparisonOperatorBeginsWith is a ComparisonOperator enum value
	ComparisonOperatorBeginsWith = "BEGINS_WITH"

	// ComparisonOperatorIn is a ComparisonOperator enum value
	ComparisonOperatorIn = "IN"

	// ComparisonOperatorBetween is a ComparisonOperator enum value
	ComparisonOperatorBetween = "BETWEEN"
)

// ComparisonOperator_Values returns all elements of the ComparisonOperator enum
func ComparisonOperator_Values() []string {
	return []string{
		ComparisonOperatorEq,
		ComparisonOperatorNe,
		ComparisonOperatorLe,
		ComparisonOperatorLt,
		ComparisonOperatorGe,
		ComparisonOperatorGt,
		ComparisonOperatorContains,
		ComparisonOperatorNotContains,
		ComparisonOperatorBeginsWith,
		ComparisonOperatorIn,
		ComparisonOperatorBetween,
	}
}

const (
	// DataLakeResourceTypeCatalog is a DataLakeResourceType enum value
	DataLakeResourceTypeCatalog = "CATALOG"

	// DataLakeResourceTypeDatabase is a DataLakeResourceType enum value
	DataLakeResourceTypeDatabase = "DATABASE"

	// DataLakeResourceTypeTable is a DataLakeResourceType enum value
	DataLakeResourceTypeTable = "TABLE"

	// DataLakeResourceTypeDataLocation is a DataLakeResourceType enum value
	DataLakeResourceTypeDataLocation = "DATA_LOCATION"

	// DataLakeResourceTypeLfTag is a DataLakeResourceType enum value
	DataLakeResourceTypeLfTag = "LF_TAG"

	// DataLakeResourceTypeLfTagPolicy is a DataLakeResourceType enum value
	DataLakeResourceTypeLfTagPolicy = "LF_TAG_POLICY"

	// DataLakeResourceTypeLfTagPolicyDatabase is a DataLakeResourceType enum value
	DataLakeResourceTypeLfTagPolicyDatabase = "LF_TAG_POLICY_DATABASE"

	// DataLakeResourceTypeLfTagPolicyTable is a DataLakeResourceType enum value
	DataLakeResourceTypeLfTagPolicyTable = "LF_TAG_POLICY_TABLE"
)

// DataLakeResourceType_Values returns all elements of the DataLakeResourceType enum
func DataLakeResourceType_Values() []string {
	return []string{
		DataLakeResourceTypeCatalog,
		DataLakeResourceTypeDatabase,
		DataLakeResourceTypeTable,
		DataLakeResourceTypeDataLocation,
		DataLakeResourceTypeLfTag,
		DataLakeResourceTypeLfTagPolicy,
		DataLakeResourceTypeLfTagPolicyDatabase,
		DataLakeResourceTypeLfTagPolicyTable,
	}
}

const (
	// EnableStatusEnabled is a EnableStatus enum value
	EnableStatusEnabled = "ENABLED"

	// EnableStatusDisabled is a EnableStatus enum value
	EnableStatusDisabled = "DISABLED"
)

// EnableStatus_Values returns all elements of the EnableStatus enum
func EnableStatus_Values() []string {
	return []string{
		EnableStatusEnabled,
		EnableStatusDisabled,
	}
}

const (
	// FieldNameStringResourceArn is a FieldNameString enum value
	FieldNameStringResourceArn = "RESOURCE_ARN"

	// FieldNameStringRoleArn is a FieldNameString enum value
	FieldNameStringRoleArn = "ROLE_ARN"

	// FieldNameStringLastModified is a FieldNameString enum value
	FieldNameStringLastModified = "LAST_MODIFIED"
)

// FieldNameString_Values returns all elements of the FieldNameString enum
func FieldNameString_Values() []string {
	return []string{
		FieldNameStringResourceArn,
		FieldNameStringRoleArn,
		FieldNameStringLastModified,
	}
}

const (
	// OptimizerTypeCompaction is a OptimizerType enum value
	OptimizerTypeCompaction = "COMPACTION"

	// OptimizerTypeGarbageCollection is a OptimizerType enum value
	OptimizerTypeGarbageCollection = "GARBAGE_COLLECTION"

	// OptimizerTypeAll is a OptimizerType enum value
	OptimizerTypeAll = "ALL"
)

// OptimizerType_Values returns all elements of the OptimizerType enum
func OptimizerType_Values() []string {
	return []string{
		OptimizerTypeCompaction,
		OptimizerTypeGarbageCollection,
		OptimizerTypeAll,
	}
}

const (
	// PermissionAll is a Permission enum value
	PermissionAll = "ALL"

	// PermissionSelect is a Permission enum value
	PermissionSelect = "SELECT"

	// PermissionAlter is a Permission enum value
	PermissionAlter = "ALTER"

	// PermissionDrop is a Permission enum value
	PermissionDrop = "DROP"

	// PermissionDelete is a Permission enum value
	PermissionDelete = "DELETE"

	// PermissionInsert is a Permission enum value
	PermissionInsert = "INSERT"

	// PermissionDescribe is a Permission enum value
	PermissionDescribe = "DESCRIBE"

	// PermissionCreateDatabase is a Permission enum value
	PermissionCreateDatabase = "CREATE_DATABASE"

	// PermissionCreateTable is a Permission enum value
	PermissionCreateTable = "CREATE_TABLE"

	// PermissionDataLocationAccess is a Permission enum value
	PermissionDataLocationAccess = "DATA_LOCATION_ACCESS"

	// PermissionCreateLfTag is a Permission enum value
	PermissionCreateLfTag = "CREATE_LF_TAG"

	// PermissionAssociate is a Permission enum value
	PermissionAssociate = "ASSOCIATE"

	// PermissionGrantWithLfTagExpression is a Permission enum value
	PermissionGrantWithLfTagExpression = "GRANT_WITH_LF_TAG_EXPRESSION"
)

// Permission_Values returns all elements of the Permission enum
func Permission_Values() []string {
	return []string{
		PermissionAll,
		PermissionSelect,
		PermissionAlter,
		PermissionDrop,
		PermissionDelete,
		PermissionInsert,
		PermissionDescribe,
		PermissionCreateDatabase,
		PermissionCreateTable,
		PermissionDataLocationAccess,
		PermissionCreateLfTag,
		PermissionAssociate,
		PermissionGrantWithLfTagExpression,
	}
}

const (
	// PermissionTypeColumnPermission is a PermissionType enum value
	PermissionTypeColumnPermission = "COLUMN_PERMISSION"

	// PermissionTypeCellFilterPermission is a PermissionType enum value
	PermissionTypeCellFilterPermission = "CELL_FILTER_PERMISSION"

	// PermissionTypeNestedPermission is a PermissionType enum value
	PermissionTypeNestedPermission = "NESTED_PERMISSION"

	// PermissionTypeNestedCellPermission is a PermissionType enum value
	PermissionTypeNestedCellPermission = "NESTED_CELL_PERMISSION"
)

// PermissionType_Values returns all elements of the PermissionType enum
func PermissionType_Values() []string {
	return []string{
		PermissionTypeColumnPermission,
		PermissionTypeCellFilterPermission,
		PermissionTypeNestedPermission,
		PermissionTypeNestedCellPermission,
	}
}

const (
	// QueryStateStringPending is a QueryStateString enum value
	QueryStateStringPending = "PENDING"

	// QueryStateStringWorkunitsAvailable is a QueryStateString enum value
	QueryStateStringWorkunitsAvailable = "WORKUNITS_AVAILABLE"

	// QueryStateStringError is a QueryStateString enum value
	QueryStateStringError = "ERROR"

	// QueryStateStringFinished is a QueryStateString enum value
	QueryStateStringFinished = "FINISHED"

	// QueryStateStringExpired is a QueryStateString enum value
	QueryStateStringExpired = "EXPIRED"
)

// QueryStateString_Values returns all elements of the QueryStateString enum
func QueryStateString_Values() []string {
	return []string{
		QueryStateStringPending,
		QueryStateStringWorkunitsAvailable,
		QueryStateStringError,
		QueryStateStringFinished,
		QueryStateStringExpired,
	}
}

const (
	// ResourceShareTypeForeign is a ResourceShareType enum value
	ResourceShareTypeForeign = "FOREIGN"

	// ResourceShareTypeAll is a ResourceShareType enum value
	ResourceShareTypeAll = "ALL"
)

// ResourceShareType_Values returns all elements of the ResourceShareType enum
func ResourceShareType_Values() []string {
	return []string{
		ResourceShareTypeForeign,
		ResourceShareTypeAll,
	}
}

const (
	// ResourceTypeDatabase is a ResourceType enum value
	ResourceTypeDatabase = "DATABASE"

	// ResourceTypeTable is a ResourceType enum value
	ResourceTypeTable = "TABLE"
)

// ResourceType_Values returns all elements of the ResourceType enum
func ResourceType_Values() []string {
	return []string{
		ResourceTypeDatabase,
		ResourceTypeTable,
	}
}

const (
	// TransactionStatusActive is a TransactionStatus enum value
	TransactionStatusActive = "ACTIVE"

	// TransactionStatusCommitted is a TransactionStatus enum value
	TransactionStatusCommitted = "COMMITTED"

	// TransactionStatusAborted is a TransactionStatus enum value
	TransactionStatusAborted = "ABORTED"

	// TransactionStatusCommitInProgress is a TransactionStatus enum value
	TransactionStatusCommitInProgress = "COMMIT_IN_PROGRESS"
)

// TransactionStatus_Values returns all elements of the TransactionStatus enum
func TransactionStatus_Values() []string {
	return []string{
		TransactionStatusActive,
		TransactionStatusCommitted,
		TransactionStatusAborted,
		TransactionStatusCommitInProgress,
	}
}

const (
	// TransactionStatusFilterAll is a TransactionStatusFilter enum value
	TransactionStatusFilterAll = "ALL"

	// TransactionStatusFilterCompleted is a TransactionStatusFilter enum value
	TransactionStatusFilterCompleted = "COMPLETED"

	// TransactionStatusFilterActive is a TransactionStatusFilter enum value
	TransactionStatusFilterActive = "ACTIVE"

	// TransactionStatusFilterCommitted is a TransactionStatusFilter enum value
	TransactionStatusFilterCommitted = "COMMITTED"

	// TransactionStatusFilterAborted is a TransactionStatusFilter enum value
	TransactionStatusFilterAborted = "ABORTED"
)

// TransactionStatusFilter_Values returns all elements of the TransactionStatusFilter enum
func TransactionStatusFilter_Values() []string {
	return []string{
		TransactionStatusFilterAll,
		TransactionStatusFilterCompleted,
		TransactionStatusFilterActive,
		TransactionStatusFilterCommitted,
		TransactionStatusFilterAborted,
	}
}

const (
	// TransactionTypeReadAndWrite is a TransactionType enum value
	TransactionTypeReadAndWrite = "READ_AND_WRITE"

	// TransactionTypeReadOnly is a TransactionType enum value
	TransactionTypeReadOnly = "READ_ONLY"
)

// TransactionType_Values returns all elements of the TransactionType enum
func TransactionType_Values() []string {
	return []string{
		TransactionTypeReadAndWrite,
		TransactionTypeReadOnly,
	}
}
