# Go API client for waf

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

## Overview
This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.  By using the [OpenAPI-spec](https://www.openapis.org/) from a remote server, you can easily generate an API client.

- API version: 2.0.0
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.GoClientCodegen

## Installation

Install the following dependencies:

```shell
go get github.com/stretchr/testify/assert
go get golang.org/x/net/context
```

Put the package under your project folder and add the following in import:

```golang
import waf "github.com/GIT_USER_ID/GIT_REPO_ID"
```

To use a proxy, set the environment variable `HTTP_PROXY`:

```golang
os.Setenv("HTTP_PROXY", "http://proxy_name:proxy_port")
```

## Configuration of Server URL

Default configuration comes with `Servers` field that contains server objects as defined in the OpenAPI specification.

### Select Server Configuration

For using other server than the one defined on index 0 set context value `sw.ContextServerIndex` of type `int`.

```golang
ctx := context.WithValue(context.Background(), waf.ContextServerIndex, 1)
```

### Templated Server URL

Templated server URL is formatted using default variables from configuration or from context value `sw.ContextServerVariables` of type `map[string]string`.

```golang
ctx := context.WithValue(context.Background(), waf.ContextServerVariables, map[string]string{
	"basePath": "v2",
})
```

Note, enum values are always validated and all unused variables are silently ignored.

### URLs Configuration per Operation

Each operation can use different server URL defined using `OperationServers` map in the `Configuration`.
An operation is uniquely identified by `"{classname}Service.{nickname}"` string.
Similar rules for overriding default operation server index and variables applies by using `sw.ContextOperationServerIndices` and `sw.ContextOperationServerVariables` context maps.

```golang
ctx := context.WithValue(context.Background(), waf.ContextOperationServerIndices, map[string]int{
	"{classname}Service.{nickname}": 2,
})
ctx = context.WithValue(context.Background(), waf.ContextOperationServerVariables, map[string]map[string]string{
	"{classname}Service.{nickname}": {
		"port": "8443",
	},
})
```

## Documentation for API Endpoints

All URIs are relative to *https://api.azionapi.net*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*WAFAPI* | [**CreateNewWAFRuleset**](docs/WAFAPI.md#createnewwafruleset) | **Post** /waf/rulesets | Create a new WAF Rule Set in an account.
*WAFAPI* | [**DeleteWAFRuleset**](docs/WAFAPI.md#deletewafruleset) | **Delete** /waf/rulesets/{waf_rule_set_id} | Remove an WAF Rule Set from an account. Warning: this action cannot be undone.
*WAFAPI* | [**GetWAFDomains**](docs/WAFAPI.md#getwafdomains) | **Get** /waf/{waf_id}/domains | List all domains attached to a Web Application Firewall (WAF) in an account.
*WAFAPI* | [**GetWAFEvents**](docs/WAFAPI.md#getwafevents) | **Get** /waf/{waf_id}/waf_events | Find WAF log events
*WAFAPI* | [**GetWAFRuleset**](docs/WAFAPI.md#getwafruleset) | **Get** /waf/rulesets/{waf_rule_set_id} | List a specific Rule Set associated to a Web Application Firewall (WAF) in an account.
*WAFAPI* | [**ListAllWAF**](docs/WAFAPI.md#listallwaf) | **Get** /waf | List all Web Application Firewalls (WAFs) created in an account
*WAFAPI* | [**ListAllWAFRulesets**](docs/WAFAPI.md#listallwafrulesets) | **Get** /waf/rulesets | list all Rule Sets associated to a Web Application Firewall (WAF) in an account.
*WAFAPI* | [**UpdateWAFRuleset**](docs/WAFAPI.md#updatewafruleset) | **Patch** /waf/rulesets/{waf_rule_set_id} | Change only select settings of a WAF Rule Set


## Documentation For Models

 - [CreateNewWAFRulesetRequest](docs/CreateNewWAFRulesetRequest.md)
 - [Links](docs/Links.md)
 - [SingleWAF](docs/SingleWAF.md)
 - [WAFDomainList200](docs/WAFDomainList200.md)
 - [WAFDomains200](docs/WAFDomains200.md)
 - [WAFEvents200](docs/WAFEvents200.md)
 - [WAFEvents200ResultsInner](docs/WAFEvents200ResultsInner.md)
 - [WAFEvents200ResultsInnerTop10CountriesInner](docs/WAFEvents200ResultsInnerTop10CountriesInner.md)
 - [WAFEvents400](docs/WAFEvents400.md)
 - [WAFEvents401](docs/WAFEvents401.md)
 - [WAFEvents404](docs/WAFEvents404.md)
 - [WAFList200](docs/WAFList200.md)
 - [WAFSensitivityChoices](docs/WAFSensitivityChoices.md)
 - [WAFSingle200](docs/WAFSingle200.md)


## Documentation For Authorization


Authentication schemes defined for the API:
### tokenAuth

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header

Note, each API key must be added to a map of `map[string]APIKey` where the key is: Authorization and passed in as the auth context for each request.

Example

```golang
auth := context.WithValue(
		context.Background(),
		sw.ContextAPIKeys,
		map[string]sw.APIKey{
			"Authorization": {Key: "API_KEY_STRING"},
		},
	)
r, err := client.Service.Operation(auth, args)
```


## Documentation for Utility Methods

Due to the fact that model structure members are all pointers, this package contains
a number of utility functions to easily obtain pointers to values of basic types.
Each of these functions takes a value of the given basic type and returns a pointer to it:

* `PtrBool`
* `PtrInt`
* `PtrInt32`
* `PtrInt64`
* `PtrFloat`
* `PtrFloat32`
* `PtrFloat64`
* `PtrString`
* `PtrTime`

## Author



