//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
)

// Camera Modes.
type CAMERA_MODE uint64

const (
	// Camera is in image/photo capture mode.
	CAMERA_MODE_IMAGE CAMERA_MODE = 0
	// Camera is in video capture mode.
	CAMERA_MODE_VIDEO CAMERA_MODE = 1
	// Camera is in image survey capture mode. It allows for camera controller to do specific settings for surveys.
	CAMERA_MODE_IMAGE_SURVEY CAMERA_MODE = 2
)

var value_to_label_CAMERA_MODE = map[CAMERA_MODE]string{
	CAMERA_MODE_IMAGE:        "CAMERA_MODE_IMAGE",
	CAMERA_MODE_VIDEO:        "CAMERA_MODE_VIDEO",
	CAMERA_MODE_IMAGE_SURVEY: "CAMERA_MODE_IMAGE_SURVEY",
}

var label_to_value_CAMERA_MODE = map[string]CAMERA_MODE{
	"CAMERA_MODE_IMAGE":        CAMERA_MODE_IMAGE,
	"CAMERA_MODE_VIDEO":        CAMERA_MODE_VIDEO,
	"CAMERA_MODE_IMAGE_SURVEY": CAMERA_MODE_IMAGE_SURVEY,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e CAMERA_MODE) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_CAMERA_MODE[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *CAMERA_MODE) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_CAMERA_MODE[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = CAMERA_MODE(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e CAMERA_MODE) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
