//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
)

// Parameter protocol error types (see PARAM_ERROR).
type MAV_PARAM_ERROR uint64

const (
	// No error occurred (not expected in PARAM_ERROR but may be used in future implementations.
	MAV_PARAM_ERROR_NO_ERROR MAV_PARAM_ERROR = 0
	// Parameter does not exist
	MAV_PARAM_ERROR_DOES_NOT_EXIST MAV_PARAM_ERROR = 1
	// Parameter value does not fit within accepted range
	MAV_PARAM_ERROR_VALUE_OUT_OF_RANGE MAV_PARAM_ERROR = 2
	// Caller is not permitted to set the value of this parameter
	MAV_PARAM_ERROR_PERMISSION_DENIED MAV_PARAM_ERROR = 3
	// Unknown component specified
	MAV_PARAM_ERROR_COMPONENT_NOT_FOUND MAV_PARAM_ERROR = 4
	// Parameter is read-only
	MAV_PARAM_ERROR_READ_ONLY MAV_PARAM_ERROR = 5
	// Parameter data type (MAV_PARAM_TYPE) is not supported by flight stack (at all)
	MAV_PARAM_ERROR_TYPE_UNSUPPORTED MAV_PARAM_ERROR = 6
	// Parameter type does not match expected type
	MAV_PARAM_ERROR_TYPE_MISMATCH MAV_PARAM_ERROR = 7
	// Parameter exists but reading failed
	MAV_PARAM_ERROR_READ_FAIL MAV_PARAM_ERROR = 8
)

var value_to_label_MAV_PARAM_ERROR = map[MAV_PARAM_ERROR]string{
	MAV_PARAM_ERROR_NO_ERROR:            "MAV_PARAM_ERROR_NO_ERROR",
	MAV_PARAM_ERROR_DOES_NOT_EXIST:      "MAV_PARAM_ERROR_DOES_NOT_EXIST",
	MAV_PARAM_ERROR_VALUE_OUT_OF_RANGE:  "MAV_PARAM_ERROR_VALUE_OUT_OF_RANGE",
	MAV_PARAM_ERROR_PERMISSION_DENIED:   "MAV_PARAM_ERROR_PERMISSION_DENIED",
	MAV_PARAM_ERROR_COMPONENT_NOT_FOUND: "MAV_PARAM_ERROR_COMPONENT_NOT_FOUND",
	MAV_PARAM_ERROR_READ_ONLY:           "MAV_PARAM_ERROR_READ_ONLY",
	MAV_PARAM_ERROR_TYPE_UNSUPPORTED:    "MAV_PARAM_ERROR_TYPE_UNSUPPORTED",
	MAV_PARAM_ERROR_TYPE_MISMATCH:       "MAV_PARAM_ERROR_TYPE_MISMATCH",
	MAV_PARAM_ERROR_READ_FAIL:           "MAV_PARAM_ERROR_READ_FAIL",
}

var label_to_value_MAV_PARAM_ERROR = map[string]MAV_PARAM_ERROR{
	"MAV_PARAM_ERROR_NO_ERROR":            MAV_PARAM_ERROR_NO_ERROR,
	"MAV_PARAM_ERROR_DOES_NOT_EXIST":      MAV_PARAM_ERROR_DOES_NOT_EXIST,
	"MAV_PARAM_ERROR_VALUE_OUT_OF_RANGE":  MAV_PARAM_ERROR_VALUE_OUT_OF_RANGE,
	"MAV_PARAM_ERROR_PERMISSION_DENIED":   MAV_PARAM_ERROR_PERMISSION_DENIED,
	"MAV_PARAM_ERROR_COMPONENT_NOT_FOUND": MAV_PARAM_ERROR_COMPONENT_NOT_FOUND,
	"MAV_PARAM_ERROR_READ_ONLY":           MAV_PARAM_ERROR_READ_ONLY,
	"MAV_PARAM_ERROR_TYPE_UNSUPPORTED":    MAV_PARAM_ERROR_TYPE_UNSUPPORTED,
	"MAV_PARAM_ERROR_TYPE_MISMATCH":       MAV_PARAM_ERROR_TYPE_MISMATCH,
	"MAV_PARAM_ERROR_READ_FAIL":           MAV_PARAM_ERROR_READ_FAIL,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e MAV_PARAM_ERROR) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_MAV_PARAM_ERROR[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *MAV_PARAM_ERROR) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_MAV_PARAM_ERROR[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = MAV_PARAM_ERROR(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e MAV_PARAM_ERROR) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
