//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
)

// Speed setpoint types used in MAV_CMD_DO_CHANGE_SPEED
type SPEED_TYPE uint64

const (
	// Airspeed
	SPEED_TYPE_AIRSPEED SPEED_TYPE = 0
	// Groundspeed
	SPEED_TYPE_GROUNDSPEED SPEED_TYPE = 1
	// Climb speed
	SPEED_TYPE_CLIMB_SPEED SPEED_TYPE = 2
	// Descent speed
	SPEED_TYPE_DESCENT_SPEED SPEED_TYPE = 3
)

var value_to_label_SPEED_TYPE = map[SPEED_TYPE]string{
	SPEED_TYPE_AIRSPEED:      "SPEED_TYPE_AIRSPEED",
	SPEED_TYPE_GROUNDSPEED:   "SPEED_TYPE_GROUNDSPEED",
	SPEED_TYPE_CLIMB_SPEED:   "SPEED_TYPE_CLIMB_SPEED",
	SPEED_TYPE_DESCENT_SPEED: "SPEED_TYPE_DESCENT_SPEED",
}

var label_to_value_SPEED_TYPE = map[string]SPEED_TYPE{
	"SPEED_TYPE_AIRSPEED":      SPEED_TYPE_AIRSPEED,
	"SPEED_TYPE_GROUNDSPEED":   SPEED_TYPE_GROUNDSPEED,
	"SPEED_TYPE_CLIMB_SPEED":   SPEED_TYPE_CLIMB_SPEED,
	"SPEED_TYPE_DESCENT_SPEED": SPEED_TYPE_DESCENT_SPEED,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e SPEED_TYPE) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_SPEED_TYPE[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *SPEED_TYPE) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_SPEED_TYPE[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = SPEED_TYPE(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e SPEED_TYPE) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
