// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0
//
// Code generated with OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package schema

// GoogleCloudConfigureAuthRequest struct for GoogleCloudConfigureAuthRequest
type GoogleCloudConfigureAuthRequest struct {
	// Google credentials JSON that Vault will use to verify users against GCP APIs. If not specified, will use application default credentials
	Credentials string `json:"credentials,omitempty"`

	// Specifies overrides for various Google API Service Endpoints used in requests.
	CustomEndpoint map[string]interface{} `json:"custom_endpoint,omitempty"`

	// Indicates what value to use when generating an alias for GCE authentications.
	GceAlias string `json:"gce_alias,omitempty"`

	// The metadata to include on the aliases and audit logs generated by this plugin. When set to 'default', includes: instance_creation_timestamp, instance_id, instance_name, project_id, project_number, role, service_account_id, service_account_email, zone. Not editing this field means the 'default' fields are included. Explicitly setting this field to empty overrides the 'default' and means no metadata will be included. If not using 'default', explicit fields must be sent like: 'field1,field2'.
	GceMetadata []string `json:"gce_metadata,omitempty"`

	// Deprecated. This field does nothing and be removed in a future release
	// Deprecated
	GoogleCertsEndpoint string `json:"google_certs_endpoint,omitempty"`

	// Indicates what value to use when generating an alias for IAM authentications.
	IamAlias string `json:"iam_alias,omitempty"`

	// The metadata to include on the aliases and audit logs generated by this plugin. When set to 'default', includes: project_id, role, service_account_id, service_account_email. Not editing this field means the 'default' fields are included. Explicitly setting this field to empty overrides the 'default' and means no metadata will be included. If not using 'default', explicit fields must be sent like: 'field1,field2'.
	IamMetadata []string `json:"iam_metadata,omitempty"`
}
