// Generated by tmpl
// https://github.com/benbjohnson/tmpl
//
// DO NOT EDIT!
// Source: conditional.gen.go.tmpl

package values

import (
	"github.com/apache/arrow/go/v7/arrow/memory"
	fluxarray "github.com/influxdata/flux/array"
	"github.com/influxdata/flux/codes"
	"github.com/influxdata/flux/internal/errors"
	"github.com/influxdata/flux/semantic"
)

// VectorConditional delegates the branch selection and necessary array building
// to specialized (by input type) functions in the `array` package, then wraps
// the output as a Value.
//
// For cases where `t` is constant (either by happening to be all the same value,
// or by being a `VectorRepeatValue`) the caller should skip this function and
// return either the consequent or alternate
// directly.
// With constant `t` is expected to be handled higher up, this function will error
// if it receives a `VectorRepeatValue` for this parameter.
//
// Cases where either or both of the consequent `c` and alternate `a` are
// `VectorRepeatValue`s are supported.
//
// Similar to the vec repeat situation, cases where either `c` or `a` are
// invalid (aka null), we treat this as if we have a null constant for the given
// branch. Items selected from the branch will produce nulls in the output.
// For cases where both `c` and `a` are null, we short circuit immediately
// returning a new untyped null Value.
func VectorConditional(t Vector, c, a Value, mem memory.Allocator) (Value, error) {
	// We will know the output type only when at least one branch is not null.
	// When both branches are null, the output can only be null (aka Invalid).
	var elemType semantic.MonoType
	if c.IsNull() && a.IsNull() {
		return Null, nil // early return an untyped null
	} else if c.IsNull() {
		elemType = a.Vector().ElementType()
	} else {
		elemType = c.Vector().ElementType()
	}

	if _, ok := t.(*VectorRepeatValue); ok {
		panic("t is constant, should be handled higher up, such as in conditionalVectorEvaluator.Eval")
	}

	switch elemType.Nature() {

	case semantic.Int:
		var (
			x   *fluxarray.Int
			err error
		)

		var cvr, avr *int64
		crepeat := false
		if vr, ok := c.(*VectorRepeatValue); ok {
			crepeat = true

			prim := vr.val.Int()

			cvr = &prim
		} else if c.IsNull() {
			crepeat = true // leave cvr as nil, but insist we treat it as a constant.
		}

		arepeat := false
		if vr, ok := a.(*VectorRepeatValue); ok {
			arepeat = true

			prim := vr.val.Int()

			avr = &prim
		} else if a.IsNull() {
			arepeat = true // leave avr as nil, but insist we treat it as a constant.
		}

		if crepeat && arepeat {
			x, err = fluxarray.IntConditionalCConstAConst(
				t.Arr().(*fluxarray.Boolean),
				cvr,
				avr,
				mem,
			)
		} else if crepeat {
			x, err = fluxarray.IntConditionalCConst(
				t.Arr().(*fluxarray.Boolean),
				cvr,
				a.Vector().Arr().(*fluxarray.Int),
				mem,
			)
		} else if arepeat {
			x, err = fluxarray.IntConditionalAConst(
				t.Arr().(*fluxarray.Boolean),
				c.Vector().Arr().(*fluxarray.Int),
				avr,
				mem,
			)
		} else {
			x, err = fluxarray.IntConditional(
				t.Arr().(*fluxarray.Boolean),
				c.Vector().Arr().(*fluxarray.Int),
				a.Vector().Arr().(*fluxarray.Int),
				mem,
			)
		}
		if err != nil {
			return nil, err
		}
		return NewVectorValue(x, semantic.BasicInt), nil

	case semantic.UInt:
		var (
			x   *fluxarray.Uint
			err error
		)

		var cvr, avr *uint64
		crepeat := false
		if vr, ok := c.(*VectorRepeatValue); ok {
			crepeat = true

			prim := vr.val.UInt()

			cvr = &prim
		} else if c.IsNull() {
			crepeat = true // leave cvr as nil, but insist we treat it as a constant.
		}

		arepeat := false
		if vr, ok := a.(*VectorRepeatValue); ok {
			arepeat = true

			prim := vr.val.UInt()

			avr = &prim
		} else if a.IsNull() {
			arepeat = true // leave avr as nil, but insist we treat it as a constant.
		}

		if crepeat && arepeat {
			x, err = fluxarray.UintConditionalCConstAConst(
				t.Arr().(*fluxarray.Boolean),
				cvr,
				avr,
				mem,
			)
		} else if crepeat {
			x, err = fluxarray.UintConditionalCConst(
				t.Arr().(*fluxarray.Boolean),
				cvr,
				a.Vector().Arr().(*fluxarray.Uint),
				mem,
			)
		} else if arepeat {
			x, err = fluxarray.UintConditionalAConst(
				t.Arr().(*fluxarray.Boolean),
				c.Vector().Arr().(*fluxarray.Uint),
				avr,
				mem,
			)
		} else {
			x, err = fluxarray.UintConditional(
				t.Arr().(*fluxarray.Boolean),
				c.Vector().Arr().(*fluxarray.Uint),
				a.Vector().Arr().(*fluxarray.Uint),
				mem,
			)
		}
		if err != nil {
			return nil, err
		}
		return NewVectorValue(x, semantic.BasicUint), nil

	case semantic.Float:
		var (
			x   *fluxarray.Float
			err error
		)

		var cvr, avr *float64
		crepeat := false
		if vr, ok := c.(*VectorRepeatValue); ok {
			crepeat = true

			prim := vr.val.Float()

			cvr = &prim
		} else if c.IsNull() {
			crepeat = true // leave cvr as nil, but insist we treat it as a constant.
		}

		arepeat := false
		if vr, ok := a.(*VectorRepeatValue); ok {
			arepeat = true

			prim := vr.val.Float()

			avr = &prim
		} else if a.IsNull() {
			arepeat = true // leave avr as nil, but insist we treat it as a constant.
		}

		if crepeat && arepeat {
			x, err = fluxarray.FloatConditionalCConstAConst(
				t.Arr().(*fluxarray.Boolean),
				cvr,
				avr,
				mem,
			)
		} else if crepeat {
			x, err = fluxarray.FloatConditionalCConst(
				t.Arr().(*fluxarray.Boolean),
				cvr,
				a.Vector().Arr().(*fluxarray.Float),
				mem,
			)
		} else if arepeat {
			x, err = fluxarray.FloatConditionalAConst(
				t.Arr().(*fluxarray.Boolean),
				c.Vector().Arr().(*fluxarray.Float),
				avr,
				mem,
			)
		} else {
			x, err = fluxarray.FloatConditional(
				t.Arr().(*fluxarray.Boolean),
				c.Vector().Arr().(*fluxarray.Float),
				a.Vector().Arr().(*fluxarray.Float),
				mem,
			)
		}
		if err != nil {
			return nil, err
		}
		return NewVectorValue(x, semantic.BasicFloat), nil

	case semantic.Bool:
		var (
			x   *fluxarray.Boolean
			err error
		)

		var cvr, avr *bool
		crepeat := false
		if vr, ok := c.(*VectorRepeatValue); ok {
			crepeat = true

			prim := vr.val.Bool()

			cvr = &prim
		} else if c.IsNull() {
			crepeat = true // leave cvr as nil, but insist we treat it as a constant.
		}

		arepeat := false
		if vr, ok := a.(*VectorRepeatValue); ok {
			arepeat = true

			prim := vr.val.Bool()

			avr = &prim
		} else if a.IsNull() {
			arepeat = true // leave avr as nil, but insist we treat it as a constant.
		}

		if crepeat && arepeat {
			x, err = fluxarray.BooleanConditionalCConstAConst(
				t.Arr().(*fluxarray.Boolean),
				cvr,
				avr,
				mem,
			)
		} else if crepeat {
			x, err = fluxarray.BooleanConditionalCConst(
				t.Arr().(*fluxarray.Boolean),
				cvr,
				a.Vector().Arr().(*fluxarray.Boolean),
				mem,
			)
		} else if arepeat {
			x, err = fluxarray.BooleanConditionalAConst(
				t.Arr().(*fluxarray.Boolean),
				c.Vector().Arr().(*fluxarray.Boolean),
				avr,
				mem,
			)
		} else {
			x, err = fluxarray.BooleanConditional(
				t.Arr().(*fluxarray.Boolean),
				c.Vector().Arr().(*fluxarray.Boolean),
				a.Vector().Arr().(*fluxarray.Boolean),
				mem,
			)
		}
		if err != nil {
			return nil, err
		}
		return NewVectorValue(x, semantic.BasicBool), nil

	case semantic.String:
		var (
			x   *fluxarray.String
			err error
		)

		var cvr, avr *string
		crepeat := false
		if vr, ok := c.(*VectorRepeatValue); ok {
			crepeat = true

			prim := vr.val.Str()

			cvr = &prim
		} else if c.IsNull() {
			crepeat = true // leave cvr as nil, but insist we treat it as a constant.
		}

		arepeat := false
		if vr, ok := a.(*VectorRepeatValue); ok {
			arepeat = true

			prim := vr.val.Str()

			avr = &prim
		} else if a.IsNull() {
			arepeat = true // leave avr as nil, but insist we treat it as a constant.
		}

		if crepeat && arepeat {
			x, err = fluxarray.StringConditionalCConstAConst(
				t.Arr().(*fluxarray.Boolean),
				cvr,
				avr,
				mem,
			)
		} else if crepeat {
			x, err = fluxarray.StringConditionalCConst(
				t.Arr().(*fluxarray.Boolean),
				cvr,
				a.Vector().Arr().(*fluxarray.String),
				mem,
			)
		} else if arepeat {
			x, err = fluxarray.StringConditionalAConst(
				t.Arr().(*fluxarray.Boolean),
				c.Vector().Arr().(*fluxarray.String),
				avr,
				mem,
			)
		} else {
			x, err = fluxarray.StringConditional(
				t.Arr().(*fluxarray.Boolean),
				c.Vector().Arr().(*fluxarray.String),
				a.Vector().Arr().(*fluxarray.String),
				mem,
			)
		}
		if err != nil {
			return nil, err
		}
		return NewVectorValue(x, semantic.BasicString), nil

	case semantic.Time:
		var (
			x   *fluxarray.Int
			err error
		)

		var cvr, avr *int64
		crepeat := false
		if vr, ok := c.(*VectorRepeatValue); ok {
			crepeat = true

			prim := vr.val.Time().Time().UnixNano()

			cvr = &prim
		} else if c.IsNull() {
			crepeat = true // leave cvr as nil, but insist we treat it as a constant.
		}

		arepeat := false
		if vr, ok := a.(*VectorRepeatValue); ok {
			arepeat = true

			prim := vr.val.Time().Time().UnixNano()

			avr = &prim
		} else if a.IsNull() {
			arepeat = true // leave avr as nil, but insist we treat it as a constant.
		}

		if crepeat && arepeat {
			x, err = fluxarray.IntConditionalCConstAConst(
				t.Arr().(*fluxarray.Boolean),
				cvr,
				avr,
				mem,
			)
		} else if crepeat {
			x, err = fluxarray.IntConditionalCConst(
				t.Arr().(*fluxarray.Boolean),
				cvr,
				a.Vector().Arr().(*fluxarray.Int),
				mem,
			)
		} else if arepeat {
			x, err = fluxarray.IntConditionalAConst(
				t.Arr().(*fluxarray.Boolean),
				c.Vector().Arr().(*fluxarray.Int),
				avr,
				mem,
			)
		} else {
			x, err = fluxarray.IntConditional(
				t.Arr().(*fluxarray.Boolean),
				c.Vector().Arr().(*fluxarray.Int),
				a.Vector().Arr().(*fluxarray.Int),
				mem,
			)
		}
		if err != nil {
			return nil, err
		}
		return NewVectorValue(x, semantic.BasicTime), nil

	default:
		return nil, errors.Newf(codes.Invalid, "unsupported type for vector: %v", elemType)
	}
}
