// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

package vulnerabilityscanning

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"net/http"
	"strings"
)

// ListHostCisBenchmarkScanResultsRequest wrapper for the ListHostCisBenchmarkScanResults operation
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/ListHostCisBenchmarkScanResults.go.html to see an example of how to use ListHostCisBenchmarkScanResultsRequest.
type ListHostCisBenchmarkScanResultsRequest struct {

	// The ID of the compartment in which to list resources.
	CompartmentId *string `mandatory:"true" contributesTo:"query" name:"compartmentId"`

	// The ID of a compute instance
	InstanceId *string `mandatory:"false" contributesTo:"query" name:"instanceId"`

	// Parameter to filter by highestProblemSeverity for scan results
	HighestProblemSeverity ListHostCisBenchmarkScanResultsHighestProblemSeverityEnum `mandatory:"false" contributesTo:"query" name:"highestProblemSeverity" omitEmpty:"true"`

	// Date and time on or after which scans were started, as described in RFC 3339 (https://tools.ietf.org/rfc/rfc3339)
	TimeStartedGreaterThanOrEqualTo *common.SDKTime `mandatory:"false" contributesTo:"query" name:"timeStartedGreaterThanOrEqualTo"`

	// Date and time on or before which scans were started, as described in RFC 3339 (https://tools.ietf.org/rfc/rfc3339)
	TimeStartedLessThanOrEqualTo *common.SDKTime `mandatory:"false" contributesTo:"query" name:"timeStartedLessThanOrEqualTo"`

	// The sort order to use, either 'ASC' or 'DESC'.
	SortOrder ListHostCisBenchmarkScanResultsSortOrderEnum `mandatory:"false" contributesTo:"query" name:"sortOrder" omitEmpty:"true"`

	// The field to sort by. Only one sort order may be provided. Default order is descending. If no value is specified timeFinished is default.
	SortBy ListHostCisBenchmarkScanResultsSortByEnum `mandatory:"false" contributesTo:"query" name:"sortBy" omitEmpty:"true"`

	// The maximum number of items to return.
	Limit *int `mandatory:"false" contributesTo:"query" name:"limit"`

	// The page token representing the page at which to start retrieving results. This is usually retrieved from a previous list call.
	Page *string `mandatory:"false" contributesTo:"query" name:"page"`

	// The client request ID for tracing.
	OpcRequestId *string `mandatory:"false" contributesTo:"header" name:"opc-request-id"`

	// A filter to return only resources that match the entire display name given.
	DisplayName *string `mandatory:"false" contributesTo:"query" name:"displayName"`

	// A flag to return only the latest scan result of an instance.
	IsLatestOnly *bool `mandatory:"false" contributesTo:"query" name:"isLatestOnly"`

	// Metadata about the request. This information will not be transmitted to the service, but
	// represents information that the SDK will consume to drive retry behavior.
	RequestMetadata common.RequestMetadata
}

func (request ListHostCisBenchmarkScanResultsRequest) String() string {
	return common.PointerString(request)
}

// HTTPRequest implements the OCIRequest interface
func (request ListHostCisBenchmarkScanResultsRequest) HTTPRequest(method, path string, binaryRequestBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (http.Request, error) {

	_, err := request.ValidateEnumValue()
	if err != nil {
		return http.Request{}, err
	}
	return common.MakeDefaultHTTPRequestWithTaggedStructAndExtraHeaders(method, path, request, extraHeaders)
}

// BinaryRequestBody implements the OCIRequest interface
func (request ListHostCisBenchmarkScanResultsRequest) BinaryRequestBody() (*common.OCIReadSeekCloser, bool) {

	return nil, false

}

// RetryPolicy implements the OCIRetryableRequest interface. This retrieves the specified retry policy.
func (request ListHostCisBenchmarkScanResultsRequest) RetryPolicy() *common.RetryPolicy {
	return request.RequestMetadata.RetryPolicy
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (request ListHostCisBenchmarkScanResultsRequest) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingListHostCisBenchmarkScanResultsHighestProblemSeverityEnum(string(request.HighestProblemSeverity)); !ok && request.HighestProblemSeverity != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for HighestProblemSeverity: %s. Supported values are: %s.", request.HighestProblemSeverity, strings.Join(GetListHostCisBenchmarkScanResultsHighestProblemSeverityEnumStringValues(), ",")))
	}
	if _, ok := GetMappingListHostCisBenchmarkScanResultsSortOrderEnum(string(request.SortOrder)); !ok && request.SortOrder != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortOrder: %s. Supported values are: %s.", request.SortOrder, strings.Join(GetListHostCisBenchmarkScanResultsSortOrderEnumStringValues(), ",")))
	}
	if _, ok := GetMappingListHostCisBenchmarkScanResultsSortByEnum(string(request.SortBy)); !ok && request.SortBy != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortBy: %s. Supported values are: %s.", request.SortBy, strings.Join(GetListHostCisBenchmarkScanResultsSortByEnumStringValues(), ",")))
	}
	if len(errMessage) > 0 {
		return true, fmt.Errorf("%s", strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// ListHostCisBenchmarkScanResultsResponse wrapper for the ListHostCisBenchmarkScanResults operation
type ListHostCisBenchmarkScanResultsResponse struct {

	// The underlying http response
	RawResponse *http.Response

	// A list of HostCisBenchmarkScanResultSummaryCollection instances
	HostCisBenchmarkScanResultSummaryCollection `presentIn:"body"`

	// Unique Oracle-assigned identifier for the request. If you need to contact
	// Oracle about a particular request, please provide the request ID.
	OpcRequestId *string `presentIn:"header" name:"opc-request-id"`

	// For pagination of a list of items. When paging through a list, if this header appears in the response,
	// then a partial list might have been returned. Include this value as the `page` parameter for the
	// subsequent GET request to get the next batch of items.
	OpcNextPage *string `presentIn:"header" name:"opc-next-page"`
}

func (response ListHostCisBenchmarkScanResultsResponse) String() string {
	return common.PointerString(response)
}

// HTTPResponse implements the OCIResponse interface
func (response ListHostCisBenchmarkScanResultsResponse) HTTPResponse() *http.Response {
	return response.RawResponse
}

// ListHostCisBenchmarkScanResultsHighestProblemSeverityEnum Enum with underlying type: string
type ListHostCisBenchmarkScanResultsHighestProblemSeverityEnum string

// Set of constants representing the allowable values for ListHostCisBenchmarkScanResultsHighestProblemSeverityEnum
const (
	ListHostCisBenchmarkScanResultsHighestProblemSeverityNone     ListHostCisBenchmarkScanResultsHighestProblemSeverityEnum = "NONE"
	ListHostCisBenchmarkScanResultsHighestProblemSeverityLow      ListHostCisBenchmarkScanResultsHighestProblemSeverityEnum = "LOW"
	ListHostCisBenchmarkScanResultsHighestProblemSeverityMedium   ListHostCisBenchmarkScanResultsHighestProblemSeverityEnum = "MEDIUM"
	ListHostCisBenchmarkScanResultsHighestProblemSeverityHigh     ListHostCisBenchmarkScanResultsHighestProblemSeverityEnum = "HIGH"
	ListHostCisBenchmarkScanResultsHighestProblemSeverityCritical ListHostCisBenchmarkScanResultsHighestProblemSeverityEnum = "CRITICAL"
)

var mappingListHostCisBenchmarkScanResultsHighestProblemSeverityEnum = map[string]ListHostCisBenchmarkScanResultsHighestProblemSeverityEnum{
	"NONE":     ListHostCisBenchmarkScanResultsHighestProblemSeverityNone,
	"LOW":      ListHostCisBenchmarkScanResultsHighestProblemSeverityLow,
	"MEDIUM":   ListHostCisBenchmarkScanResultsHighestProblemSeverityMedium,
	"HIGH":     ListHostCisBenchmarkScanResultsHighestProblemSeverityHigh,
	"CRITICAL": ListHostCisBenchmarkScanResultsHighestProblemSeverityCritical,
}

var mappingListHostCisBenchmarkScanResultsHighestProblemSeverityEnumLowerCase = map[string]ListHostCisBenchmarkScanResultsHighestProblemSeverityEnum{
	"none":     ListHostCisBenchmarkScanResultsHighestProblemSeverityNone,
	"low":      ListHostCisBenchmarkScanResultsHighestProblemSeverityLow,
	"medium":   ListHostCisBenchmarkScanResultsHighestProblemSeverityMedium,
	"high":     ListHostCisBenchmarkScanResultsHighestProblemSeverityHigh,
	"critical": ListHostCisBenchmarkScanResultsHighestProblemSeverityCritical,
}

// GetListHostCisBenchmarkScanResultsHighestProblemSeverityEnumValues Enumerates the set of values for ListHostCisBenchmarkScanResultsHighestProblemSeverityEnum
func GetListHostCisBenchmarkScanResultsHighestProblemSeverityEnumValues() []ListHostCisBenchmarkScanResultsHighestProblemSeverityEnum {
	values := make([]ListHostCisBenchmarkScanResultsHighestProblemSeverityEnum, 0)
	for _, v := range mappingListHostCisBenchmarkScanResultsHighestProblemSeverityEnum {
		values = append(values, v)
	}
	return values
}

// GetListHostCisBenchmarkScanResultsHighestProblemSeverityEnumStringValues Enumerates the set of values in String for ListHostCisBenchmarkScanResultsHighestProblemSeverityEnum
func GetListHostCisBenchmarkScanResultsHighestProblemSeverityEnumStringValues() []string {
	return []string{
		"NONE",
		"LOW",
		"MEDIUM",
		"HIGH",
		"CRITICAL",
	}
}

// GetMappingListHostCisBenchmarkScanResultsHighestProblemSeverityEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListHostCisBenchmarkScanResultsHighestProblemSeverityEnum(val string) (ListHostCisBenchmarkScanResultsHighestProblemSeverityEnum, bool) {
	enum, ok := mappingListHostCisBenchmarkScanResultsHighestProblemSeverityEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// ListHostCisBenchmarkScanResultsSortOrderEnum Enum with underlying type: string
type ListHostCisBenchmarkScanResultsSortOrderEnum string

// Set of constants representing the allowable values for ListHostCisBenchmarkScanResultsSortOrderEnum
const (
	ListHostCisBenchmarkScanResultsSortOrderAsc  ListHostCisBenchmarkScanResultsSortOrderEnum = "ASC"
	ListHostCisBenchmarkScanResultsSortOrderDesc ListHostCisBenchmarkScanResultsSortOrderEnum = "DESC"
)

var mappingListHostCisBenchmarkScanResultsSortOrderEnum = map[string]ListHostCisBenchmarkScanResultsSortOrderEnum{
	"ASC":  ListHostCisBenchmarkScanResultsSortOrderAsc,
	"DESC": ListHostCisBenchmarkScanResultsSortOrderDesc,
}

var mappingListHostCisBenchmarkScanResultsSortOrderEnumLowerCase = map[string]ListHostCisBenchmarkScanResultsSortOrderEnum{
	"asc":  ListHostCisBenchmarkScanResultsSortOrderAsc,
	"desc": ListHostCisBenchmarkScanResultsSortOrderDesc,
}

// GetListHostCisBenchmarkScanResultsSortOrderEnumValues Enumerates the set of values for ListHostCisBenchmarkScanResultsSortOrderEnum
func GetListHostCisBenchmarkScanResultsSortOrderEnumValues() []ListHostCisBenchmarkScanResultsSortOrderEnum {
	values := make([]ListHostCisBenchmarkScanResultsSortOrderEnum, 0)
	for _, v := range mappingListHostCisBenchmarkScanResultsSortOrderEnum {
		values = append(values, v)
	}
	return values
}

// GetListHostCisBenchmarkScanResultsSortOrderEnumStringValues Enumerates the set of values in String for ListHostCisBenchmarkScanResultsSortOrderEnum
func GetListHostCisBenchmarkScanResultsSortOrderEnumStringValues() []string {
	return []string{
		"ASC",
		"DESC",
	}
}

// GetMappingListHostCisBenchmarkScanResultsSortOrderEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListHostCisBenchmarkScanResultsSortOrderEnum(val string) (ListHostCisBenchmarkScanResultsSortOrderEnum, bool) {
	enum, ok := mappingListHostCisBenchmarkScanResultsSortOrderEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// ListHostCisBenchmarkScanResultsSortByEnum Enum with underlying type: string
type ListHostCisBenchmarkScanResultsSortByEnum string

// Set of constants representing the allowable values for ListHostCisBenchmarkScanResultsSortByEnum
const (
	ListHostCisBenchmarkScanResultsSortByTimestarted                 ListHostCisBenchmarkScanResultsSortByEnum = "timeStarted"
	ListHostCisBenchmarkScanResultsSortByTimefinished                ListHostCisBenchmarkScanResultsSortByEnum = "timeFinished"
	ListHostCisBenchmarkScanResultsSortByCisbenchmarkscanissuescount ListHostCisBenchmarkScanResultsSortByEnum = "cisBenchmarkScanIssuesCount"
)

var mappingListHostCisBenchmarkScanResultsSortByEnum = map[string]ListHostCisBenchmarkScanResultsSortByEnum{
	"timeStarted":                 ListHostCisBenchmarkScanResultsSortByTimestarted,
	"timeFinished":                ListHostCisBenchmarkScanResultsSortByTimefinished,
	"cisBenchmarkScanIssuesCount": ListHostCisBenchmarkScanResultsSortByCisbenchmarkscanissuescount,
}

var mappingListHostCisBenchmarkScanResultsSortByEnumLowerCase = map[string]ListHostCisBenchmarkScanResultsSortByEnum{
	"timestarted":                 ListHostCisBenchmarkScanResultsSortByTimestarted,
	"timefinished":                ListHostCisBenchmarkScanResultsSortByTimefinished,
	"cisbenchmarkscanissuescount": ListHostCisBenchmarkScanResultsSortByCisbenchmarkscanissuescount,
}

// GetListHostCisBenchmarkScanResultsSortByEnumValues Enumerates the set of values for ListHostCisBenchmarkScanResultsSortByEnum
func GetListHostCisBenchmarkScanResultsSortByEnumValues() []ListHostCisBenchmarkScanResultsSortByEnum {
	values := make([]ListHostCisBenchmarkScanResultsSortByEnum, 0)
	for _, v := range mappingListHostCisBenchmarkScanResultsSortByEnum {
		values = append(values, v)
	}
	return values
}

// GetListHostCisBenchmarkScanResultsSortByEnumStringValues Enumerates the set of values in String for ListHostCisBenchmarkScanResultsSortByEnum
func GetListHostCisBenchmarkScanResultsSortByEnumStringValues() []string {
	return []string{
		"timeStarted",
		"timeFinished",
		"cisBenchmarkScanIssuesCount",
	}
}

// GetMappingListHostCisBenchmarkScanResultsSortByEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListHostCisBenchmarkScanResultsSortByEnum(val string) (ListHostCisBenchmarkScanResultsSortByEnum, bool) {
	enum, ok := mappingListHostCisBenchmarkScanResultsSortByEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
