// Copyright 2017 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
////////////////////////////////////////////////////////////////////////////////

// Definitions for Elliptic Curve Digital Signature Algorithm (ECDSA).

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        v3.21.12
// source: ecies_aead_hkdf.proto

package ecies_aead_hkdf_go_proto

import (
	common_go_proto "github.com/tink-crypto/tink-go/v2/proto/common_go_proto"
	tink_go_proto "github.com/tink-crypto/tink-go/v2/proto/tink_go_proto"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Parameters of KEM (Key Encapsulation Mechanism)
type EciesHkdfKemParams struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Required.
	CurveType common_go_proto.EllipticCurveType `protobuf:"varint,1,opt,name=curve_type,json=curveType,proto3,enum=google.crypto.tink.EllipticCurveType" json:"curve_type,omitempty"`
	// Required.
	HkdfHashType common_go_proto.HashType `protobuf:"varint,2,opt,name=hkdf_hash_type,json=hkdfHashType,proto3,enum=google.crypto.tink.HashType" json:"hkdf_hash_type,omitempty"`
	// Optional.
	HkdfSalt      []byte `protobuf:"bytes,11,opt,name=hkdf_salt,json=hkdfSalt,proto3" json:"hkdf_salt,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *EciesHkdfKemParams) Reset() {
	*x = EciesHkdfKemParams{}
	mi := &file_ecies_aead_hkdf_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EciesHkdfKemParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EciesHkdfKemParams) ProtoMessage() {}

func (x *EciesHkdfKemParams) ProtoReflect() protoreflect.Message {
	mi := &file_ecies_aead_hkdf_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EciesHkdfKemParams.ProtoReflect.Descriptor instead.
func (*EciesHkdfKemParams) Descriptor() ([]byte, []int) {
	return file_ecies_aead_hkdf_proto_rawDescGZIP(), []int{0}
}

func (x *EciesHkdfKemParams) GetCurveType() common_go_proto.EllipticCurveType {
	if x != nil {
		return x.CurveType
	}
	return common_go_proto.EllipticCurveType(0)
}

func (x *EciesHkdfKemParams) GetHkdfHashType() common_go_proto.HashType {
	if x != nil {
		return x.HkdfHashType
	}
	return common_go_proto.HashType(0)
}

func (x *EciesHkdfKemParams) GetHkdfSalt() []byte {
	if x != nil {
		return x.HkdfSalt
	}
	return nil
}

// Parameters of AEAD DEM (Data Encapsulation Mechanism).
type EciesAeadDemParams struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Required.
	// Contains an Aead or DeterministicAead key format (e.g:
	// AesCtrHmacAeadKeyFormat, AesGcmKeyFormat or AesSivKeyFormat).
	// The output_prefix_type in this template here is ignored (RAW is assumed).
	AeadDem       *tink_go_proto.KeyTemplate `protobuf:"bytes,2,opt,name=aead_dem,json=aeadDem,proto3" json:"aead_dem,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *EciesAeadDemParams) Reset() {
	*x = EciesAeadDemParams{}
	mi := &file_ecies_aead_hkdf_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EciesAeadDemParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EciesAeadDemParams) ProtoMessage() {}

func (x *EciesAeadDemParams) ProtoReflect() protoreflect.Message {
	mi := &file_ecies_aead_hkdf_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EciesAeadDemParams.ProtoReflect.Descriptor instead.
func (*EciesAeadDemParams) Descriptor() ([]byte, []int) {
	return file_ecies_aead_hkdf_proto_rawDescGZIP(), []int{1}
}

func (x *EciesAeadDemParams) GetAeadDem() *tink_go_proto.KeyTemplate {
	if x != nil {
		return x.AeadDem
	}
	return nil
}

type EciesAeadHkdfParams struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Key Encapsulation Mechanism.
	// Required.
	KemParams *EciesHkdfKemParams `protobuf:"bytes,1,opt,name=kem_params,json=kemParams,proto3" json:"kem_params,omitempty"`
	// Data Encapsulation Mechanism.
	// Required.
	DemParams *EciesAeadDemParams `protobuf:"bytes,2,opt,name=dem_params,json=demParams,proto3" json:"dem_params,omitempty"`
	// EC point format.
	// Required.
	EcPointFormat common_go_proto.EcPointFormat `protobuf:"varint,3,opt,name=ec_point_format,json=ecPointFormat,proto3,enum=google.crypto.tink.EcPointFormat" json:"ec_point_format,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *EciesAeadHkdfParams) Reset() {
	*x = EciesAeadHkdfParams{}
	mi := &file_ecies_aead_hkdf_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EciesAeadHkdfParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EciesAeadHkdfParams) ProtoMessage() {}

func (x *EciesAeadHkdfParams) ProtoReflect() protoreflect.Message {
	mi := &file_ecies_aead_hkdf_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EciesAeadHkdfParams.ProtoReflect.Descriptor instead.
func (*EciesAeadHkdfParams) Descriptor() ([]byte, []int) {
	return file_ecies_aead_hkdf_proto_rawDescGZIP(), []int{2}
}

func (x *EciesAeadHkdfParams) GetKemParams() *EciesHkdfKemParams {
	if x != nil {
		return x.KemParams
	}
	return nil
}

func (x *EciesAeadHkdfParams) GetDemParams() *EciesAeadDemParams {
	if x != nil {
		return x.DemParams
	}
	return nil
}

func (x *EciesAeadHkdfParams) GetEcPointFormat() common_go_proto.EcPointFormat {
	if x != nil {
		return x.EcPointFormat
	}
	return common_go_proto.EcPointFormat(0)
}

// EciesAeadHkdfPublicKey represents HybridEncryption primitive.
// key_type: type.googleapis.com/google.crypto.tink.EciesAeadHkdfPublicKey
type EciesAeadHkdfPublicKey struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Required.
	Version uint32 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	// Required.
	Params *EciesAeadHkdfParams `protobuf:"bytes,2,opt,name=params,proto3" json:"params,omitempty"`
	// Affine coordinates of the public key in bigendian representation.
	// The public key is a point (x, y) on the curve defined by
	// params.kem_params.curve. Required.
	X []byte `protobuf:"bytes,3,opt,name=x,proto3" json:"x,omitempty"`
	// Required.
	Y             []byte `protobuf:"bytes,4,opt,name=y,proto3" json:"y,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *EciesAeadHkdfPublicKey) Reset() {
	*x = EciesAeadHkdfPublicKey{}
	mi := &file_ecies_aead_hkdf_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EciesAeadHkdfPublicKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EciesAeadHkdfPublicKey) ProtoMessage() {}

func (x *EciesAeadHkdfPublicKey) ProtoReflect() protoreflect.Message {
	mi := &file_ecies_aead_hkdf_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EciesAeadHkdfPublicKey.ProtoReflect.Descriptor instead.
func (*EciesAeadHkdfPublicKey) Descriptor() ([]byte, []int) {
	return file_ecies_aead_hkdf_proto_rawDescGZIP(), []int{3}
}

func (x *EciesAeadHkdfPublicKey) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *EciesAeadHkdfPublicKey) GetParams() *EciesAeadHkdfParams {
	if x != nil {
		return x.Params
	}
	return nil
}

func (x *EciesAeadHkdfPublicKey) GetX() []byte {
	if x != nil {
		return x.X
	}
	return nil
}

func (x *EciesAeadHkdfPublicKey) GetY() []byte {
	if x != nil {
		return x.Y
	}
	return nil
}

// EciesKdfAeadPrivateKey represents HybridDecryption primitive.
// key_type: type.googleapis.com/google.crypto.tink.EciesAeadHkdfPrivateKey
type EciesAeadHkdfPrivateKey struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Required.
	Version uint32 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	// Required.
	PublicKey *EciesAeadHkdfPublicKey `protobuf:"bytes,2,opt,name=public_key,json=publicKey,proto3" json:"public_key,omitempty"`
	// Required.
	KeyValue      []byte `protobuf:"bytes,3,opt,name=key_value,json=keyValue,proto3" json:"key_value,omitempty"` // Placeholder for multi-line ctype and debug_redact.  // Big integer in bigendian representation.
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *EciesAeadHkdfPrivateKey) Reset() {
	*x = EciesAeadHkdfPrivateKey{}
	mi := &file_ecies_aead_hkdf_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EciesAeadHkdfPrivateKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EciesAeadHkdfPrivateKey) ProtoMessage() {}

func (x *EciesAeadHkdfPrivateKey) ProtoReflect() protoreflect.Message {
	mi := &file_ecies_aead_hkdf_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EciesAeadHkdfPrivateKey.ProtoReflect.Descriptor instead.
func (*EciesAeadHkdfPrivateKey) Descriptor() ([]byte, []int) {
	return file_ecies_aead_hkdf_proto_rawDescGZIP(), []int{4}
}

func (x *EciesAeadHkdfPrivateKey) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *EciesAeadHkdfPrivateKey) GetPublicKey() *EciesAeadHkdfPublicKey {
	if x != nil {
		return x.PublicKey
	}
	return nil
}

func (x *EciesAeadHkdfPrivateKey) GetKeyValue() []byte {
	if x != nil {
		return x.KeyValue
	}
	return nil
}

type EciesAeadHkdfKeyFormat struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Required.
	Params        *EciesAeadHkdfParams `protobuf:"bytes,1,opt,name=params,proto3" json:"params,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *EciesAeadHkdfKeyFormat) Reset() {
	*x = EciesAeadHkdfKeyFormat{}
	mi := &file_ecies_aead_hkdf_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EciesAeadHkdfKeyFormat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EciesAeadHkdfKeyFormat) ProtoMessage() {}

func (x *EciesAeadHkdfKeyFormat) ProtoReflect() protoreflect.Message {
	mi := &file_ecies_aead_hkdf_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EciesAeadHkdfKeyFormat.ProtoReflect.Descriptor instead.
func (*EciesAeadHkdfKeyFormat) Descriptor() ([]byte, []int) {
	return file_ecies_aead_hkdf_proto_rawDescGZIP(), []int{5}
}

func (x *EciesAeadHkdfKeyFormat) GetParams() *EciesAeadHkdfParams {
	if x != nil {
		return x.Params
	}
	return nil
}

var File_ecies_aead_hkdf_proto protoreflect.FileDescriptor

const file_ecies_aead_hkdf_proto_rawDesc = "" +
	"\n" +
	"\x15ecies_aead_hkdf.proto\x12\x12google.crypto.tink\x1a\x12proto/common.proto\x1a\x10proto/tink.proto\"\xbb\x01\n" +
	"\x12EciesHkdfKemParams\x12D\n" +
	"\n" +
	"curve_type\x18\x01 \x01(\x0e2%.google.crypto.tink.EllipticCurveTypeR\tcurveType\x12B\n" +
	"\x0ehkdf_hash_type\x18\x02 \x01(\x0e2\x1c.google.crypto.tink.HashTypeR\fhkdfHashType\x12\x1b\n" +
	"\thkdf_salt\x18\v \x01(\fR\bhkdfSalt\"P\n" +
	"\x12EciesAeadDemParams\x12:\n" +
	"\baead_dem\x18\x02 \x01(\v2\x1f.google.crypto.tink.KeyTemplateR\aaeadDem\"\xee\x01\n" +
	"\x13EciesAeadHkdfParams\x12E\n" +
	"\n" +
	"kem_params\x18\x01 \x01(\v2&.google.crypto.tink.EciesHkdfKemParamsR\tkemParams\x12E\n" +
	"\n" +
	"dem_params\x18\x02 \x01(\v2&.google.crypto.tink.EciesAeadDemParamsR\tdemParams\x12I\n" +
	"\x0fec_point_format\x18\x03 \x01(\x0e2!.google.crypto.tink.EcPointFormatR\recPointFormat\"\x8f\x01\n" +
	"\x16EciesAeadHkdfPublicKey\x12\x18\n" +
	"\aversion\x18\x01 \x01(\rR\aversion\x12?\n" +
	"\x06params\x18\x02 \x01(\v2'.google.crypto.tink.EciesAeadHkdfParamsR\x06params\x12\f\n" +
	"\x01x\x18\x03 \x01(\fR\x01x\x12\f\n" +
	"\x01y\x18\x04 \x01(\fR\x01y\"\x9b\x01\n" +
	"\x17EciesAeadHkdfPrivateKey\x12\x18\n" +
	"\aversion\x18\x01 \x01(\rR\aversion\x12I\n" +
	"\n" +
	"public_key\x18\x02 \x01(\v2*.google.crypto.tink.EciesAeadHkdfPublicKeyR\tpublicKey\x12\x1b\n" +
	"\tkey_value\x18\x03 \x01(\fR\bkeyValue\"Y\n" +
	"\x16EciesAeadHkdfKeyFormat\x12?\n" +
	"\x06params\x18\x01 \x01(\v2'.google.crypto.tink.EciesAeadHkdfParamsR\x06paramsBb\n" +
	"\x1ccom.google.crypto.tink.protoP\x01Z@github.com/tink-crypto/tink-go/v2/proto/ecies_aead_hkdf_go_protob\x06proto3"

var (
	file_ecies_aead_hkdf_proto_rawDescOnce sync.Once
	file_ecies_aead_hkdf_proto_rawDescData []byte
)

func file_ecies_aead_hkdf_proto_rawDescGZIP() []byte {
	file_ecies_aead_hkdf_proto_rawDescOnce.Do(func() {
		file_ecies_aead_hkdf_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_ecies_aead_hkdf_proto_rawDesc), len(file_ecies_aead_hkdf_proto_rawDesc)))
	})
	return file_ecies_aead_hkdf_proto_rawDescData
}

var file_ecies_aead_hkdf_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_ecies_aead_hkdf_proto_goTypes = []any{
	(*EciesHkdfKemParams)(nil),             // 0: google.crypto.tink.EciesHkdfKemParams
	(*EciesAeadDemParams)(nil),             // 1: google.crypto.tink.EciesAeadDemParams
	(*EciesAeadHkdfParams)(nil),            // 2: google.crypto.tink.EciesAeadHkdfParams
	(*EciesAeadHkdfPublicKey)(nil),         // 3: google.crypto.tink.EciesAeadHkdfPublicKey
	(*EciesAeadHkdfPrivateKey)(nil),        // 4: google.crypto.tink.EciesAeadHkdfPrivateKey
	(*EciesAeadHkdfKeyFormat)(nil),         // 5: google.crypto.tink.EciesAeadHkdfKeyFormat
	(common_go_proto.EllipticCurveType)(0), // 6: google.crypto.tink.EllipticCurveType
	(common_go_proto.HashType)(0),          // 7: google.crypto.tink.HashType
	(*tink_go_proto.KeyTemplate)(nil),      // 8: google.crypto.tink.KeyTemplate
	(common_go_proto.EcPointFormat)(0),     // 9: google.crypto.tink.EcPointFormat
}
var file_ecies_aead_hkdf_proto_depIdxs = []int32{
	6, // 0: google.crypto.tink.EciesHkdfKemParams.curve_type:type_name -> google.crypto.tink.EllipticCurveType
	7, // 1: google.crypto.tink.EciesHkdfKemParams.hkdf_hash_type:type_name -> google.crypto.tink.HashType
	8, // 2: google.crypto.tink.EciesAeadDemParams.aead_dem:type_name -> google.crypto.tink.KeyTemplate
	0, // 3: google.crypto.tink.EciesAeadHkdfParams.kem_params:type_name -> google.crypto.tink.EciesHkdfKemParams
	1, // 4: google.crypto.tink.EciesAeadHkdfParams.dem_params:type_name -> google.crypto.tink.EciesAeadDemParams
	9, // 5: google.crypto.tink.EciesAeadHkdfParams.ec_point_format:type_name -> google.crypto.tink.EcPointFormat
	2, // 6: google.crypto.tink.EciesAeadHkdfPublicKey.params:type_name -> google.crypto.tink.EciesAeadHkdfParams
	3, // 7: google.crypto.tink.EciesAeadHkdfPrivateKey.public_key:type_name -> google.crypto.tink.EciesAeadHkdfPublicKey
	2, // 8: google.crypto.tink.EciesAeadHkdfKeyFormat.params:type_name -> google.crypto.tink.EciesAeadHkdfParams
	9, // [9:9] is the sub-list for method output_type
	9, // [9:9] is the sub-list for method input_type
	9, // [9:9] is the sub-list for extension type_name
	9, // [9:9] is the sub-list for extension extendee
	0, // [0:9] is the sub-list for field type_name
}

func init() { file_ecies_aead_hkdf_proto_init() }
func file_ecies_aead_hkdf_proto_init() {
	if File_ecies_aead_hkdf_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_ecies_aead_hkdf_proto_rawDesc), len(file_ecies_aead_hkdf_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_ecies_aead_hkdf_proto_goTypes,
		DependencyIndexes: file_ecies_aead_hkdf_proto_depIdxs,
		MessageInfos:      file_ecies_aead_hkdf_proto_msgTypes,
	}.Build()
	File_ecies_aead_hkdf_proto = out.File
	file_ecies_aead_hkdf_proto_goTypes = nil
	file_ecies_aead_hkdf_proto_depIdxs = nil
}
