// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.5.1
// - protoc             v3.21.12
// source: yandex/cloud/iot/broker/v1/broker_service.proto

package broker

import (
	context "context"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	BrokerService_Get_FullMethodName               = "/yandex.cloud.iot.broker.v1.BrokerService/Get"
	BrokerService_List_FullMethodName              = "/yandex.cloud.iot.broker.v1.BrokerService/List"
	BrokerService_Create_FullMethodName            = "/yandex.cloud.iot.broker.v1.BrokerService/Create"
	BrokerService_Update_FullMethodName            = "/yandex.cloud.iot.broker.v1.BrokerService/Update"
	BrokerService_Delete_FullMethodName            = "/yandex.cloud.iot.broker.v1.BrokerService/Delete"
	BrokerService_ListCertificates_FullMethodName  = "/yandex.cloud.iot.broker.v1.BrokerService/ListCertificates"
	BrokerService_AddCertificate_FullMethodName    = "/yandex.cloud.iot.broker.v1.BrokerService/AddCertificate"
	BrokerService_DeleteCertificate_FullMethodName = "/yandex.cloud.iot.broker.v1.BrokerService/DeleteCertificate"
	BrokerService_ListPasswords_FullMethodName     = "/yandex.cloud.iot.broker.v1.BrokerService/ListPasswords"
	BrokerService_AddPassword_FullMethodName       = "/yandex.cloud.iot.broker.v1.BrokerService/AddPassword"
	BrokerService_DeletePassword_FullMethodName    = "/yandex.cloud.iot.broker.v1.BrokerService/DeletePassword"
	BrokerService_ListOperations_FullMethodName    = "/yandex.cloud.iot.broker.v1.BrokerService/ListOperations"
)

// BrokerServiceClient is the client API for BrokerService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// A set of methods for managing broker.
type BrokerServiceClient interface {
	// Returns the specified broker.
	//
	// To get the list of available brokers, make a [List] request.
	Get(ctx context.Context, in *GetBrokerRequest, opts ...grpc.CallOption) (*Broker, error)
	// Retrieves the list of brokers in the specified folder.
	List(ctx context.Context, in *ListBrokersRequest, opts ...grpc.CallOption) (*ListBrokersResponse, error)
	// Creates a broker in the specified folder.
	Create(ctx context.Context, in *CreateBrokerRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates the specified broker.
	Update(ctx context.Context, in *UpdateBrokerRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified broker.
	Delete(ctx context.Context, in *DeleteBrokerRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Retrieves the list of broker certificates for the specified broker.
	ListCertificates(ctx context.Context, in *ListBrokerCertificatesRequest, opts ...grpc.CallOption) (*ListBrokerCertificatesResponse, error)
	// Adds a certificate.
	AddCertificate(ctx context.Context, in *AddBrokerCertificateRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified broker certificate.
	DeleteCertificate(ctx context.Context, in *DeleteBrokerCertificateRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Retrieves the list of passwords for the specified broker.
	ListPasswords(ctx context.Context, in *ListBrokerPasswordsRequest, opts ...grpc.CallOption) (*ListBrokerPasswordsResponse, error)
	// Adds password for the specified broker.
	AddPassword(ctx context.Context, in *AddBrokerPasswordRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified password.
	DeletePassword(ctx context.Context, in *DeleteBrokerPasswordRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Lists operations for the specified broker.
	ListOperations(ctx context.Context, in *ListBrokerOperationsRequest, opts ...grpc.CallOption) (*ListBrokerOperationsResponse, error)
}

type brokerServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewBrokerServiceClient(cc grpc.ClientConnInterface) BrokerServiceClient {
	return &brokerServiceClient{cc}
}

func (c *brokerServiceClient) Get(ctx context.Context, in *GetBrokerRequest, opts ...grpc.CallOption) (*Broker, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Broker)
	err := c.cc.Invoke(ctx, BrokerService_Get_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *brokerServiceClient) List(ctx context.Context, in *ListBrokersRequest, opts ...grpc.CallOption) (*ListBrokersResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ListBrokersResponse)
	err := c.cc.Invoke(ctx, BrokerService_List_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *brokerServiceClient) Create(ctx context.Context, in *CreateBrokerRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, BrokerService_Create_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *brokerServiceClient) Update(ctx context.Context, in *UpdateBrokerRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, BrokerService_Update_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *brokerServiceClient) Delete(ctx context.Context, in *DeleteBrokerRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, BrokerService_Delete_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *brokerServiceClient) ListCertificates(ctx context.Context, in *ListBrokerCertificatesRequest, opts ...grpc.CallOption) (*ListBrokerCertificatesResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ListBrokerCertificatesResponse)
	err := c.cc.Invoke(ctx, BrokerService_ListCertificates_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *brokerServiceClient) AddCertificate(ctx context.Context, in *AddBrokerCertificateRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, BrokerService_AddCertificate_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *brokerServiceClient) DeleteCertificate(ctx context.Context, in *DeleteBrokerCertificateRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, BrokerService_DeleteCertificate_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *brokerServiceClient) ListPasswords(ctx context.Context, in *ListBrokerPasswordsRequest, opts ...grpc.CallOption) (*ListBrokerPasswordsResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ListBrokerPasswordsResponse)
	err := c.cc.Invoke(ctx, BrokerService_ListPasswords_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *brokerServiceClient) AddPassword(ctx context.Context, in *AddBrokerPasswordRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, BrokerService_AddPassword_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *brokerServiceClient) DeletePassword(ctx context.Context, in *DeleteBrokerPasswordRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, BrokerService_DeletePassword_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *brokerServiceClient) ListOperations(ctx context.Context, in *ListBrokerOperationsRequest, opts ...grpc.CallOption) (*ListBrokerOperationsResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ListBrokerOperationsResponse)
	err := c.cc.Invoke(ctx, BrokerService_ListOperations_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BrokerServiceServer is the server API for BrokerService service.
// All implementations should embed UnimplementedBrokerServiceServer
// for forward compatibility.
//
// A set of methods for managing broker.
type BrokerServiceServer interface {
	// Returns the specified broker.
	//
	// To get the list of available brokers, make a [List] request.
	Get(context.Context, *GetBrokerRequest) (*Broker, error)
	// Retrieves the list of brokers in the specified folder.
	List(context.Context, *ListBrokersRequest) (*ListBrokersResponse, error)
	// Creates a broker in the specified folder.
	Create(context.Context, *CreateBrokerRequest) (*operation.Operation, error)
	// Updates the specified broker.
	Update(context.Context, *UpdateBrokerRequest) (*operation.Operation, error)
	// Deletes the specified broker.
	Delete(context.Context, *DeleteBrokerRequest) (*operation.Operation, error)
	// Retrieves the list of broker certificates for the specified broker.
	ListCertificates(context.Context, *ListBrokerCertificatesRequest) (*ListBrokerCertificatesResponse, error)
	// Adds a certificate.
	AddCertificate(context.Context, *AddBrokerCertificateRequest) (*operation.Operation, error)
	// Deletes the specified broker certificate.
	DeleteCertificate(context.Context, *DeleteBrokerCertificateRequest) (*operation.Operation, error)
	// Retrieves the list of passwords for the specified broker.
	ListPasswords(context.Context, *ListBrokerPasswordsRequest) (*ListBrokerPasswordsResponse, error)
	// Adds password for the specified broker.
	AddPassword(context.Context, *AddBrokerPasswordRequest) (*operation.Operation, error)
	// Deletes the specified password.
	DeletePassword(context.Context, *DeleteBrokerPasswordRequest) (*operation.Operation, error)
	// Lists operations for the specified broker.
	ListOperations(context.Context, *ListBrokerOperationsRequest) (*ListBrokerOperationsResponse, error)
}

// UnimplementedBrokerServiceServer should be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedBrokerServiceServer struct{}

func (UnimplementedBrokerServiceServer) Get(context.Context, *GetBrokerRequest) (*Broker, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedBrokerServiceServer) List(context.Context, *ListBrokersRequest) (*ListBrokersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedBrokerServiceServer) Create(context.Context, *CreateBrokerRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Create not implemented")
}
func (UnimplementedBrokerServiceServer) Update(context.Context, *UpdateBrokerRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}
func (UnimplementedBrokerServiceServer) Delete(context.Context, *DeleteBrokerRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedBrokerServiceServer) ListCertificates(context.Context, *ListBrokerCertificatesRequest) (*ListBrokerCertificatesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCertificates not implemented")
}
func (UnimplementedBrokerServiceServer) AddCertificate(context.Context, *AddBrokerCertificateRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddCertificate not implemented")
}
func (UnimplementedBrokerServiceServer) DeleteCertificate(context.Context, *DeleteBrokerCertificateRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCertificate not implemented")
}
func (UnimplementedBrokerServiceServer) ListPasswords(context.Context, *ListBrokerPasswordsRequest) (*ListBrokerPasswordsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPasswords not implemented")
}
func (UnimplementedBrokerServiceServer) AddPassword(context.Context, *AddBrokerPasswordRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddPassword not implemented")
}
func (UnimplementedBrokerServiceServer) DeletePassword(context.Context, *DeleteBrokerPasswordRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePassword not implemented")
}
func (UnimplementedBrokerServiceServer) ListOperations(context.Context, *ListBrokerOperationsRequest) (*ListBrokerOperationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListOperations not implemented")
}
func (UnimplementedBrokerServiceServer) testEmbeddedByValue() {}

// UnsafeBrokerServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to BrokerServiceServer will
// result in compilation errors.
type UnsafeBrokerServiceServer interface {
	mustEmbedUnimplementedBrokerServiceServer()
}

func RegisterBrokerServiceServer(s grpc.ServiceRegistrar, srv BrokerServiceServer) {
	// If the following call pancis, it indicates UnimplementedBrokerServiceServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&BrokerService_ServiceDesc, srv)
}

func _BrokerService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBrokerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BrokerServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BrokerService_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BrokerServiceServer).Get(ctx, req.(*GetBrokerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BrokerService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBrokersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BrokerServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BrokerService_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BrokerServiceServer).List(ctx, req.(*ListBrokersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BrokerService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateBrokerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BrokerServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BrokerService_Create_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BrokerServiceServer).Create(ctx, req.(*CreateBrokerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BrokerService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateBrokerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BrokerServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BrokerService_Update_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BrokerServiceServer).Update(ctx, req.(*UpdateBrokerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BrokerService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteBrokerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BrokerServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BrokerService_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BrokerServiceServer).Delete(ctx, req.(*DeleteBrokerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BrokerService_ListCertificates_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBrokerCertificatesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BrokerServiceServer).ListCertificates(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BrokerService_ListCertificates_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BrokerServiceServer).ListCertificates(ctx, req.(*ListBrokerCertificatesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BrokerService_AddCertificate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddBrokerCertificateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BrokerServiceServer).AddCertificate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BrokerService_AddCertificate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BrokerServiceServer).AddCertificate(ctx, req.(*AddBrokerCertificateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BrokerService_DeleteCertificate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteBrokerCertificateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BrokerServiceServer).DeleteCertificate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BrokerService_DeleteCertificate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BrokerServiceServer).DeleteCertificate(ctx, req.(*DeleteBrokerCertificateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BrokerService_ListPasswords_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBrokerPasswordsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BrokerServiceServer).ListPasswords(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BrokerService_ListPasswords_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BrokerServiceServer).ListPasswords(ctx, req.(*ListBrokerPasswordsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BrokerService_AddPassword_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddBrokerPasswordRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BrokerServiceServer).AddPassword(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BrokerService_AddPassword_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BrokerServiceServer).AddPassword(ctx, req.(*AddBrokerPasswordRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BrokerService_DeletePassword_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteBrokerPasswordRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BrokerServiceServer).DeletePassword(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BrokerService_DeletePassword_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BrokerServiceServer).DeletePassword(ctx, req.(*DeleteBrokerPasswordRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BrokerService_ListOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBrokerOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BrokerServiceServer).ListOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BrokerService_ListOperations_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BrokerServiceServer).ListOperations(ctx, req.(*ListBrokerOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// BrokerService_ServiceDesc is the grpc.ServiceDesc for BrokerService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var BrokerService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.iot.broker.v1.BrokerService",
	HandlerType: (*BrokerServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _BrokerService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _BrokerService_List_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _BrokerService_Create_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _BrokerService_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _BrokerService_Delete_Handler,
		},
		{
			MethodName: "ListCertificates",
			Handler:    _BrokerService_ListCertificates_Handler,
		},
		{
			MethodName: "AddCertificate",
			Handler:    _BrokerService_AddCertificate_Handler,
		},
		{
			MethodName: "DeleteCertificate",
			Handler:    _BrokerService_DeleteCertificate_Handler,
		},
		{
			MethodName: "ListPasswords",
			Handler:    _BrokerService_ListPasswords_Handler,
		},
		{
			MethodName: "AddPassword",
			Handler:    _BrokerService_AddPassword_Handler,
		},
		{
			MethodName: "DeletePassword",
			Handler:    _BrokerService_DeletePassword_Handler,
		},
		{
			MethodName: "ListOperations",
			Handler:    _BrokerService_ListOperations_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/iot/broker/v1/broker_service.proto",
}
