// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpcommon "go.opentelemetry.io/proto/slim/otlp/common/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	otlpcommon "go.opentelemetry.io/collector/pdata/internal/data/protogen/common/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigKeyValueList(t *testing.T) {
	for name, src := range genTestEncodingValuesKeyValueList() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewOrigKeyValueList()
				CopyOrigKeyValueList(dest, src)
				assert.Equal(t, src, dest)
				CopyOrigKeyValueList(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestMarshalAndUnmarshalJSONOrigKeyValueListUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewOrigKeyValueList()
	UnmarshalJSONOrigKeyValueList(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewOrigKeyValueList(), dest)
}

func TestMarshalAndUnmarshalJSONOrigKeyValueList(t *testing.T) {
	for name, src := range genTestEncodingValuesKeyValueList() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				MarshalJSONOrigKeyValueList(src, stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewOrigKeyValueList()
				UnmarshalJSONOrigKeyValueList(dest, iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteOrigKeyValueList(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoOrigKeyValueListFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesKeyValueList() {
		t.Run(name, func(t *testing.T) {
			dest := NewOrigKeyValueList()
			require.Error(t, UnmarshalProtoOrigKeyValueList(dest, buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigKeyValueListUnknown(t *testing.T) {
	dest := NewOrigKeyValueList()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, UnmarshalProtoOrigKeyValueList(dest, []byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewOrigKeyValueList(), dest)
}

func TestMarshalAndUnmarshalProtoOrigKeyValueList(t *testing.T) {
	for name, src := range genTestEncodingValuesKeyValueList() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, SizeProtoOrigKeyValueList(src))
				gotSize := MarshalProtoOrigKeyValueList(src, buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewOrigKeyValueList()
				require.NoError(t, UnmarshalProtoOrigKeyValueList(dest, buf))

				assert.Equal(t, src, dest)
				DeleteOrigKeyValueList(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufKeyValueList(t *testing.T) {
	for name, src := range genTestEncodingValuesKeyValueList() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigKeyValueList(src))
			gotSize := MarshalProtoOrigKeyValueList(src, buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpcommon.KeyValueList{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewOrigKeyValueList()
			require.NoError(t, UnmarshalProtoOrigKeyValueList(dest, goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesKeyValueList() map[string][]byte {
	return map[string][]byte{
		"invalid_field":          {0x02},
		"Values/wrong_wire_type": {0xc},
		"Values/missing_value":   {0xa},
	}
}

func genTestEncodingValuesKeyValueList() map[string]*otlpcommon.KeyValueList {
	return map[string]*otlpcommon.KeyValueList{
		"empty":                   NewOrigKeyValueList(),
		"Values/default_and_test": {Values: []otlpcommon.KeyValue{{}, *GenTestOrigKeyValue()}},
	}
}
