// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpprofiles "go.opentelemetry.io/proto/slim/otlp/profiles/v1development"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigStack(t *testing.T) {
	for name, src := range genTestEncodingValuesStack() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewOrigStack()
				CopyOrigStack(dest, src)
				assert.Equal(t, src, dest)
				CopyOrigStack(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestMarshalAndUnmarshalJSONOrigStackUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewOrigStack()
	UnmarshalJSONOrigStack(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewOrigStack(), dest)
}

func TestMarshalAndUnmarshalJSONOrigStack(t *testing.T) {
	for name, src := range genTestEncodingValuesStack() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				MarshalJSONOrigStack(src, stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewOrigStack()
				UnmarshalJSONOrigStack(dest, iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteOrigStack(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoOrigStackFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesStack() {
		t.Run(name, func(t *testing.T) {
			dest := NewOrigStack()
			require.Error(t, UnmarshalProtoOrigStack(dest, buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigStackUnknown(t *testing.T) {
	dest := NewOrigStack()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, UnmarshalProtoOrigStack(dest, []byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewOrigStack(), dest)
}

func TestMarshalAndUnmarshalProtoOrigStack(t *testing.T) {
	for name, src := range genTestEncodingValuesStack() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, SizeProtoOrigStack(src))
				gotSize := MarshalProtoOrigStack(src, buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewOrigStack()
				require.NoError(t, UnmarshalProtoOrigStack(dest, buf))

				assert.Equal(t, src, dest)
				DeleteOrigStack(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufStack(t *testing.T) {
	for name, src := range genTestEncodingValuesStack() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigStack(src))
			gotSize := MarshalProtoOrigStack(src, buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpprofiles.Stack{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewOrigStack()
			require.NoError(t, UnmarshalProtoOrigStack(dest, goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesStack() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                   {0x02},
		"LocationIndices/wrong_wire_type": {0xc},
		"LocationIndices/missing_value":   {0xa},
	}
}

func genTestEncodingValuesStack() map[string]*otlpprofiles.Stack {
	return map[string]*otlpprofiles.Stack{
		"empty":                            NewOrigStack(),
		"LocationIndices/default_and_test": {LocationIndices: []int32{int32(0), int32(13)}},
	}
}
