// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pprofile

import (
	"go.opentelemetry.io/collector/pdata/internal"
	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/pcommon"
)

// Stack represents a stack trace as a list of locations.

// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewStack function to create new instances.
// Important: zero-initialized instance is not valid for use.
type Stack struct {
	orig  *otlpprofiles.Stack
	state *internal.State
}

func newStack(orig *otlpprofiles.Stack, state *internal.State) Stack {
	return Stack{orig: orig, state: state}
}

// NewStack creates a new empty Stack.
//
// This must be used only in testing code. Users should use "AppendEmpty" when part of a Slice,
// OR directly access the member if this is embedded in another struct.
func NewStack() Stack {
	return newStack(internal.NewOrigStack(), internal.NewState())
}

// MoveTo moves all properties from the current struct overriding the destination and
// resetting the current instance to its zero value
func (ms Stack) MoveTo(dest Stack) {
	ms.state.AssertMutable()
	dest.state.AssertMutable()
	// If they point to the same data, they are the same, nothing to do.
	if ms.orig == dest.orig {
		return
	}
	internal.DeleteOrigStack(dest.orig, false)
	*dest.orig, *ms.orig = *ms.orig, *dest.orig
}

// LocationIndices returns the LocationIndices associated with this Stack.
func (ms Stack) LocationIndices() pcommon.Int32Slice {
	return pcommon.Int32Slice(internal.NewInt32Slice(&ms.orig.LocationIndices, ms.state))
}

// CopyTo copies all properties from the current struct overriding the destination.
func (ms Stack) CopyTo(dest Stack) {
	dest.state.AssertMutable()
	internal.CopyOrigStack(dest.orig, ms.orig)
}
