//go:build !ignore_autogenerated
// +build !ignore_autogenerated

/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by defaulter-gen. DO NOT EDIT.

package v1alpha2

import (
	runtime "k8s.io/apimachinery/pkg/runtime"
)

// RegisterDefaults adds defaulters functions to the given scheme.
// Public to allow building arbitrary schemes.
// All generated defaulters are covering - they call all nested defaulters.
func RegisterDefaults(scheme *runtime.Scheme) error {
	scheme.AddTypeDefaultingFunc(&Cluster{}, func(obj interface{}) { SetObjectDefaults_Cluster(obj.(*Cluster)) })
	scheme.AddTypeDefaultingFunc(&ClusterList{}, func(obj interface{}) { SetObjectDefaults_ClusterList(obj.(*ClusterList)) })
	return nil
}

func SetObjectDefaults_Cluster(in *Cluster) {
	SetDefaults_ClusterSpec(&in.Spec)
	if in.Spec.KubeAPIServer != nil {
		for i := range in.Spec.KubeAPIServer.Env {
			a := &in.Spec.KubeAPIServer.Env[i]
			if a.ValueFrom != nil {
				if a.ValueFrom.ConfigMapKeyRef != nil {
					if a.ValueFrom.ConfigMapKeyRef.LocalObjectReference.Name == "" {
						a.ValueFrom.ConfigMapKeyRef.LocalObjectReference.Name = ""
					}
				}
				if a.ValueFrom.SecretKeyRef != nil {
					if a.ValueFrom.SecretKeyRef.LocalObjectReference.Name == "" {
						a.ValueFrom.SecretKeyRef.LocalObjectReference.Name = ""
					}
				}
			}
		}
	}
}

func SetObjectDefaults_ClusterList(in *ClusterList) {
	for i := range in.Items {
		a := &in.Items[i]
		SetObjectDefaults_Cluster(a)
	}
}
