/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.oql.engine.api.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.lib.profiler.heap.Field;
import org.netbeans.lib.profiler.heap.FieldValue;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.ObjectArrayInstance;
import org.netbeans.lib.profiler.heap.ObjectFieldValue;
import org.netbeans.modules.profiler.oql.engine.api.impl.ReachableExcludes;
import org.netbeans.modules.profiler.oql.engine.api.impl.TreeIterator;

public class ReachableObjects {
    private ReachableExcludes excludes;
    private Instance root;
    private Set<Instance> alreadyReached;

    public ReachableObjects(Instance root, ReachableExcludes excludes) {
        this.root = root;
        this.excludes = excludes;
        this.alreadyReached = new HashSet<Instance>();
    }

    public Instance getRoot() {
        return this.root;
    }

    public Iterator<Instance> getReachables() {
        return new TreeIterator<Instance, Instance>(this.root){

            @Override
            protected Iterator<Instance> getSameLevelIterator(Instance popped) {
                Instance i;
                ArrayList<Instance> instances = new ArrayList<Instance>();
                for (Object fv : popped.getFieldValues()) {
                    if (!(fv instanceof ObjectFieldValue) || ReachableObjects.this.excludes != null && ReachableObjects.this.excludes.isExcluded(ReachableObjects.this.getFQFieldName(((FieldValue)fv).getField())) || (i = ((ObjectFieldValue)fv).getInstance()) == null || ReachableObjects.this.alreadyReached.contains(i)) continue;
                    instances.add(i);
                    ReachableObjects.this.alreadyReached.add(i);
                }
                if (popped instanceof ObjectArrayInstance) {
                    for (Object el : ((ObjectArrayInstance)popped).getValues()) {
                        i = (Instance)el;
                        if (i == null || ReachableObjects.this.alreadyReached.contains(i)) continue;
                        instances.add(i);
                        ReachableObjects.this.alreadyReached.add(i);
                    }
                }
                return instances.iterator();
            }

            @Override
            protected Iterator<Instance> getTraversingIterator(Instance popped) {
                ArrayList<Instance> instances = new ArrayList<Instance>();
                for (Object fv : popped.getFieldValues()) {
                    Instance i;
                    if (!(fv instanceof ObjectFieldValue) || ReachableObjects.this.excludes != null && ReachableObjects.this.excludes.isExcluded(ReachableObjects.this.getFQFieldName(((FieldValue)fv).getField())) || (i = ((ObjectFieldValue)fv).getInstance()) == null) continue;
                    instances.add(i);
                }
                if (popped instanceof ObjectArrayInstance) {
                    for (Object el : ((ObjectArrayInstance)popped).getValues()) {
                        if (!(el instanceof Instance)) continue;
                        instances.add((Instance)el);
                    }
                }
                return instances.iterator();
            }
        };
    }

    public long getTotalSize() {
        return -1L;
    }

    private String getFQFieldName(Field fld) {
        return fld.getDeclaringClass().getName() + "." + fld.getName();
    }
}

