/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.entitygenerator;

import java.util.Locale;
import org.netbeans.modules.dbschema.ColumnElement;
import org.netbeans.modules.j2ee.persistence.dd.JavaPersistenceQLKeywords;
import org.netbeans.modules.j2ee.persistence.entitygenerator.DbSchemaEntityMember;
import org.netbeans.modules.j2ee.persistence.entitygenerator.EntityRelation;
import org.openide.util.Utilities;

public abstract class EntityMember {
    private String memberName;
    private String memberClass;

    public static String makeFieldName(String fieldName) {
        StringBuilder retName = EntityMember.makeName(fieldName);
        retName.setCharAt(0, Character.toLowerCase(retName.charAt(0)));
        Object returnS = retName.toString();
        if (!Utilities.isJavaIdentifier((String)returnS)) {
            returnS = (String)returnS + "1";
        }
        return returnS;
    }

    public static String makeRelationshipFieldName(String fieldName, boolean isCollection) {
        return EntityMember.makeRelationshipFieldName(fieldName, EntityRelation.CollectionType.COLLECTION, isCollection);
    }

    public static String makeRelationshipFieldName(String fieldName, EntityRelation.CollectionType collectionType, boolean isCollection) {
        if (isCollection) {
            fieldName = (String)fieldName + collectionType.getShortName();
        }
        return EntityMember.makeFieldName((String)fieldName);
    }

    @Deprecated
    public static String fixRelationshipFieldName(String orgName, EntityRelation.CollectionType colType) {
        Object newName = orgName;
        if (orgName.endsWith("Collection")) {
            int ix = orgName.lastIndexOf("Collection");
            newName = orgName.substring(0, ix) + colType.getShortName();
        }
        return newName;
    }

    private static StringBuilder makeName(String fieldName) {
        if (fieldName == null || fieldName.length() == 0) {
            fieldName = "a";
        }
        if (!Character.isLetter(fieldName.charAt(0))) {
            StringBuilder removed = new StringBuilder(fieldName);
            while (removed.length() > 0 && !Character.isLetter(removed.charAt(0))) {
                removed.deleteCharAt(0);
            }
            return EntityMember.makeName(removed.toString());
        }
        String lower = fieldName.toLowerCase(Locale.ENGLISH);
        String upper = fieldName.toUpperCase(Locale.ENGLISH);
        boolean mixedCase = !fieldName.equals(lower) && !fieldName.equals(upper);
        return EntityMember.mapName(new StringBuilder(mixedCase ? fieldName : lower), !mixedCase);
    }

    public static String makeClassName(String className) {
        StringBuilder fieldName = EntityMember.makeName(className);
        if (JavaPersistenceQLKeywords.isKeyword(fieldName.toString())) {
            fieldName.append('1');
        }
        fieldName.setCharAt(0, Character.toUpperCase(fieldName.charAt(0)));
        return fieldName.toString();
    }

    private static StringBuilder mapName(StringBuilder mappedName, boolean convertUpper) {
        int i = 0;
        while (i < mappedName.length()) {
            if (!Character.isLetterOrDigit(mappedName.charAt(i))) {
                if (convertUpper && i + 1 < mappedName.length()) {
                    mappedName.setCharAt(i + 1, Character.toUpperCase(mappedName.charAt(i + 1)));
                }
                mappedName.deleteCharAt(i);
                continue;
            }
            ++i;
        }
        return mappedName;
    }

    public static EntityMember create(ColumnElement columnElement) {
        if (columnElement == null) {
            throw new IllegalArgumentException("columnElement == null");
        }
        return new DbSchemaEntityMember(columnElement);
    }

    public String getMemberName() {
        return this.memberName;
    }

    public void setMemberName(String name) {
        if (!Utilities.isJavaIdentifier((String)name)) {
            throw new IllegalArgumentException("isJavaIdentifier()==false");
        }
        this.memberName = name;
    }

    public String getMemberType() {
        return this.memberClass;
    }

    public void setMemberType(String aType) {
        if (aType == null) {
            throw new IllegalArgumentException("aType == null");
        }
        this.memberClass = aType;
    }

    public abstract boolean isLobType();

    public abstract boolean isPrimaryKey();

    public abstract void setPrimaryKey(boolean var1, boolean var2);

    public abstract boolean isAutoIncrement();

    public abstract boolean supportsFinder();

    public abstract Integer getLength();

    public abstract Integer getPrecision();

    public abstract Integer getScale();

    public boolean equals(Object other) {
        if (other == null || !other.getClass().isInstance(this.getClass())) {
            return false;
        }
        return ((EntityMember)other).getMemberName().equals(this.getMemberName());
    }

    public int hashCode() {
        return this.getMemberName().hashCode();
    }

    public abstract boolean isNullable();

    public abstract String getColumnName();

    public abstract String getTableName();
}

