/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.gsf.testrunner.plugin.CommonPlugin;
import org.netbeans.modules.junit.AbstractTestGenerator;
import org.netbeans.modules.junit.TestCreator;
import org.netbeans.modules.junit.TestabilityJudge;
import org.netbeans.modules.junit.TestabilityResult;
import org.netbeans.modules.junit.TopClassFinder;
import org.netbeans.modules.junit.api.JUnitSettings;
import org.netbeans.modules.junit.api.JUnitTestUtil;

public final class TestGeneratorSetup
implements TestabilityJudge {
    private static final String JUNIT_SUPER_CLASS_NAME = "TestCase";
    private static final String JUNIT_FRAMEWORK_PACKAGE_NAME = "junit.framework";
    private static final String METHOD_NAME_SETUP = "setUp";
    private static final String METHOD_NAME_TEARDOWN = "tearDown";
    private static final String CLASS_COMMENT_LINE1 = "TestCreator.javaClass.addTestsHereComment.l1";
    private static final String CLASS_COMMENT_LINE2 = "TestCreator.javaClass.addTestsHereComment.l2";
    private boolean skipTestClasses = true;
    private boolean skipPkgPrivateClasses = false;
    private boolean skipAbstractClasses = false;
    private boolean skipExceptionClasses = false;
    private boolean generateSuiteClasses = true;
    private Set<Modifier> methodAccessModifiers = AbstractTestGenerator.createModifierSet(Modifier.PUBLIC, Modifier.PROTECTED);
    private boolean testPkgPrivateMethods = true;
    private boolean generateDefMethodBody = true;
    private boolean generateMethodJavadoc = true;
    private boolean generateSourceCodeHints = true;
    private boolean generateTestSetUp = true;
    private boolean generateTestTearDown = true;
    private boolean generateClassSetUp = true;
    private boolean generateClassTearDown = true;
    private boolean generateMainMethod = true;

    public TestGeneratorSetup(boolean loadDefaults) {
        if (loadDefaults) {
            this.loadDefaults();
        }
    }

    public TestGeneratorSetup(Map<CommonPlugin.CreateTestParam, Object> params) {
        JUnitSettings settings = JUnitSettings.getDefault();
        this.skipTestClasses = !JUnitSettings.GENERATE_TESTS_FROM_TEST_CLASSES;
        this.skipPkgPrivateClasses = !Boolean.TRUE.equals(params.get(CommonPlugin.CreateTestParam.INC_PKG_PRIVATE_CLASS));
        this.skipAbstractClasses = !Boolean.TRUE.equals(params.get(CommonPlugin.CreateTestParam.INC_ABSTRACT_CLASS));
        this.skipExceptionClasses = !Boolean.TRUE.equals(params.get(CommonPlugin.CreateTestParam.INC_EXCEPTION_CLASS));
        this.generateSuiteClasses = Boolean.TRUE.equals(params.get(CommonPlugin.CreateTestParam.INC_GENERATE_SUITE));
        this.methodAccessModifiers.clear();
        if (Boolean.TRUE.equals(params.get(CommonPlugin.CreateTestParam.INC_PUBLIC))) {
            this.methodAccessModifiers.add(Modifier.PUBLIC);
        }
        if (Boolean.TRUE.equals(params.get(CommonPlugin.CreateTestParam.INC_PROTECTED))) {
            this.methodAccessModifiers.add(Modifier.PROTECTED);
        }
        this.testPkgPrivateMethods = Boolean.TRUE.equals(params.get(CommonPlugin.CreateTestParam.INC_PKG_PRIVATE));
        this.generateDefMethodBody = Boolean.TRUE.equals(params.get(CommonPlugin.CreateTestParam.INC_METHOD_BODIES));
        this.generateMethodJavadoc = Boolean.TRUE.equals(params.get(CommonPlugin.CreateTestParam.INC_JAVADOC));
        this.generateSourceCodeHints = Boolean.TRUE.equals(params.get(CommonPlugin.CreateTestParam.INC_CODE_HINT));
        this.generateTestSetUp = Boolean.TRUE.equals(params.get(CommonPlugin.CreateTestParam.INC_SETUP));
        this.generateTestTearDown = Boolean.TRUE.equals(params.get(CommonPlugin.CreateTestParam.INC_TEAR_DOWN));
        this.generateClassSetUp = Boolean.TRUE.equals(params.get(CommonPlugin.CreateTestParam.INC_CLASS_SETUP));
        this.generateClassTearDown = Boolean.TRUE.equals(params.get(CommonPlugin.CreateTestParam.INC_CLASS_TEAR_DOWN));
        this.generateMainMethod = settings.isGenerateMainMethod();
    }

    private void loadDefaults() {
        JUnitSettings settings = JUnitSettings.getDefault();
        this.skipTestClasses = JUnitSettings.GENERATE_TESTS_FROM_TEST_CLASSES;
        this.skipPkgPrivateClasses = !settings.isIncludePackagePrivateClasses();
        this.skipAbstractClasses = !settings.isGenerateAbstractImpl();
        this.skipExceptionClasses = !settings.isGenerateExceptionClasses();
        this.generateSuiteClasses = settings.isGenerateSuiteClasses();
        this.methodAccessModifiers.clear();
        if (settings.isMembersPublic()) {
            this.methodAccessModifiers.add(Modifier.PUBLIC);
        }
        if (settings.isMembersProtected()) {
            this.methodAccessModifiers.add(Modifier.PROTECTED);
        }
        this.testPkgPrivateMethods = settings.isMembersPackage();
        this.generateDefMethodBody = settings.isBodyContent();
        this.generateMethodJavadoc = settings.isJavaDoc();
        this.generateSourceCodeHints = settings.isBodyComments();
        this.generateTestSetUp = settings.isGenerateSetUp();
        this.generateTestTearDown = settings.isGenerateTearDown();
        this.generateClassSetUp = settings.isGenerateClassSetUp();
        this.generateClassTearDown = settings.isGenerateClassTearDown();
        this.generateMainMethod = settings.isGenerateMainMethod();
    }

    public void setSkipTestClasses(boolean skip) {
        this.skipTestClasses = skip;
    }

    public boolean isSkipTestClasses() {
        return this.skipTestClasses;
    }

    public void setSkipPackagePrivateClasses(boolean skip) {
        this.skipPkgPrivateClasses = skip;
    }

    public boolean isSkipPackagePrivateClasses() {
        return this.skipPkgPrivateClasses;
    }

    public void setSkipAbstractClasses(boolean skip) {
        this.skipAbstractClasses = skip;
    }

    public boolean isSkipAbstractClasses() {
        return this.skipAbstractClasses;
    }

    public void setSkipExceptionClasses(boolean skip) {
        this.skipExceptionClasses = skip;
    }

    public boolean isSkipExceptionClasses() {
        return this.skipExceptionClasses;
    }

    public void setGenerateSuiteClasses(boolean generate) {
        this.generateSuiteClasses = generate;
    }

    public boolean isGenerateSuiteClasses() {
        return this.generateSuiteClasses;
    }

    public void setTestPublicMethods(boolean test) {
        if (test) {
            this.methodAccessModifiers.add(Modifier.PUBLIC);
        } else {
            this.methodAccessModifiers.remove((Object)Modifier.PUBLIC);
        }
    }

    public boolean isTestPublicMethods() {
        return this.methodAccessModifiers.contains((Object)Modifier.PUBLIC);
    }

    public void setTestProtectedMethods(boolean test) {
        if (test) {
            this.methodAccessModifiers.add(Modifier.PROTECTED);
        } else {
            this.methodAccessModifiers.remove((Object)Modifier.PROTECTED);
        }
    }

    public boolean isTestProtectedMethods() {
        return this.methodAccessModifiers.contains((Object)Modifier.PROTECTED);
    }

    public EnumSet<Modifier> getMethodAccessModifiers() {
        return EnumSet.copyOf(this.methodAccessModifiers);
    }

    public void setTestPackagePrivateMethods(boolean test) {
        this.testPkgPrivateMethods = test;
    }

    public boolean isTestPackagePrivateMethods() {
        return this.testPkgPrivateMethods;
    }

    public void setGenerateDefMethodBody(boolean generate) {
        this.generateDefMethodBody = generate;
    }

    public boolean isGenerateDefMethodBody() {
        return this.generateDefMethodBody;
    }

    public void setGenerateMethodJavadoc(boolean generate) {
        this.generateMethodJavadoc = generate;
    }

    public boolean isGenerateMethodJavadoc() {
        return this.generateMethodJavadoc;
    }

    public void setGenerateMethodBodyComment(boolean generate) {
        this.generateSourceCodeHints = generate;
    }

    public boolean isGenerateMethodBodyComment() {
        return this.generateSourceCodeHints;
    }

    public void setGenerateSetUp(boolean generate) {
        this.generateTestSetUp = generate;
    }

    public boolean isGenerateSetUp() {
        return this.generateTestSetUp;
    }

    public void setGenerateTearDown(boolean generate) {
        this.generateTestTearDown = generate;
    }

    public boolean isGenerateTearDown() {
        return this.generateTestTearDown;
    }

    public void setGenerateBefore(boolean generate) {
        this.setGenerateSetUp(generate);
    }

    public boolean isGenerateBefore() {
        return this.isGenerateSetUp();
    }

    public void setGenerateAfter(boolean generate) {
        this.setGenerateTearDown(generate);
    }

    public boolean isGenerateAfter() {
        return this.isGenerateTearDown();
    }

    public void setGenerateBeforeClass(boolean generate) {
        this.generateClassSetUp = generate;
    }

    public boolean isGenerateBeforeClass() {
        return this.generateClassSetUp;
    }

    public void setGenerateAfterClass(boolean generate) {
        this.generateClassTearDown = generate;
    }

    public boolean isGenerateAfterClass() {
        return this.generateClassTearDown;
    }

    public void setGenerateMainMethod(boolean generate) {
        this.generateMainMethod = generate;
    }

    public boolean isGenerateMainMethod() {
        return this.generateMainMethod;
    }

    @Override
    public TestabilityResult isClassTestable(CompilationInfo compInfo, TypeElement classElem, long skipTestabilityResultMask) {
        assert (classElem != null);
        TestabilityResult result = this.isClassTestableSingle(compInfo, classElem, skipTestabilityResultMask);
        if (result.isTestable()) {
            return TestabilityResult.OK;
        }
        List<? extends Element> enclosedElems = classElem.getEnclosedElements();
        if (enclosedElems.isEmpty()) {
            return result;
        }
        List<TypeElement> enclosedTypes = ElementFilter.typesIn(enclosedElems);
        if (enclosedTypes.isEmpty()) {
            return result;
        }
        ArrayList<TypeElement> stack = new ArrayList<TypeElement>(Math.max(10, enclosedTypes.size()));
        stack.addAll(enclosedTypes);
        int stackSize = stack.size();
        HashSet<TypeElement> nonTestable = new HashSet<TypeElement>(64);
        nonTestable.add(classElem);
        do {
            TypeElement classToCheck = (TypeElement)stack.remove(--stackSize);
            if (!TopClassFinder.isTestable(classElem) || !nonTestable.add(classToCheck)) continue;
            TestabilityResult resultSingle = this.isClassTestableSingle(compInfo, classToCheck, skipTestabilityResultMask);
            if (resultSingle.isTestable()) {
                return TestabilityResult.OK;
            }
            result = TestabilityResult.combine(result, resultSingle);
            enclosedTypes = ElementFilter.typesIn(classToCheck.getEnclosedElements());
            if (enclosedTypes.isEmpty()) continue;
            stack.addAll(enclosedTypes);
            stackSize = stack.size();
        } while (stackSize != 0);
        return result;
    }

    private TestabilityResult isClassTestableSingle(CompilationInfo compInfo, TypeElement classElem, long skipTestabilityResultMask) {
        assert (classElem != null);
        TestabilityResult result = TestabilityResult.OK;
        Set<Modifier> modifiers = classElem.getModifiers();
        if (modifiers.contains((Object)Modifier.PRIVATE)) {
            result = TestabilityResult.combine(result, TestabilityResult.PRIVATE_CLASS);
        }
        if (this.isSkipTestClasses() && JUnitTestUtil.isClassImplementingTestInterface(compInfo, classElem)) {
            result = TestabilityResult.combine(result, TestabilityResult.TEST_CLASS);
        }
        if (this.isSkipPackagePrivateClasses() && (modifiers.isEmpty() || !EnumSet.copyOf(modifiers).removeAll(TestCreator.ACCESS_MODIFIERS))) {
            result = TestabilityResult.combine(result, TestabilityResult.PACKAGE_PRIVATE_CLASS);
        }
        if (this.isSkipAbstractClasses() && modifiers.contains((Object)Modifier.ABSTRACT)) {
            result = TestabilityResult.combine(result, TestabilityResult.ABSTRACT_CLASS);
        }
        if (!modifiers.contains((Object)Modifier.STATIC) && classElem.getNestingKind() != NestingKind.TOP_LEVEL) {
            result = TestabilityResult.combine(result, TestabilityResult.NONSTATIC_INNER_CLASS);
        }
        if (this.isSkipExceptionClasses() && JUnitTestUtil.isClassException(compInfo, classElem)) {
            result = TestabilityResult.combine(result, TestabilityResult.EXCEPTION_CLASS);
        }
        result = TestabilityResult.filter(result, skipTestabilityResultMask);
        return result;
    }

    private boolean hasTestableMethods(TypeElement classElem) {
        List<? extends Element> enclosedElems = classElem.getEnclosedElements();
        if (enclosedElems.isEmpty()) {
            return false;
        }
        List<ExecutableElement> methods = ElementFilter.methodsIn(enclosedElems);
        if (methods.isEmpty()) {
            return false;
        }
        for (ExecutableElement method : methods) {
            if (!this.isMethodTestable(method)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isMethodTestable(ExecutableElement method) {
        Set<Modifier> modifiers = method.getModifiers();
        if (modifiers.isEmpty()) {
            return this.isTestPackagePrivateMethods();
        }
        return this.isTestPackagePrivateMethods() && !EnumSet.copyOf(modifiers).removeAll(TestCreator.ACCESS_MODIFIERS) || EnumSet.copyOf(modifiers).removeAll(this.getMethodAccessModifiers());
    }
}

