/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.custom.hints;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.html.custom.hints.AddAttributeFix;
import org.netbeans.modules.html.custom.hints.Bundle;
import org.netbeans.modules.html.custom.hints.EditProjectsConfFix;
import org.netbeans.modules.html.custom.hints.Utils;
import org.netbeans.modules.parsing.api.Snapshot;

public class UnknownAttributes
extends Hint {
    private static final Rule RULE = new RuleI(false);
    private static final Rule LINE_RULE = new RuleI(true);

    public UnknownAttributes(Collection<String> attributeNames, String elementName, RuleContext context, OffsetRange range, boolean lineHint) {
        super(lineHint ? LINE_RULE : RULE, Bundle.unknownAttribute(Utils.attributeNames2String(attributeNames)), context.parserResult.getSnapshot().getSource().getFileObject(), range, UnknownAttributes.getFixes(attributeNames, elementName, context), 30);
    }

    private static List<HintFix> getFixes(Collection<String> attributeNames, String elementName, RuleContext context) {
        ArrayList<HintFix> fixes = new ArrayList<HintFix>();
        Snapshot snap = context.parserResult.getSnapshot();
        for (String aName : attributeNames) {
            fixes.add(new AddAttributeFix(aName, elementName, snap));
            fixes.add(new AddAttributeFix(aName, null, snap));
        }
        if (attributeNames.size() > 1) {
            fixes.add(new AddAttributeFix(attributeNames, elementName, snap));
            fixes.add(new AddAttributeFix(attributeNames, null, snap));
        }
        fixes.add(new EditProjectsConfFix(snap));
        return fixes;
    }

    private static class RuleI
    implements Rule {
        private final boolean lineHint;

        public RuleI(boolean lineHint) {
            this.lineHint = lineHint;
        }

        public boolean appliesTo(RuleContext context) {
            return true;
        }

        public String getDisplayName() {
            return Bundle.unknownAttributeRule();
        }

        public boolean showInTasklist() {
            return false;
        }

        public HintSeverity getDefaultSeverity() {
            return this.lineHint ? HintSeverity.CURRENT_LINE_WARNING : HintSeverity.WARNING;
        }
    }
}

