/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.actions;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.SmartSteppingFilter;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.SmartSteppingCallback;

public final class CompoundSmartSteppingListener
extends SmartSteppingCallback {
    private static final Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda.step");
    private List<? extends SmartSteppingCallback> smartSteppings;
    private final ContextProvider lookupProvider;

    public CompoundSmartSteppingListener(ContextProvider lookupProvider) {
        this.lookupProvider = lookupProvider;
        SmartSteppingFilter smartSteppingFilter = (SmartSteppingFilter)lookupProvider.lookupFirst(null, SmartSteppingFilter.class);
        this.initFilter(smartSteppingFilter);
    }

    public void initFilter(SmartSteppingFilter filter) {
        this.smartSteppings = this.lookupProvider.lookup(null, SmartSteppingCallback.class);
        for (SmartSteppingCallback smartSteppingCallback : this.smartSteppings) {
            smartSteppingCallback.initFilter(filter);
        }
    }

    public boolean stopHere(ContextProvider lookupProvider, JPDAThread t, SmartSteppingFilter smartSteppingFilter) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("\nSS  CompoundSmartSteppingListener.stopHere? : " + t.getClassName() + "." + t.getMethodName() + ":" + t.getLineNumber(null));
        }
        boolean stop = true;
        for (SmartSteppingCallback smartSteppingCallback : this.smartSteppings) {
            boolean sh = smartSteppingCallback.stopHere(lookupProvider, t, smartSteppingFilter);
            boolean bl = stop = stop && sh;
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.fine("SS    " + smartSteppingCallback.getClass() + " = " + sh);
        }
        return stop;
    }

    public SmartSteppingCallback.StopOrStep stopAt(ContextProvider lookupProvider, CallStackFrame frame, SmartSteppingFilter f) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("\nSS  CompoundSmartSteppingListener.canStopAt? : " + frame.getClassName() + "." + frame.getMethodName() + ":" + frame.getLineNumber(null));
        }
        SmartSteppingCallback.StopOrStep ss = null;
        for (SmartSteppingCallback smartSteppingCallback : this.smartSteppings) {
            SmartSteppingCallback.StopOrStep s = smartSteppingCallback.stopAt(lookupProvider, frame, f);
            if (ss == null) {
                ss = s;
            } else if (!ss.equals((Object)s)) {
                boolean stop = ss.isStop() && s.isStop();
                int ssi = ss.getStepSize();
                int ssd = ss.getStepDepth();
                int si = s.getStepSize();
                int sd = s.getStepDepth();
                int stepSize = ssi == 0 ? si : (si == 0 ? ssi : Math.max(ssi, si));
                int stepDepth = ssd == 0 ? sd : (sd == 0 ? ssd : Math.min(ssd, sd));
                ss = stop || stepSize == 0 && stepDepth == 0 ? (stop ? SmartSteppingCallback.StopOrStep.stop() : SmartSteppingCallback.StopOrStep.skip()) : SmartSteppingCallback.StopOrStep.step((int)stepSize, (int)stepDepth);
            }
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.fine("SS    " + smartSteppingCallback.getClass() + " = " + s);
        }
        if (ss == null) {
            ss = SmartSteppingCallback.StopOrStep.stop();
        }
        logger.log(Level.FINE, "SS  stop or step: {0}", ss);
        return ss;
    }
}

