/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.client.jersey;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WrappedResponseInputStream
extends InputStream {
    private static final Logger LOG = LoggerFactory.getLogger(WrappedResponseInputStream.class);
    protected final InputStream delegate;
    protected final Response delegateResponse;

    public WrappedResponseInputStream(@Nonnull InputStream delegate, @Nonnull Response delegateResponse) {
        if (delegate == null) {
            throw new NullPointerException("delegate is marked non-null but is null");
        }
        if (delegateResponse == null) {
            throw new NullPointerException("delegateResponse is marked non-null but is null");
        }
        this.delegate = delegate;
        this.delegateResponse = delegateResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void closeResponseSilently(Response response) {
        Response response2 = response;
        synchronized (response2) {
            try {
                response.close();
            }
            catch (Throwable t) {
                LOG.debug("Exception while closing response", t);
            }
        }
    }

    @Override
    public int read() throws IOException {
        return this.delegate.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.delegate.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.delegate.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.delegate.skip(n);
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.delegate.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.delegate.reset();
    }

    @Override
    public int available() throws IOException {
        return this.delegate.available();
    }

    @Override
    public boolean markSupported() {
        return this.delegate.markSupported();
    }

    @Override
    public void close() throws IOException {
        try {
            this.delegate.close();
        }
        catch (ProcessingException e) {
            LOG.debug("Exception caused while trying to close the stream", (Throwable)e);
        }
        finally {
            WrappedResponseInputStream.closeResponseSilently(this.delegateResponse);
        }
    }
}

