/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.memory;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.netbeans.lib.profiler.results.memory.RuntimeMemoryCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeObjAllocTermCCTNode;
import org.netbeans.lib.profiler.results.memory.SurvGenSet;

public class RuntimeObjLivenessTermCCTNode
extends RuntimeObjAllocTermCCTNode {
    private int[][] epochAndNLiveObjects;

    public RuntimeObjLivenessTermCCTNode(int methodId) {
        super(methodId);
    }

    protected RuntimeObjLivenessTermCCTNode() {
    }

    @Override
    public int getType() {
        return 3;
    }

    public void addLiveObjectForEpoch(int epoch) {
        int lenMinusOne;
        int row;
        if (this.epochAndNLiveObjects == null) {
            this.epochAndNLiveObjects = new int[2][2];
            this.epochAndNLiveObjects[0][1] = -1;
            this.epochAndNLiveObjects[0][0] = -1;
        }
        int len = this.epochAndNLiveObjects[0].length;
        for (row = lenMinusOne = len - 1; this.epochAndNLiveObjects[0][row] == -1 && row > 0; --row) {
        }
        if (this.epochAndNLiveObjects[0][row] > -1) {
            if (this.epochAndNLiveObjects[0][row] < epoch) {
                if (row == lenMinusOne) {
                    int[][] newEpochAndNLiveObjects = new int[2][len + 2];
                    System.arraycopy(this.epochAndNLiveObjects[0], 0, newEpochAndNLiveObjects[0], 0, len);
                    System.arraycopy(this.epochAndNLiveObjects[1], 0, newEpochAndNLiveObjects[1], 0, len);
                    this.epochAndNLiveObjects = newEpochAndNLiveObjects;
                    this.epochAndNLiveObjects[0][len + 1] = -1;
                    this.epochAndNLiveObjects[0][len] = -1;
                }
                ++row;
            } else {
                while (row > 0 && this.epochAndNLiveObjects[0][row] != epoch) {
                    --row;
                }
                if (this.epochAndNLiveObjects[0][row] != epoch) {
                    return;
                }
            }
        }
        this.epochAndNLiveObjects[0][row] = epoch;
        int[] nArray = this.epochAndNLiveObjects[1];
        int n = row;
        nArray[n] = nArray[n] + 1;
    }

    public static float calculateAvgObjectAgeForAllPaths(RuntimeMemoryCCTNode rootNode, int currentEpoch) {
        int[] nObjAndAge = new int[2];
        RuntimeObjLivenessTermCCTNode.calculateNObjAndAge(rootNode, currentEpoch, nObjAndAge);
        if (nObjAndAge[0] == 0) {
            return 0.0f;
        }
        return (float)((double)nObjAndAge[1] / (double)nObjAndAge[0]);
    }

    public int calculateTotalNLiveObjects() {
        if (this.epochAndNLiveObjects == null) {
            return 0;
        }
        int res = 0;
        int len = this.epochAndNLiveObjects[0].length;
        for (int row = 0; row < len && this.epochAndNLiveObjects[0][row] != -1; ++row) {
            res += this.epochAndNLiveObjects[1][row];
        }
        return res;
    }

    public static int calculateTotalNumberOfSurvGensForAllPaths(RuntimeMemoryCCTNode rootNode) {
        SurvGenSet sgSet = new SurvGenSet();
        RuntimeObjLivenessTermCCTNode.calculateTotalNumberOfSurvGens(rootNode, sgSet);
        return sgSet.getTotalNoOfAges();
    }

    @Override
    public Object clone() {
        RuntimeObjLivenessTermCCTNode ret = (RuntimeObjLivenessTermCCTNode)super.clone();
        if (this.epochAndNLiveObjects == null) {
            ret.epochAndNLiveObjects = null;
        } else {
            int len = this.epochAndNLiveObjects[0].length;
            ret.epochAndNLiveObjects = new int[2][len];
            System.arraycopy(this.epochAndNLiveObjects[0], 0, ret.epochAndNLiveObjects[0], 0, len);
            System.arraycopy(this.epochAndNLiveObjects[1], 0, ret.epochAndNLiveObjects[1], 0, len);
        }
        return ret;
    }

    @Override
    public void readFromStream(DataInputStream in) throws IOException {
        super.readFromStream(in);
        int len = in.readInt();
        this.epochAndNLiveObjects = new int[2][len];
        for (int i = 0; i < len; ++i) {
            this.epochAndNLiveObjects[0][i] = in.readInt();
            this.epochAndNLiveObjects[1][i] = in.readInt();
        }
    }

    public void removeLiveObjectForEpoch(int epoch) {
        int lenMinusOne;
        int row;
        assert (this.epochAndNLiveObjects != null);
        int len = this.epochAndNLiveObjects[0].length;
        for (row = lenMinusOne = len - 1; this.epochAndNLiveObjects[0][row] != epoch && row > 0; --row) {
        }
        if (this.epochAndNLiveObjects[0][row] != epoch) {
            return;
        }
        int[] nArray = this.epochAndNLiveObjects[1];
        int n = row;
        nArray[n] = nArray[n] - 1;
        if (this.epochAndNLiveObjects[1][row] == 0) {
            if (row < lenMinusOne) {
                if (row >= lenMinusOne || this.epochAndNLiveObjects[0][row + 1] != -1) {
                    System.arraycopy(this.epochAndNLiveObjects[0], row + 1, this.epochAndNLiveObjects[0], row, lenMinusOne - row);
                    System.arraycopy(this.epochAndNLiveObjects[1], row + 1, this.epochAndNLiveObjects[1], row, lenMinusOne - row);
                } else {
                    this.epochAndNLiveObjects[0][row] = -1;
                }
            }
            this.epochAndNLiveObjects[0][lenMinusOne] = -1;
            this.epochAndNLiveObjects[1][lenMinusOne] = 0;
        }
    }

    @Override
    public void writeToStream(DataOutputStream out) throws IOException {
        super.writeToStream(out);
        int len = this.epochAndNLiveObjects == null ? 0 : this.epochAndNLiveObjects[0].length;
        out.writeInt(len);
        for (int i = 0; i < len; ++i) {
            out.writeInt(this.epochAndNLiveObjects[0][i]);
            out.writeInt(this.epochAndNLiveObjects[1][i]);
        }
    }

    protected static void calculateNObjAndAge(RuntimeMemoryCCTNode node, int currentEpoch, int[] nObjAndAge) {
        if (node instanceof RuntimeObjLivenessTermCCTNode) {
            RuntimeObjLivenessTermCCTNode thisNode = (RuntimeObjLivenessTermCCTNode)node;
            int[][] epochAndNLiveObjects = thisNode.epochAndNLiveObjects;
            if (epochAndNLiveObjects != null) {
                int len = epochAndNLiveObjects[0].length;
                for (int row = 0; row < len && epochAndNLiveObjects[0][row] != -1; ++row) {
                    nObjAndAge[0] = nObjAndAge[0] + epochAndNLiveObjects[1][row];
                    nObjAndAge[1] = nObjAndAge[1] + epochAndNLiveObjects[1][row] * (currentEpoch - epochAndNLiveObjects[0][row]);
                }
            }
        }
        if (node.children != null) {
            if (node.children instanceof RuntimeMemoryCCTNode) {
                RuntimeObjLivenessTermCCTNode.calculateNObjAndAge((RuntimeMemoryCCTNode)node.children, currentEpoch, nObjAndAge);
            } else {
                RuntimeMemoryCCTNode[] ar = (RuntimeMemoryCCTNode[])node.children;
                for (int i = 0; i < ar.length; ++i) {
                    RuntimeObjLivenessTermCCTNode.calculateNObjAndAge(ar[i], currentEpoch, nObjAndAge);
                }
            }
        }
    }

    protected static void calculateTotalNumberOfSurvGens(RuntimeMemoryCCTNode node, SurvGenSet sgSet) {
        if (node instanceof RuntimeObjLivenessTermCCTNode) {
            RuntimeObjLivenessTermCCTNode thisNode = (RuntimeObjLivenessTermCCTNode)node;
            int[][] epochAndNLiveObjects = thisNode.epochAndNLiveObjects;
            if (epochAndNLiveObjects != null) {
                int[] epochs = epochAndNLiveObjects[0];
                int len = epochs.length;
                for (int i = 0; i < len && epochs[i] != -1; ++i) {
                    sgSet.addAge(epochs[i]);
                }
            }
        }
        if (node.children != null) {
            if (node.children instanceof RuntimeMemoryCCTNode) {
                RuntimeObjLivenessTermCCTNode.calculateTotalNumberOfSurvGens((RuntimeMemoryCCTNode)node.children, sgSet);
            } else {
                RuntimeMemoryCCTNode[] ar = (RuntimeMemoryCCTNode[])node.children;
                for (int i = 0; i < ar.length; ++i) {
                    RuntimeObjLivenessTermCCTNode.calculateTotalNumberOfSurvGens(ar[i], sgSet);
                }
            }
        }
    }

    protected void dumpEpochs() {
        if (this.epochAndNLiveObjects != null) {
            int len = this.epochAndNLiveObjects[0].length;
            for (int i = 0; i < len; ++i) {
                System.err.println("epoch = " + this.epochAndNLiveObjects[0][i] + ", objno = " + this.epochAndNLiveObjects[1][i]);
            }
        } else {
            System.err.println("epoch = null");
        }
    }
}

