/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AutonomousDbVersionSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="version")
    private final String version;
    @JsonProperty(value="dbWorkload")
    private final DbWorkload dbWorkload;
    @JsonProperty(value="isDedicated")
    private final Boolean isDedicated;
    @JsonProperty(value="details")
    private final String details;
    @JsonProperty(value="isFreeTierEnabled")
    private final Boolean isFreeTierEnabled;
    @JsonProperty(value="isPaidEnabled")
    private final Boolean isPaidEnabled;
    @JsonProperty(value="isDefaultForFree")
    private final Boolean isDefaultForFree;
    @JsonProperty(value="isDefaultForPaid")
    private final Boolean isDefaultForPaid;

    @Deprecated
    @ConstructorProperties(value={"version", "dbWorkload", "isDedicated", "details", "isFreeTierEnabled", "isPaidEnabled", "isDefaultForFree", "isDefaultForPaid"})
    public AutonomousDbVersionSummary(String version, DbWorkload dbWorkload, Boolean isDedicated, String details, Boolean isFreeTierEnabled, Boolean isPaidEnabled, Boolean isDefaultForFree, Boolean isDefaultForPaid) {
        this.version = version;
        this.dbWorkload = dbWorkload;
        this.isDedicated = isDedicated;
        this.details = details;
        this.isFreeTierEnabled = isFreeTierEnabled;
        this.isPaidEnabled = isPaidEnabled;
        this.isDefaultForFree = isDefaultForFree;
        this.isDefaultForPaid = isDefaultForPaid;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getVersion() {
        return this.version;
    }

    public DbWorkload getDbWorkload() {
        return this.dbWorkload;
    }

    public Boolean getIsDedicated() {
        return this.isDedicated;
    }

    public String getDetails() {
        return this.details;
    }

    public Boolean getIsFreeTierEnabled() {
        return this.isFreeTierEnabled;
    }

    public Boolean getIsPaidEnabled() {
        return this.isPaidEnabled;
    }

    public Boolean getIsDefaultForFree() {
        return this.isDefaultForFree;
    }

    public Boolean getIsDefaultForPaid() {
        return this.isDefaultForPaid;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AutonomousDbVersionSummary(");
        sb.append("super=").append(super.toString());
        sb.append("version=").append(String.valueOf(this.version));
        sb.append(", dbWorkload=").append(String.valueOf((Object)this.dbWorkload));
        sb.append(", isDedicated=").append(String.valueOf(this.isDedicated));
        sb.append(", details=").append(String.valueOf(this.details));
        sb.append(", isFreeTierEnabled=").append(String.valueOf(this.isFreeTierEnabled));
        sb.append(", isPaidEnabled=").append(String.valueOf(this.isPaidEnabled));
        sb.append(", isDefaultForFree=").append(String.valueOf(this.isDefaultForFree));
        sb.append(", isDefaultForPaid=").append(String.valueOf(this.isDefaultForPaid));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AutonomousDbVersionSummary)) {
            return false;
        }
        AutonomousDbVersionSummary other = (AutonomousDbVersionSummary)((Object)o);
        return Objects.equals(this.version, other.version) && Objects.equals((Object)this.dbWorkload, (Object)other.dbWorkload) && Objects.equals(this.isDedicated, other.isDedicated) && Objects.equals(this.details, other.details) && Objects.equals(this.isFreeTierEnabled, other.isFreeTierEnabled) && Objects.equals(this.isPaidEnabled, other.isPaidEnabled) && Objects.equals(this.isDefaultForFree, other.isDefaultForFree) && Objects.equals(this.isDefaultForPaid, other.isDefaultForPaid) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.dbWorkload == null ? 43 : this.dbWorkload.hashCode());
        result = result * 59 + (this.isDedicated == null ? 43 : this.isDedicated.hashCode());
        result = result * 59 + (this.details == null ? 43 : this.details.hashCode());
        result = result * 59 + (this.isFreeTierEnabled == null ? 43 : this.isFreeTierEnabled.hashCode());
        result = result * 59 + (this.isPaidEnabled == null ? 43 : this.isPaidEnabled.hashCode());
        result = result * 59 + (this.isDefaultForFree == null ? 43 : this.isDefaultForFree.hashCode());
        result = result * 59 + (this.isDefaultForPaid == null ? 43 : this.isDefaultForPaid.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum DbWorkload implements BmcEnum
    {
        Oltp("OLTP"),
        Dw("DW"),
        Ajd("AJD"),
        Apex("APEX"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, DbWorkload> map;

        private DbWorkload(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DbWorkload create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'DbWorkload', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(DbWorkload.class);
            map = new HashMap<String, DbWorkload>();
            for (DbWorkload v : DbWorkload.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="dbWorkload")
        private DbWorkload dbWorkload;
        @JsonProperty(value="isDedicated")
        private Boolean isDedicated;
        @JsonProperty(value="details")
        private String details;
        @JsonProperty(value="isFreeTierEnabled")
        private Boolean isFreeTierEnabled;
        @JsonProperty(value="isPaidEnabled")
        private Boolean isPaidEnabled;
        @JsonProperty(value="isDefaultForFree")
        private Boolean isDefaultForFree;
        @JsonProperty(value="isDefaultForPaid")
        private Boolean isDefaultForPaid;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder version(String version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder dbWorkload(DbWorkload dbWorkload) {
            this.dbWorkload = dbWorkload;
            this.__explicitlySet__.add("dbWorkload");
            return this;
        }

        public Builder isDedicated(Boolean isDedicated) {
            this.isDedicated = isDedicated;
            this.__explicitlySet__.add("isDedicated");
            return this;
        }

        public Builder details(String details) {
            this.details = details;
            this.__explicitlySet__.add("details");
            return this;
        }

        public Builder isFreeTierEnabled(Boolean isFreeTierEnabled) {
            this.isFreeTierEnabled = isFreeTierEnabled;
            this.__explicitlySet__.add("isFreeTierEnabled");
            return this;
        }

        public Builder isPaidEnabled(Boolean isPaidEnabled) {
            this.isPaidEnabled = isPaidEnabled;
            this.__explicitlySet__.add("isPaidEnabled");
            return this;
        }

        public Builder isDefaultForFree(Boolean isDefaultForFree) {
            this.isDefaultForFree = isDefaultForFree;
            this.__explicitlySet__.add("isDefaultForFree");
            return this;
        }

        public Builder isDefaultForPaid(Boolean isDefaultForPaid) {
            this.isDefaultForPaid = isDefaultForPaid;
            this.__explicitlySet__.add("isDefaultForPaid");
            return this;
        }

        public AutonomousDbVersionSummary build() {
            AutonomousDbVersionSummary model = new AutonomousDbVersionSummary(this.version, this.dbWorkload, this.isDedicated, this.details, this.isFreeTierEnabled, this.isPaidEnabled, this.isDefaultForFree, this.isDefaultForPaid);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AutonomousDbVersionSummary model) {
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("dbWorkload")) {
                this.dbWorkload(model.getDbWorkload());
            }
            if (model.wasPropertyExplicitlySet("isDedicated")) {
                this.isDedicated(model.getIsDedicated());
            }
            if (model.wasPropertyExplicitlySet("details")) {
                this.details(model.getDetails());
            }
            if (model.wasPropertyExplicitlySet("isFreeTierEnabled")) {
                this.isFreeTierEnabled(model.getIsFreeTierEnabled());
            }
            if (model.wasPropertyExplicitlySet("isPaidEnabled")) {
                this.isPaidEnabled(model.getIsPaidEnabled());
            }
            if (model.wasPropertyExplicitlySet("isDefaultForFree")) {
                this.isDefaultForFree(model.getIsDefaultForFree());
            }
            if (model.wasPropertyExplicitlySet("isDefaultForPaid")) {
                this.isDefaultForPaid(model.getIsDefaultForPaid());
            }
            return this;
        }
    }
}

