/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class NetworkBondingModeDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="clientNetworkBondingMode")
    private final ClientNetworkBondingMode clientNetworkBondingMode;
    @JsonProperty(value="backupNetworkBondingMode")
    private final BackupNetworkBondingMode backupNetworkBondingMode;
    @JsonProperty(value="drNetworkBondingMode")
    private final DrNetworkBondingMode drNetworkBondingMode;

    @Deprecated
    @ConstructorProperties(value={"clientNetworkBondingMode", "backupNetworkBondingMode", "drNetworkBondingMode"})
    public NetworkBondingModeDetails(ClientNetworkBondingMode clientNetworkBondingMode, BackupNetworkBondingMode backupNetworkBondingMode, DrNetworkBondingMode drNetworkBondingMode) {
        this.clientNetworkBondingMode = clientNetworkBondingMode;
        this.backupNetworkBondingMode = backupNetworkBondingMode;
        this.drNetworkBondingMode = drNetworkBondingMode;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public ClientNetworkBondingMode getClientNetworkBondingMode() {
        return this.clientNetworkBondingMode;
    }

    public BackupNetworkBondingMode getBackupNetworkBondingMode() {
        return this.backupNetworkBondingMode;
    }

    public DrNetworkBondingMode getDrNetworkBondingMode() {
        return this.drNetworkBondingMode;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("NetworkBondingModeDetails(");
        sb.append("super=").append(super.toString());
        sb.append("clientNetworkBondingMode=").append(String.valueOf((Object)this.clientNetworkBondingMode));
        sb.append(", backupNetworkBondingMode=").append(String.valueOf((Object)this.backupNetworkBondingMode));
        sb.append(", drNetworkBondingMode=").append(String.valueOf((Object)this.drNetworkBondingMode));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NetworkBondingModeDetails)) {
            return false;
        }
        NetworkBondingModeDetails other = (NetworkBondingModeDetails)((Object)o);
        return Objects.equals((Object)this.clientNetworkBondingMode, (Object)other.clientNetworkBondingMode) && Objects.equals((Object)this.backupNetworkBondingMode, (Object)other.backupNetworkBondingMode) && Objects.equals((Object)this.drNetworkBondingMode, (Object)other.drNetworkBondingMode) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.clientNetworkBondingMode == null ? 43 : this.clientNetworkBondingMode.hashCode());
        result = result * 59 + (this.backupNetworkBondingMode == null ? 43 : this.backupNetworkBondingMode.hashCode());
        result = result * 59 + (this.drNetworkBondingMode == null ? 43 : this.drNetworkBondingMode.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum DrNetworkBondingMode implements BmcEnum
    {
        ActiveBackup("ACTIVE_BACKUP"),
        Lacp("LACP"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, DrNetworkBondingMode> map;

        private DrNetworkBondingMode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DrNetworkBondingMode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'DrNetworkBondingMode', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(DrNetworkBondingMode.class);
            map = new HashMap<String, DrNetworkBondingMode>();
            for (DrNetworkBondingMode v : DrNetworkBondingMode.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum BackupNetworkBondingMode implements BmcEnum
    {
        ActiveBackup("ACTIVE_BACKUP"),
        Lacp("LACP"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, BackupNetworkBondingMode> map;

        private BackupNetworkBondingMode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static BackupNetworkBondingMode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'BackupNetworkBondingMode', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(BackupNetworkBondingMode.class);
            map = new HashMap<String, BackupNetworkBondingMode>();
            for (BackupNetworkBondingMode v : BackupNetworkBondingMode.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ClientNetworkBondingMode implements BmcEnum
    {
        ActiveBackup("ACTIVE_BACKUP"),
        Lacp("LACP"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ClientNetworkBondingMode> map;

        private ClientNetworkBondingMode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ClientNetworkBondingMode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ClientNetworkBondingMode', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ClientNetworkBondingMode.class);
            map = new HashMap<String, ClientNetworkBondingMode>();
            for (ClientNetworkBondingMode v : ClientNetworkBondingMode.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="clientNetworkBondingMode")
        private ClientNetworkBondingMode clientNetworkBondingMode;
        @JsonProperty(value="backupNetworkBondingMode")
        private BackupNetworkBondingMode backupNetworkBondingMode;
        @JsonProperty(value="drNetworkBondingMode")
        private DrNetworkBondingMode drNetworkBondingMode;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder clientNetworkBondingMode(ClientNetworkBondingMode clientNetworkBondingMode) {
            this.clientNetworkBondingMode = clientNetworkBondingMode;
            this.__explicitlySet__.add("clientNetworkBondingMode");
            return this;
        }

        public Builder backupNetworkBondingMode(BackupNetworkBondingMode backupNetworkBondingMode) {
            this.backupNetworkBondingMode = backupNetworkBondingMode;
            this.__explicitlySet__.add("backupNetworkBondingMode");
            return this;
        }

        public Builder drNetworkBondingMode(DrNetworkBondingMode drNetworkBondingMode) {
            this.drNetworkBondingMode = drNetworkBondingMode;
            this.__explicitlySet__.add("drNetworkBondingMode");
            return this;
        }

        public NetworkBondingModeDetails build() {
            NetworkBondingModeDetails model = new NetworkBondingModeDetails(this.clientNetworkBondingMode, this.backupNetworkBondingMode, this.drNetworkBondingMode);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(NetworkBondingModeDetails model) {
            if (model.wasPropertyExplicitlySet("clientNetworkBondingMode")) {
                this.clientNetworkBondingMode(model.getClientNetworkBondingMode());
            }
            if (model.wasPropertyExplicitlySet("backupNetworkBondingMode")) {
                this.backupNetworkBondingMode(model.getBackupNetworkBondingMode());
            }
            if (model.wasPropertyExplicitlySet("drNetworkBondingMode")) {
                this.drNetworkBondingMode(model.getDrNetworkBondingMode());
            }
            return this;
        }
    }
}

