/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.refactoring;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.TreePath;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

public abstract class RefactoringUtil {
    private static final String JAVA_MIME_TYPE = "text/x-java";

    public static String renameClass(String originalFullyQualifiedName, String newName) {
        Parameters.notEmpty((CharSequence)"originalFullyQualifiedName", (CharSequence)originalFullyQualifiedName);
        Parameters.notEmpty((CharSequence)"newName", (CharSequence)newName);
        int lastDot = originalFullyQualifiedName.lastIndexOf(46);
        return lastDot <= 0 ? newName : originalFullyQualifiedName.substring(0, lastDot + 1) + newName;
    }

    public static Problem addToEnd(Problem toAdd, Problem existing) {
        if (existing == null) {
            return toAdd;
        }
        if (toAdd == null) {
            return existing;
        }
        Problem tail = existing;
        while (tail.getNext() != null) {
            tail = tail.getNext();
        }
        tail.setNext(toAdd);
        return tail;
    }

    public static boolean isOnSourceClasspath(FileObject fo) {
        Project p = FileOwnerQuery.getOwner((FileObject)fo);
        if (p == null) {
            return false;
        }
        if (OpenProjects.getDefault().isProjectOpen(p)) {
            SourceGroup[] gr = ProjectUtils.getSources((Project)p).getSourceGroups("java");
            for (int j = 0; j < gr.length; ++j) {
                if (fo == gr[j].getRootFolder()) {
                    return true;
                }
                if (!FileUtil.isParentOf((FileObject)gr[j].getRootFolder(), (FileObject)fo)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean isJavaFile(FileObject f) {
        return JAVA_MIME_TYPE.equals(f.getMIMEType());
    }

    public static String getPropertyName(String accessor) {
        Parameters.notEmpty((CharSequence)"accessor", (CharSequence)accessor);
        int prefixLength = RefactoringUtil.getPrefixLength(accessor);
        String withoutPrefix = accessor.substring(prefixLength);
        char firstChar = withoutPrefix.charAt(0);
        if (!Character.isUpperCase(firstChar)) {
            return accessor;
        }
        return Character.toLowerCase(firstChar) + withoutPrefix.substring(1);
    }

    private static int getPrefixLength(String accessor) {
        String[] accessorPrefixes;
        for (String prefix : accessorPrefixes = new String[]{"get", "set", "is"}) {
            if (!accessor.startsWith(prefix)) continue;
            return prefix.length();
        }
        return 0;
    }

    public static TreePathHandle resolveTreePathHandle(AbstractRefactoring refactoring) throws IOException {
        Parameters.notNull((CharSequence)"refactoring", (Object)refactoring);
        TreePathHandle tph = (TreePathHandle)refactoring.getRefactoringSource().lookup(TreePathHandle.class);
        if (tph != null) {
            return tph;
        }
        final TreePathHandle[] result = new TreePathHandle[1];
        JavaSource source = JavaSource.forFileObject((FileObject)((FileObject)refactoring.getRefactoringSource().lookup(FileObject.class)));
        source.runUserActionTask((Task)new CancellableTask<CompilationController>(){

            public void cancel() {
            }

            public void run(CompilationController co) throws Exception {
                co.toPhase(JavaSource.Phase.RESOLVED);
                CompilationUnitTree cut = co.getCompilationUnit();
                result[0] = TreePathHandle.create((TreePath)TreePath.getPath(cut, cut.getTypeDecls().get(0)), (CompilationInfo)co);
            }
        }, true);
        return result[0];
    }

    public static TreePathHandle getTreePathHandle(final String fieldName, final String className, FileObject file) throws IOException {
        final TreePathHandle[] result = new TreePathHandle[1];
        JavaSource source = JavaSource.forFileObject((FileObject)file);
        source.runUserActionTask((Task)new CancellableTask<CompilationController>(){

            public void cancel() {
            }

            public void run(CompilationController info) throws Exception {
                info.toPhase(JavaSource.Phase.RESOLVED);
                TypeElement te = info.getElements().getTypeElement(className);
                for (Element element : te.getEnclosedElements()) {
                    if (!element.getSimpleName().contentEquals(fieldName)) continue;
                    TreePath propertyPath = info.getTrees().getPath(element);
                    result[0] = TreePathHandle.create((TreePath)propertyPath, (CompilationInfo)info);
                }
            }
        }, true);
        return result[0];
    }

    public static String getPackageName(URL url) {
        File f = null;
        try {
            f = FileUtil.normalizeFile((File)Utilities.toFile((URI)url.toURI()));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Cannot create package name for url " + url);
        }
        Object suffix = "";
        do {
            FileObject fo;
            if ((fo = FileUtil.toFileObject((File)f)) != null) {
                String prefix;
                if ("".equals(suffix)) {
                    return RefactoringUtil.getPackageName(fo);
                }
                return prefix + ("".equals(prefix = RefactoringUtil.getPackageName(fo)) ? "" : ".") + (String)suffix;
            }
            if (!"".equals(suffix)) {
                suffix = "." + (String)suffix;
            }
            suffix = URLDecoder.decode(f.getPath().substring(f.getPath().lastIndexOf(File.separatorChar) + 1)) + (String)suffix;
        } while ((f = f.getParentFile()) != null);
        throw new IllegalArgumentException("Cannot create package name for url " + url);
    }

    private static String getPackageName(FileObject folder) {
        assert (folder.isFolder()) : "argument must be folder";
        return ClassPath.getClassPath((FileObject)folder, (String)"classpath/source").getResourceName(folder, '.', false);
    }
}

