/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.completion.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.TypeUtilities;
import org.netbeans.modules.javafx2.editor.completion.beans.FxBean;
import org.netbeans.modules.javafx2.editor.completion.beans.FxDefinitionKind;
import org.netbeans.modules.javafx2.editor.completion.beans.FxProperty;
import org.netbeans.modules.javafx2.editor.completion.impl.AttachedPropertyItem;
import org.netbeans.modules.javafx2.editor.completion.impl.CompletionContext;
import org.netbeans.modules.javafx2.editor.completion.impl.CompletionUtils;
import org.netbeans.modules.javafx2.editor.completion.impl.InstanceCompleter;
import org.netbeans.modules.javafx2.editor.completion.model.FxClassUtils;
import org.netbeans.modules.javafx2.editor.completion.model.FxInstance;
import org.netbeans.modules.javafx2.editor.completion.model.FxNode;
import org.netbeans.modules.javafx2.editor.completion.model.ImportDecl;
import org.netbeans.modules.javafx2.editor.completion.model.StaticProperty;
import org.netbeans.spi.editor.completion.CompletionItem;

public class StaticPropertyCompleter
extends InstanceCompleter {
    private Set<String> directClasses = new HashSet<String>();
    private String propertyPrefix;
    private String classPrefix;
    private String simpleClassPrefix;
    private List<CompletionItem> result = new ArrayList<CompletionItem>();
    private static final int MAX_SAMPLES_LEN = 40;

    @Override
    public boolean hasMoreItems() {
        return false;
    }

    public StaticPropertyCompleter() {
    }

    StaticPropertyCompleter(FxInstance instance, boolean attribute, CompletionContext ctx) {
        super(instance, attribute, ctx);
    }

    private void evalPrefixes() {
        String s = this.ctx.getPrefix();
        if (s == null) {
            return;
        }
        if (!this.attribute && s.startsWith("<")) {
            s = s.substring(1);
        }
        if (s.isEmpty()) {
            return;
        }
        int lastDot = s.lastIndexOf(46);
        if (lastDot == -1) {
            if (Character.isUpperCase(s.charAt(0))) {
                this.classPrefix = s;
            } else {
                this.propertyPrefix = s;
            }
        } else {
            this.propertyPrefix = s.substring(lastDot + 1);
            this.classPrefix = s.substring(0, lastDot);
            lastDot = this.classPrefix.lastIndexOf(46);
            if (lastDot != -1) {
                this.simpleClassPrefix = this.classPrefix.substring(lastDot + 1);
            }
        }
    }

    private void collectDirectClasses() {
        for (FxNode fxNode : this.ctx.getParents()) {
            FxInstance parentInstance;
            String parentClass;
            if (fxNode.getKind() != FxNode.Kind.Instance || (parentClass = (parentInstance = (FxInstance)fxNode).getResolvedName()) == null || this.classPrefix != null && !CompletionUtils.startsWith(CompletionUtils.getSimpleName(parentClass), this.classPrefix)) continue;
            this.directClasses.add(parentClass);
        }
        if (this.ctx.getCompletionType() == 9) {
            for (ImportDecl importDecl : this.ctx.getModel().getImports()) {
                String n = importDecl.getImportedName();
                if (importDecl.isWildcard()) continue;
                this.directClasses.add(n);
            }
        }
    }

    private Collection<String> findProperties(FxBean bi) {
        List<String> c = null;
        for (String pn : bi.getAttachedPropertyNames()) {
            if (!this.acceptsProperty(bi, bi.getAttachedProperty(pn))) continue;
            if (c == null) {
                c = Collections.singletonList(pn);
                continue;
            }
            if (c.size() == 1) {
                c = new ArrayList<String>(c);
            }
            c.add(pn);
        }
        return c;
    }

    private boolean acceptsProperty(FxBean owner, FxProperty info) {
        if (info.getKind() != FxDefinitionKind.ATTACHED) {
            return false;
        }
        if (this.propertyPrefix != null && !CompletionUtils.startsWith(info.getName(), this.propertyPrefix)) {
            return false;
        }
        if (this.classPrefix != null) {
            int dot = owner.getClassName().lastIndexOf(46);
            if (!CompletionUtils.startsWith(owner.getClassName().substring(dot + 1), this.classPrefix)) {
                return false;
            }
        }
        Collection<StaticProperty> staticProps = this.instance.getStaticProperties();
        for (StaticProperty sp : staticProps) {
            ElementHandle<TypeElement> sH;
            if (sp.getSourceName() == null || !sp.getSourceName().equals(info.getName()) || sp.getSourceClassName() == null || !((sH = sp.getSourceClassHandle()) == null ? sp.getSourceClassName().equals(CompletionUtils.getSimpleName(owner.getClassName())) : sH.getQualifiedName().equals(owner.getClassName()))) continue;
            return false;
        }
        TypeMirrorHandle h = info.getObjectType();
        if (h == null) {
            return false;
        }
        TypeMirror type = h.resolve(this.ctx.getCompilationInfo());
        if (type == null) {
            return false;
        }
        return this.ctx.getCompilationInfo().getTypes().isAssignable(this.instanceType.asType(), type);
    }

    @Override
    protected InstanceCompleter createCompleter(FxInstance instance, boolean attribute, CompletionContext ctx) {
        if (instance.getJavaType() == null) {
            return null;
        }
        return new StaticPropertyCompleter(instance, attribute, ctx);
    }

    public List<CompletionItem> complete() {
        this.evalPrefixes();
        this.makeDirectList();
        return this.result;
    }

    private void makeDirectList() {
        this.collectDirectClasses();
        if (this.classPrefix != null && this.propertyPrefix == null && this.directClasses.isEmpty()) {
            this.propertyPrefix = this.classPrefix;
            this.classPrefix = null;
            this.collectDirectClasses();
        }
        for (String classFullName : this.directClasses) {
            int dot;
            Collection<String> props;
            FxBean beanInfo = this.ctx.getBeanInfo(classFullName);
            if (beanInfo == null) continue;
            String cn = this.ctx.getSimpleClassName(classFullName);
            if (cn == null) {
                cn = classFullName;
            }
            if ((props = this.findProperties(beanInfo)) == null) continue;
            if (this.directClasses.size() == 1 || props.size() == 1 || this.ctx.getCompletionType() == 9) {
                for (String pn : props) {
                    FxProperty pi = beanInfo.getAttachedProperty(pn);
                    TypeMirror pType = pi.getType().resolve(this.ctx.getCompilationInfo());
                    boolean primitive = FxClassUtils.isPrimitive(pType);
                    String type = this.ctx.getCompilationInfo().getTypeUtilities().getTypeName(pType, new TypeUtilities.TypeNameOptions[0]).toString();
                    String replacementText = cn + "." + pi.getName();
                    String propName = !cn.equals(this.classPrefix) ? cn + "." + pi.getName() : pi.getName();
                    AttachedPropertyItem api = new AttachedPropertyItem(this.ctx, replacementText, propName, type, primitive);
                    api.setAttribute(this.attribute);
                    this.result.add(api);
                }
                continue;
            }
            StringBuilder sb = new StringBuilder();
            for (String pn : props) {
                int nextLen;
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                if ((nextLen = sb.length() + pn.length()) > 40) {
                    if (40 - sb.length() > 4) {
                        sb.append(pn.substring(0, nextLen - sb.length()));
                    }
                    sb.append("...");
                    break;
                }
                sb.append(pn);
            }
            String sn = (dot = classFullName.lastIndexOf(46)) == -1 ? classFullName : classFullName.substring(dot + 1);
            String replacementText = cn + ".";
            AttachedPropertyItem api = new AttachedPropertyItem(this.ctx, replacementText, sn, sb.toString());
            api.setAttribute(this.attribute);
            this.result.add(api);
        }
    }
}

