/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.options.ui.v2;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.netbeans.modules.profiler.api.ProfilerIDESettings;
import org.netbeans.modules.profiler.options.ui.v2.Bundle;
import org.netbeans.modules.profiler.options.ui.v2.ProfilerOptionsPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;

public class ProfilerOptionsContainer
extends ProfilerOptionsPanel {
    private List<ProfilerOptionsPanel> panels;
    private CategoriesListModel categoriesModel;
    private CategoriesSelectionModel categoriesSelection;
    private static int scrollIncrement = 20;
    private JPanel content;

    public ProfilerOptionsContainer() {
        this.initUI();
    }

    @Override
    public String getDisplayName() {
        return null;
    }

    @Override
    public void storeTo(final ProfilerIDESettings settings) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ProfilerOptionsContainer.this.panels != null) {
                    for (ProfilerOptionsPanel panel : ProfilerOptionsContainer.this.panels) {
                        panel.storeTo(settings);
                    }
                }
            }
        });
    }

    @Override
    public void loadFrom(ProfilerIDESettings settings) {
        int sel = this.categoriesSelection.getLeadSelectionIndex();
        if (sel == -1) {
            sel = 0;
        }
        if (this.panels == null) {
            this.panels = new ArrayList<ProfilerOptionsPanel>();
        } else {
            this.panels.clear();
        }
        this.panels.addAll(Lookup.getDefault().lookupAll(ProfilerOptionsPanel.class));
        this.categoriesModel.changed();
        for (ProfilerOptionsPanel panel : this.panels) {
            panel.loadFrom(settings);
        }
        if (this.categoriesModel.getSize() > 0) {
            this.categoriesSelection.setSelectionInterval(sel, sel);
        }
    }

    @Override
    public boolean equalsTo(ProfilerIDESettings settings) {
        if (this.panels != null) {
            for (ProfilerOptionsPanel panel : this.panels) {
                if (panel.equalsTo(settings)) continue;
                return false;
            }
        }
        return true;
    }

    private void initUI() {
        this.categoriesModel = new CategoriesListModel();
        this.categoriesSelection = new CategoriesSelectionModel();
        scrollIncrement = new JCheckBox((String)"XXX").getPreferredSize().height;
        JList<ProfilerOptionsPanel> categoriesList = new JList<ProfilerOptionsPanel>((ListModel)this.categoriesModel){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.width = Math.max(dim.width + 20, 140);
                return dim;
            }
        };
        categoriesList.setVisibleRowCount(0);
        categoriesList.setSelectionModel(this.categoriesSelection);
        categoriesList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String panelName = " " + ((ProfilerOptionsPanel)value).getDisplayName() + " ";
                return super.getListCellRendererComponent((JList<?>)list, panelName, index, isSelected, cellHasFocus);
            }
        });
        JScrollPane categoriesScroll = new JScrollPane(categoriesList);
        JLabel categoriesLabel = new JLabel();
        categoriesLabel.setHorizontalAlignment(10);
        Mnemonics.setLocalizedText((JLabel)categoriesLabel, (String)Bundle.ProfilerOptionsContainer_Categories());
        categoriesLabel.setLabelFor(categoriesList);
        int labelOffset = 6;
        JPanel categoriesPanel = new JPanel(new BorderLayout(0, labelOffset));
        categoriesPanel.add((Component)categoriesLabel, "North");
        categoriesPanel.add((Component)categoriesScroll, "Center");
        this.content = new JPanel(new BorderLayout());
        this.content.setBorder(BorderFactory.createEmptyBorder(categoriesLabel.getPreferredSize().height + labelOffset, 11, 0, 0));
        this.content.setMinimumSize(new Dimension(0, 0));
        this.content.setPreferredSize(new Dimension(0, 0));
        this.setLayout(new BorderLayout());
        this.add((Component)categoriesPanel, "West");
        this.add((Component)this.content, "Center");
    }

    private void panelSelected(final int index) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProfilerOptionsContainer.this.content.removeAll();
                ProfilerOptionsContainer.this.content.add((Component)ProfilerOptionsContainer.this.createPanelScroll((ProfilerOptionsPanel)ProfilerOptionsContainer.this.panels.get(index)), "Center");
                ProfilerOptionsContainer.this.content.revalidate();
                ProfilerOptionsContainer.this.content.repaint();
            }
        });
    }

    private JScrollPane createPanelScroll(ProfilerOptionsPanel panel) {
        ProfilerOptionsContainer.enlargeBorder(panel, 0, 0, 0, 5);
        JScrollPane scroll = new JScrollPane(panel);
        scroll.setBorder(BorderFactory.createEmptyBorder());
        scroll.setViewportBorder(BorderFactory.createEmptyBorder());
        scroll.getVerticalScrollBar().setUnitIncrement(scrollIncrement);
        scroll.getVerticalScrollBar().setBlockIncrement((int)((double)this.content.getHeight() * 0.8));
        scroll.getHorizontalScrollBar().setUnitIncrement(scrollIncrement);
        scroll.getHorizontalScrollBar().setBlockIncrement((int)((double)this.content.getWidth() * 0.8));
        return scroll;
    }

    private static void enlargeBorder(JComponent c, int t, int l, int b, int r) {
        Border current = c.getBorder();
        Border larger = BorderFactory.createEmptyBorder(t, l, b, r);
        if (current == null) {
            c.setBorder(larger);
        } else {
            c.setBorder(BorderFactory.createCompoundBorder(larger, current));
        }
    }

    private class CategoriesSelectionModel
    extends DefaultListSelectionModel {
        CategoriesSelectionModel() {
            this.setSelectionMode(0);
        }

        @Override
        public void clearSelection() {
        }

        @Override
        public void removeSelectionInterval(int index0, int index1) {
        }

        @Override
        protected void fireValueChanged(int firstIndex, int lastIndex, boolean isAdjusting) {
            super.fireValueChanged(firstIndex, lastIndex, isAdjusting);
            if (!isAdjusting) {
                ProfilerOptionsContainer.this.panelSelected(this.getLeadSelectionIndex());
            }
        }
    }

    private class CategoriesListModel
    extends AbstractListModel<ProfilerOptionsPanel> {
        private CategoriesListModel() {
        }

        @Override
        public int getSize() {
            return ProfilerOptionsContainer.this.panels == null ? 0 : ProfilerOptionsContainer.this.panels.size();
        }

        @Override
        public ProfilerOptionsPanel getElementAt(int index) {
            return ProfilerOptionsContainer.this.panels == null ? null : (ProfilerOptionsPanel)ProfilerOptionsContainer.this.panels.get(index);
        }

        void changed() {
            if (ProfilerOptionsContainer.this.panels != null) {
                super.fireContentsChanged(this, 0, ProfilerOptionsContainer.this.panels.size());
            }
        }
    }
}

