/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.wizards.urlpatternstep;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.ui.browser.RepositoryPaths;
import org.netbeans.modules.subversion.ui.wizards.AbstractStep;
import org.netbeans.modules.subversion.ui.wizards.urlpatternstep.URLPatternPanel;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class URLPatternStep
extends AbstractStep
implements DocumentListener,
ActionListener,
FocusListener,
ItemListener {
    private URLPatternPanel urlPatternPanel;
    private RepositoryPaths repositoryPaths;

    @Override
    public HelpCtx getHelp() {
        return new HelpCtx(URLPatternStep.class);
    }

    @Override
    protected JComponent createComponent() {
        if (this.urlPatternPanel == null) {
            this.urlPatternPanel = new URLPatternPanel();
            this.urlPatternPanel.repositoryPathTextField.getDocument().addDocumentListener(this);
            this.urlPatternPanel.depthComboBox.addItemListener(this);
            this.urlPatternPanel.depthComboBox.addFocusListener(this);
            this.urlPatternPanel.anyURLCheckBox.addActionListener(this);
            this.urlPatternPanel.useFolderRadioButton.addActionListener(this);
            this.urlPatternPanel.useSubfolderRadioButton.addActionListener(this);
        }
        return this.urlPatternPanel;
    }

    public void setup(RepositoryFile repositoryFile) {
        if (this.repositoryPaths == null) {
            this.repositoryPaths = new RepositoryPaths(repositoryFile, this.urlPatternPanel.repositoryPathTextField, this.urlPatternPanel.browseRepositoryButton, null, null);
            String browserPurposeMessage = NbBundle.getMessage(URLPatternStep.class, (String)"LBL_BrowserMessage");
            int browserMode = 9;
            this.repositoryPaths.setupBehavior(browserPurposeMessage, browserMode, "org.netbeans.modules.subversion.ui.browser.urlpattern", "org.netbeans.modules.subversion.ui.search.urlpattern");
        } else {
            this.repositoryPaths.setRepositoryFile(repositoryFile);
        }
        this.urlPatternPanel.repositoryPathTextField.setText(repositoryFile.getPath());
        this.validateUserInput();
    }

    @Override
    protected void validateBeforeNext() {
    }

    private void validateUserInput() {
        if (this.urlPatternPanel.repositoryPathTextField.getText().trim().equals("")) {
            this.setInvalid(new AbstractStep.WizardMessage(NbBundle.getMessage(URLPatternStep.class, (String)"MSG_MissingFolder"), true));
            return;
        }
        this.refreshPreview();
        this.valid();
    }

    private void setInvalid(AbstractStep.WizardMessage msg) {
        this.invalid(msg);
        this.urlPatternPanel.previewLabel.setText(" ");
    }

    private void refreshPreview() {
        this.urlPatternPanel.previewLabel.setText(this.getPattern(true));
    }

    private String getGroupiefiedPath(int depth, boolean html) {
        int i;
        String[] segments = this.urlPatternPanel.repositoryPathTextField.getText().split("/");
        StringBuffer ret = new StringBuffer();
        for (i = 0; i < segments.length; ++i) {
            if (i == depth) {
                ret.append("/(");
                if (html) {
                    ret.append("<b>");
                }
                ret.append(segments[i]);
                if (html) {
                    ret.append("</b>");
                }
                ret.append(")");
                continue;
            }
            ret.append("/");
            ret.append(segments[i]);
        }
        if (depth >= segments.length) {
            for (i = segments.length; i <= depth; ++i) {
                if (i == depth) {
                    ret.append("/");
                    if (html) {
                        ret.append("<b>");
                    }
                    ret.append("(.+?)");
                    if (!html) continue;
                    ret.append("</b>");
                    continue;
                }
                ret.append("/.*");
            }
        }
        ret.append("/.*");
        return ret.toString();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.validateUserInput();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.validateUserInput();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.validateUserInput();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.validateUserInput();
    }

    @Override
    public void focusGained(FocusEvent evt) {
        if (evt.getSource() == this.urlPatternPanel.depthComboBox && !this.urlPatternPanel.useSubfolderRadioButton.isSelected()) {
            this.urlPatternPanel.useSubfolderRadioButton.setSelected(true);
        }
    }

    @Override
    public void focusLost(FocusEvent evt) {
    }

    @Override
    public void itemStateChanged(ItemEvent arg0) {
        this.validateUserInput();
    }

    public String getPattern() {
        return this.getPattern(false);
    }

    private String getPattern(boolean html) {
        StringBuffer preview = new StringBuffer();
        if (html) {
            preview.append("<html>");
        }
        if (this.urlPatternPanel.anyURLCheckBox.isSelected()) {
            preview.append(".*");
        } else {
            preview.append(this.repositoryPaths.getRepositoryUrl().toString());
        }
        if (this.urlPatternPanel.useFolderRadioButton.isSelected()) {
            preview.append("/");
            if (html) {
                preview.append("<b>");
            }
            preview.append(this.urlPatternPanel.repositoryPathTextField.getText());
            if (html) {
                preview.append("</b>");
            }
            preview.append("/.*");
        } else {
            String depthString = (String)this.urlPatternPanel.depthComboBox.getSelectedItem();
            if (depthString.equals("")) {
                preview.append(this.getGroupiefiedPath(0, html));
            } else {
                preview.append(this.getGroupiefiedPath(Integer.parseInt(depthString), html));
            }
        }
        if (html) {
            preview.append("</html>");
        }
        return preview.toString();
    }

    public String getRepositoryFolder() {
        return this.urlPatternPanel.repositoryPathTextField.getText();
    }

    public boolean useName() {
        return this.urlPatternPanel.useFolderRadioButton.isSelected();
    }
}

