/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CpeDeviceInfo
extends ExplicitlySetBmcModel {
    @JsonProperty(value="vendor")
    private final String vendor;
    @JsonProperty(value="platformSoftwareVersion")
    private final String platformSoftwareVersion;

    @Deprecated
    @ConstructorProperties(value={"vendor", "platformSoftwareVersion"})
    public CpeDeviceInfo(String vendor, String platformSoftwareVersion) {
        this.vendor = vendor;
        this.platformSoftwareVersion = platformSoftwareVersion;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getPlatformSoftwareVersion() {
        return this.platformSoftwareVersion;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CpeDeviceInfo(");
        sb.append("super=").append(super.toString());
        sb.append("vendor=").append(String.valueOf(this.vendor));
        sb.append(", platformSoftwareVersion=").append(String.valueOf(this.platformSoftwareVersion));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CpeDeviceInfo)) {
            return false;
        }
        CpeDeviceInfo other = (CpeDeviceInfo)((Object)o);
        return Objects.equals(this.vendor, other.vendor) && Objects.equals(this.platformSoftwareVersion, other.platformSoftwareVersion) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.vendor == null ? 43 : this.vendor.hashCode());
        result = result * 59 + (this.platformSoftwareVersion == null ? 43 : this.platformSoftwareVersion.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="vendor")
        private String vendor;
        @JsonProperty(value="platformSoftwareVersion")
        private String platformSoftwareVersion;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder vendor(String vendor) {
            this.vendor = vendor;
            this.__explicitlySet__.add("vendor");
            return this;
        }

        public Builder platformSoftwareVersion(String platformSoftwareVersion) {
            this.platformSoftwareVersion = platformSoftwareVersion;
            this.__explicitlySet__.add("platformSoftwareVersion");
            return this;
        }

        public CpeDeviceInfo build() {
            CpeDeviceInfo model = new CpeDeviceInfo(this.vendor, this.platformSoftwareVersion);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CpeDeviceInfo model) {
            if (model.wasPropertyExplicitlySet("vendor")) {
                this.vendor(model.getVendor());
            }
            if (model.wasPropertyExplicitlySet("platformSoftwareVersion")) {
                this.platformSoftwareVersion(model.getPlatformSoftwareVersion());
            }
            return this;
        }
    }
}

