/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle;

import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildActionExecuter;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.ConfigurableLauncher;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.ResultHandler;
import org.gradle.tooling.TestLauncher;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.GradleConnectorManager;
import org.netbeans.modules.gradle.api.execute.GradleDistributionManager;
import org.netbeans.modules.gradle.spi.execute.GradleDistributionProvider;
import org.netbeans.modules.gradle.spi.execute.GradleJavaPlatformProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.WeakListeners;

public final class GradleProjectConnection
implements ProjectConnection {
    private static final Logger LOG = Logger.getLogger(GradleProjectConnection.class.getName());
    final Project project;
    ProjectConnection conn;
    final ChangeListener listener = e -> this.close();

    public GradleProjectConnection(Project project) {
        this.project = project;
    }

    public <T> T getModel(Class<T> type) throws GradleConnectionException, IllegalStateException {
        return (T)this.getConnection().getModel(type);
    }

    public <T> void getModel(Class<T> type, ResultHandler<? super T> rh) throws IllegalStateException {
        this.getConnection().getModel(type, rh);
    }

    public BuildLauncher newBuild() {
        return this.setJavaHome(this.getConnection().newBuild());
    }

    public TestLauncher newTestLauncher() {
        return this.setJavaHome(this.getConnection().newTestLauncher());
    }

    public <T> ModelBuilder<T> model(Class<T> type) {
        return this.setJavaHome(this.getConnection().model(type));
    }

    public <T> BuildActionExecuter<T> action(BuildAction<T> action) {
        return this.setJavaHome(this.getConnection().action(action));
    }

    public BuildActionExecuter.Builder action() {
        return this.getConnection().action();
    }

    public void notifyDaemonsAboutChangedPaths(List<Path> list) {
        this.getConnection().notifyDaemonsAboutChangedPaths(list);
    }

    public synchronized void close() {
        if (this.conn != null) {
            this.conn.close();
        }
        this.conn = null;
    }

    synchronized boolean hasConnection() {
        return this.conn != null;
    }

    private synchronized ProjectConnection getConnection() {
        if (this.conn == null) {
            File projectDir = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
            GradleDistributionProvider pvd = (GradleDistributionProvider)this.project.getLookup().lookup(GradleDistributionProvider.class);
            if (pvd != null) {
                pvd.addChangeListener(WeakListeners.change((ChangeListener)this.listener, (Object)pvd));
                GradleDistributionManager.GradleDistribution dist = pvd.getGradleDistribution();
                if (dist != null) {
                    this.conn = this.createConnection(dist, projectDir);
                }
            }
            if (this.conn == null) {
                this.conn = this.createConnection(GradleDistributionManager.get().defaultDistribution(), projectDir);
            }
        }
        return this.conn;
    }

    private <T extends ConfigurableLauncher<?>> T setJavaHome(T launcher) {
        GradleJavaPlatformProvider pvd = (GradleJavaPlatformProvider)this.project.getLookup().lookup(GradleJavaPlatformProvider.class);
        if (pvd != null) {
            try {
                File javaHome = pvd.getJavaHome();
                launcher.setJavaHome(javaHome);
                LOG.log(Level.FINE, "Using JAVA_HOME=''{0}'' for project info load for: {1}", new Object[]{javaHome, this.project});
            }
            catch (FileNotFoundException ex) {
                LOG.log(Level.WARNING, "JAVA_HOME for project " + this.project + " not found.", ex);
            }
        }
        return launcher;
    }

    private ProjectConnection createConnection(GradleDistributionManager.GradleDistribution dist, File projectDir) {
        GradleConnector gconn = GradleConnectorManager.getDefault().getConnector(this.project);
        gconn = gconn.useGradleUserHomeDir(dist.getGradleUserHome());
        gconn = dist.isAvailable() ? gconn.useInstallation(dist.getDistributionDir()) : gconn.useDistribution(dist.getDistributionURI());
        return gconn.forProjectDirectory(projectDir).connect();
    }
}

