/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.visualeditor.querybuilder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.api.db.sql.support.SQLIdentifiers;
import org.netbeans.modules.db.sql.visualeditor.Log;
import org.netbeans.modules.db.sql.visualeditor.parser.ParseException;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QueryBuilderMetaData;
import org.netbeans.modules.db.sql.visualeditor.querymodel.And;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Column;
import org.netbeans.modules.db.sql.visualeditor.querymodel.ColumnProvider;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Expression;
import org.netbeans.modules.db.sql.visualeditor.querymodel.ExpressionList;
import org.netbeans.modules.db.sql.visualeditor.querymodel.From;
import org.netbeans.modules.db.sql.visualeditor.querymodel.GroupBy;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Having;
import org.netbeans.modules.db.sql.visualeditor.querymodel.JoinTable;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Or;
import org.netbeans.modules.db.sql.visualeditor.querymodel.OrderBy;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Predicate;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Query;
import org.netbeans.modules.db.sql.visualeditor.querymodel.SQLQueryFactory;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Select;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Table;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Value;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Where;

class QueryModel {
    private static boolean DEBUG = false;
    private Query _query = null;
    private QueryBuilderMetaData qbMetaData;
    private SQLIdentifiers.Quoter quoter;

    QueryModel(SQLIdentifiers.Quoter quoter) {
        this.quoter = quoter;
    }

    void parse(String cmd) throws ParseException {
        this._query = SQLQueryFactory.parse(cmd);
    }

    String genText() {
        Log.getLogger().entering("QueryModel", "genText");
        if (DEBUG) {
            new Throwable().printStackTrace();
        }
        if (this._query == null) {
            return null;
        }
        return this._query.genText(this.quoter);
    }

    Select getSelect() {
        return this._query.getSelect();
    }

    From getFrom() {
        return this._query.getFrom();
    }

    Where getWhere() {
        return this._query == null ? null : this._query.getWhere();
    }

    GroupBy getGroupBy() {
        return this._query.getGroupBy();
    }

    OrderBy getOrderBy() {
        return this._query.getOrderBy();
    }

    Having getHaving() {
        return this._query.getHaving();
    }

    void setSelect(Select select) {
        this._query.setSelect(select);
    }

    void setFrom(From from) {
        this._query.setFrom(from);
    }

    void setWhere(Where where) {
        this._query.setWhere(where);
    }

    void setGroupBy(GroupBy groupBy) {
        this._query.setGroupBy(groupBy);
    }

    void setOrderBy(OrderBy orderBy) {
        this._query.setOrderBy(orderBy);
    }

    void setHaving(Having having) {
        this._query.setHaving(having);
    }

    void removeGroupBy() {
        this.setGroupBy(null);
    }

    boolean hasGroupBy() {
        return this._query.getGroupBy() != null;
    }

    void insertTable(JoinTable joinTable) {
        this._query.getFrom().addTable(joinTable);
    }

    void removeTable(String tableSpec) {
        Log.getLogger().entering("QueryModel", "removeTable", tableSpec);
        this._query.removeTable(tableSpec);
    }

    void replaceStar(ColumnProvider tableReader) {
        Log.getLogger().entering("QueryModel", "replaceStar");
        this._query.replaceStar(tableReader);
    }

    void addColumn(String tableSpec, String columnName) {
        this._query.addColumn(tableSpec, columnName);
    }

    void removeColumn(String tableSpec, String columnName) {
        this._query.removeColumn(tableSpec, columnName);
    }

    Expression findCond(String table1, String column1, String table2, String column2) {
        return this._query.getWhere().findExpression(table1, column1, table2, column2);
    }

    Table findTable(String tableSpec) {
        if (this._query != null && this._query.getFrom() != null) {
            return this._query.getFrom().findTable(tableSpec);
        }
        return null;
    }

    Column findSelectColumn(String tableSpec, String columnName) {
        ArrayList columns = new ArrayList();
        this._query.getSelect().getReferencedColumns(columns);
        for (int i = 0; i < columns.size(); ++i) {
            Column col = (Column)columns.get(i);
            if (!col.matches(tableSpec, columnName)) continue;
            return col;
        }
        return null;
    }

    String getFullTableName(String corrName) {
        if (this._query != null && this._query.getFrom() != null && corrName != null) {
            return this._query.getFrom().getFullTableName(corrName);
        }
        return null;
    }

    String genUniqueName(String fullTableName) {
        if (this.findTable(fullTableName) == null) {
            return null;
        }
        String[] table = fullTableName.split("\\.");
        String tableName = table.length > 1 ? table[1] : table[0];
        int i = 1;
        String candidate;
        while (this.findTable(candidate = tableName + "_" + i) != null) {
            ++i;
        }
        return candidate;
    }

    void addSortSpecification(String tableSpec, String columnName, String direction, int order) {
        OrderBy orderBy = this.getOrderBy();
        if (orderBy == null) {
            orderBy = SQLQueryFactory.createOrderBy();
            this.setOrderBy(orderBy);
        }
        orderBy.removeSortSpecification(tableSpec, columnName);
        orderBy.addSortSpecification(tableSpec, columnName, direction, order);
    }

    void removeSortSpecification(String tableSpec, String columnName) {
        OrderBy ob = this.getOrderBy();
        if (ob != null) {
            ob.removeSortSpecification(tableSpec, columnName);
        }
    }

    int getSortCount() {
        OrderBy orderBy = this.getOrderBy();
        if (orderBy == null) {
            return 0;
        }
        return orderBy.getSortSpecificationCount();
    }

    void setDerivedColName(String tableSpec, String columnName, String derivedColName) {
        Column col = this.findSelectColumn(tableSpec, columnName);
        if (col != null) {
            col.setDerivedColName(derivedColName);
        }
    }

    void removeDerivedColName(String tableSpec, String columnName) {
        this.setDerivedColName(tableSpec, columnName, null);
    }

    boolean isParameterized() {
        Where where = this.getWhere();
        if (where == null) {
            return false;
        }
        return where.isParameterized();
    }

    void getParameterizedPredicates(Collection predicates) {
        Where where = this.getWhere();
        if (where == null) {
            return;
        }
        Expression expr = where.getExpression();
        this.getParameterized(expr, predicates);
    }

    private void getParameterized(Expression expr, Collection predicates) {
        block4: {
            Value val2;
            Value val1;
            block5: {
                block3: {
                    if (!(expr instanceof ExpressionList)) break block3;
                    for (int i = 0; i < ((ExpressionList)expr).size(); ++i) {
                        Expression e = ((ExpressionList)expr).getExpression(i);
                        this.getParameterized(e, predicates);
                    }
                    break block4;
                }
                if (!expr.isParameterized() || !(expr instanceof Predicate)) break block4;
                Predicate pred = (Predicate)expr;
                val1 = pred.getVal1();
                val2 = pred.getVal2();
                if (!val1.isParameterized()) break block5;
                String val1String = val1.genText(this.quoter);
                for (int i = 0; i < val1String.length(); ++i) {
                    if (val1String.charAt(i) != '?') continue;
                    predicates.add(val2.genText(this.quoter));
                }
                break block4;
            }
            if (!val2.isParameterized()) break block4;
            String val2String = val2.genText(this.quoter);
            for (int i = 0; i < val2String.length(); ++i) {
                if (val2String.charAt(i) != '?') continue;
                predicates.add(val1.genText(this.quoter));
            }
        }
    }

    void renameTableSpec(String oldTableSpec, String corrName) {
        Log.getLogger().entering("QueryModel", "renameTableSpec", new Object[]{oldTableSpec, corrName});
        this._query.renameTableSpec(oldTableSpec, corrName);
    }

    JoinTable findJoinTable(String table1, String column1, String table2, String column2) {
        return this._query.getFrom().findJoinTable(table1, column1, table2, column2);
    }

    public void getColumnNames(String tableSpec, Collection columnNames) {
        ArrayList columns = new ArrayList();
        this.getSelect().getReferencedColumns(columns);
        for (int i = 0; i < columns.size(); ++i) {
            Column col;
            Object element = columns.get(i);
            if (!(element instanceof Column) || (col = (Column)element) == null) continue;
            String colName = col.getColumnName();
            String tabSpec = col.getTableSpec();
            if (colName == null || tabSpec == null || !colName.equals("*") && !tabSpec.equals(tableSpec)) continue;
            columnNames.add(colName);
        }
    }

    void addGroupBy() {
        ArrayList columns = new ArrayList();
        this.getSelect().getReferencedColumns(columns);
        this.setGroupBy(SQLQueryFactory.createGroupBy(columns));
    }

    void addRelationships(JoinTable joinTable, List relationships) {
        if (relationships.isEmpty()) {
            return;
        }
        String[] rel = (String[])relationships.get(0);
        String corrName1 = this._query.getFrom().getTableSpec(rel[0]);
        String corrName2 = this._query.getFrom().getTableSpec(rel[2]);
        String lastTableFullName = this._query.getFrom().getPreviousTableFullName();
        if (rel[0].equals(lastTableFullName) || rel[2].equals(lastTableFullName)) {
            joinTable.addJoinCondition(rel);
        } else {
            this.addOrCreateAndExpression(SQLQueryFactory.createPredicate(rel));
        }
        for (int i = 1; i < relationships.size(); ++i) {
            rel = (String[])relationships.get(i);
            this.addOrCreateAndExpression(SQLQueryFactory.createPredicate(rel));
        }
    }

    void removeCondition(Predicate removePred) {
        Where where = this.getWhere();
        if (where == null || where.getExpression() == null) {
            return;
        }
        Expression expr = this.getWhere().getExpression();
        if ((expr = this.removeConditionFromExpression(removePred, expr)) == null) {
            where.resetExpression();
            this._query.setWhere(null);
        } else {
            where.replaceExpression(expr);
        }
    }

    private Expression removeConditionFromExpression(Predicate removePred, Expression expr) {
        Value removeVal1 = removePred.getVal1();
        Value removeVal2 = removePred.getVal2();
        if (expr instanceof Predicate) {
            Predicate pred = (Predicate)expr;
            Value val1 = pred.getVal1();
            Value val2 = pred.getVal2();
            if (val1 instanceof Column && val2 instanceof Column && removeVal1 instanceof Column && removeVal2 instanceof Column) {
                Column col1 = (Column)val1;
                Column col2 = (Column)val2;
                Column removeCol1 = (Column)removeVal1;
                Column removeCol2 = (Column)removeVal2;
                if (col1.equals(removeCol1) && col2.equals(removeCol2)) {
                    return null;
                }
            }
        } else if (expr instanceof ExpressionList) {
            ExpressionList exprList = (ExpressionList)expr;
            for (int i = exprList.size() - 1; i >= 0; --i) {
                Expression element = this.removeConditionFromExpression(removePred, exprList.getExpression(i));
                if (element == null) {
                    exprList.removeExpression(i);
                    continue;
                }
                exprList.replaceExpression(i, element);
            }
            int size = exprList.size();
            if (size == 0) {
                return null;
            }
            if (size == 1) {
                return exprList.getExpression(0);
            }
        }
        return expr;
    }

    int getCriteriaCount() {
        Expression expr;
        Where where = this.getWhere();
        if (where != null && (expr = where.getExpression()) != null) {
            if (expr instanceof And) {
                return ((ExpressionList)expr).size();
            }
            return 1;
        }
        return 0;
    }

    void removeJoinNode(String table1, String column1, String table2, String column2) {
        JoinTable jt;
        if (this.getFrom() != null && (jt = this.getFrom().findJoinTable(table1, column1, table2, column2)) != null) {
            jt.setJoinType(null);
            jt.setExpression(null);
        }
    }

    void removeCriteria(String tableSpec, String columnName, int recurseLevel) {
        Where where = this.getWhere();
        if (where != null) {
            Expression expr = where.getExpression();
            if (expr == null) {
                return;
            }
            if ((expr = this.removeCriteriaFromExpression(tableSpec, columnName, expr, recurseLevel)) == null) {
                where.resetExpression();
                this._query.setWhere(null);
            } else {
                where.replaceExpression(expr);
            }
        }
    }

    private Expression removeCriteriaFromExpression(String tableSpec, String columnName, Expression expr, int recurseLevel) {
        if (expr instanceof Predicate) {
            Predicate pred = (Predicate)expr;
            Value val1 = pred.getVal1();
            Value val2 = pred.getVal2();
            if (pred.isCriterion() && (val1 instanceof Column && ((Column)val1).matches(tableSpec, columnName) || val2 instanceof Column && ((Column)val2).matches(tableSpec, columnName))) {
                return null;
            }
        } else if (recurseLevel > 0 && expr instanceof ExpressionList) {
            --recurseLevel;
            ExpressionList exprList = (ExpressionList)expr;
            for (int i = exprList.size() - 1; i >= 0; --i) {
                Expression item = this.removeCriteriaFromExpression(tableSpec, columnName, exprList.getExpression(i), recurseLevel);
                if (item == null) {
                    exprList.removeExpression(i);
                    continue;
                }
                exprList.replaceExpression(i, item);
            }
            int size = exprList.size();
            if (size == 0) {
                return null;
            }
            if (size == 1) {
                return exprList.getExpression(0);
            }
        }
        return expr;
    }

    void addCriteria(String tableSpec, String columnName, Predicate pred) {
        Where where;
        if (DEBUG) {
            System.out.println("Entering QueryModel.addCriteriaOrder () tableSpec = " + tableSpec + " ColumnName = " + columnName + " Predicate = " + pred + "\n");
        }
        if ((where = this.getWhere()) == null) {
            this.setWhere(SQLQueryFactory.createWhere(pred));
        } else {
            Expression expr = where.getExpression();
            if (expr == null) {
                where.replaceExpression(pred);
            } else {
                this.addOrCreateAndExpression(pred);
            }
        }
    }

    void replaceCriteria(String tableSpec, String columnName, Predicate pred, int order) {
        Where where;
        Expression expr;
        --order;
        if (DEBUG) {
            System.out.println("Entering QueryModel.replaceCriteria () tableSpec = " + tableSpec + " ColumnName = " + columnName + " Predicate = " + pred + " Order = " + order + "\n");
        }
        if ((expr = (where = this.getWhere()).getExpression()) instanceof ExpressionList) {
            ((ExpressionList)expr).replaceExpression(order, pred);
        } else {
            where.replaceExpression(pred);
        }
    }

    void addCriteria(String tableSpec, String columnName, Predicate pred, int order) {
        Where where;
        Expression expr;
        --order;
        if (DEBUG) {
            System.out.println("Entering QueryModel.addCriteriaOrder () tableSpec = " + tableSpec + " ColumnName = " + columnName + " Predicate = " + pred + " Order = " + order + "\n");
        }
        if ((expr = (where = this.getWhere()).getExpression()) instanceof And) {
            ((ExpressionList)expr).addExpression(order, pred);
        } else if (expr == null) {
            where.replaceExpression(pred);
        } else {
            expr = order == 0 ? SQLQueryFactory.createAnd(pred, expr) : SQLQueryFactory.createAnd(expr, pred);
            this.getWhere().replaceExpression(expr);
        }
    }

    void addOrCreateAndExpression(Predicate pred) {
        Expression expr;
        if (this.getWhere() != null && (expr = this.getWhere().getExpression()) != null) {
            if (expr instanceof And) {
                And andExpr = (And)expr;
                andExpr.addExpression(pred);
            } else {
                expr = SQLQueryFactory.createAnd(expr, pred);
                this.getWhere().replaceExpression(expr);
            }
            return;
        }
        this.setWhere(SQLQueryFactory.createWhere(pred));
    }

    void addOrCreateOrExpression(Predicate pred) {
        Expression expr;
        if (this.getWhere() != null && (expr = this.getWhere().getExpression()) != null) {
            if (expr instanceof Or) {
                Or orExpr = (Or)expr;
                orExpr.addExpression(pred);
                return;
            }
            expr = SQLQueryFactory.createOr(expr, pred);
            this.getWhere().replaceExpression(expr);
            return;
        }
        this.setWhere(SQLQueryFactory.createWhere(pred));
    }
}

