/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ide.ergonomics.fod;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.ide.ergonomics.fod.FeatureInfo;
import org.netbeans.modules.ide.ergonomics.fod.FeatureManager;
import org.netbeans.modules.ide.ergonomics.fod.FoDEditorOpened;
import org.netbeans.spi.project.ProjectFactory;
import org.netbeans.spi.project.support.ant.AntBasedProjectType;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;

public final class FoDLayersProvider
extends Repository.LayerProvider
implements LookupListener,
Runnable {
    static final Logger LOG = Logger.getLogger(FoDLayersProvider.class.getPackage().getName());
    private RequestProcessor.Task refresh = FeatureManager.getInstance().create(this, true);
    private Lookup.Result<ProjectFactory> factories;
    private Lookup.Result<?> ants;

    public static FoDLayersProvider getInstance() {
        return (FoDLayersProvider)Lookup.getDefault().lookup(FoDLayersProvider.class);
    }

    protected void registerLayers(Collection<? super URL> context) {
        boolean empty = true;
        LOG.fine("collecting layers");
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(0, FoDLayersProvider.class.getResource("common.xml"));
        for (FeatureInfo featureInfo : FeatureManager.features()) {
            if (!featureInfo.isPresent()) continue;
            LOG.log(Level.FINEST, "adding feature {0}", featureInfo.clusterName);
            if (featureInfo.getLayerURL() != null) {
                urls.add(featureInfo.getLayerURL());
            }
            if (!featureInfo.isEnabled()) continue;
            empty = false;
        }
        if (empty && this.noAdditionalProjects() && !FoDEditorOpened.anEditorIsOpened) {
            LOG.fine("adding default layer");
            urls.add(0, FoDLayersProvider.class.getResource("default.xml"));
        }
        LOG.log(Level.FINE, "delegating to {0} layers", urls.size());
        context.addAll(urls);
        LOG.log(Level.FINEST, "{0}", urls);
        LOG.fine("done");
        FeatureManager.dumpModules();
    }

    public FeatureInfo whichProvides(FileObject template) {
        HashSet<URL> layers = new HashSet<URL>();
        Object obj = template.getAttribute("layers");
        if (obj instanceof URL[]) {
            layers.addAll(Arrays.asList((URL[])obj));
        }
        for (FeatureInfo featureInfo : FeatureManager.features()) {
            if (!layers.contains(featureInfo.getLayerURL())) continue;
            return featureInfo;
        }
        return null;
    }

    public URL getDelegateFileSystem(FileObject template) {
        Object obj = template.getAttribute("layers");
        if (obj instanceof URL[]) {
            return ((URL[])obj)[0];
        }
        return null;
    }

    public void resultChanged(LookupEvent ev) {
        this.refresh.schedule(500);
    }

    public void refreshForce() {
        super.refresh();
    }

    @Override
    public void run() {
        super.refresh();
    }

    public void waitFinished() {
        this.refresh.waitFinished();
    }

    private boolean noAdditionalProjects() {
        if (this.factories == null) {
            this.factories = Lookup.getDefault().lookupResult(ProjectFactory.class);
            this.factories.addLookupListener((LookupListener)this);
            this.ants = Lookup.getDefault().lookupResult(AntBasedProjectType.class);
            this.ants.addLookupListener((LookupListener)this);
        }
        for (ProjectFactory pf : this.factories.allInstances()) {
            if (pf.getClass().getName().contains("AntBasedProjectFactorySingleton") || pf.getClass().getName().startsWith("org.netbeans.modules.ide.ergonomics") || pf.getClass().getName().startsWith("org.netbeans.modules.project.ui.convertor.ProjectConvertorFactory")) continue;
            return false;
        }
        return this.ants.allItems().isEmpty();
    }
}

