/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.refactoring;

import java.util.Collection;
import org.netbeans.modules.groovy.refactoring.RefactoringTask;
import org.netbeans.modules.groovy.refactoring.RefactoringTaskFactory;
import org.netbeans.modules.groovy.refactoring.utils.GroovyProjectUtil;
import org.netbeans.modules.refactoring.spi.ui.ActionsImplementationProvider;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class RefactoringActionsProvider
extends ActionsImplementationProvider {
    public boolean canFindUsages(Lookup lookup) {
        return this.canBeDone(lookup, RefactoringTaskFactory.RefactoringType.FIND_USAGES);
    }

    public boolean canRename(Lookup lookup) {
        return this.canBeDone(lookup, RefactoringTaskFactory.RefactoringType.RENAME);
    }

    public boolean canMove(Lookup lookup) {
        return false;
    }

    public void doFindUsages(Lookup lookup) {
        this.createTask(lookup, RefactoringTaskFactory.RefactoringType.FIND_USAGES).run();
    }

    public void doRename(Lookup lookup) {
        this.createTask(lookup, RefactoringTaskFactory.RefactoringType.RENAME).run();
    }

    public void doMove(Lookup lookup) {
        this.createTask(lookup, RefactoringTaskFactory.RefactoringType.MOVE).run();
    }

    private boolean canBeDone(Lookup lookup, RefactoringTaskFactory.RefactoringType type) {
        RefactoringTask task = this.createTask(lookup, type);
        return this.isValid(lookup) && task != null && task.isValid();
    }

    private RefactoringTask createTask(Lookup lookup, RefactoringTaskFactory.RefactoringType type) {
        return RefactoringTaskFactory.createRefactoringTask(lookup, type);
    }

    private boolean isValid(Lookup lookup) {
        Collection nodes = lookup.lookupAll(Node.class);
        if (nodes.size() != 1) {
            return false;
        }
        Node node = (Node)nodes.iterator().next();
        DataObject dataObject = (DataObject)node.getLookup().lookup(DataObject.class);
        if (dataObject == null) {
            return false;
        }
        return GroovyProjectUtil.isGroovyFile(dataObject.getPrimaryFile());
    }
}

