/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.refactoring.findusages.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.modules.groovy.editor.api.ElementUtils;
import org.netbeans.modules.groovy.editor.api.GroovyIndex;
import org.netbeans.modules.groovy.editor.api.Methods;
import org.netbeans.modules.groovy.editor.api.elements.index.IndexedMethod;
import org.netbeans.modules.groovy.refactoring.findusages.impl.AbstractFindUsagesVisitor;
import org.netbeans.modules.groovy.refactoring.findusages.model.MethodRefactoringElement;
import org.netbeans.modules.groovy.refactoring.findusages.model.RefactoringElement;
import org.netbeans.modules.groovy.refactoring.utils.GroovyProjectUtil;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;

public class FindMethodUsagesVisitor
extends AbstractFindUsagesVisitor {
    private final MethodRefactoringElement element;
    private final String methodType;
    private final String methodName;
    private final List<String> methodParams;
    private final GroovyIndex index;
    private IndexedMethod method;

    public FindMethodUsagesVisitor(ModuleNode moduleNode, RefactoringElement refactoringElement) {
        super(moduleNode);
        assert (refactoringElement instanceof MethodRefactoringElement) : "It was: " + refactoringElement.getClass().getSimpleName();
        this.element = (MethodRefactoringElement)refactoringElement;
        this.methodType = this.element.getMethodTypeName();
        this.methodName = this.element.getName();
        this.methodParams = this.element.getMethodParameters();
        ClasspathInfo cpInfo = GroovyProjectUtil.getClasspathInfoFor(this.element.getFileObject());
        ClassPath cp = cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE);
        this.index = GroovyIndex.get(Arrays.asList(cp.getRoots()));
        Set possibleMethods = this.index.getMethods(this.methodName, this.methodType, QuerySupport.Kind.EXACT);
        for (IndexedMethod indexedMethod : possibleMethods) {
            boolean sameName = this.methodName.equals(indexedMethod.getName());
            boolean sameParameters = Methods.isSameList(this.methodParams, (List)indexedMethod.getParameterTypes());
            if (!sameName || !sameParameters) continue;
            this.method = indexedMethod;
        }
    }

    protected void visitConstructorOrMethod(MethodNode node, boolean isConstructor) {
        String className = ElementUtils.getDeclaringClassName((ASTNode)node);
        if (!node.hasNoRealSourcePosition() && this.methodType.equals(className)) {
            if (isConstructor && this.methodType.endsWith(this.methodName)) {
                this.usages.add(node);
            } else if (this.methodName.equals(node.getName()) && Methods.hasSameParameters((IndexedMethod)this.method, (MethodNode)node)) {
                this.usages.add(node);
            }
        }
        super.visitConstructorOrMethod(node, isConstructor);
    }

    public void visitConstructorCallExpression(ConstructorCallExpression constructorCall) {
        String typeName = constructorCall.getType().getNameWithoutPackage();
        if (this.methodName.equals(typeName)) {
            this.usages.add(constructorCall);
        }
        super.visitConstructorCallExpression(constructorCall);
    }

    public void visitMethodCallExpression(MethodCallExpression methodCall) {
        Expression expression = methodCall.getObjectExpression();
        if (expression instanceof VariableExpression) {
            VariableExpression variableExpression = (VariableExpression)expression;
            Variable variable = variableExpression.getAccessedVariable();
            if (variable != null) {
                if (variable.isDynamicTyped()) {
                    this.addDynamicVarUsages(methodCall, variable);
                } else {
                    this.addStaticVarUsages(methodCall, variable);
                }
            } else {
                this.addThisUsages(methodCall);
            }
        } else if (expression instanceof ConstructorCallExpression) {
            this.addConstructorUsages(methodCall, (ConstructorCallExpression)expression);
        }
        super.visitMethodCallExpression(methodCall);
    }

    private void addDynamicVarUsages(MethodCallExpression methodCall, Variable variable) {
        this.findAndAdd(variable.getType(), methodCall);
    }

    private void addStaticVarUsages(MethodCallExpression methodCall, Variable variable) {
        if (this.methodType.equals(variable.getType().getName())) {
            this.findAndAdd(variable.getType(), methodCall);
        }
    }

    private void addThisUsages(MethodCallExpression methodCall) {
        List classes = this.moduleNode.getClasses();
        for (ClassNode classNode : classes) {
            if (!this.methodType.equals(classNode.getName())) continue;
            this.findAndAdd(this.element.getMethodType(), methodCall);
            break;
        }
    }

    private void addConstructorUsages(MethodCallExpression methodCall, ConstructorCallExpression constructorCallExpression) {
        ClassNode type = constructorCallExpression.getType();
        if (this.methodType.equals(ElementUtils.getDeclaringClassName((ASTNode)type))) {
            this.findAndAdd(type, methodCall);
        }
    }

    private void findAndAdd(ClassNode type, MethodCallExpression methodCall) {
        if (this.method == null || methodCall == null) {
            return;
        }
        if (this.methodName.equals(methodCall.getMethodAsString()) && Methods.hasSameParameters((IndexedMethod)this.method, (MethodCallExpression)methodCall)) {
            this.usages.add(methodCall.getMethod());
        }
    }
}

