/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.refactoring;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ui.OpenProjects;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Utilities;

public class RetoucheUtils {
    private static final String JAVA_MIME_TYPE = "text/x-java";

    public static boolean isJavaFile(FileObject f) {
        return JAVA_MIME_TYPE.equals(f.getMIMEType());
    }

    public static boolean isOnSourceClasspath(FileObject fo) {
        Project p = FileOwnerQuery.getOwner((FileObject)fo);
        if (p == null) {
            return false;
        }
        Project[] opened = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < opened.length; ++i) {
            if (!p.equals(opened[i]) && !opened[i].equals(p)) continue;
            SourceGroup[] gr = ProjectUtils.getSources((Project)p).getSourceGroups("java");
            for (int j = 0; j < gr.length; ++j) {
                if (fo == gr[j].getRootFolder()) {
                    return true;
                }
                if (!FileUtil.isParentOf((FileObject)gr[j].getRootFolder(), (FileObject)fo)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private static String getPackageName(FileObject folder) {
        assert (folder.isFolder()) : "argument must be folder";
        return ClassPath.getClassPath((FileObject)folder, (String)"classpath/source").getResourceName(folder, '.', false);
    }

    public static String getPackageName(URL url) {
        File f;
        FileObject result = URLMapper.findFileObject((URL)url);
        if (result != null) {
            return RetoucheUtils.getPackageName(result);
        }
        try {
            f = Utilities.toFile((URI)url.toURI());
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
        do {
            FileObject fo;
            if ((fo = FileUtil.toFileObject((File)f)) == null) continue;
            return RetoucheUtils.getPackageName(fo);
        } while ((f = f.getParentFile()) != null);
        throw new IllegalArgumentException("Cannot create package name for url " + url);
    }
}

