/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.analysis.options;

import java.util.Collections;
import java.util.List;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.php.analysis.ui.analyzer.MessDetectorCustomizerPanel;
import org.netbeans.modules.php.analysis.ui.options.MessDetectorOptionsPanel;

public final class ValidatorMessDetectorParameter {
    @NullAllowed
    private final String messDetectorPath;
    private final List<String> ruleSets;
    @NullAllowed
    private final String ruleSetFilePath;

    public static ValidatorMessDetectorParameter create(MessDetectorOptionsPanel panel) {
        return new ValidatorMessDetectorParameter(panel);
    }

    public static ValidatorMessDetectorParameter create(MessDetectorCustomizerPanel panel) {
        return new ValidatorMessDetectorParameter(panel);
    }

    private ValidatorMessDetectorParameter() {
        this.messDetectorPath = null;
        this.ruleSets = Collections.emptyList();
        this.ruleSetFilePath = null;
    }

    private ValidatorMessDetectorParameter(MessDetectorOptionsPanel panel) {
        this.messDetectorPath = panel.getMessDetectorPath();
        this.ruleSets = panel.getMessDetectorRuleSets();
        this.ruleSetFilePath = panel.getMessDetectorRuleSetFilePath();
    }

    private ValidatorMessDetectorParameter(MessDetectorCustomizerPanel panel) {
        this.messDetectorPath = panel.getValidMessDetectorPath();
        this.ruleSets = panel.getSelectedRuleSets();
        this.ruleSetFilePath = panel.getRuleSetFile();
    }

    @CheckForNull
    public String getMessDetectorPath() {
        return this.messDetectorPath;
    }

    public List<String> getRuleSets() {
        return Collections.unmodifiableList(this.ruleSets);
    }

    @CheckForNull
    public String getRuleSetFilePath() {
        return this.ruleSetFilePath;
    }
}

