/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.analysis.ui.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.php.analysis.ui.options.AnalysisCategoryPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;

public class AnalysisOptionsPanel
extends JPanel {
    private static final long serialVersionUID = -895132465784564654L;
    private final Map<String, AnalysisCategoryPanel> categoryPanels = new HashMap<String, AnalysisCategoryPanel>();
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JList<String> categoriesList;
    private JScrollPane categoriesScrollPane;
    private JPanel categoryPanel;
    private JLabel errorLabel;

    public AnalysisOptionsPanel() {
        assert (EventQueue.isDispatchThread());
        this.initComponents();
        this.init();
    }

    private void init() {
        this.errorLabel.setText(" ");
        this.categoriesList.setCellRenderer(new CategoryNameListCellRenderer(this.categoriesList.getCellRenderer()));
    }

    public void addCategoryPanel(AnalysisCategoryPanel panel) {
        assert (EventQueue.isDispatchThread());
        String name = panel.getCategoryName();
        assert (!this.categoryPanels.containsKey(name)) : name + " already found in " + this.categoryPanels;
        ((DefaultListModel)this.categoriesList.getModel()).addElement(name);
        this.categoryPanels.put(name, panel);
    }

    public void selectCategoryPanel(String name) {
        assert (EventQueue.isDispatchThread());
        assert (this.categoryPanels.containsKey(name)) : name + " not found in " + this.categoryPanels;
        this.categoriesList.setSelectedValue(name, true);
    }

    public void setError(String message) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.errorForeground"));
        this.errorLabel.setText(message);
    }

    public void setWarning(String message) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.warningForeground"));
        this.errorLabel.setText(message);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    @CheckForNull
    public AnalysisCategoryPanel getSelectedPanel() {
        assert (EventQueue.isDispatchThread());
        String categoryName = this.categoriesList.getSelectedValue();
        return this.categoryPanels.get(categoryName);
    }

    private void initComponents() {
        this.errorLabel = new JLabel();
        this.categoriesScrollPane = new JScrollPane();
        this.categoriesList = new JList();
        this.categoryPanel = new JPanel();
        Mnemonics.setLocalizedText((JLabel)this.errorLabel, (String)"ERROR");
        this.categoriesList.setModel(new DefaultListModel());
        this.categoriesList.setSelectionMode(0);
        this.categoriesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                AnalysisOptionsPanel.this.categoriesListValueChanged(evt);
            }
        });
        this.categoriesScrollPane.setViewportView(this.categoriesList);
        this.categoryPanel.setLayout(new BorderLayout());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.categoriesScrollPane, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.categoryPanel, -1, 130, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.errorLabel).addGap(0, 0, Short.MAX_VALUE))).addGap(0, 0, 0)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.categoryPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.errorLabel)).addComponent(this.categoriesScrollPane)).addGap(0, 0, 0)));
    }

    private void categoriesListValueChanged(ListSelectionEvent evt) {
        this.categoryPanel.removeAll();
        AnalysisCategoryPanel selectedPanel = this.getSelectedPanel();
        if (selectedPanel != null) {
            this.categoryPanel.add((Component)selectedPanel, "Center");
        }
        this.categoryPanel.revalidate();
        this.categoryPanel.repaint();
        this.fireChange();
    }

    private static final class CategoryNameListCellRenderer
    implements ListCellRenderer<String> {
        private final ListCellRenderer<? super String> defaultCellRenderer;

        CategoryNameListCellRenderer(ListCellRenderer<? super String> defaultCellRenderer) {
            assert (defaultCellRenderer != null);
            this.defaultCellRenderer = defaultCellRenderer;
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends String> list, String value, int index, boolean isSelected, boolean cellHasFocus) {
            value = (String)value + "   ";
            return this.defaultCellRenderer.getListCellRendererComponent(list, (String)value, index, isSelected, cellHasFocus);
        }
    }
}

