/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.assets;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import org.netbeans.modules.cloud.oracle.actions.AddADBAction;
import org.netbeans.modules.cloud.oracle.actions.OCIItemCreator;
import org.netbeans.modules.cloud.oracle.assets.CloudAssets;
import org.netbeans.modules.cloud.oracle.assets.CreateNewResourceItem;
import org.netbeans.modules.cloud.oracle.assets.Steps;
import org.netbeans.modules.cloud.oracle.assets.SuggestedItem;
import org.netbeans.modules.cloud.oracle.database.DatabaseItem;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.netbeans.modules.cloud.oracle.steps.CompartmentStep;
import org.netbeans.modules.cloud.oracle.steps.DatabaseConnectionStep;
import org.netbeans.modules.cloud.oracle.steps.SuggestedStep;
import org.netbeans.modules.cloud.oracle.steps.TenancyStep;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class AddSuggestedItemAction
implements ActionListener {
    private static final Logger LOG = Logger.getLogger(AddADBAction.class.getName());
    private final SuggestedItem context;

    public AddSuggestedItemAction(SuggestedItem context) {
        this.context = context;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("Database".equals(this.context.getPath())) {
            Steps.getDefault().executeMultistep(new DatabaseConnectionStep(), Lookup.EMPTY).thenAccept(values -> {
                DatabaseItem db = (DatabaseItem)values.getValueForStep(DatabaseConnectionStep.class);
                if (db != null) {
                    CloudAssets.getDefault().addItem(db);
                } else {
                    new AddADBAction().addADB().thenAccept(i -> CloudAssets.getDefault().addItem((OCIItem)i));
                }
            });
            return;
        }
        Steps.NextStepProvider nsProvider = Steps.NextStepProvider.builder().stepForClass(TenancyStep.class, s -> new CompartmentStep()).stepForClass(CompartmentStep.class, s -> new SuggestedStep(this.context.getPath())).build();
        Lookup lookup = Lookups.fixed((Object[])new Object[]{nsProvider});
        Steps.getDefault().executeMultistep(new TenancyStep(), lookup).thenAccept(values -> {
            if (values.getValueForStep(SuggestedStep.class) instanceof CreateNewResourceItem) {
                OCIItemCreator creator = OCIItemCreator.getCreator(this.context.getPath());
                if (creator != null) {
                    CompletableFuture<Map<String, Object>> vals = creator.steps();
                    ((CompletableFuture)vals.thenCompose(params -> creator.create((Steps.Values)values, (Map<String, Object>)params))).thenAccept(i -> CloudAssets.getDefault().addItem((OCIItem)i));
                }
            } else {
                OCIItem item = (OCIItem)values.getValueForStep(SuggestedStep.class);
                CloudAssets.getDefault().addItem(item);
            }
        });
    }
}

