/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.v8debug.breakpoints;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.lib.v8debug.V8Arguments;
import org.netbeans.lib.v8debug.V8Breakpoint;
import org.netbeans.lib.v8debug.V8Command;
import org.netbeans.lib.v8debug.V8Request;
import org.netbeans.lib.v8debug.V8Response;
import org.netbeans.lib.v8debug.commands.ChangeBreakpoint;
import org.netbeans.lib.v8debug.commands.ClearBreakpoint;
import org.netbeans.lib.v8debug.commands.Flags;
import org.netbeans.lib.v8debug.commands.SetBreakpoint;
import org.netbeans.lib.v8debug.events.BreakEventBody;
import org.netbeans.modules.javascript.v8debug.ScriptsHandler;
import org.netbeans.modules.javascript.v8debug.V8Debugger;
import org.netbeans.modules.javascript.v8debug.breakpoints.Bundle;
import org.netbeans.modules.javascript.v8debug.breakpoints.SubmittedBreakpoint;
import org.netbeans.modules.javascript.v8debug.frames.CallFrame;
import org.netbeans.modules.javascript2.debug.breakpoints.JSBreakpointStatus;
import org.netbeans.modules.javascript2.debug.breakpoints.JSLineBreakpoint;
import org.netbeans.modules.web.common.sourcemap.SourceMapsTranslator;
import org.openide.filesystems.FileObject;
import org.openide.util.Pair;

public class BreakpointsHandler
implements V8Debugger.Listener {
    private static final Logger LOG = Logger.getLogger(BreakpointsHandler.class.getName());
    private final V8Debugger dbg;
    private final Map<JSLineBreakpoint, SubmittedBreakpoint> submittedBreakpoints = new HashMap<JSLineBreakpoint, SubmittedBreakpoint>();
    private final Map<Long, SubmittedBreakpoint> breakpointsById = new HashMap<Long, SubmittedBreakpoint>();
    private final Set<JSLineBreakpoint> removeAfterSubmit = Collections.newSetFromMap(new WeakHashMap());
    private final List<ActiveBreakpointListener> abListeners = new CopyOnWriteArrayList<ActiveBreakpointListener>();
    private volatile JSLineBreakpoint activeBreakpoint;
    private final List<BreakpointsActiveListener> acListeners = new CopyOnWriteArrayList<BreakpointsActiveListener>();
    private volatile boolean areBreakpointsActive = true;

    public BreakpointsHandler(V8Debugger dbg) {
        this.dbg = dbg;
        dbg.addListener(this);
    }

    public void add(JSLineBreakpoint lb) {
        List<Pair<SetBreakpoint.Arguments, SourceMapsTranslator.Location>> srargsLoc = this.createSetRequestArguments(lb);
        LOG.log(Level.FINE, "Adding {0}, args = {1}", new Object[]{lb, srargsLoc});
        if (srargsLoc == null) {
            return;
        }
        JSBreakpointStatus.setInvalid((JSLineBreakpoint)lb, (String)Bundle.MSG_BRKP_Unresolved());
        BreakpointsCommandsCallback breakpointsCommandsCallback = new BreakpointsCommandsCallback(lb, srargsLoc);
        for (Pair<SetBreakpoint.Arguments, SourceMapsTranslator.Location> arg : srargsLoc) {
            V8Request request = this.dbg.sendCommandRequest(V8Command.Setbreakpoint, (V8Arguments)arg.first(), breakpointsCommandsCallback);
            LOG.log(Level.FINE, "  request = {0}", request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(JSLineBreakpoint lb) {
        SubmittedBreakpoint sb;
        Map<JSLineBreakpoint, SubmittedBreakpoint> map = this.submittedBreakpoints;
        synchronized (map) {
            sb = this.submittedBreakpoints.get(lb);
            if (sb == null) {
                this.removeAfterSubmit.add(lb);
            }
        }
        sb.notifyDestroyed();
        this.requestRemove(lb, sb.getIds());
    }

    private void requestRemove(JSLineBreakpoint lb, List<Long> ids) {
        for (Long id : ids) {
            ClearBreakpoint.Arguments cbargs = new ClearBreakpoint.Arguments(id.longValue());
            V8Request request = this.dbg.sendCommandRequest(V8Command.Clearbreakpoint, (V8Arguments)cbargs);
            LOG.log(Level.FINE, "Removing {0}, request = {1}", new Object[]{lb, request});
        }
    }

    @CheckForNull
    private List<Pair<SetBreakpoint.Arguments, SourceMapsTranslator.Location>> createSetRequestArguments(JSLineBreakpoint b) {
        FileObject fo = b.getFileObject();
        ScriptsHandler scriptsHandler = this.dbg.getScriptsHandler();
        ArrayList<String> serverPath = new ArrayList<String>();
        ArrayList<Long> lineNumber = new ArrayList<Long>();
        ArrayList<Long> columnNumber = new ArrayList<Long>();
        ArrayList<SourceMapsTranslator.Location> bpLocation = new ArrayList<SourceMapsTranslator.Location>();
        if (fo != null) {
            SourceMapsTranslator.Location loc;
            SourceMapsTranslator.Location cl;
            serverPath.add(scriptsHandler.getServerPath(fo));
            lineNumber.add(Long.valueOf(b.getLineNumber() - 1));
            columnNumber.add(0L);
            bpLocation.add(null);
            SourceMapsTranslator smt = this.dbg.getScriptsHandler().getSourceMapsTranslator();
            if (smt != null && (cl = smt.getCompiledLocation(loc = new SourceMapsTranslator.Location(fo, b.getLineNumber() - 1, 0))) != loc) {
                fo = cl.getFile();
                long relocatedLineNumber = cl.getLine();
                long relocatedColumnNumber = cl.getColumn();
                if (relocatedLineNumber == 0L) {
                    relocatedColumnNumber += (long)this.dbg.getScriptsHandler().getScriptFirstLineColumnShift(fo);
                }
                serverPath.add(scriptsHandler.getServerPath(fo));
                lineNumber.add(relocatedLineNumber);
                columnNumber.add(relocatedColumnNumber);
                bpLocation.add(cl);
            }
        } else {
            URL url = b.getURL();
            if (scriptsHandler.containsRemoteFile(url)) {
                serverPath.add(scriptsHandler.getServerPath(url));
                lineNumber.add(Long.valueOf(b.getLineNumber() - 1));
                columnNumber.add(0L);
                bpLocation.add(null);
            }
        }
        Long groupId = null;
        String condition = b.isConditional() ? b.getCondition() : null;
        ArrayList<Pair<SetBreakpoint.Arguments, SourceMapsTranslator.Location>> args = new ArrayList<Pair<SetBreakpoint.Arguments, SourceMapsTranslator.Location>>();
        for (int i = 0; i < serverPath.size(); ++i) {
            SetBreakpoint.Arguments newBreakPoint = new SetBreakpoint.Arguments(V8Breakpoint.Type.scriptName, (String)serverPath.get(i), (Long)lineNumber.get(i), (Long)columnNumber.get(i), Boolean.valueOf(b.isEnabled()), condition, null, groupId);
            args.add((Pair<SetBreakpoint.Arguments, SourceMapsTranslator.Location>)Pair.of((Object)newBreakPoint, (Object)((SourceMapsTranslator.Location)bpLocation.get(i))));
        }
        return args;
    }

    static List<ChangeBreakpoint.Arguments> createChangeRequestArguments(SubmittedBreakpoint sb) {
        JSLineBreakpoint b = sb.getBreakpoint();
        String condition = b.isConditional() ? b.getCondition() : null;
        return sb.getIds().stream().map(id -> new ChangeBreakpoint.Arguments(id.longValue(), Boolean.valueOf(b.isEnabled()), condition, null)).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void event(BreakEventBody beb) {
        long[] ids = beb.getBreakpoints();
        if (ids == null) {
            return;
        }
        for (long id : ids) {
            SubmittedBreakpoint sb;
            Map<JSLineBreakpoint, SubmittedBreakpoint> map = this.submittedBreakpoints;
            synchronized (map) {
                sb = this.breakpointsById.get(id);
            }
            if (sb == null) continue;
            JSLineBreakpoint b = sb.getBreakpoint();
            this.setActiveBreakpoint(b);
        }
    }

    @Override
    public void notifySuspended(boolean suspended) {
        if (!suspended) {
            this.setActiveBreakpoint(null);
        }
    }

    @Override
    public void notifyCurrentFrame(CallFrame cf) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyFinished() {
        ArrayList<SubmittedBreakpoint> sbs;
        Map<JSLineBreakpoint, SubmittedBreakpoint> map = this.submittedBreakpoints;
        synchronized (map) {
            sbs = new ArrayList<SubmittedBreakpoint>(this.submittedBreakpoints.values());
            this.submittedBreakpoints.clear();
            this.breakpointsById.clear();
        }
        for (SubmittedBreakpoint sb : sbs) {
            sb.notifyDestroyed();
        }
        this.setActiveBreakpoint(null);
    }

    public JSLineBreakpoint getActiveBreakpoint() {
        return this.activeBreakpoint;
    }

    private void setActiveBreakpoint(JSLineBreakpoint activeBreakpoint) {
        this.activeBreakpoint = activeBreakpoint;
        JSBreakpointStatus.setActive((JSLineBreakpoint)activeBreakpoint);
        for (ActiveBreakpointListener abl : this.abListeners) {
            abl.notifyActiveBreakpoint(activeBreakpoint);
        }
    }

    public void addActiveBreakpointListener(ActiveBreakpointListener abl) {
        this.abListeners.add(abl);
    }

    public void removeActiveBreakpointListener(ActiveBreakpointListener abl) {
        this.abListeners.remove(abl);
    }

    boolean areBreakpointsActive() {
        return this.areBreakpointsActive;
    }

    void setBreakpointsActive(final boolean active) {
        Flags.Arguments args = new Flags.Arguments("breakPointsActive", active);
        V8Request fRequest = this.dbg.sendCommandRequest(V8Command.Flags, (V8Arguments)args, new V8Debugger.CommandResponseCallback(){

            @Override
            public void notifyResponse(V8Request request, V8Response response) {
                if (response != null && response.isSuccess()) {
                    BreakpointsHandler.this.areBreakpointsActive = active;
                    for (BreakpointsActiveListener acl : BreakpointsHandler.this.acListeners) {
                        acl.breakpointsActivated(active);
                    }
                }
            }
        });
    }

    void addBreakpointsActiveListener(BreakpointsActiveListener abl) {
        this.acListeners.add(abl);
    }

    void removeBreakpointsActiveListener(BreakpointsActiveListener abl) {
        this.acListeners.remove(abl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void positionChanged(long bpId, long line, long column) {
        SubmittedBreakpoint sb;
        Map<JSLineBreakpoint, SubmittedBreakpoint> map = this.submittedBreakpoints;
        synchronized (map) {
            sb = this.breakpointsById.get(bpId);
        }
        if (sb != null) {
            sb.updatePosition(bpId, line, column);
        }
    }

    private final class BreakpointsCommandsCallback
    implements V8Debugger.CommandResponseCallback {
        private final JSLineBreakpoint lb;
        private final IdentityHashMap<SetBreakpoint.Arguments, V8Response> responses = new IdentityHashMap();
        private final IdentityHashMap<SetBreakpoint.Arguments, SourceMapsTranslator.Location> requests = new IdentityHashMap();

        public BreakpointsCommandsCallback(JSLineBreakpoint lb, List<Pair<SetBreakpoint.Arguments, SourceMapsTranslator.Location>> requestlist) {
            for (Pair<SetBreakpoint.Arguments, SourceMapsTranslator.Location> request : requestlist) {
                this.requests.put((SetBreakpoint.Arguments)request.first(), (SourceMapsTranslator.Location)request.second());
            }
            this.lb = lb;
        }

        @Override
        public void notifyResponse(V8Request request, V8Response response) {
            this.responses.put((SetBreakpoint.Arguments)request.getArguments(), response);
            if (this.responses.size() == this.requests.size()) {
                this.postProcess();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void postProcess() {
            boolean failed = false;
            String errorMessage = null;
            for (SetBreakpoint.Arguments arg : this.requests.keySet()) {
                V8Response res = this.responses.get(arg);
                if (res.getBody() != null) continue;
                failed = true;
                errorMessage = res.getErrorMessage();
                break;
            }
            if (failed) {
                JSBreakpointStatus.setInvalid((JSLineBreakpoint)this.lb, errorMessage);
            } else {
                boolean removed;
                ArrayList<Long> ids = new ArrayList<Long>();
                ArrayList<SourceMapsTranslator.Location> locations = new ArrayList<SourceMapsTranslator.Location>();
                ArrayList<V8Breakpoint.ActualLocation[]> actualLocations = new ArrayList<V8Breakpoint.ActualLocation[]>();
                for (SetBreakpoint.Arguments arg : this.requests.keySet()) {
                    V8Response res = this.responses.get(arg);
                    SetBreakpoint.ResponseBody sbrb = (SetBreakpoint.ResponseBody)res.getBody();
                    ids.add(sbrb.getBreakpoint());
                    locations.add(this.requests.get(arg));
                    actualLocations.add(sbrb.getActualLocations());
                }
                SubmittedBreakpoint sb = new SubmittedBreakpoint(this.lb, ids, locations, actualLocations, BreakpointsHandler.this.dbg);
                Map map = BreakpointsHandler.this.submittedBreakpoints;
                synchronized (map) {
                    BreakpointsHandler.this.submittedBreakpoints.put(this.lb, sb);
                    for (Long id : ids) {
                        BreakpointsHandler.this.breakpointsById.put(id, sb);
                    }
                    removed = BreakpointsHandler.this.removeAfterSubmit.remove(this.lb);
                }
                if (removed) {
                    BreakpointsHandler.this.requestRemove(this.lb, ids);
                    sb.notifyDestroyed();
                } else {
                    JSBreakpointStatus.setValid((JSLineBreakpoint)this.lb, (String)Bundle.MSG_BRKP_Resolved());
                }
            }
        }
    }

    public static interface ActiveBreakpointListener {
        public void notifyActiveBreakpoint(JSLineBreakpoint var1);
    }

    static interface BreakpointsActiveListener {
        public void breakpointsActivated(boolean var1);
    }
}

